/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandArrow
extends SingleLineCommand2<SequenceDiagram> {
    public CommandArrow(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram, CommandArrow.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr("PART1", new RegexLeaf("PART1CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("PART1LONG", "\"([^\"]+)\""), new RegexLeaf("PART1LONGCODE", "\"([^\"]+)\"\\s*as\\s+([\\p{L}0-9_.]+)"), new RegexLeaf("PART1CODELONG", "([\\p{L}0-9_.]+)\\s+as\\s*\"([^\"]+)\"")), new RegexLeaf("\\s*"), new RegexLeaf("ARROW", "(\\$?([=-]+(>>?|//?|\\\\\\\\?)|(<<?|//?|\\\\\\\\?)[=-]+)\\$?)"), new RegexLeaf("\\s*"), new RegexOr("PART2", new RegexLeaf("PART2CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("PART2LONG", "\"([^\"]+)\""), new RegexLeaf("PART2LONGCODE", "\"([^\"]+)\"\\s*as\\s+([\\p{L}0-9_.]+)"), new RegexLeaf("PART2CODELONG", "([\\p{L}0-9_.]+)\\s+as\\s*\"([^\"]+)\"")), new RegexLeaf("\\s*"), new RegexLeaf("MESSAGE", "(?::\\s*(.*))?$"));
    }

    private Participant getOrCreateParticipant(Map<String, RegexPartialMatch> map, String string) {
        List<String> list;
        String string2;
        if (map.get(string + "CODE").get(0) != null) {
            string2 = map.get(string + "CODE").get(0);
            list = StringUtils.getWithNewlines(string2);
        } else if (map.get(string + "LONG").get(0) != null) {
            string2 = map.get(string + "LONG").get(0);
            list = StringUtils.getWithNewlines(string2);
        } else if (map.get(string + "LONGCODE").get(0) != null) {
            list = StringUtils.getWithNewlines(map.get(string + "LONGCODE").get(0));
            string2 = map.get(string + "LONGCODE").get(1);
        } else {
            if (map.get(string + "CODELONG").get(0) != null) {
                String string3 = map.get(string + "CODELONG").get(0);
                List<String> list2 = StringUtils.getWithNewlines(map.get(string + "CODELONG").get(1));
                return ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(string3, list2);
            }
            throw new IllegalStateException();
        }
        return ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(string2, list);
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        boolean bl;
        boolean bl2;
        Participant participant;
        Participant participant2;
        String string = StringUtils.manageArrowForSequence(map.get("ARROW").get(0));
        boolean bl3 = string.startsWith("$");
        boolean bl4 = string.endsWith("$");
        if ((string = string.replaceAll("\\$", "")).endsWith(">") || string.endsWith("\\") || string.endsWith("/")) {
            participant2 = this.getOrCreateParticipant(map, "PART1");
            participant = this.getOrCreateParticipant(map, "PART2");
            bl2 = bl4;
            bl = bl3;
        } else if (string.startsWith("<") || string.startsWith("\\") || string.startsWith("/")) {
            participant = this.getOrCreateParticipant(map, "PART1");
            participant2 = this.getOrCreateParticipant(map, "PART2");
            bl2 = bl3;
            bl = bl4;
        } else {
            throw new IllegalStateException(map.toString());
        }
        boolean bl5 = string.endsWith(">>") || string.startsWith("<<") || string.contains("\\\\") || string.contains("//");
        boolean bl6 = string.contains("--");
        List<String> list = map.get("MESSAGE").get(0) == null ? Arrays.asList("") : StringUtils.getWithNewlines(map.get("MESSAGE").get(0));
        ArrowConfiguration arrowConfiguration = ArrowConfiguration.withDirection(ArrowDirection.LEFT_TO_RIGHT_NORMAL);
        if (bl6) {
            arrowConfiguration = arrowConfiguration.withDotted();
        }
        if (bl5) {
            arrowConfiguration = arrowConfiguration.withAsync();
        }
        if (string.endsWith("\\") || string.startsWith("/")) {
            arrowConfiguration = arrowConfiguration.withPart(ArrowPart.TOP_PART);
        }
        if (string.endsWith("/") || string.startsWith("\\")) {
            arrowConfiguration = arrowConfiguration.withPart(ArrowPart.BOTTOM_PART);
        }
        ((SequenceDiagram)this.getSystem()).addMessage(new Message(participant2, participant, list, arrowConfiguration, ((SequenceDiagram)this.getSystem()).getNextMessageNumber()));
        if (((SequenceDiagram)this.getSystem()).isAutoactivate()) {
            if (participant2 != participant && !arrowConfiguration.isASync()) {
                if (arrowConfiguration.isDotted()) {
                    ((SequenceDiagram)this.getSystem()).activate(participant2, LifeEventType.DEACTIVATE, null);
                } else {
                    ((SequenceDiagram)this.getSystem()).activate(participant, LifeEventType.ACTIVATE, null);
                }
            }
        } else {
            if (bl) {
                ((SequenceDiagram)this.getSystem()).activate(participant2, LifeEventType.DEACTIVATE, null);
            }
            if (bl2) {
                ((SequenceDiagram)this.getSystem()).activate(participant, LifeEventType.ACTIVATE, null);
            }
        }
        return CommandExecutionResult.ok();
    }
}

