/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentRoseNote
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final HtmlColor back;
    private final HtmlColor foregroundColor;

    public ComponentRoseNote(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, List<? extends CharSequence> list) {
        super(list, htmlColor3, uFont, HorizontalAlignement.LEFT, 6, 15, 5);
        this.back = htmlColor;
        this.foregroundColor = htmlColor2;
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX();
        return d;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPaddingX() {
        return 5.0;
    }

    @Override
    public double getPaddingY() {
        return 5.0;
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Dimension2D dimension2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        int n2 = (int)this.getTextWidth(stringBounder);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, n);
        uPolygon.addPoint(n2, n);
        uPolygon.addPoint(n2, 10.0);
        uPolygon.addPoint(n2 - 10, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic.getParam().setColor(this.foregroundColor);
        uGraphic.getParam().setBackcolor(this.back);
        uGraphic.draw(0.0, 0.0, uPolygon);
        uGraphic.draw(n2 - 10, 0.0, new ULine(0.0, 10.0));
        uGraphic.draw(n2, 10.0, new ULine(-10.0, 0.0));
        this.getTextBlock().drawU(uGraphic, this.getMarginX1(), this.getMarginY());
    }
}

