/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.tier;

import org.apache.lucene.search.ChainedFilter;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.spatial.geohash.GeoHashDistanceFilter;
import org.apache.lucene.spatial.tier.CartesianPolyFilterBuilder;
import org.apache.lucene.spatial.tier.DistanceFilter;
import org.apache.lucene.spatial.tier.LatLongDistanceFilter;

public class DistanceQueryBuilder {
    private static final long serialVersionUID = 1L;
    private final double lat;
    private final double lng;
    private final double miles;
    private final Filter filter;
    final DistanceFilter distanceFilter;

    public DistanceQueryBuilder(double lat, double lng, double miles, String latField, String lngField, String tierFieldPrefix, boolean needPrecise, int minTierIndexed, int maxTierIndexed) {
        this.lat = lat;
        this.lng = lng;
        this.miles = miles;
        CartesianPolyFilterBuilder cpf = new CartesianPolyFilterBuilder(tierFieldPrefix, minTierIndexed, maxTierIndexed);
        Filter cartesianFilter = cpf.getBoundingArea(lat, lng, miles);
        if (needPrecise) {
            this.distanceFilter = new LatLongDistanceFilter(cartesianFilter, lat, lng, miles, latField, lngField);
            this.filter = this.distanceFilter;
        } else {
            this.filter = cartesianFilter;
            this.distanceFilter = null;
        }
    }

    public DistanceQueryBuilder(double lat, double lng, double miles, String geoHashFieldPrefix, String tierFieldPrefix, boolean needPrecise, int minTierIndexed, int maxTierIndexed) {
        this.lat = lat;
        this.lng = lng;
        this.miles = miles;
        CartesianPolyFilterBuilder cpf = new CartesianPolyFilterBuilder(tierFieldPrefix, minTierIndexed, maxTierIndexed);
        Filter cartesianFilter = cpf.getBoundingArea(lat, lng, miles);
        if (needPrecise) {
            this.distanceFilter = new GeoHashDistanceFilter(cartesianFilter, lat, lng, miles, geoHashFieldPrefix);
            this.filter = this.distanceFilter;
        } else {
            this.filter = cartesianFilter;
            this.distanceFilter = null;
        }
    }

    public Filter getFilter() {
        if (this.distanceFilter != null) {
            this.distanceFilter.reset();
        }
        return this.filter;
    }

    public Filter getFilter(Query query) {
        if (this.distanceFilter != null) {
            this.distanceFilter.reset();
        }
        QueryWrapperFilter qf = new QueryWrapperFilter(query);
        return new ChainedFilter(new Filter[]{qf, this.filter}, 1);
    }

    public DistanceFilter getDistanceFilter() {
        return this.distanceFilter;
    }

    public Query getQuery(Query query) {
        return new ConstantScoreQuery(this.getFilter(query));
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    public double getMiles() {
        return this.miles;
    }

    public String toString() {
        return "DistanceQuery lat: " + this.lat + " lng: " + this.lng + " miles: " + this.miles;
    }
}

