/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V>
implements SolrCache<K, V> {
    private CumulativeStats stats;
    private long lookups;
    private long hits;
    private long inserts;
    private long evictions;
    private long warmupTime = 0L;
    private Map<K, V> map;
    private String name;
    private int autowarmCount;
    private SolrCache.State state;
    private CacheRegenerator regenerator;
    private String description = "LRU Cache";

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        this.state = SolrCache.State.CREATED;
        this.regenerator = regenerator;
        this.name = (String)args.get("name");
        String str = (String)args.get("size");
        final int limit = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get("initialSize");
        int initialSize = Math.min(str == null ? 1024 : Integer.parseInt(str), limit);
        str = (String)args.get("autowarmCount");
        this.autowarmCount = str == null ? 0 : Integer.parseInt(str);
        this.description = "LRU Cache(maxSize=" + limit + ", initialSize=" + initialSize;
        if (this.autowarmCount > 0) {
            this.description = this.description + ", autowarmCount=" + this.autowarmCount + ", regenerator=" + regenerator;
        }
        this.description = this.description + ')';
        this.map = new LinkedHashMap<K, V>(initialSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                if (this.size() > limit) {
                    LRUCache.this.evictions++;
                    ((LRUCache)LRUCache.this).stats.evictions.incrementAndGet();
                    return true;
                }
                return false;
            }
        };
        if (persistence == null) {
            persistence = new CumulativeStats();
        }
        this.stats = (CumulativeStats)persistence;
        return persistence;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Map<K, V> map = this.map;
        synchronized (map) {
            if (this.state == SolrCache.State.LIVE) {
                this.stats.inserts.incrementAndGet();
            }
            ++this.inserts;
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        Map<K, V> map = this.map;
        synchronized (map) {
            V val = this.map.get(key);
            if (this.state == SolrCache.State.LIVE) {
                ++this.lookups;
                this.stats.lookups.incrementAndGet();
                if (val != null) {
                    ++this.hits;
                    this.stats.hits.incrementAndGet();
                }
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }

    @Override
    public void setState(SolrCache.State state) {
        this.state = state;
    }

    @Override
    public SolrCache.State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache<K, V> old) throws IOException {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.currentTimeMillis();
        LRUCache other = (LRUCache)old;
        if (this.autowarmCount != 0) {
            Object[] keys;
            Object[] vals = null;
            Map<K, V> map = other.map;
            synchronized (map) {
                int i;
                int sz = other.map.size();
                if (this.autowarmCount != -1) {
                    sz = Math.min(sz, this.autowarmCount);
                }
                keys = new Object[sz];
                vals = new Object[sz];
                Iterator<Map.Entry<K, V>> iter = other.map.entrySet().iterator();
                int skip = other.map.size() - sz;
                for (i = 0; i < skip; ++i) {
                    iter.next();
                }
                for (i = 0; i < sz; ++i) {
                    Map.Entry<K, V> entry = iter.next();
                    keys[i] = entry.getKey();
                    vals[i] = entry.getValue();
                }
            }
            for (int i = 0; i < keys.length; ++i) {
                try {
                    boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, keys[i], vals[i]);
                    if (continueRegen) continue;
                    break;
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (String)("Error during auto-warming of key:" + keys[i]), (Throwable)e);
                }
            }
        }
        this.warmupTime = System.currentTimeMillis() - warmingStartTime;
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return LRUCache.class.getName();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CACHE;
    }

    @Override
    public String getSourceId() {
        return "$Id: LRUCache.java 1065312 2011-01-30 16:08:25Z rmuir $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_4/solr/core/src/java/org/apache/solr/search/LRUCache.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    private static String calcHitRatio(long lookups, long hits) {
        if (lookups == 0L) {
            return "0.00";
        }
        if (lookups == hits) {
            return "1.00";
        }
        int hundredths = (int)(hits * 100L / lookups);
        if (hundredths < 10) {
            return "0.0" + hundredths;
        }
        return "0." + hundredths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        Map<K, V> map = this.map;
        synchronized (map) {
            lst.add("lookups", (Object)this.lookups);
            lst.add("hits", (Object)this.hits);
            lst.add("hitratio", (Object)LRUCache.calcHitRatio(this.lookups, this.hits));
            lst.add("inserts", (Object)this.inserts);
            lst.add("evictions", (Object)this.evictions);
            lst.add("size", (Object)this.map.size());
        }
        lst.add("warmupTime", (Object)this.warmupTime);
        long clookups = this.stats.lookups.get();
        long chits = this.stats.hits.get();
        lst.add("cumulative_lookups", (Object)clookups);
        lst.add("cumulative_hits", (Object)chits);
        lst.add("cumulative_hitratio", (Object)LRUCache.calcHitRatio(clookups, chits));
        lst.add("cumulative_inserts", (Object)this.stats.inserts.get());
        lst.add("cumulative_evictions", (Object)this.stats.evictions.get());
        return lst;
    }

    public String toString() {
        return this.name + this.getStatistics().toString();
    }

    private static class CumulativeStats {
        AtomicLong lookups = new AtomicLong();
        AtomicLong hits = new AtomicLong();
        AtomicLong inserts = new AtomicLong();
        AtomicLong evictions = new AtomicLong();

        private CumulativeStats() {
        }
    }
}

