/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.common.query;

import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.response.CSVResponseWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.PHPResponseWriter;
import org.apache.solr.response.PHPSerializedResponseWriter;
import org.apache.solr.response.PythonResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.RubyResponseWriter;
import org.apache.solr.response.VelocityResponseWriter;
import org.apache.solr.response.XMLResponseWriter;

public class SolrQueryResponseWriterFactory {
    public static final String XML = "xml";
    public static final String JSON = "json";
    public static final String PYTHON = "python";
    public static final String RUBY = "ruby";
    public static final String PHP = "php";
    public static final String PHPS = "phps";
    public static final String VELOCITY = "velocity";
    public static final String CSV = "csv";

    public static QueryResponseWriter generateResponseWriter(String wt) throws SolrServerException {
        XMLResponseWriter writer = null;
        if (wt == null || wt.trim().equals("") || wt.equals(XML)) {
            writer = new XMLResponseWriter();
        } else if (wt.equals(JSON)) {
            writer = new JSONResponseWriter();
        } else if (wt.equals(PYTHON)) {
            writer = new PythonResponseWriter();
        } else if (wt.equals(RUBY)) {
            writer = new RubyResponseWriter();
        } else if (wt.equals(PHP)) {
            writer = new PHPResponseWriter();
        } else if (wt.equals(PHPS)) {
            writer = new PHPSerializedResponseWriter();
        } else if (wt.equals(VELOCITY)) {
            writer = new VelocityResponseWriter();
        } else if (wt.equals(CSV)) {
            writer = new CSVResponseWriter();
        } else {
            throw new SolrServerException("Metacat doesn't support this response format " + wt);
        }
        return writer;
    }

    public static String getContentType(String wt) {
        String contentType = null;
        contentType = wt == null || wt.trim().equals("") || wt.equals(XML) ? "text/xml" : (wt.equals(JSON) ? "text/json" : (wt.equals(PYTHON) ? "text/plain" : (wt.equals(RUBY) ? "text/plain" : (wt.equals(PHP) ? "text/plain" : (wt.equals(PHPS) ? "text/plain" : (wt.equals(VELOCITY) ? "text/html" : (wt.equals(CSV) ? "text/csv" : null)))))));
        return contentType;
    }
}

