/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.log4j.Logger;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.util.TypeMarshaller;
import org.jibx.runtime.JiBXException;

public class TypeFactory {
    protected static Logger logger = Logger.getLogger((String)TypeFactory.class.getName());

    public static ObjectFormatIdentifier buildFormatIdentifier(String value) {
        ObjectFormatIdentifier fid = new ObjectFormatIdentifier();
        fid.setValue(value);
        return fid;
    }

    public static Identifier buildIdentifier(String value) {
        Identifier id = new Identifier();
        id.setValue(value);
        return id;
    }

    public static NodeReference buildNodeReference(String value) {
        NodeReference id = new NodeReference();
        id.setValue(value);
        return id;
    }

    public static Subject buildSubject(String value) {
        Subject s = new Subject();
        s.setValue(value);
        return s;
    }

    public static ObjectFormatIdentifier cloneFormatIdentifier(ObjectFormatIdentifier orig) {
        if (orig == null) {
            return null;
        }
        return TypeFactory.buildFormatIdentifier(orig.getValue());
    }

    public static Identifier cloneIdentifier(Identifier orig) {
        if (orig == null) {
            return null;
        }
        return TypeFactory.buildIdentifier(orig.getValue());
    }

    public static NodeReference cloneNodeReference(NodeReference orig) {
        if (orig == null) {
            return null;
        }
        return TypeFactory.buildNodeReference(orig.getValue());
    }

    public static Subject cloneSubject(Subject orig) {
        if (orig == null) {
            return null;
        }
        return TypeFactory.buildSubject(orig.getValue());
    }

    public static <T> T clone(Object original) throws JiBXException, IOException, InstantiationException, IllegalAccessException {
        if (original == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Cloning object %s (of type %s)...", original.toString(), original.getClass().getCanonicalName()));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TypeMarshaller.marshalTypeToOutputStream(original, baos);
        return (T)TypeMarshaller.unmarshalTypeFromStream(original.getClass(), new ByteArrayInputStream(baos.toByteArray()));
    }

    public static AccessRule buildAccessRule(String subjectString, Permission permission) {
        if (subjectString == null || permission == null) {
            return null;
        }
        AccessRule ar = new AccessRule();
        ar.addSubject(TypeFactory.buildSubject(subjectString));
        ar.addPermission(permission);
        return ar;
    }

    public static AccessRule buildAccessRule(String subjectString, Permission[] permissions) {
        if (subjectString == null || permissions == null) {
            return null;
        }
        AccessRule ar = new AccessRule();
        ar.addSubject(TypeFactory.buildSubject(subjectString));
        for (Permission p : permissions) {
            ar.addPermission(p);
        }
        return ar;
    }

    public static SystemMetadata buildMinimalSystemMetadata(Identifier id, InputStream data, String checksumAlgorithm, ObjectFormatIdentifier formatId, Subject submitterRightsHolder) throws NoSuchAlgorithmException, IOException, NotFound, ServiceFailure {
        SystemMetadata sm = new SystemMetadata();
        sm.setIdentifier(id);
        sm.setFormatId(formatId);
        CountingInputStream cis = new CountingInputStream(data);
        if (checksumAlgorithm == null) {
            checksumAlgorithm = "MD5";
        }
        Checksum checksum = ChecksumUtil.checksum((InputStream)cis, checksumAlgorithm);
        sm.setChecksum(checksum);
        sm.setSize(new BigInteger(String.valueOf(cis.getByteCount())));
        cis.close();
        sm.setSerialVersion(BigInteger.ONE);
        sm.setSubmitter(submitterRightsHolder);
        sm.setRightsHolder(submitterRightsHolder);
        Date now = new Date();
        sm.setDateUploaded(now);
        sm.setDateSysMetadataModified(now);
        return sm;
    }
}

