/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v2.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.ObjectFormatList;
import org.dataone.service.util.TypeMarshaller;
import org.jibx.runtime.JiBXException;

public class ObjectFormatServiceImpl {
    private Logger logger = Logger.getLogger(ObjectFormatServiceImpl.class);
    private static ObjectFormatServiceImpl instance = null;
    protected ObjectFormatList objectFormatList = null;
    protected HashMap<ObjectFormatIdentifier, ObjectFormat> objectFormatMap = new HashMap();
    private String objectFormatFilePath = "/org/dataone/service/resources/config/v2/objectFormatList.xml";

    protected ObjectFormatServiceImpl() throws ServiceFailure {
        try {
            this.refreshCache();
        }
        catch (ServiceFailure se) {
            this.logger.debug((Object)("There was a problem creating the ObjectFormatServiceImpl. The error message was: " + se.getMessage()));
            throw se;
        }
    }

    public static synchronized ObjectFormatServiceImpl getInstance() throws ServiceFailure {
        if (instance == null) {
            instance = new ObjectFormatServiceImpl();
        }
        return instance;
    }

    public ObjectFormatList listFormats() {
        return this.objectFormatList;
    }

    public ObjectFormat getFormat(ObjectFormatIdentifier formatId) throws NotFound, ServiceFailure, NotImplemented {
        ObjectFormat objectFormat = this.getObjectFormatMap().get(formatId);
        if (objectFormat == null) {
            throw new NotFound("0000", "The format specified by '" + formatId.getValue() + "' does not exist at this node.");
        }
        return objectFormat;
    }

    private void refreshCache() throws ServiceFailure {
        try {
            InputStream inputStream = this.getObjectFormatFile();
            this.objectFormatList = TypeMarshaller.unmarshalTypeFromStream(ObjectFormatList.class, inputStream);
            for (ObjectFormat objectFormat : this.objectFormatList.getObjectFormatList()) {
                this.getObjectFormatMap().put(objectFormat.getFormatId(), objectFormat);
            }
        }
        catch (JiBXException jibxe) {
            String message = "The object format list could not be deserialized. The error message was: " + jibxe.getMessage();
            this.logger.error((Object)message);
            throw new ServiceFailure("0000", message);
        }
        catch (IOException ioe) {
            String message = "The object format list could not be read. The error message was: " + ioe.getMessage();
            this.logger.error((Object)message);
            throw new ServiceFailure("0000", message);
        }
        catch (InstantiationException ie) {
            String message = "The object format list could not be instantiated. The error message was: " + ie.getMessage();
            this.logger.error((Object)message);
            throw new ServiceFailure("0000", message);
        }
        catch (IllegalAccessException iae) {
            String message = "The object format list could not be accessed. The error message was: " + iae.getMessage();
            this.logger.error((Object)message);
            throw new ServiceFailure("0000", message);
        }
    }

    public InputStream getObjectFormatFile() {
        InputStream inputStream = this.getClass().getResourceAsStream(this.objectFormatFilePath);
        return inputStream;
    }

    protected HashMap<ObjectFormatIdentifier, ObjectFormat> getObjectFormatMap() {
        return this.objectFormatMap;
    }
}

