/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v2.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.NodeState;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.ServiceMethodRestriction;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.Node;

public class ServiceMethodRestrictionUtil {
    private static final Logger logger = Logger.getLogger(ServiceMethodRestrictionUtil.class);

    public static boolean isMethodAllowed(Subject subject, List<Node> nodeList, String serviceName, String methodName) {
        boolean isAllowed = false;
        if (subject != null) {
            List<String> admins = ServiceMethodRestrictionUtil.getCnAdministrativeList(nodeList, serviceName, methodName);
            isAllowed = admins.contains(subject.getValue());
        }
        return isAllowed;
    }

    public static List<String> getCnAdministrativeList(List<Node> nodeList, String serviceName, String methodName) {
        ArrayList<String> administrators = new ArrayList<String>();
        String[] administratorsProperties = Settings.getConfiguration().getStringArray("cn.administrators");
        if (administrators != null) {
            for (String administrator : administratorsProperties) {
                logger.debug((Object)("Adding cn.administrators entry: " + administrator));
                administrators.add(administrator);
            }
        }
        for (Node node : nodeList) {
            if (!node.getType().equals(NodeType.CN) || !node.getState().equals(NodeState.UP)) continue;
            for (Subject adminstrativeSubject : node.getSubjectList()) {
                logger.debug((Object)("Adding CN subject entry: " + adminstrativeSubject.getValue()));
                administrators.add(adminstrativeSubject.getValue());
            }
            List<Service> cnServices = node.getServices().getServiceList();
            for (Service service : cnServices) {
                if (!service.getName().equalsIgnoreCase(serviceName) || service.getRestrictionList() == null || service.getRestrictionList().isEmpty()) continue;
                List<ServiceMethodRestriction> serviceMethodRestrictionList = service.getRestrictionList();
                for (ServiceMethodRestriction serviceMethodRestriction : serviceMethodRestrictionList) {
                    if (!serviceMethodRestriction.getMethodName().equalsIgnoreCase(methodName) || serviceMethodRestriction.getSubjectList() == null) continue;
                    for (Subject administrator : serviceMethodRestriction.getSubjectList()) {
                        logger.debug((Object)("Adding ServiceMethodRestriction entry: " + administrator.getValue()));
                        administrators.add(administrator.getValue());
                    }
                }
            }
        }
        return administrators;
    }
}

