/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.utils;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.auth.X509Session;
import org.dataone.client.rest.HttpMultipartRestClient;
import org.dataone.client.utils.HttpConnectionMonitorService;
import org.dataone.configuration.Settings;
import org.jibx.runtime.JiBXException;

public class HttpUtils {
    static final Logger logger = Logger.getLogger((String)HttpUtils.class.getName());
    public static final String SCHEME_NAME = "https";
    public static final boolean MONITOR_STALE_CONNECTIONS = Settings.getConfiguration().getBoolean("D1Client.http.monitorStaleConnections", true);
    public static final int MAX_CONNECTIONS = Settings.getConfiguration().getInteger("D1Client.http.maxConnectionsTotal", Integer.valueOf(200));
    public static final int MAX_CONNECTIONS_PER_ROUTE = Settings.getConfiguration().getInteger("D1Client.http.maxConnectionsPerServer", Integer.valueOf(5));
    public static final long DEFAULT_KEEP_ALIVE_SECONDS = Settings.getConfiguration().getLong("D1Client.http.keepAliveDuration.sec", 5L);
    public static final boolean USE_CACHING_CLIENT = Settings.getConfiguration().getBoolean("D1Client.http.useCachingClient", true);
    public static final int CACHE_MAX_ENTRIES = Settings.getConfiguration().getInt("D1Client.http.cacheMaxEntries", 50);
    public static final int CACHE_MAX_OBJECT_SIZE = Settings.getConfiguration().getInt("D1Client.http.cacheMaxObjectSize", 102400);

    public static void setupSSL_v4_1(AbstractHttpClient httpClient, X509Session x509Session) {
        SchemeRegistry schemeReg = httpClient.getConnectionManager().getSchemeRegistry();
        if (schemeReg.getScheme(SCHEME_NAME) == null) {
            SSLSocketFactory socketFactory = null;
            try {
                socketFactory = CertificateManager.getInstance().getSSLSocketFactory(x509Session);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception from CertificateManager at SSL setup - client will be anonymous: " + e.getClass() + ":: " + e.getMessage()));
            }
            try {
                Scheme sch = new Scheme(SCHEME_NAME, 443, (SchemeSocketFactory)socketFactory);
                httpClient.getConnectionManager().getSchemeRegistry().register(sch);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to set up SSL connection for client. Continuing. " + e.getClass() + ":: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static HttpClient createHttpClient(X509Session x509session) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, InstantiationException, IllegalAccessException, IOException, JiBXException {
        return HttpUtils.getHttpClientBuilder(x509session).build();
    }

    public static HttpClientBuilder getHttpClientBuilder(X509Session x509session) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, InstantiationException, IllegalAccessException, IOException, JiBXException {
        return HttpUtils.getHttpClientBuilder(x509session, null);
    }

    public static HttpClientBuilder getHttpClientBuilder(X509Session x509session, Boolean monitorStaleConnections) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, InstantiationException, IllegalAccessException, IOException, JiBXException {
        PoolingHttpClientConnectionManager connMan = new PoolingHttpClientConnectionManager(HttpUtils.buildConnectionRegistry(x509session));
        SocketConfig sc = SocketConfig.custom().setSoTimeout(HttpMultipartRestClient.DEFAULT_TIMEOUT_VALUE.intValue()).build();
        connMan.setDefaultSocketConfig(sc);
        connMan.setDefaultMaxPerRoute(MAX_CONNECTIONS_PER_ROUTE);
        connMan.setMaxTotal(MAX_CONNECTIONS);
        if (monitorStaleConnections != null) {
            if (monitorStaleConnections.booleanValue()) {
                HttpConnectionMonitorService.getInstance().addMonitor((HttpClientConnectionManager)connMan);
            }
        } else if (MONITOR_STALE_CONNECTIONS) {
            HttpConnectionMonitorService.getInstance().addMonitor((HttpClientConnectionManager)connMan);
        }
        return HttpUtils.selectHttpClientBuilder().setKeepAliveStrategy(HttpUtils.buildD1KeepAliveStrategy(DEFAULT_KEEP_ALIVE_SECONDS)).setConnectionManager((HttpClientConnectionManager)connMan);
    }

    public static HttpClient createHttpClient(String authToken) {
        return HttpUtils.getHttpClientBuilder(authToken).build();
    }

    public static HttpClientBuilder getHttpClientBuilder(String authToken) {
        return HttpUtils.getHttpClientBuilder(authToken, null);
    }

    public static HttpClientBuilder getHttpClientBuilder(final String authToken, Boolean monitorStaleConnections) {
        PoolingHttpClientConnectionManager connMan = new PoolingHttpClientConnectionManager(HttpUtils.buildConnectionRegistry());
        SocketConfig sc = SocketConfig.custom().setSoTimeout(HttpMultipartRestClient.DEFAULT_TIMEOUT_VALUE.intValue()).build();
        connMan.setDefaultSocketConfig(sc);
        connMan.setDefaultMaxPerRoute(MAX_CONNECTIONS_PER_ROUTE);
        connMan.setMaxTotal(MAX_CONNECTIONS);
        if (monitorStaleConnections != null) {
            if (monitorStaleConnections.booleanValue()) {
                HttpConnectionMonitorService.getInstance().addMonitor((HttpClientConnectionManager)connMan);
            }
        } else if (MONITOR_STALE_CONNECTIONS) {
            HttpConnectionMonitorService.getInstance().addMonitor((HttpClientConnectionManager)connMan);
        }
        return HttpUtils.selectHttpClientBuilder().setConnectionManager((HttpClientConnectionManager)connMan).setKeepAliveStrategy(HttpUtils.buildD1KeepAliveStrategy(DEFAULT_KEEP_ALIVE_SECONDS)).addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader("Authorization", "Bearer " + authToken);
            }
        });
    }

    private static HttpClientBuilder selectHttpClientBuilder() {
        if (USE_CACHING_CLIENT) {
            CachingHttpClientBuilder b = CachingHttpClients.custom();
            CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(CACHE_MAX_ENTRIES).setMaxObjectSize((long)CACHE_MAX_OBJECT_SIZE).build();
            b.setCacheConfig(cacheConfig);
            return b;
        }
        return HttpClients.custom();
    }

    public static X509Session selectSession(String subjectString) throws IOException {
        return CertificateManager.getInstance().selectSession(subjectString);
    }

    public static Registry<ConnectionSocketFactory> buildConnectionRegistry(X509Session x509Session) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        RegistryBuilder rb = RegistryBuilder.create();
        rb.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        SSLConnectionSocketFactory sslSocketFactory = null;
        sslSocketFactory = CertificateManager.getInstance().getSSLConnectionSocketFactory(x509Session);
        rb.register(SCHEME_NAME, (Object)sslSocketFactory);
        Registry sfRegistry = rb.build();
        return sfRegistry;
    }

    public static Registry<ConnectionSocketFactory> buildConnectionRegistry() {
        RegistryBuilder rb = RegistryBuilder.create();
        rb.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        SSLConnectionSocketFactory sslSocketFactory = null;
        sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
        rb.register(SCHEME_NAME, (Object)sslSocketFactory);
        Registry sfRegistry = rb.build();
        return sfRegistry;
    }

    public static ConnectionKeepAliveStrategy buildD1KeepAliveStrategy(final long defaultKeepAliveTimeout) {
        return new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    try {
                        return Long.parseLong(value) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                return defaultKeepAliveTimeout * 1000L;
            }
        };
    }
}

