/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v1.impl;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.MultipartD1Node;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.utils.ExceptionUtils;
import org.dataone.client.v1.CNode;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.configuration.Settings;
import org.dataone.mimemultipart.SimpleMultipartEntity;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidCredentials;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.ChecksumAlgorithmList;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeList;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormat;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectFormatList;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.ObjectLocationList;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.types.v1.util.NodelistUtil;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.util.D1Url;
import org.jibx.runtime.JiBXException;

public class MultipartCNode
extends MultipartD1Node
implements CNode {
    protected static Log log = LogFactory.getLog(MultipartCNode.class);
    private Map<String, String> nodeId2URLMap;
    private long lastNodeListRefreshTimeMS = 0L;
    private Integer nodelistRefreshIntervalSeconds = 120;

    @Deprecated
    public MultipartCNode(String nodeBaseServiceUrl) throws IOException, ClientSideException {
        super(nodeBaseServiceUrl);
        this.nodeType = NodeType.CN;
        this.nodelistRefreshIntervalSeconds = Settings.getConfiguration().getInteger("CNode.nodemap.cache.refresh.interval.seconds", this.nodelistRefreshIntervalSeconds);
    }

    public MultipartCNode(MultipartRestClient mrc, String nodeBaseServiceUrl) {
        super(mrc, nodeBaseServiceUrl);
        this.nodeType = NodeType.CN;
        this.nodelistRefreshIntervalSeconds = Settings.getConfiguration().getInteger("CNode.nodemap.cache.refresh.interval.seconds", this.nodelistRefreshIntervalSeconds);
    }

    public MultipartCNode(MultipartRestClient mrc, String nodeBaseServiceUrl, Session session) {
        super(mrc, nodeBaseServiceUrl, session);
        this.nodeType = NodeType.CN;
        this.nodelistRefreshIntervalSeconds = Settings.getConfiguration().getInteger("CNode.nodemap.cache.refresh.interval.seconds", this.nodelistRefreshIntervalSeconds);
    }

    @Override
    public String getNodeBaseServiceUrl() {
        D1Url url = new D1Url(super.getNodeBaseServiceUrl());
        url.addNextPathElement("v1");
        return url.getUrl();
    }

    public String lookupNodeBaseUrl(String nodeId) throws ServiceFailure, NotImplemented {
        if (nodeId == null) {
            nodeId = "";
        }
        String url = null;
        if (this.isNodeMapStale()) {
            this.refreshNodeMap();
            url = this.nodeId2URLMap.get(nodeId);
        } else {
            url = this.nodeId2URLMap.get(nodeId);
            if (url == null) {
                this.refreshNodeMap();
                url = this.nodeId2URLMap.get(nodeId);
            }
        }
        return url;
    }

    public String lookupNodeBaseUrl(NodeReference nodeRef) throws ServiceFailure, NotImplemented {
        String nodeId;
        String string = nodeId = nodeRef == null ? "" : nodeRef.getValue();
        if (nodeId == null) {
            nodeId = "";
        }
        String url = null;
        if (this.isNodeMapStale()) {
            this.refreshNodeMap();
            url = this.nodeId2URLMap.get(nodeId);
        } else {
            url = this.nodeId2URLMap.get(nodeId);
            if (url == null) {
                this.refreshNodeMap();
                url = this.nodeId2URLMap.get(nodeId);
            }
        }
        return url;
    }

    public String lookupNodeId(String nodeBaseUrl) throws ServiceFailure, NotImplemented {
        String nodeId = "";
        if (this.isNodeMapStale()) {
            this.refreshNodeMap();
        }
        for (String key : this.nodeId2URLMap.keySet()) {
            if (!nodeBaseUrl.equals(this.nodeId2URLMap.get(key))) continue;
            nodeId = key;
            break;
        }
        return nodeId;
    }

    private void refreshNodeMap() throws ServiceFailure, NotImplemented {
        this.nodeId2URLMap = NodelistUtil.mapNodeList((NodeList)this.listNodes());
    }

    public Set<String> listNodeIds() throws ServiceFailure, NotImplemented {
        if (this.isNodeMapStale()) {
            this.refreshNodeMap();
        }
        return this.nodeId2URLMap.keySet();
    }

    private boolean isNodeMapStale() {
        if (this.nodeId2URLMap == null) {
            return true;
        }
        Date now = new Date();
        long nowMS = now.getTime();
        DateFormat df = DateFormat.getDateTimeInstance();
        df.format(now);
        long refreshIntervalMS = (long)this.nodelistRefreshIntervalSeconds.intValue() * 1000L;
        if (nowMS - this.lastNodeListRefreshTimeMS > refreshIntervalMS) {
            this.lastNodeListRefreshTimeMS = nowMS;
            log.info((Object)("  CNode nodelist refresh: new cached time: " + df.format(now)));
            return true;
        }
        return false;
    }

    public ObjectFormatList listFormats() throws ServiceFailure, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "formats");
        ObjectFormatList formatList = null;
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            formatList = this.deserializeServiceType(ObjectFormatList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return formatList;
    }

    public ObjectFormat getFormat(ObjectFormatIdentifier formatid) throws ServiceFailure, NotFound, NotImplemented {
        org.dataone.service.types.v2.ObjectFormat objectFormat = null;
        boolean useObjectFormatCache = false;
        useObjectFormatCache = Settings.getConfiguration().getBoolean("CNode.useObjectFormatCache", useObjectFormatCache);
        if (useObjectFormatCache) {
            try {
                objectFormat = ObjectFormatCache.getInstance().getFormat(formatid);
            }
            catch (BaseException be) {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
            }
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "formats");
        url.addNextPathElement(formatid.getValue());
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            objectFormat = this.deserializeServiceType(ObjectFormat.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return objectFormat;
    }

    public ObjectList listObjects(Session session, Date fromDate, Date toDate, ObjectFormatIdentifier formatid, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        if (toDate != null && fromDate != null && !toDate.after(fromDate)) {
            throw new InvalidRequest("1000", "fromDate must be before toDate in listObjects() call. " + fromDate + " " + toDate);
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        url.addDateParamPair("fromDate", fromDate);
        url.addDateParamPair("toDate", toDate);
        if (formatid != null) {
            url.addNonEmptyParamPair("formatId", formatid.getValue());
        }
        if (replicaStatus != null) {
            if (replicaStatus.booleanValue()) {
                url.addNonEmptyParamPair("replicaStatus", Integer.valueOf(1));
            } else {
                url.addNonEmptyParamPair("replicaStatus", Integer.valueOf(0));
            }
        }
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        ObjectList objectList = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            objectList = this.deserializeServiceType(ObjectList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return objectList;
    }

    public ObjectList listObjects(Date fromDate, Date toDate, ObjectFormatIdentifier formatid, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return this.listObjects(null, fromDate, toDate, formatid, replicaStatus, start, count);
    }

    public ChecksumAlgorithmList listChecksumAlgorithms() throws ServiceFailure, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "checksum");
        ChecksumAlgorithmList algorithmList = null;
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            algorithmList = this.deserializeServiceType(ChecksumAlgorithmList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return algorithmList;
    }

    public org.dataone.service.types.v1.Log getLogRecords(Session session, Date fromDate, Date toDate, Event event, String idFilter, Integer start, Integer count) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "log");
        url.addDateParamPair("fromDate", fromDate);
        url.addDateParamPair("toDate", toDate);
        if (event != null) {
            url.addNonEmptyParamPair("event", event.xmlValue());
        }
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        url.addNonEmptyParamPair("idFilter", idFilter);
        org.dataone.service.types.v1.Log log = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.D1Node.getLogRecords.timeout", null));
            log = this.deserializeServiceType(org.dataone.service.types.v1.Log.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return log;
    }

    public org.dataone.service.types.v1.Log getLogRecords(Date fromDate, Date toDate, Event event, String idFilter, Integer start, Integer count) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        return this.getLogRecords(null, fromDate, toDate, event, idFilter, start, count);
    }

    public NodeList listNodes() throws NotImplemented, ServiceFailure {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        NodeList nodelist = null;
        try {
            InputStream is = this.getRestClient(this.defaultSession).doGetRequest(url.getUrl(), null);
            nodelist = this.deserializeServiceType(NodeList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return nodelist;
    }

    public Identifier reserveIdentifier(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, NotImplemented, InvalidRequest {
        return this.reserveIdentifier(this.defaultSession, pid);
    }

    public Identifier reserveIdentifier(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "reserve");
        SimpleMultipartEntity smpe = new SimpleMultipartEntity();
        if (pid == null) {
            throw new InvalidRequest("0000", "PID cannot be null");
        }
        smpe.addParamPart("pid", pid.getValue());
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), smpe, Settings.getConfiguration().getInteger("D1Client.CNode.reserveIdentifier.timeout", null));
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    public boolean hasReservation(Subject subject, Identifier pid) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, InvalidRequest, NotImplemented {
        return this.hasReservation(this.defaultSession, subject, pid);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasReservation(Session session, Subject subject, Identifier pid) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, InvalidRequest, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "reserve");
        try {
            if (subject != null) {
                url.addNonEmptyParamPair("subject", subject.getValue());
            }
            if (pid != null) {
                url.addNextPathElement(pid.getValue());
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof NotImplemented)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotImplemented)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public Identifier create(Identifier pid, InputStream object, SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        return this.create(this.defaultSession, pid, object, sysmeta);
    }

    public Identifier create(Session session, Identifier pid, InputStream object, SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        if (pid == null) {
            throw new InvalidRequest("0000", "PID cannot be null");
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addParamPart("pid", pid.getValue());
            if (object == null) {
                mpe.addFilePart("object", "");
            } else {
                mpe.addFilePart("object", object);
            }
            mpe.addFilePart("sysmeta", (Object)sysmeta);
        }
        catch (IOException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        catch (JiBXException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.create.timeouts", null));
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)((Object)be);
            }
            if (be instanceof UnsupportedType) {
                throw (UnsupportedType)be;
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)((Object)be);
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    public Identifier registerSystemMetadata(Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        return this.registerSystemMetadata(this.defaultSession, pid, sysmeta);
    }

    public Identifier registerSystemMetadata(Session session, Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "meta");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addParamPart("pid", pid.getValue());
            mpe.addFilePart("sysmeta", (Object)sysmeta);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.registerSystemMetadata.timeouts", null));
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidSystemMetadata) {
                throw (InvalidSystemMetadata)be;
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    public boolean setObsoletedBy(Identifier pid, Identifier obsoletedByPid, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        return this.setObsoletedBy(this.defaultSession, pid, obsoletedByPid, serialVersion);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setObsoletedBy(Session session, Identifier pid, Identifier obsoletedByPid, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "obsoletedBy");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (obsoletedByPid != null) {
            mpe.addParamPart("obsoletedByPid", obsoletedByPid.getValue());
        }
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof VersionMismatch)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (VersionMismatch)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    protected SystemMetadata getSystemMetadata(Session session, Identifier pid, boolean useSystemMetadataCache) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "meta");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SystemMetadata sysmeta = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.D1Node.getSystemMetadata.timeout", null));
            sysmeta = this.deserializeServiceType(SystemMetadata.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return sysmeta;
    }

    public SystemMetadata getSystemMetadata(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.getSystemMetadata(session, pid, false);
    }

    public SystemMetadata getSystemMetadata(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.getSystemMetadata(null, pid, false);
    }

    public ObjectLocationList resolve(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.resolve(this.defaultSession, pid);
    }

    public ObjectLocationList resolve(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "resolve");
        if (pid == null) {
            throw new NotFound("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        ObjectLocationList oll = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null, false);
            oll = this.deserializeServiceType(ObjectLocationList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return oll;
    }

    @Override
    public InputStream get(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        try {
            return super.get(pid);
        }
        catch (InsufficientResources e) {
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
    }

    @Override
    public InputStream get(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        try {
            return super.get(session, pid);
        }
        catch (InsufficientResources e) {
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
    }

    public Checksum getChecksum(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        Checksum cs = null;
        try {
            cs = super.getChecksum(pid, null);
        }
        catch (InvalidRequest e) {
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
        return cs;
    }

    public Checksum getChecksum(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        Checksum cs = null;
        try {
            cs = super.getChecksum(session, pid, null);
        }
        catch (InvalidRequest e) {
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure((BaseException)((Object)e));
        }
        return cs;
    }

    public ObjectList search(String queryType, D1Url queryD1url) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return this.search(this.defaultSession, queryType, queryD1url);
    }

    public ObjectList search(Session session, String queryType, D1Url queryD1url) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        String pathAndQueryString = queryD1url.getUrl();
        return this.search(session, queryType, pathAndQueryString);
    }

    public ObjectList search(String queryType, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return this.search(this.defaultSession, queryType, query);
    }

    public ObjectList search(Session session, String queryType, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "search");
        url.addNextPathElement(queryType);
        String finalUrl = url.getUrl() + "/" + query;
        ObjectList objectList = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(finalUrl, null);
            objectList = this.deserializeServiceType(ObjectList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return objectList;
    }

    public Identifier setRightsHolder(Identifier pid, Subject userId, long serialVersion) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, VersionMismatch {
        return this.setRightsHolder(this.defaultSession, pid, userId, serialVersion);
    }

    public Identifier setRightsHolder(Session session, Identifier pid, Subject userId, long serialVersion) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "owner");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (userId == null) {
            throw new InvalidRequest("0000", "parameter 'userId' cannot be null");
        }
        mpe.addParamPart("userId", userId.getValue());
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        Identifier identifier = null;
        try {
            InputStream is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof VersionMismatch) {
                throw (VersionMismatch)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return identifier;
    }

    public boolean setAccessPolicy(Identifier pid, AccessPolicy accessPolicy, long serialVersion) throws InvalidToken, NotFound, NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, VersionMismatch {
        return this.setAccessPolicy(this.defaultSession, pid, accessPolicy, serialVersion);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setAccessPolicy(Session session, Identifier pid, AccessPolicy accessPolicy, long serialVersion) throws InvalidToken, NotFound, NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accessRules");
        if (pid == null) {
            throw new InvalidRequest("0000", "'pid' cannot be null");
        }
        url.addNextPathElement(pid.getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("accessPolicy", (Object)accessPolicy);
            mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof VersionMismatch)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (VersionMismatch)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public Subject registerAccount(Person person) throws ServiceFailure, NotAuthorized, IdentifierNotUnique, InvalidCredentials, NotImplemented, InvalidRequest, InvalidToken {
        return this.registerAccount(this.defaultSession, person);
    }

    public Subject registerAccount(Session session, Person person) throws ServiceFailure, NotAuthorized, IdentifierNotUnique, InvalidCredentials, NotImplemented, InvalidRequest, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("person", (Object)person);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        Subject subject = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
            subject = this.deserializeServiceType(Subject.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)((Object)be);
            }
            if (be instanceof InvalidCredentials) {
                throw (InvalidCredentials)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subject;
    }

    public Subject updateAccount(Person person) throws ServiceFailure, NotAuthorized, InvalidCredentials, NotImplemented, InvalidRequest, InvalidToken, NotFound {
        return this.updateAccount(this.defaultSession, person);
    }

    public Subject updateAccount(Session session, Person person) throws ServiceFailure, NotAuthorized, InvalidCredentials, NotImplemented, InvalidRequest, InvalidToken, NotFound {
        if (person.getSubject() == null) {
            throw new NotFound("0000", "'person.subject' cannot be null");
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        url.addNextPathElement(person.getSubject().getValue());
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("person", (Object)person);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        Subject subject = null;
        try {
            InputStream is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
            subject = this.deserializeServiceType(Subject.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof InvalidCredentials) {
                throw (InvalidCredentials)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subject;
    }

    public boolean verifyAccount(Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, InvalidToken, InvalidRequest {
        return this.verifyAccount(this.defaultSession, subject);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyAccount(Session session, Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, InvalidToken, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/verification");
        if (subject == null) {
            throw new InvalidRequest("0000", "'subject' cannot be null");
        }
        url.addNextPathElement(subject.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), null, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (!(be instanceof InvalidRequest)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (InvalidRequest)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public SubjectInfo getSubjectInfo(Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, NotFound, InvalidToken {
        return this.getSubjectInfo(this.defaultSession, subject);
    }

    public SubjectInfo getSubjectInfo(Session session, Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, NotFound, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        if (subject == null) {
            throw new NotFound("0000", "'subject' cannot be null");
        }
        url.addNextPathElement(subject.getValue());
        SubjectInfo subjectInfo = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            subjectInfo = this.deserializeServiceType(SubjectInfo.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subjectInfo;
    }

    public SubjectInfo listSubjects(String query, String status, Integer start, Integer count) throws InvalidRequest, ServiceFailure, InvalidToken, NotAuthorized, NotImplemented {
        return this.listSubjects(this.defaultSession, query, status, start, count);
    }

    public SubjectInfo listSubjects(Session session, String query, String status, Integer start, Integer count) throws InvalidRequest, ServiceFailure, InvalidToken, NotAuthorized, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts");
        url.addNonEmptyParamPair("query", query);
        url.addNonEmptyParamPair("status", status);
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        SubjectInfo subjectInfo = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            subjectInfo = this.deserializeServiceType(SubjectInfo.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subjectInfo;
    }

    public boolean mapIdentity(Subject primarySubject, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest, IdentifierNotUnique {
        return this.mapIdentity(this.defaultSession, primarySubject, secondarySubject);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mapIdentity(Session session, Subject primarySubject, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest, IdentifierNotUnique {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/map");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (primarySubject != null) {
            mpe.addParamPart("primarySubject", primarySubject.getValue());
        }
        if (secondarySubject != null) {
            mpe.addParamPart("secondarySubject", secondarySubject.getValue());
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof IdentifierNotUnique)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (IdentifierNotUnique)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public boolean requestMapIdentity(Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest, IdentifierNotUnique {
        return this.requestMapIdentity(this.defaultSession, subject);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean requestMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest, IdentifierNotUnique {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        mpe.addParamPart("subject", subject.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof IdentifierNotUnique)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (IdentifierNotUnique)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public SubjectInfo getPendingMapIdentity(Subject subject) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.getPendingMapIdentity(this.defaultSession, subject);
    }

    public SubjectInfo getPendingMapIdentity(Session session, Subject subject) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        url.addNextPathElement(subject.getValue());
        SubjectInfo subjectInfo = null;
        try {
            InputStream is = this.getRestClient(session).doGetRequest(url.getUrl(), null);
            subjectInfo = this.deserializeServiceType(SubjectInfo.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subjectInfo;
    }

    public boolean confirmMapIdentity(Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        return this.confirmMapIdentity(this.defaultSession, subject);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean confirmMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        url.addNextPathElement(subject.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), null, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (!(be instanceof NotImplemented)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotImplemented)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public boolean denyMapIdentity(Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        return this.denyMapIdentity(this.defaultSession, subject);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean denyMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/pendingmap");
        url.addNextPathElement(subject.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doDeleteRequest(url.getUrl(), null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (!(be instanceof NotImplemented)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotImplemented)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public boolean removeMapIdentity(Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        return this.removeMapIdentity(this.defaultSession, subject);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "accounts/map");
        url.addNextPathElement(subject.getValue());
        InputStream is = null;
        try {
            is = this.getRestClient(session).doDeleteRequest(url.getUrl(), null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (!(be instanceof NotImplemented)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotImplemented)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public Subject createGroup(Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented, IdentifierNotUnique {
        return this.createGroup(this.defaultSession, group);
    }

    public Subject createGroup(Session session, Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented, IdentifierNotUnique {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "groups");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("group", (Object)group);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        Subject subject = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
            subject = this.deserializeServiceType(Subject.class, is);
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)((Object)be);
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return subject;
    }

    public boolean updateGroup(Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        return this.updateGroup(this.defaultSession, group);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateGroup(Session session, Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "groups");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("group", (Object)group);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (!(be instanceof InvalidRequest)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (InvalidRequest)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public boolean updateNodeCapabilities(NodeReference nodeid, Node node) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, NotFound, InvalidToken {
        return this.updateNodeCapabilities(this.defaultSession, nodeid, node);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateNodeCapabilities(Session session, NodeReference nodeid, Node node) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, NotFound, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        if (nodeid != null) {
            url.addNextPathElement(nodeid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("node", (Object)node);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, null);
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (!(be instanceof NotFound)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotFound)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public NodeReference register(Node node) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, IdentifierNotUnique, InvalidToken {
        return this.register(this.defaultSession, node);
    }

    public NodeReference register(Session session, Node node) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, IdentifierNotUnique, InvalidToken {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "node");
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("node", (Object)node);
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        NodeReference nodeRef = null;
        try {
            InputStream is = this.getRestClient(session).doPostRequest(url.getUrl(), mpe, null);
            nodeRef = this.deserializeServiceType(NodeReference.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof IdentifierNotUnique) {
                throw (IdentifierNotUnique)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientSideException e) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
        return nodeRef;
    }

    public boolean setReplicationStatus(Identifier pid, NodeReference nodeRef, ReplicationStatus status, BaseException failure) throws ServiceFailure, NotImplemented, InvalidToken, NotAuthorized, InvalidRequest, NotFound {
        return this.setReplicationStatus(this.defaultSession, pid, nodeRef, status, failure);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setReplicationStatus(Session session, Identifier pid, NodeReference nodeRef, ReplicationStatus status, BaseException failure) throws ServiceFailure, NotImplemented, InvalidToken, NotAuthorized, InvalidRequest, NotFound {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaNotifications");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        mpe.addParamPart("nodeRef", nodeRef.getValue());
        mpe.addParamPart("status", status.xmlValue());
        try {
            if (failure != null) {
                mpe.addFilePart("failure", failure.serialize(0));
            }
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof NotFound)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (NotFound)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public boolean setReplicationPolicy(Identifier pid, ReplicationPolicy policy, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        return this.setReplicationPolicy(this.defaultSession, pid, policy, serialVersion);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setReplicationPolicy(Session session, Identifier pid, ReplicationPolicy policy, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaPolicies");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("policy", (Object)policy);
            mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (!(be instanceof VersionMismatch)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (VersionMismatch)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public boolean isNodeAuthorized(Subject targetNodeSubject, Identifier pid) throws NotImplemented, NotAuthorized, InvalidToken, ServiceFailure, NotFound, InvalidRequest {
        return this.isNodeAuthorized(this.defaultSession, targetNodeSubject, pid);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNodeAuthorized(Session session, Subject targetNodeSubject, Identifier pid) throws NotImplemented, NotAuthorized, InvalidToken, ServiceFailure, NotFound, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaAuthorizations");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        if (targetNodeSubject != null) {
            url.addNonEmptyParamPair("targetNodeSubject", targetNodeSubject.getValue());
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doGetRequest(url.getUrl(), Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (!(be instanceof InvalidRequest)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (InvalidRequest)((Object)be);
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public boolean updateReplicationMetadata(Identifier pid, Replica replicaMetadata, long serialVersion) throws NotImplemented, NotAuthorized, ServiceFailure, NotFound, InvalidRequest, InvalidToken, VersionMismatch {
        return this.updateReplicationMetadata(this.defaultSession, pid, replicaMetadata, serialVersion);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateReplicationMetadata(Session session, Identifier pid, Replica replicaMetadata, long serialVersion) throws NotImplemented, NotAuthorized, ServiceFailure, NotFound, InvalidRequest, InvalidToken, VersionMismatch {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "replicaMetadata");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        try {
            mpe.addFilePart("replicaMetadata", (Object)replicaMetadata);
            mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        }
        catch (IOException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e1);
        }
        catch (JiBXException e1) {
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure((Exception)((Object)e1));
        }
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (!(be instanceof VersionMismatch)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (VersionMismatch)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public boolean deleteReplicationMetadata(Identifier pid, NodeReference nodeId, long serialVersion) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, VersionMismatch, InvalidRequest {
        return this.deleteReplicationMetadata(this.defaultSession, pid, nodeId, serialVersion);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteReplicationMetadata(Session session, Identifier pid, NodeReference nodeId, long serialVersion) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, VersionMismatch, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "removeReplicaMetadata");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        SimpleMultipartEntity mpe = new SimpleMultipartEntity();
        if (nodeId != null) {
            mpe.addParamPart("nodeId", nodeId.getValue());
        }
        mpe.addParamPart("serialVersion", String.valueOf(serialVersion));
        InputStream is = null;
        try {
            is = this.getRestClient(session).doPutRequest(url.getUrl(), mpe, Settings.getConfiguration().getInteger("D1Client.CNode.replication.timeout", null));
        }
        catch (BaseException be) {
            try {
                if (be instanceof NotImplemented) {
                    throw (NotImplemented)((Object)be);
                }
                if (be instanceof NotAuthorized) {
                    throw (NotAuthorized)((Object)be);
                }
                if (be instanceof ServiceFailure) {
                    throw (ServiceFailure)((Object)be);
                }
                if (be instanceof NotFound) {
                    throw (NotFound)((Object)be);
                }
                if (be instanceof InvalidToken) {
                    throw (InvalidToken)be;
                }
                if (be instanceof InvalidRequest) {
                    throw (InvalidRequest)((Object)be);
                }
                if (!(be instanceof VersionMismatch)) throw ExceptionUtils.recastDataONEExceptionToServiceFailure(be);
                throw (VersionMismatch)be;
                catch (ClientSideException e) {
                    throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
                }
            }
            catch (Throwable throwable) {
                MultipartD1Node.closeLoudly(is);
                throw throwable;
            }
        }
        MultipartD1Node.closeLoudly(is);
        return true;
    }

    public InputStream query(String queryEngine, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        return super.query(null, queryEngine, query);
    }

    public QueryEngineDescription getQueryEngineDescription(String queryEngine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        return super.getQueryEngineDescription(null, queryEngine);
    }

    public QueryEngineList listQueryEngines() throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        return super.listQueryEngines(null);
    }
}

