/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v2.itk;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang.StringUtils;
import org.dataone.client.types.AccessPolicyEditor;
import org.dataone.client.v1.MNode;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectLocation;
import org.dataone.service.types.v1.ObjectLocationList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;

public class D1Object {
    private SystemMetadata sysmeta;
    private DataSource data;
    private boolean alreadyCreated = false;

    public D1Object() {
        this.sysmeta = new SystemMetadata();
    }

    @Deprecated
    public D1Object(Identifier id, byte[] data, String formatValue, String rightsHolderValue, String nodeIdValue) throws NoSuchAlgorithmException, IOException, NotFound, InvalidRequest {
        this.alreadyCreated = false;
        this.data = new ByteArrayDataSource(data, formatValue);
        ObjectFormatIdentifier formatId = new ObjectFormatIdentifier();
        formatId.setValue(formatValue);
        Subject submitter = new Subject();
        submitter.setValue(rightsHolderValue);
        NodeReference nodeRef = new NodeReference();
        nodeRef.setValue(nodeIdValue);
        try {
            this.sysmeta = this.generateSystemMetadata(id, this.data.getInputStream(), formatId, submitter, nodeRef);
        }
        catch (ServiceFailure e) {
            throw new NotFound("0", "recast ServiceFailure: " + e.getDescription());
        }
        catch (NotImplemented e) {
            throw new NotFound("0", "recast NotImplemented: " + e.getDescription());
        }
    }

    @Deprecated
    public D1Object(Identifier id, byte[] data, ObjectFormatIdentifier formatId, Subject rightsHolder, NodeReference nodeId) throws NoSuchAlgorithmException, IOException, NotFound, InvalidRequest {
        this.alreadyCreated = false;
        this.data = new ByteArrayDataSource(data, formatId == null ? null : formatId.getValue());
        try {
            this.sysmeta = this.generateSystemMetadata(id, this.data.getInputStream(), formatId, rightsHolder, nodeId);
        }
        catch (ServiceFailure e) {
            throw new NotFound("0", "recast ServiceFailure: " + e.getDescription());
        }
        catch (NotImplemented e) {
            throw new NotFound("0", "recast NotImplemented: " + e.getDescription());
        }
    }

    public D1Object(Identifier id, DataSource data, ObjectFormatIdentifier formatId, Subject submitter, NodeReference nodeId) throws NoSuchAlgorithmException, IOException, NotFound, InvalidRequest {
        this.alreadyCreated = false;
        this.data = data;
        try {
            this.sysmeta = this.generateSystemMetadata(id, data.getInputStream(), formatId, submitter, nodeId);
        }
        catch (ServiceFailure e) {
            throw new NotFound("0", "recast ServiceFailure: " + e.getDescription());
        }
        catch (NotImplemented e) {
            throw new NotFound("0", "recast NotImplemented: " + e.getDescription());
        }
    }

    public Identifier getIdentifier() {
        return this.sysmeta.getIdentifier();
    }

    @Deprecated
    public ObjectFormatIdentifier getFmtId() {
        return this.sysmeta.getFormatId();
    }

    public ObjectFormatIdentifier getFormatId() {
        return this.sysmeta.getFormatId();
    }

    public SystemMetadata getSystemMetadata() {
        return this.sysmeta;
    }

    public void setSystemMetadata(SystemMetadata sysmeta) throws InvalidRequest {
        if (sysmeta == null) {
            throw new InvalidRequest("Client Error", "sysmeta cannot be null");
        }
        this.sysmeta = sysmeta;
    }

    public byte[] getData() throws IOException {
        return IOUtils.toByteArray((InputStream)this.data.getInputStream());
    }

    public void setData(byte[] data) throws InvalidRequest {
        if (data == null) {
            throw new InvalidRequest("Client Error", "data cannot be null");
        }
        this.data = new ByteArrayDataSource(data, null);
    }

    public DataSource getDataSource() {
        return this.data;
    }

    public void setDataSource(DataSource dataSource) {
        this.data = dataSource;
    }

    public void setPublicAccess(Session token) throws ServiceFailure, InvalidToken, NotFound, NotAuthorized, NotImplemented, InvalidRequest, VersionMismatch {
        AccessPolicy ap = new AccessPolicy();
        AccessRule ar = new AccessRule();
        Subject s = new Subject();
        s.setValue("public");
        ar.addSubject(s);
        ar.addPermission(Permission.READ);
        ap.addAllow(ar);
        if (this.alreadyCreated) {
            SystemMetadata smd = D1Client.getCN().getSystemMetadata(token, this.getIdentifier());
            D1Client.getCN().setAccessPolicy(token, this.sysmeta.getIdentifier(), ap, smd.getSerialVersion().longValue());
        } else {
            this.sysmeta.setAccessPolicy(ap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static D1Object download(Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources, InvalidRequest {
        D1Object o = null;
        boolean gotData = false;
        Throwable latestException = null;
        try {
            CNode cn = D1Client.getCN();
            SystemMetadata m = cn.getSystemMetadata(null, id);
            if (m != null) {
                o = new D1Object();
                o.setSystemMetadata(m);
            }
            ObjectLocationList oll = cn.resolve(null, id);
            for (ObjectLocation ol : oll.getObjectLocationList()) {
                System.out.println("   === Trying Location: " + ol.getNodeIdentifier().getValue() + " (" + ol.getUrl() + ")");
                MNode v1mn = null;
                Object v2mn = null;
                v1mn = org.dataone.client.v1.itk.D1Client.getMN(ol.getNodeIdentifier());
                List services = v1mn.getCapabilities().getServices().getServiceList();
                boolean v2GetIsAvailable = false;
                for (Service service : services) {
                    String serviceName = service.getName();
                    String serviceVersion = service.getVersion();
                    Boolean isAvailable = service.getAvailable();
                    if (serviceName != "MNRead" || serviceVersion.toLowerCase() != "v2" || !isAvailable.booleanValue()) continue;
                    v2GetIsAvailable = true;
                    break;
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                String tempDirStr = "";
                File tempFile = null;
                File tempDir = null;
                try {
                    int len;
                    inputStream = v2GetIsAvailable ? v2mn.get(null, id) : v1mn.get(id);
                    tempDirStr = Settings.getConfiguration().getString("D1Client.io.tmpdir", System.getProperty("java.io.tmpdir"));
                    if (tempDirStr != null) {
                        tempDir = new File(tempDirStr);
                    }
                    tempFile = File.createTempFile("d1_libclient_java.", ".tmp", tempDir);
                    FileDataSource dataSource = new FileDataSource(tempFile);
                    outputStream = dataSource.getOutputStream();
                    byte[] bytes = new byte[4096];
                    while ((len = inputStream.read(bytes)) > 0) {
                        outputStream.write(bytes, 0, len);
                    }
                    o.setDataSource((DataSource)dataSource);
                    gotData = true;
                }
                catch (IOException e) {
                    latestException = e;
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(inputStream);
                            IOUtils.closeQuietly(outputStream);
                            if (tempFile == null || !tempFile.exists()) throw throwable;
                            tempFile.deleteOnExit();
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly(outputStream);
                    if (tempFile == null || !tempFile.exists()) continue;
                    tempFile.deleteOnExit();
                    continue;
                    catch (BaseException e2) {
                        latestException = e2;
                        IOUtils.closeQuietly((InputStream)inputStream);
                        IOUtils.closeQuietly(outputStream);
                        if (tempFile == null || !tempFile.exists()) continue;
                        tempFile.deleteOnExit();
                        continue;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                break;
            }
        }
        catch (BaseException be) {
            latestException = be;
        }
        if (!gotData) {
            if (latestException == null) {
                throw new ServiceFailure("0000: Client Error", "Unexpected failure.  Could not get the request object, but no exception raised");
            }
            if (latestException instanceof InvalidToken) {
                throw (InvalidToken)latestException;
            }
            if (latestException instanceof ServiceFailure) {
                throw (ServiceFailure)latestException;
            }
            if (latestException instanceof NotAuthorized) {
                throw (NotAuthorized)latestException;
            }
            if (latestException instanceof NotFound) {
                throw (NotFound)latestException;
            }
            if (latestException instanceof NotImplemented) {
                throw (NotImplemented)latestException;
            }
            if (latestException instanceof InsufficientResources) {
                throw (InsufficientResources)latestException;
            }
            if (!(latestException instanceof InvalidRequest)) return o;
            throw (InvalidRequest)latestException;
        } else {
            o.alreadyCreated = true;
        }
        return o;
    }

    private SystemMetadata generateSystemMetadata(Identifier id, InputStream data, ObjectFormatIdentifier formatId, Subject rightsHolder, NodeReference nodeId) throws NoSuchAlgorithmException, IOException, NotFound, InvalidRequest, ServiceFailure, NotImplemented {
        ObjectFormat fmt;
        D1Object.validateRequest(id, "ignore".getBytes(), formatId, rightsHolder, nodeId);
        SystemMetadata sm = new SystemMetadata();
        sm.setIdentifier(id);
        try {
            fmt = ObjectFormatCache.getInstance().getFormat(formatId);
        }
        catch (BaseException be) {
            formatId.setValue("application/octet-stream");
            fmt = ObjectFormatCache.getInstance().getFormat(formatId);
        }
        sm.setFormatId(fmt.getFormatId());
        CountingInputStream cis = new CountingInputStream(data);
        Checksum checksum = ChecksumUtil.checksum((InputStream)cis, (String)"MD5");
        sm.setChecksum(checksum);
        sm.setSize(new BigInteger(String.valueOf(cis.getByteCount())));
        sm.setSerialVersion(BigInteger.ONE);
        if (rightsHolder != null) {
            sm.setRightsHolder(rightsHolder);
        }
        Date dateCreated = new Date();
        sm.setDateUploaded(dateCreated);
        Date dateUpdated = new Date();
        sm.setDateSysMetadataModified(dateUpdated);
        sm.setOriginMemberNode(nodeId);
        sm.setAuthoritativeMemberNode(nodeId);
        return sm;
    }

    protected static void validateRequest(Identifier id, byte[] data, ObjectFormatIdentifier formatId, Subject rightsHolder, NodeReference nodeId) throws InvalidRequest {
        List<Object> objects = Arrays.asList(id, data, formatId, rightsHolder, nodeId);
        D1Object.checkNotNull(objects);
        String invalidParams = "";
        if (StringUtils.isEmpty((String)id.getValue())) {
            invalidParams = invalidParams + "'id' ";
        }
        if (StringUtils.isEmpty((String)formatId.getValue())) {
            invalidParams = invalidParams + "'formatId' ";
        }
        if (StringUtils.isEmpty((String)rightsHolder.getValue())) {
            invalidParams = invalidParams + "'rightsHolder' ";
        }
        if (StringUtils.isEmpty((String)nodeId.getValue())) {
            invalidParams = invalidParams + "'nodeId' ";
        }
        if (StringUtils.isNotEmpty((String)invalidParams)) {
            throw new InvalidRequest("0", "values for " + invalidParams + "parameters were empty or null.");
        }
    }

    public static void checkNotNull(List<Object> objects) throws InvalidRequest {
        for (Object obj : objects) {
            if (obj != null) continue;
            throw new InvalidRequest("0", "Parameter was null.  Provide all parameters.");
        }
    }

    protected static void checkLength(List<String> strings) throws InvalidRequest {
        for (String string : strings) {
            if (string.length() >= 1) continue;
            throw new InvalidRequest("0", "String parameter had length 0.");
        }
    }

    public boolean checkDataIntegrity() throws NoSuchAlgorithmException, IOException {
        Checksum calcd = ChecksumUtil.checksum((InputStream)this.data.getInputStream(), (String)this.sysmeta.getChecksum().getAlgorithm());
        return calcd.getValue().equals(this.sysmeta.getChecksum().getValue());
    }

    public AccessPolicyEditor getAccessPolicyEditor() {
        AccessPolicy ap = this.sysmeta.getAccessPolicy();
        if (ap == null) {
            this.sysmeta.setAccessPolicy(new AccessPolicy());
        }
        return new AccessPolicyEditor(this.sysmeta.getAccessPolicy());
    }

    public boolean refreshSystemMetadata(Integer retryTimeoutMS) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, InterruptedException {
        SystemMetadata smd = null;
        if (retryTimeoutMS == null) {
            retryTimeoutMS = 0;
        }
        try {
            smd = D1Client.getCN().getSystemMetadata(null, this.getIdentifier());
        }
        catch (BaseException be) {
            NodeReference nodeId = this.sysmeta.getAuthoritativeMemberNode();
            int interval = retryTimeoutMS > 40000 ? 10000 : 5000;
            for (int i = -1; i < retryTimeoutMS; i += interval) {
                try {
                    smd = D1Client.getMN(nodeId).getSystemMetadata(null, this.getIdentifier());
                    break;
                }
                catch (NotFound e) {
                    if (i + interval >= retryTimeoutMS) continue;
                    Thread.sleep(interval);
                    continue;
                }
            }
        }
        if (smd == null) {
            return false;
        }
        if (smd.getIdentifier().equals((Object)this.getSystemMetadata().getIdentifier())) {
            if (this.getSystemMetadata().getDateUploaded() != null && smd.getSerialVersion().compareTo(this.getSystemMetadata().getSerialVersion()) > 0) {
                try {
                    this.setSystemMetadata(smd);
                }
                catch (InvalidRequest invalidRequest) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
        throw new ServiceFailure("clientException", "The identifier for the retrieved systemMetadata doesn't match that of the local version.");
    }
}

