/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.ResourceReferenceRegistry;

public class SharedResources {
    private final ResourceReferenceRegistry registry;

    public SharedResources(ResourceReferenceRegistry registry) {
        this.registry = registry;
    }

    public final void add(Class<?> scope, String name, Locale locale, String style, String variation, IResource resource) {
        AutoResourceReference ref = new AutoResourceReference(scope, name, locale, style, variation, resource);
        this.registry.registerResourceReference(ref);
    }

    public final void add(String name, Locale locale, IResource resource) {
        this.add(Application.class, name, locale, null, null, resource);
    }

    public final void add(String name, IResource resource) {
        this.add(Application.class, name, null, null, null, resource);
    }

    public ResourceReference get(Class<?> scope, String name, Locale locale, String style, String variation, boolean strict) {
        return this.registry.getResourceReference(scope, name, locale, style, variation, strict, true);
    }

    public final ResourceReference remove(ResourceReference.Key key) {
        return this.registry.unregisterResourceReference(key);
    }

    private static final class AutoResourceReference
    extends ResourceReference {
        private static final long serialVersionUID = 1L;
        private final IResource resource;

        private AutoResourceReference(Class<?> scope, String name, Locale locale, String style, String variation, IResource resource) {
            super(scope, name, locale, style, variation);
            this.resource = resource;
        }

        @Override
        public IResource getResource() {
            return this.resource;
        }
    }
}

