/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.request.resource.CssPackageResource;
import org.apache.wicket.request.resource.JavaScriptPackageResource;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageResourceReference
extends ResourceReference {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PackageResourceReference.class);
    private static final String CSS_EXTENSION = "css";
    private static final String JAVASCRIPT_EXTENSION = "js";
    private transient ConcurrentMap<ResourceReference.UrlAttributes, ResourceReference.UrlAttributes> urlAttributesCacheMap;
    private static final ConcurrentMap<PackageResourceReference, String> MINIFIED_NAMES_CACHE = Generics.newConcurrentHashMap();
    private static final String NO_MINIFIED_NAME = new String();

    public PackageResourceReference(ResourceReference.Key key) {
        super(key);
    }

    public PackageResourceReference(Class<?> scope, String name, Locale locale, String style, String variation) {
        super(scope, name, locale, style, variation);
    }

    public PackageResourceReference(Class<?> scope, String name) {
        super(scope, name);
    }

    public PackageResourceReference(String name) {
        super(name);
    }

    @Override
    public PackageResource getResource() {
        String extension = this.getExtension();
        PackageResource resource = CSS_EXTENSION.equals(extension) ? new CssPackageResource(this.getScope(), this.getName(), this.getLocale(), this.getStyle(), this.getVariation()) : (JAVASCRIPT_EXTENSION.equals(extension) ? new JavaScriptPackageResource(this.getScope(), this.getName(), this.getLocale(), this.getStyle(), this.getVariation()) : new PackageResource(this.getScope(), this.getName(), this.getLocale(), this.getStyle(), this.getVariation()));
        String minifiedName = (String)MINIFIED_NAMES_CACHE.get(this);
        if (minifiedName != null && minifiedName != NO_MINIFIED_NAME) {
            resource.setCompress(false);
        }
        return resource;
    }

    private ResourceReference.UrlAttributes getUrlAttributes(Locale locale, String style, String variation) {
        IResourceStreamLocator locator = Application.get().getResourceSettings().getResourceStreamLocator();
        String absolutePath = Packages.absolutePath(this.getScope(), (String)this.getName());
        IResourceStream stream = locator.locate(this.getScope(), absolutePath, style, variation, locale, null, false);
        if (stream == null) {
            return new ResourceReference.UrlAttributes(null, null, null);
        }
        return new ResourceReference.UrlAttributes(stream.getLocale(), stream.getStyle(), stream.getVariation());
    }

    private Locale getCurrentLocale() {
        return this.getLocale() != null ? this.getLocale() : Session.get().getLocale();
    }

    private String getCurrentStyle() {
        return this.getStyle() != null ? this.getStyle() : Session.get().getStyle();
    }

    private String internalGetMinifiedName() {
        String minifiedName = (String)MINIFIED_NAMES_CACHE.get(this);
        if (minifiedName != null) {
            return minifiedName;
        }
        String name = this.getMinifiedName();
        IResourceStreamLocator locator = Application.get().getResourceSettings().getResourceStreamLocator();
        String absolutePath = Packages.absolutePath(this.getScope(), (String)name);
        IResourceStream stream = locator.locate(this.getScope(), absolutePath, this.getStyle(), this.getVariation(), this.getLocale(), null, true);
        minifiedName = stream != null ? name : NO_MINIFIED_NAME;
        MINIFIED_NAMES_CACHE.put(this, minifiedName);
        if (minifiedName == NO_MINIFIED_NAME && log.isDebugEnabled()) {
            log.debug("No minified version of '" + super.getName() + "' found, expected a file with the name '" + name + "', using full version");
        }
        return minifiedName;
    }

    protected String getMinifiedName() {
        String minifiedName;
        String name = super.getName();
        int idxOfExtension = name.lastIndexOf(46);
        if (idxOfExtension > -1) {
            String extension = name.substring(idxOfExtension);
            minifiedName = name.substring(0, name.length() - extension.length() + 1) + "min" + extension;
        } else {
            minifiedName = name + ".min";
        }
        return minifiedName;
    }

    @Override
    public String getName() {
        String minifiedName;
        String name = null;
        if (Application.exists() && Application.get().getResourceSettings().getUseMinifiedResources() && (minifiedName = this.internalGetMinifiedName()) != NO_MINIFIED_NAME) {
            name = minifiedName;
        }
        if (name == null) {
            name = super.getName();
        }
        return name;
    }

    @Override
    public ResourceReference.UrlAttributes getUrlAttributes() {
        ResourceReference.UrlAttributes tmpValue;
        ResourceReference.UrlAttributes value;
        Locale locale = this.getCurrentLocale();
        String style = this.getCurrentStyle();
        String variation = this.getVariation();
        ResourceReference.UrlAttributes key = new ResourceReference.UrlAttributes(locale, style, variation);
        if (this.urlAttributesCacheMap == null) {
            this.urlAttributesCacheMap = Generics.newConcurrentHashMap();
        }
        if ((value = (ResourceReference.UrlAttributes)this.urlAttributesCacheMap.get(key)) == null && (tmpValue = this.urlAttributesCacheMap.putIfAbsent(key, value = this.getUrlAttributes(locale, style, variation))) != null) {
            value = tmpValue;
        }
        return value;
    }
}

