/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.SimpleEntryImpl;
import edu.uiuc.ncsa.security.core.exceptions.ConfigurationException;
import edu.uiuc.ncsa.security.core.exceptions.FilePermissionsException;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.FSInitializer;
import edu.uiuc.ncsa.security.storage.IndexedStreamStore;
import edu.uiuc.ncsa.security.storage.XMLMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class FileStore<V extends Identifiable>
extends IndexedStreamStore<V> {
    protected File indexDirectory;
    protected File storageDirectory = null;

    protected void checkPermissions() {
        if (this.storageDirectory == null) {
            throw new ConfigurationException("Error: There is no storage directory specified for this file store.");
        }
        if (!this.storageDirectory.exists()) {
            throw new FilePermissionsException("Error: the storage directory " + this.storageDirectory.getAbsolutePath() + " does not exist.");
        }
        if (!this.storageDirectory.canRead()) {
            throw new FilePermissionsException("Error: the storage directory " + this.storageDirectory.getAbsolutePath() + " cannot be read.");
        }
        if (!this.storageDirectory.canWrite()) {
            throw new FilePermissionsException("Error: the store cannot write to the storage directory " + this.storageDirectory.getAbsolutePath() + ".");
        }
        if (this.indexDirectory == null) {
            throw new ConfigurationException("Error: There is no index directory specified for this file store.");
        }
        if (!this.indexDirectory.exists()) {
            throw new FilePermissionsException("Error: the index directory " + this.indexDirectory.getAbsolutePath() + " does not exist.");
        }
        if (!this.indexDirectory.canRead()) {
            throw new FilePermissionsException("Error: the index directory " + this.storageDirectory.getAbsolutePath() + " cannot be read.");
        }
        if (!this.indexDirectory.canWrite()) {
            throw new FilePermissionsException("Error: the store cannot write to the index directory " + this.storageDirectory.getAbsolutePath() + ".");
        }
    }

    protected FileStore(File storeDirectory, File indexDirectory, IdentifiableProvider<V> identifiableProvider, MapConverter<V> converter) {
        this.initializer = new FSInitializer(storeDirectory, indexDirectory);
        if (!this.initializer.isCreated() && !this.initializer.createNew()) {
            throw new GeneralException("Error: Could not create the store directory \"" + storeDirectory.getAbsolutePath() + "\" or maybe the index directory \"" + indexDirectory.getAbsolutePath() + "\". Please check paths and permissions");
        }
        this.indexDirectory = indexDirectory;
        this.storageDirectory = storeDirectory;
        this.identifiableProvider = identifiableProvider;
        this.converter = converter;
    }

    protected File getItemFile(V t) {
        return this.getItemFile(t.getIdentifierString());
    }

    protected File getItemFile(String identifier) {
        this.checkPermissions();
        if (identifier == null || identifier.length() == 0) {
            throw new IllegalArgumentException("Error: no identifier found. Cannot retrieve any store entry");
        }
        return new File(this.storageDirectory, this.hashString(identifier));
    }

    public void realSave(boolean checkExists, V t) {
        this.checkPermissions();
        FileOutputStream fos = null;
        File f = this.getItemFile(t);
        if (checkExists && !f.exists()) {
            throw new GeneralException("Error: Cannot update a non-existent store entry. Save it first.");
        }
        this.getCreatedItems().remove(t.getIdentifierString());
        try {
            fos = new FileOutputStream(f);
            if (this.converter != null) {
                try {
                    XMLMap map = new XMLMap();
                    this.converter.toMap(t, map);
                    map.toXML(fos);
                    fos.flush();
                    fos.close();
                }
                catch (Throwable z) {
                    System.out.println(this.getClass().getSimpleName() + ": could not property serialize object");
                    z.printStackTrace();
                    this.serializeObject(t, fos);
                }
            } else {
                this.serializeObject(t, fos);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new GeneralException("Error loading file \"" + f.getCanonicalPath() + "\" for store entry " + t, (Throwable)e);
            }
            catch (IOException e1) {
                throw new GeneralException("Error loading file \"" + f + "\" for store entry " + t, (Throwable)e1);
            }
        }
        catch (IOException e) {
            throw new GeneralException("Error serializing store entry " + t + "to file \"" + f, (Throwable)e);
        }
    }

    protected void createIndexEntry(String otherKey, String identifier) throws IOException {
        String h = this.hashString(otherKey);
        File f = new File(this.indexDirectory, h);
        FileWriter fw = new FileWriter(f);
        fw.write(this.hashString(identifier));
        fw.flush();
        fw.close();
    }

    protected V loadFromIndex(String hashedName) {
        this.checkPermissions();
        File f = new File(this.indexDirectory, hashedName);
        if (!f.exists() || !f.isFile()) {
            return null;
        }
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            String realFilename = br.readLine();
            return this.loadFile(new File(this.storageDirectory, realFilename));
        }
        catch (IOException e) {
            throw new GeneralException("Error: could not load file from index dir with hashed name \"" + hashedName + "\"", (Throwable)e);
        }
    }

    protected V loadByIdentifier(String identifier) {
        try {
            return this.loadFile(this.getItemFile(identifier));
        }
        catch (FilePermissionsException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected V loadFile(File f) {
        FileInputStream fis = null;
        this.checkPermissions();
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new GeneralException("Error: file not found", (Throwable)e);
        }
        return this.loadStream(fis);
    }

    public FileStore(File file, IdentifiableProvider<V> idp, MapConverter<V> cp) {
        this.converter = cp;
        File storeDir = new File(file, "store");
        File index = new File(file, "index");
        this.initializer = new FSInitializer(storeDir, index);
        if (!this.initializer.isCreated()) {
            this.initializer.createNew();
        }
        this.storageDirectory = storeDir;
        this.indexDirectory = index;
        this.identifiableProvider = idp;
    }

    public void update(V t) {
        this.realSave(true, t);
    }

    public void register(V t) {
        this.realSave(false, t);
    }

    public void clear() {
        this.initializer.init();
    }

    public void save(V t) {
        this.realSave(false, t);
    }

    public Set<Identifier> keySet() {
        String[] filenames;
        this.checkPermissions();
        HashSet<Identifier> ids = new HashSet<Identifier>();
        for (String filename : filenames = this.storageDirectory.list()) {
            Object t = null;
            t = this.loadFile(new File(this.storageDirectory, filename));
            ids.add(t.getIdentifier());
        }
        return ids;
    }

    public Collection<V> values() {
        this.checkPermissions();
        LinkedList<V> allOfThem = new LinkedList<V>();
        for (File f : this.storageDirectory.listFiles()) {
            allOfThem.add(this.loadFile(f));
        }
        return allOfThem;
    }

    public Set<Map.Entry<Identifier, V>> entrySet() {
        this.checkPermissions();
        HashSet<Map.Entry<Identifier, V>> entries = new HashSet<Map.Entry<Identifier, V>>();
        for (File f : this.storageDirectory.listFiles()) {
            V t = this.loadFile(f);
            entries.add((Map.Entry<Identifier, V>)new SimpleEntryImpl((Object)t.getIdentifier(), t));
        }
        return entries;
    }

    public int size() {
        return this.storageDirectory.list().length;
    }

    public boolean containsKey(Object key) {
        this.checkPermissions();
        if (key == null) {
            return false;
        }
        return this.storageDirectory.list(new IdentifierFileFilter(key.toString())).length == 1;
    }

    public boolean containsValue(Object value) {
        Identifiable t = (Identifiable)value;
        return this.containsKey(t.getIdentifierString());
    }

    public V get(Object key) {
        return this.loadByIdentifier(key.toString());
    }

    public boolean delete(String identifier) {
        V t = this.loadByIdentifier(identifier);
        try {
            this.realRemove(t);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    protected V realRemove(V oldItem) {
        File f = this.getItemFile(oldItem.getIdentifierString());
        if (f.exists() && !f.isDirectory()) {
            f.delete();
        }
        return oldItem;
    }

    public V remove(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        V t = this.loadByIdentifier(key.toString());
        return this.realRemove(t);
    }

    public void putAll(Map m) {
        for (Map.Entry e : m.entrySet()) {
            this.put((Identifiable)e.getValue());
        }
    }

    protected boolean removeIndexEntry(String token) {
        File f = new File(this.indexDirectory, this.hashString(token));
        return f.delete();
    }

    protected V getIndexEntry(String token) {
        return this.loadFromIndex(this.hashString(token));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[dataPath=" + this.storageDirectory.getAbsolutePath() + ", indexPath=" + this.indexDirectory.getAbsolutePath() + "]";
    }

    @Override
    public V create() {
        this.checkPermissions();
        return super.create();
    }

    class IdentifierFileFilter
    implements FilenameFilter {
        String id;

        @Override
        public boolean accept(File dir, String name) {
            return name.equals(this.id);
        }

        IdentifierFileFilter(String identifier) {
            this.id = FileStore.this.hashString(identifier);
        }
    }
}

