/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtils {
    private static final Method SUPPRESS_METHOD;

    private IOUtils() {
    }

    public static <E extends Exception> void closeWhileHandlingException(E priorException, Closeable ... objects) throws E, IOException {
        Throwable th = null;
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (Throwable t) {
                IOUtils.addSuppressed(priorException == null ? th : (Throwable)priorException, t);
                if (th != null) continue;
                th = t;
            }
        }
        if (priorException != null) {
            throw priorException;
        }
        if (th != null) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    public static <E extends Exception> void closeWhileHandlingException(E priorException, Iterable<Closeable> objects) throws E, IOException {
        Throwable th = null;
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (Throwable t) {
                IOUtils.addSuppressed(priorException == null ? th : (Throwable)priorException, t);
                if (th != null) continue;
                th = t;
            }
        }
        if (priorException != null) {
            throw priorException;
        }
        if (th != null) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    public static void close(Closeable ... objects) throws IOException {
        Throwable th = null;
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (Throwable t) {
                IOUtils.addSuppressed(th, t);
                if (th != null) continue;
                th = t;
            }
        }
        if (th != null) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    public static void close(Iterable<? extends Closeable> objects) throws IOException {
        Throwable th = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable t) {
                IOUtils.addSuppressed(th, t);
                if (th != null) continue;
                th = t;
            }
        }
        if (th != null) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    public static void closeWhileHandlingException(Closeable ... objects) throws IOException {
        for (Closeable object : objects) {
            try {
                if (object == null) continue;
                object.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> objects) throws IOException {
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static final void addSuppressed(Throwable exception, Throwable suppressed) {
        if (SUPPRESS_METHOD != null && exception != null && suppressed != null) {
            try {
                SUPPRESS_METHOD.invoke((Object)exception, suppressed);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    static {
        Method m;
        try {
            m = Throwable.class.getMethod("addSuppressed", Throwable.class);
        }
        catch (Exception e) {
            m = null;
        }
        SUPPRESS_METHOD = m;
    }
}

