/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.configuration.provider;

import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.DefaultStoreDisabledException;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;

public abstract class MultiTypeProvider<T>
extends TypedProvider<T> {
    protected boolean disableDefaultStore = false;
    protected MyLoggingFacade logger;

    protected MultiTypeProvider() {
    }

    protected MultiTypeProvider(ConfigurationNode config, boolean disableDefaultStore, MyLoggingFacade logger, String type, String target) {
        super(config, type, target);
        this.logger = logger;
        this.disableDefaultStore = disableDefaultStore;
    }

    protected MultiTypeProvider(MyLoggingFacade logger, String type, String target) {
        super(type, target);
        this.logger = logger;
    }

    @Override
    public Object componentFound(CfgEvent configurationEvent) {
        return this.get();
    }

    public T get() {
        List kidList = this.getConfig().getChildren();
        for (int i = 0; i < kidList.size(); ++i) {
            ConfigurationNode foo = (ConfigurationNode)kidList.get(i);
            Object gotOne = this.fireComponentFound(new CfgEvent(this, foo));
            if (gotOne == null) continue;
            return gotOne;
        }
        if (this.disableDefaultStore) {
            throw new DefaultStoreDisabledException("Error: Default store is not enabled for this configuration.(" + this.getClass().getSimpleName() + ")");
        }
        return this.getDefaultStore();
    }

    public abstract T getDefaultStore();
}

