/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Locale;
import org.geotools.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XArray {
    private XArray() {
    }

    private static <T> T doResize(T array, int length) {
        int current;
        int n = current = array == null ? 0 : Array.getLength(array);
        if (current != length) {
            Object newArray = Array.newInstance(array.getClass().getComponentType(), length);
            System.arraycopy(array, 0, newArray, 0, Math.min(current, length));
            return (T)newArray;
        }
        return array;
    }

    public static <E> E[] resize(E[] array, int length) {
        return XArray.doResize(array, length);
    }

    public static double[] resize(double[] array, int length) {
        return XArray.doResize(array, length);
    }

    public static float[] resize(float[] array, int length) {
        return XArray.doResize(array, length);
    }

    public static long[] resize(long[] array, int length) {
        return XArray.doResize(array, length);
    }

    public static int[] resize(int[] array, int length) {
        return XArray.doResize(array, length);
    }

    public static short[] resize(short[] array, int length) {
        return XArray.doResize(array, length);
    }

    public static byte[] resize(byte[] array, int length) {
        return XArray.doResize(array, length);
    }

    public static char[] resize(char[] array, int length) {
        return XArray.doResize(array, length);
    }

    public static boolean[] resize(boolean[] array, int length) {
        return XArray.doResize(array, length);
    }

    private static <T> T doRemove(T array, int index, int length) {
        if (length == 0) {
            return array;
        }
        int arrayLength = Array.getLength(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength -= length);
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, arrayLength - index);
        return (T)newArray;
    }

    public static <E> E[] remove(E[] array, int index, int length) {
        return XArray.doRemove(array, index, length);
    }

    public static double[] remove(double[] array, int index, int length) {
        return XArray.doRemove(array, index, length);
    }

    public static float[] remove(float[] array, int index, int length) {
        return XArray.doRemove(array, index, length);
    }

    public static long[] remove(long[] array, int index, int length) {
        return XArray.doRemove(array, index, length);
    }

    public static int[] remove(int[] array, int index, int length) {
        return XArray.doRemove(array, index, length);
    }

    public static short[] remove(short[] array, int index, int length) {
        return XArray.doRemove(array, index, length);
    }

    public static byte[] remove(byte[] array, int index, int length) {
        return XArray.doRemove(array, index, length);
    }

    public static char[] remove(char[] array, int index, int length) {
        return XArray.doRemove(array, index, length);
    }

    public static boolean[] remove(boolean[] array, int index, int length) {
        return XArray.doRemove(array, index, length);
    }

    private static <T> T doInsert(T array, int index, int length) {
        if (length == 0) {
            return array;
        }
        int arrayLength = Array.getLength(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + length);
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index, newArray, index + length, arrayLength - index);
        return (T)newArray;
    }

    public static <E> E[] insert(E[] array, int index, int length) {
        return XArray.doInsert(array, index, length);
    }

    public static double[] insert(double[] array, int index, int length) {
        return XArray.doInsert(array, index, length);
    }

    public static float[] insert(float[] array, int index, int length) {
        return XArray.doInsert(array, index, length);
    }

    public static long[] insert(long[] array, int index, int length) {
        return XArray.doInsert(array, index, length);
    }

    public static int[] insert(int[] array, int index, int length) {
        return XArray.doInsert(array, index, length);
    }

    public static short[] insert(short[] array, int index, int length) {
        return XArray.doInsert(array, index, length);
    }

    public static byte[] insert(byte[] array, int index, int length) {
        return XArray.doInsert(array, index, length);
    }

    public static char[] insert(char[] array, int index, int length) {
        return XArray.doInsert(array, index, length);
    }

    public static boolean[] insert(boolean[] array, int index, int length) {
        return XArray.doInsert(array, index, length);
    }

    private static <T> Object doInsert(T src, int src_pos, T dst, int dst_pos, int length) {
        if (length == 0) {
            return dst;
        }
        int dstLength = Array.getLength(dst);
        Object newArray = Array.newInstance(dst.getClass().getComponentType(), dstLength + length);
        System.arraycopy(dst, 0, newArray, 0, dst_pos);
        System.arraycopy(src, src_pos, newArray, dst_pos, length);
        System.arraycopy(dst, dst_pos, newArray, dst_pos + length, dstLength - dst_pos);
        return newArray;
    }

    public static <E> E[] insert(E[] src, int src_pos, E[] dst, int dst_pos, int length) {
        return (Object[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static double[] insert(double[] src, int src_pos, double[] dst, int dst_pos, int length) {
        return (double[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static float[] insert(float[] src, int src_pos, float[] dst, int dst_pos, int length) {
        return (float[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static long[] insert(long[] src, int src_pos, long[] dst, int dst_pos, int length) {
        return (long[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static int[] insert(int[] src, int src_pos, int[] dst, int dst_pos, int length) {
        return (int[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static short[] insert(short[] src, int src_pos, short[] dst, int dst_pos, int length) {
        return (short[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static byte[] insert(byte[] src, int src_pos, byte[] dst, int dst_pos, int length) {
        return (byte[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static char[] insert(char[] src, int src_pos, char[] dst, int dst_pos, int length) {
        return (char[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static boolean[] insert(boolean[] src, int src_pos, boolean[] dst, int dst_pos, int length) {
        return (boolean[])XArray.doInsert(src, src_pos, dst, dst_pos, length);
    }

    public static <T> boolean isSorted(T[] array, Comparator<T> comparator) {
        for (int i = 1; i < array.length; ++i) {
            if (comparator.compare(array[i], array[i - 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(char[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(byte[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(short[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(int[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(long[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(float[] array) {
        int previous = 0;
        for (int i = 1; i < array.length; ++i) {
            float value = array[i];
            if (value < array[previous]) {
                return false;
            }
            if (Float.isNaN(value)) continue;
            previous = i;
        }
        return true;
    }

    public static boolean isSorted(double[] array) {
        int previous = 0;
        for (int i = 1; i < array.length; ++i) {
            double value = array[i];
            if (value < array[previous]) {
                return false;
            }
            if (Double.isNaN(value)) continue;
            previous = i;
        }
        return true;
    }

    public static boolean isStrictlySorted(int[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] > array[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean allEquals(float[] array, float value) {
        if (Float.isNaN(value)) {
            for (int i = 0; i < array.length; ++i) {
                if (Float.isNaN(array[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == value) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allEquals(double[] array, double value) {
        if (Double.isNaN(value)) {
            for (int i = 0; i < array.length; ++i) {
                if (Double.isNaN(array[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == value) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasNaN(float[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Float.isNaN(array[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNaN(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Double.isNaN(array[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] array, String value) {
        if (array != null) {
            for (String element : array) {
                if (!value.equalsIgnoreCase(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Object[] array, Object value) {
        if (array != null) {
            for (Object element : array) {
                if (!Utilities.equals(element, value)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean intersects(Object[] array1, Object[] array2) {
        for (Object element : array1) {
            if (!XArray.contains(array2, element)) continue;
            return true;
        }
        return false;
    }

    public static String toString(Object array, Locale locale) {
        StringBuffer buffer = new StringBuffer();
        NumberFormat format = NumberFormat.getNumberInstance(locale);
        FieldPosition dummy = new FieldPosition(0);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            format.format(Array.get(array, i), buffer, dummy);
        }
        return buffer.toString();
    }
}

