/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.text.ParseException;
import org.apache.tools.ant.BuildException;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Export
extends SvnCommand {
    private ISVNClientAdapter svnClient = null;
    private boolean force = false;
    private SVNUrl srcUrl = null;
    private File srcPath = null;
    private File destPath = null;
    private SVNRevision revision = SVNRevision.HEAD;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        this.validateAttributes();
        this.log("Svn : Exporting");
        try {
            if (this.srcUrl != null) {
                iSVNClientAdapter.doExport(this.srcUrl, this.destPath, this.revision, this.force);
            } else {
                iSVNClientAdapter.doExport(this.srcPath, this.destPath, this.force);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Can't export", (Throwable)sVNClientException);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.destPath == null) {
            throw new BuildException("destPath attribute must be set");
        }
        if (this.srcUrl == null && this.srcPath == null) {
            throw new BuildException("Either srcUrl or srcPath must be set");
        }
        if (this.srcUrl != null && this.srcPath != null) {
            throw new BuildException("Either srcUrl or srcPath must be set");
        }
    }

    public void setRevision(String string) {
        try {
            this.revision = SVNRevision.getRevision((String)string);
        }
        catch (ParseException parseException) {
            this.revision = null;
        }
    }

    public void setSrcUrl(SVNUrl sVNUrl) {
        this.srcUrl = sVNUrl;
    }

    public void setSrcPath(File file) {
        this.srcPath = file;
    }

    public void setDestPath(File file) {
        this.destPath = file;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }
}

