/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Utils {
    public static String className(Object obj) {
        return Utils.classShortName(obj.getClass());
    }

    public static String classShortName(Class<?> cls) {
        String tmp = cls.getName();
        int i = tmp.lastIndexOf(46);
        tmp = tmp.substring(i + 1);
        return tmp;
    }

    public static String nowAsXSDDateTimeString() {
        return Utils.calendarToXSDDateTimeString(new GregorianCalendar());
    }

    public static String todayAsXSDDateString() {
        return Utils.calendarToXSDDateString(new GregorianCalendar());
    }

    public static String XSDDateTime2String(XSDDateTime xdt) {
        return xdt.toString();
    }

    public static String nowAsString() {
        return Utils.nowAsString("yyyy/MM/dd HH:mm:ss z");
    }

    public static String nowAsString(String formatString) {
        SimpleDateFormat df = new SimpleDateFormat(formatString);
        return df.format(new Date());
    }

    public static String calendarToXSDDateTimeString(Calendar cal) {
        return Utils.calendarToXSDString(cal, "yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    public static String calendarToXSDDateString(Calendar cal) {
        return Utils.calendarToXSDString(cal, "yyyy-MM-dd");
    }

    public static String calendarToXSDTimeString(Calendar cal) {
        return Utils.calendarToXSDString(cal, "HH:mm:ss.SSS");
    }

    private static String calendarToXSDString(Calendar cal, String fmt) {
        SimpleDateFormat dFmt = new SimpleDateFormat(fmt);
        Date date2 = cal.getTime();
        String lex = dFmt.format(date2);
        lex = lex + Utils.calcTimezone(cal);
        return lex;
    }

    private static String calcTimezone(Calendar cal) {
        int tzOff;
        Date date2 = cal.getTime();
        TimeZone z = cal.getTimeZone();
        int tz = tzOff = z.getRawOffset();
        if (z.inDaylightTime(date2)) {
            int tzDst = z.getDSTSavings();
            tz += tzDst;
        }
        String sign = "+";
        if (tz < 0) {
            sign = "-";
            tz = -tz;
        }
        int tzH = tz / 3600000;
        int tzM = (tz - tzH * 60 * 60 * 1000) / 60000;
        String tzH_str = Integer.toString(tzH);
        String tzM_str = Integer.toString(tzM);
        if (tzH < 10) {
            tzH_str = "0" + tzH_str;
        }
        if (tzM < 10) {
            tzM_str = "0" + tzM_str;
        }
        return sign + tzH_str + ":" + tzM_str;
    }

    public static String stringForm(BigDecimal decimal) {
        return decimal.toPlainString();
    }

    public static String stringForm(double d) {
        if (Double.isInfinite(d)) {
            if (d < 0.0) {
                return "-INF";
            }
            return "INF";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        String x = Double.toString(d);
        if (x.indexOf(101) != -1 || x.indexOf(69) != -1) {
            return x;
        }
        return x + "e0";
    }

    public static String stringForm(float f) {
        return Float.toString(f);
    }
}

