/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.OffsetLimitTokenFilter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.QueryTermScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.highlight.DefaultEncoder;
import org.apache.solr.highlight.GapFragmenter;
import org.apache.solr.highlight.HtmlFormatter;
import org.apache.solr.highlight.ScoreOrderFragmentsBuilder;
import org.apache.solr.highlight.SimpleFragListBuilder;
import org.apache.solr.highlight.SolrEncoder;
import org.apache.solr.highlight.SolrFormatter;
import org.apache.solr.highlight.SolrFragListBuilder;
import org.apache.solr.highlight.SolrFragmenter;
import org.apache.solr.highlight.SolrFragmentsBuilder;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.highlight.TermOffsetsTokenStream;
import org.apache.solr.highlight.TokenOrderingFilter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSolrHighlighter
extends SolrHighlighter
implements PluginInfoInitialized {
    public static Logger log = LoggerFactory.getLogger(DefaultSolrHighlighter.class);
    private SolrCore solrCore;
    private boolean initialized = false;

    public DefaultSolrHighlighter() {
    }

    public DefaultSolrHighlighter(SolrCore solrCore) {
        this.solrCore = solrCore;
    }

    @Override
    public void init(PluginInfo info) {
        this.formatters.clear();
        this.encoders.clear();
        this.fragmenters.clear();
        this.fragListBuilders.clear();
        this.fragmentsBuilders.clear();
        SolrFragmenter frag = this.solrCore.initPlugins(info.getChildren("fragmenter"), this.fragmenters, SolrFragmenter.class, null);
        if (frag == null) {
            frag = new GapFragmenter();
        }
        this.fragmenters.put("", frag);
        this.fragmenters.put(null, frag);
        SolrFormatter fmt = this.solrCore.initPlugins(info.getChildren("formatter"), this.formatters, SolrFormatter.class, null);
        if (fmt == null) {
            fmt = new HtmlFormatter();
        }
        this.formatters.put("", fmt);
        this.formatters.put(null, fmt);
        SolrEncoder enc = this.solrCore.initPlugins(info.getChildren("encoder"), this.encoders, SolrEncoder.class, null);
        if (enc == null) {
            enc = new DefaultEncoder();
        }
        this.encoders.put("", enc);
        this.encoders.put(null, enc);
        SolrFragListBuilder fragListBuilder = this.solrCore.initPlugins(info.getChildren("fragListBuilder"), this.fragListBuilders, SolrFragListBuilder.class, null);
        if (fragListBuilder == null) {
            fragListBuilder = new SimpleFragListBuilder();
        }
        this.fragListBuilders.put("", fragListBuilder);
        this.fragListBuilders.put(null, fragListBuilder);
        SolrFragmentsBuilder fragsBuilder = this.solrCore.initPlugins(info.getChildren("fragmentsBuilder"), this.fragmentsBuilders, SolrFragmentsBuilder.class, null);
        if (fragsBuilder == null) {
            fragsBuilder = new ScoreOrderFragmentsBuilder();
        }
        this.fragmentsBuilders.put("", fragsBuilder);
        this.fragmentsBuilders.put(null, fragsBuilder);
        this.initialized = true;
    }

    @Override
    @Deprecated
    public void initalize(SolrConfig config) {
        if (this.initialized) {
            return;
        }
        GapFragmenter frag = new GapFragmenter();
        this.fragmenters.put("", frag);
        this.fragmenters.put(null, frag);
        HtmlFormatter fmt = new HtmlFormatter();
        this.formatters.put("", fmt);
        this.formatters.put(null, fmt);
        DefaultEncoder enc = new DefaultEncoder();
        this.encoders.put("", enc);
        this.encoders.put(null, enc);
        SimpleFragListBuilder fragListBuilder = new SimpleFragListBuilder();
        this.fragListBuilders.put("", fragListBuilder);
        this.fragListBuilders.put(null, fragListBuilder);
        ScoreOrderFragmentsBuilder fragsBuilder = new ScoreOrderFragmentsBuilder();
        this.fragmentsBuilders.put("", fragsBuilder);
        this.fragmentsBuilders.put(null, fragsBuilder);
    }

    protected Highlighter getPhraseHighlighter(Query query, String fieldName, SolrQueryRequest request, CachingTokenFilter tokenStream) throws IOException {
        SolrParams params = request.getParams();
        Highlighter highlighter = null;
        highlighter = new Highlighter(this.getFormatter(fieldName, params), this.getEncoder(fieldName, params), (Scorer)this.getSpanQueryScorer(query, fieldName, (TokenStream)tokenStream, request));
        highlighter.setTextFragmenter(this.getFragmenter(fieldName, params));
        return highlighter;
    }

    protected Highlighter getHighlighter(Query query, String fieldName, SolrQueryRequest request) {
        SolrParams params = request.getParams();
        Highlighter highlighter = new Highlighter(this.getFormatter(fieldName, params), this.getEncoder(fieldName, params), this.getQueryScorer(query, fieldName, request));
        highlighter.setTextFragmenter(this.getFragmenter(fieldName, params));
        return highlighter;
    }

    private QueryScorer getSpanQueryScorer(Query query, String fieldName, TokenStream tokenStream, SolrQueryRequest request) throws IOException {
        boolean reqFieldMatch = request.getParams().getFieldBool(fieldName, "hl.requireFieldMatch", false);
        Boolean highlightMultiTerm = request.getParams().getBool("hl.highlightMultiTerm", true);
        if (highlightMultiTerm == null) {
            highlightMultiTerm = false;
        }
        QueryScorer scorer = reqFieldMatch ? new QueryScorer(query, fieldName) : new QueryScorer(query, null);
        scorer.setExpandMultiTermQuery(highlightMultiTerm.booleanValue());
        return scorer;
    }

    private Scorer getQueryScorer(Query query, String fieldName, SolrQueryRequest request) {
        boolean reqFieldMatch = request.getParams().getFieldBool(fieldName, "hl.requireFieldMatch", false);
        if (reqFieldMatch) {
            return new QueryTermScorer(query, (IndexReader)request.getSearcher().getReader(), fieldName);
        }
        return new QueryTermScorer(query);
    }

    protected int getMaxSnippets(String fieldName, SolrParams params) {
        return params.getFieldInt(fieldName, "hl.snippets", 1);
    }

    protected boolean isMergeContiguousFragments(String fieldName, SolrParams params) {
        return params.getFieldBool(fieldName, "hl.mergeContiguous", false);
    }

    protected Formatter getFormatter(String fieldName, SolrParams params) {
        String str = params.getFieldParam(fieldName, "hl.formatter");
        SolrFormatter formatter = (SolrFormatter)this.formatters.get(str);
        if (formatter == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown formatter: " + str);
        }
        return formatter.getFormatter(fieldName, params);
    }

    protected Encoder getEncoder(String fieldName, SolrParams params) {
        String str = params.getFieldParam(fieldName, "hl.encoder");
        SolrEncoder encoder = (SolrEncoder)this.encoders.get(str);
        if (encoder == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown encoder: " + str);
        }
        return encoder.getEncoder(fieldName, params);
    }

    protected Fragmenter getFragmenter(String fieldName, SolrParams params) {
        String fmt = params.getFieldParam(fieldName, "hl.fragmenter");
        SolrFragmenter frag = (SolrFragmenter)this.fragmenters.get(fmt);
        if (frag == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fragmenter: " + fmt);
        }
        return frag.getFragmenter(fieldName, params);
    }

    protected FragListBuilder getFragListBuilder(String fieldName, SolrParams params) {
        String flb = params.getFieldParam(fieldName, "hl.fragListBuilder");
        SolrFragListBuilder solrFlb = (SolrFragListBuilder)this.fragListBuilders.get(flb);
        if (solrFlb == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fragListBuilder: " + flb);
        }
        return solrFlb.getFragListBuilder(params);
    }

    protected FragmentsBuilder getFragmentsBuilder(String fieldName, SolrParams params) {
        return this.getSolrFragmentsBuilder(fieldName, params).getFragmentsBuilder(params);
    }

    private SolrFragmentsBuilder getSolrFragmentsBuilder(String fieldName, SolrParams params) {
        String fb = params.getFieldParam(fieldName, "hl.fragmentsBuilder");
        SolrFragmentsBuilder solrFb = (SolrFragmentsBuilder)this.fragmentsBuilders.get(fb);
        if (solrFb == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fragmentsBuilder: " + fb);
        }
        return solrFb;
    }

    @Override
    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        SolrParams params = req.getParams();
        if (!this.isHighlightingEnabled(params)) {
            return null;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        IndexSchema schema = searcher.getSchema();
        SimpleOrderedMap fragments = new SimpleOrderedMap();
        String[] fieldNames = this.getHighlightFields(query, req, defaultFields);
        HashSet<String> fset = new HashSet<String>();
        for (String f : fieldNames) {
            fset.add(f);
        }
        SchemaField keyField = schema.getUniqueKeyField();
        if (null != keyField) {
            fset.add(keyField.getName());
        }
        FastVectorHighlighter fvh = new FastVectorHighlighter(params.getBool("hl.usePhraseHighlighter", true), params.getBool("hl.requireFieldMatch", false));
        fvh.setPhraseLimit(params.getInt("hl.phraseLimit", Integer.MAX_VALUE));
        FieldQuery fieldQuery = fvh.getFieldQuery(query);
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docs.size(); ++i) {
            int docId = iterator.nextDoc();
            Document doc = searcher.doc(docId, fset);
            SimpleOrderedMap docSummaries = new SimpleOrderedMap();
            for (String fieldName : fieldNames) {
                if (this.useFastVectorHighlighter(params, schema, fieldName = fieldName.trim())) {
                    this.doHighlightingByFastVectorHighlighter(fvh, fieldQuery, req, (NamedList)docSummaries, docId, doc, fieldName);
                    continue;
                }
                this.doHighlightingByHighlighter(query, req, (NamedList)docSummaries, docId, doc, fieldName);
            }
            String printId = schema.printableUniqueKey(doc);
            fragments.add(printId == null ? null : printId, (Object)docSummaries);
        }
        return fragments;
    }

    private boolean useFastVectorHighlighter(SolrParams params, IndexSchema schema, String fieldName) {
        SchemaField schemaField = schema.getFieldOrNull(fieldName);
        return schemaField != null && schemaField.storeTermPositions() && schemaField.storeTermOffsets() && params.getFieldBool(fieldName, "hl.useFastVectorHighlighter", false);
    }

    private void doHighlightingByHighlighter(Query query, SolrQueryRequest req, NamedList docSummaries, int docId, Document doc, String fieldName) throws IOException {
        SolrParams params = req.getParams();
        String[] docTexts = doc.getValues(fieldName);
        if (docTexts.length == 0) {
            return;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        IndexSchema schema = searcher.getSchema();
        TokenStream tstream = null;
        int numFragments = this.getMaxSnippets(fieldName, params);
        boolean mergeContiguousFragments = this.isMergeContiguousFragments(fieldName, params);
        String[] summaries = null;
        ArrayList<TextFragment> frags = new ArrayList<TextFragment>();
        TermOffsetsTokenStream tots = null;
        try {
            TokenStream tvStream = TokenSources.getTokenStream((IndexReader)searcher.getReader(), (int)docId, (String)fieldName);
            if (tvStream != null) {
                tots = new TermOffsetsTokenStream(tvStream);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        for (int j = 0; j < docTexts.length; ++j) {
            Highlighter highlighter;
            tstream = tots != null ? tots.getMultiValuedTokenStream(docTexts[j].length()) : this.createAnalyzerTStream(schema, fieldName, docTexts[j]);
            int maxCharsToAnalyze = params.getFieldInt(fieldName, "hl.maxAnalyzedChars", 51200);
            if (Boolean.valueOf(req.getParams().get("hl.usePhraseHighlighter", "true")).booleanValue()) {
                tstream = maxCharsToAnalyze < 0 ? new CachingTokenFilter(tstream) : new CachingTokenFilter((TokenStream)new OffsetLimitTokenFilter(tstream, maxCharsToAnalyze));
                highlighter = this.getPhraseHighlighter(query, fieldName, req, (CachingTokenFilter)tstream);
                tstream.reset();
            } else {
                highlighter = this.getHighlighter(query, fieldName, req);
            }
            if (maxCharsToAnalyze < 0) {
                highlighter.setMaxDocCharsToAnalyze(docTexts[j].length());
            } else {
                highlighter.setMaxDocCharsToAnalyze(maxCharsToAnalyze);
            }
            try {
                TextFragment[] bestTextFragments = highlighter.getBestTextFragments(tstream, docTexts[j], mergeContiguousFragments, numFragments);
                for (int k = 0; k < bestTextFragments.length; ++k) {
                    if (bestTextFragments[k] == null || !(bestTextFragments[k].getScore() > 0.0f)) continue;
                    frags.add(bestTextFragments[k]);
                }
                continue;
            }
            catch (InvalidTokenOffsetsException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        Collections.sort(frags, new Comparator<TextFragment>(){

            @Override
            public int compare(TextFragment arg0, TextFragment arg1) {
                return Math.round(arg1.getScore() - arg0.getScore());
            }
        });
        if (frags.size() > 0) {
            ArrayList<String> fragTexts = new ArrayList<String>();
            for (TextFragment fragment : frags) {
                if (fragment != null && fragment.getScore() > 0.0f) {
                    fragTexts.add(fragment.toString());
                }
                if (fragTexts.size() < numFragments) continue;
                break;
            }
            if ((summaries = fragTexts.toArray(new String[0])).length > 0) {
                docSummaries.add(fieldName, (Object)summaries);
            }
        }
        if (summaries == null || summaries.length == 0) {
            this.alternateField(docSummaries, params, doc, fieldName);
        }
    }

    private void doHighlightingByFastVectorHighlighter(FastVectorHighlighter highlighter, FieldQuery fieldQuery, SolrQueryRequest req, NamedList docSummaries, int docId, Document doc, String fieldName) throws IOException {
        SolrParams params = req.getParams();
        SolrFragmentsBuilder solrFb = this.getSolrFragmentsBuilder(fieldName, params);
        String[] snippets = highlighter.getBestFragments(fieldQuery, (IndexReader)req.getSearcher().getReader(), docId, fieldName, params.getFieldInt(fieldName, "hl.fragsize", 100), params.getFieldInt(fieldName, "hl.snippets", 1), this.getFragListBuilder(fieldName, params), this.getFragmentsBuilder(fieldName, params), solrFb.getPreTags(params, fieldName), solrFb.getPostTags(params, fieldName), this.getEncoder(fieldName, params));
        if (snippets != null && snippets.length > 0) {
            docSummaries.add(fieldName, (Object)snippets);
        } else {
            this.alternateField(docSummaries, params, doc, fieldName);
        }
    }

    private void alternateField(NamedList docSummaries, SolrParams params, Document doc, String fieldName) {
        String[] altTexts;
        String alternateField = params.getFieldParam(fieldName, "hl.alternateField");
        if (alternateField != null && alternateField.length() > 0 && (altTexts = doc.getValues(alternateField)) != null && altTexts.length > 0) {
            int alternateFieldLen = params.getFieldInt(fieldName, "hl.maxAlternateFieldLength", 0);
            if (alternateFieldLen <= 0) {
                docSummaries.add(fieldName, (Object)altTexts);
            } else {
                ArrayList<String> altList = new ArrayList<String>();
                int len = 0;
                for (String altText : altTexts) {
                    altList.add(len + altText.length() > alternateFieldLen ? new String(altText.substring(0, alternateFieldLen - len)) : altText);
                    if ((len += altText.length()) >= alternateFieldLen) break;
                }
                docSummaries.add(fieldName, altList);
            }
        }
    }

    private TokenStream createAnalyzerTStream(IndexSchema schema, String fieldName, String docText) throws IOException {
        TokenStream ts = schema.getAnalyzer().reusableTokenStream(fieldName, (Reader)new StringReader(docText));
        ts.reset();
        TokenOrderingFilter tstream = new TokenOrderingFilter(ts, 10);
        return tstream;
    }
}

