/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.AuthInterface;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AuthTest
implements AuthInterface {
    private String authUrl = "";
    private String testUser = "test-user";
    private String testUserName = "Test User";
    private String testPassword = "test-password";
    private String testGroup = "test-group";
    private String testGroupDesc = "this is a test group";
    private String testOrg = "NCEAS";
    private String testOrgUnit = "UCSB";
    private String testEmail = "test-user@dummy.email.com";
    private String otherTestUser = "other-test-user";
    private String otherTestUserName = "Other Test User";
    private String otherTestGroup = "other-test-group";
    private String otherTestGroupDesc = "this is a another test group";
    private String otherTestOrg = "DUMMY";
    private String otherTestOrgUnit = "UCLA";
    private String otherTestEmail = "other-test-user@dummy.email.com";
    private String attributeName = "attribute-name";
    private String attributeValue1 = "attribute-value1";
    private String attributeValue2 = "attribute-value2";
    private static Logger logMetacat = Logger.getLogger(AuthTest.class);

    public AuthTest() throws InstantiationException {
        try {
            this.authUrl = PropertyService.getProperty("auth.url");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new InstantiationException("Could not instantiate AuthTest.  Property not found: " + pnfe.getMessage());
        }
    }

    @Override
    public boolean authenticate(String user, String password) throws ConnectException {
        if (user.equals(this.testUser) && password.equals(this.testPassword)) {
            logMetacat.debug((Object)(user + " is authenticated"));
            return true;
        }
        logMetacat.debug((Object)(user + " could not be authenticated"));
        return false;
    }

    @Override
    public String[][] getUsers(String user, String password) throws ConnectException {
        String[][] users = new String[1][1];
        users[0][0] = this.testUser;
        return users;
    }

    @Override
    public String[] getUserInfo(String user, String password) throws ConnectException {
        String[] userinfo = new String[]{this.testUser, this.testOrg, this.testEmail};
        return userinfo;
    }

    @Override
    public String[] getUsers(String user, String password, String group) throws ConnectException {
        String[] users = null;
        users[0] = this.testUser;
        return users;
    }

    @Override
    public String[][] getGroups(String user, String password) throws ConnectException {
        return this.getGroups(user, password, null);
    }

    @Override
    public String[][] getGroups(String user, String password, String foruser) throws ConnectException {
        String[][] groups = new String[1][2];
        if (user.equals(this.testUser) && password.equals(this.testPassword)) {
            if (foruser != null) {
                groups[0][1] = this.testGroup;
                groups[0][1] = this.testGroupDesc;
            } else if (foruser.equals(this.otherTestUser)) {
                groups[0][0] = this.otherTestGroup;
                groups[0][1] = this.otherTestGroupDesc;
            }
        }
        return groups;
    }

    @Override
    public HashMap<String, Vector<String>> getAttributes(String foruser) throws ConnectException {
        return this.getAttributes(null, null, foruser);
    }

    @Override
    public HashMap<String, Vector<String>> getAttributes(String user, String password, String foruser) throws ConnectException {
        HashMap<String, Vector<String>> attributes = new HashMap<String, Vector<String>>();
        if (foruser.equals(this.otherTestUser)) {
            Vector<String> attributeValues = new Vector<String>();
            attributeValues.add(this.attributeValue1);
            attributeValues.add(this.attributeValue2);
            attributes.put(this.attributeName, attributeValues);
        }
        return attributes;
    }

    @Override
    public String getPrincipals(String user, String password) throws ConnectException {
        String out = new String();
        out = out + "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n";
        out = out + "<principals>\n";
        out = out + "  <authSystem URI=\"" + this.authUrl + ">\n";
        out = out + "    <group>\n";
        out = out + "      <groupname>" + this.testGroup + "</groupname>\n";
        out = out + "      <description>" + this.testGroupDesc + "</description>\n";
        out = out + "      <user>\n";
        out = out + "        <username>" + this.testUser + "</username>\n";
        out = out + "        <name>" + this.testUserName + "</name>\n";
        out = out + "        <organization>" + this.testOrg + "</organization>\n";
        out = out + "        <organizationUnitName>" + this.testOrgUnit + "</organizationUnitName>\n";
        out = out + "        <email>" + this.testEmail + "</email>\n";
        out = out + "      </user>\n";
        out = out + "    </group>\n";
        out = out + "    <group>\n";
        out = out + "      <groupname>" + this.otherTestGroup + "</groupname>\n";
        out = out + "      <description>" + this.otherTestGroupDesc + "</description>\n";
        out = out + "      <user>\n";
        out = out + "        <username>" + this.otherTestUser + "</username>\n";
        out = out + "        <name>" + this.otherTestUserName + "</name>\n";
        out = out + "        <organization>" + this.otherTestOrg + "</organization>\n";
        out = out + "        <organizationUnitName>" + this.otherTestOrgUnit + "</organizationUnitName>\n";
        out = out + "        <email>" + this.otherTestEmail + "</email>\n";
        out = out + "      </user>\n";
        out = out + "    </group>\n";
        out = out + "  </authSystem>\n";
        out = out + "</principals>";
        return out;
    }
}

