/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DBUtil {
    private static Logger logMetacat = Logger.getLogger(DBUtil.class);
    private static final int MAXMUM = -2;
    public static final int NONEEXIST = -1;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Wrong number of arguments!!!");
            System.err.println("USAGE: java DBUtil <-dt | -ds [doctype] | -dl user>");
            return;
        }
        try {
            DBUtil dbutil = new DBUtil();
            if (args[0].equals("-dt")) {
                String doctypes = dbutil.readDoctypes();
                System.out.println(doctypes);
            } else if (args[0].equals("-ds")) {
                String doctype = null;
                if (args.length == 2) {
                    doctype = args[1];
                }
                String dtdschema = dbutil.readDTDSchema(doctype);
                System.out.println(dtdschema);
            } else if (args[0].equals("-dl")) {
                String scope = "";
                if (args.length == 2) {
                    scope = args[1];
                }
                String docid = dbutil.getMaxDocid(scope);
                System.out.println(docid);
            } else {
                System.err.println("USAGE: java DBUtil <-dt | -ds [doctype] | -dg [doctype]>");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readDoctypes() throws SQLException {
        Vector<String> doctypeList = new Vector<String>();
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBUtil.readDoctypes");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("SELECT public_id FROM xml_catalog WHERE entry_type = 'DTD'");
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            while (tableHasRows) {
                doctypeList.addElement(rs.getString(1));
                tableHasRows = rs.next();
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SQLException("DBUtil.readDoctypes - SQL error: " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        return this.formatToXML(doctypeList, "doctype");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readDTDSchema(String doctype) throws SQLException, MalformedURLException, IOException, PropertyNotFoundException {
        String systemID = null;
        Statement pstmt = null;
        StringBuffer cbuff = new StringBuffer();
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBUtil.readDTDSchema");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("SELECT system_id FROM xml_catalog WHERE entry_type in ('DTD','Schema') AND public_id LIKE ?");
            pstmt.setString(1, doctype);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean hasRow = rs.next();
            if (hasRow) {
                systemID = rs.getString(1);
                if (!systemID.startsWith("http://")) {
                    systemID = SystemUtil.getContextURL() + systemID;
                }
            } else {
                throw new SQLException("DBUtil.readDTDSchema - Non-registered doctype: " + doctype);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SQLException("DBUtil.readDTDSchema - " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        try {
            int inputByte;
            InputStream istream = new URL(systemID).openStream();
            BufferedInputStream in = new BufferedInputStream(istream);
            while ((inputByte = in.read()) != -1) {
                cbuff.append((char)inputByte);
            }
            in.close();
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException("DBUtil.readDTDSchema - Malformed URL Error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("DBUtil.readDTDSchema - I/O error: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new IOException("DBUtil.readDTDSchema - Security error: " + e.getMessage());
        }
        return cbuff.toString();
    }

    private String formatToXML(Vector<String> resultset, String tag) {
        String val = null;
        StringBuffer result = new StringBuffer();
        Enumeration<String> rs = resultset.elements();
        result.append("<?xml version=\"1.0\"?>\n");
        result.append("<resultset>\n");
        while (rs.hasMoreElements()) {
            val = rs.nextElement();
            result.append("   <" + tag + ">" + val + "</" + tag + ">\n");
        }
        result.append("</resultset>\n");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMaxDocid(String scope) throws SQLException {
        String accnum = null;
        String sep = ".";
        try {
            PropertyService.getProperty("document.accNumSeparator");
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("DBUtil.getMaxDocid - could not get property 'accNumSeparator'.  setting to '.': " + pnfe.getMessage()));
        }
        Statement pstmt = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBUtil.getMaxDocid");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("SELECT docid, max(rev) FROM ( SELECT docid, rev FROM xml_documents WHERE docid LIKE ? UNION SELECT docid, rev FROM xml_revisions WHERE docid LIKE ?) subquery GROUP BY docid");
            pstmt.setString(1, scope + sep + "%");
            pstmt.setString(2, scope + sep + "%");
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            long max = 0L;
            String temp = null;
            while (rs.next()) {
                temp = rs.getString(1);
                if (temp == null) continue;
                temp = temp.substring(temp.indexOf(scope) + scope.length() + 1);
                try {
                    long localid = Long.parseLong(temp);
                    if (localid <= max) continue;
                    max = localid;
                    accnum = rs.getString(1) + sep + rs.getString(2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SQLException("DBUtil.getMaxDocid(). " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        return accnum;
    }

    public boolean idExists(String docid) throws SQLException {
        Vector<String> v = DBUtil.getAllDocids(null);
        for (int i = 0; i < v.size(); ++i) {
            String id = v.elementAt(i);
            if (!id.trim().equals(docid.trim())) continue;
            return true;
        }
        return false;
    }

    public static Vector<String> getAllDocidsByType(String doctype, boolean includeRevs) throws SQLException {
        return DBUtil.getAllDocidsByType(doctype, includeRevs, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<String> getAllDocidsByType(String doctype, boolean includeRevs, int serverLocation) throws SQLException {
        Vector<String> resultVector = new Vector<String>();
        String sep = ".";
        try {
            PropertyService.getProperty("document.accNumSeparator");
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("DBUtil.getAllDocidsByType - could not get property 'accNumSeparator'.  setting to '.': " + pnfe.getMessage()));
        }
        Statement pstmt = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBUtil.getAllDocidsByType");
            serialNumber = dbConn.getCheckOutSerialNumber();
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT docid, rev FROM ( SELECT docid, rev FROM xml_documents ");
            sb.append("WHERE true ");
            if (doctype != null) {
                sb.append("AND doctype LIKE ? ");
            }
            if (serverLocation > 0) {
                sb.append("AND server_location = ' " + serverLocation + "' ");
            }
            if (includeRevs) {
                sb.append("UNION SELECT docid, rev FROM xml_revisions ");
                sb.append("WHERE true ");
                if (doctype != null) {
                    sb.append("AND doctype LIKE ?");
                }
                if (serverLocation > 0) {
                    sb.append("AND server_location = ' " + serverLocation + "' ");
                }
            }
            sb.append(") subquery GROUP BY docid, rev");
            pstmt = dbConn.prepareStatement(sb.toString());
            if (doctype != null) {
                pstmt.setString(1, doctype);
                if (includeRevs) {
                    pstmt.setString(2, doctype);
                }
            }
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            String id = null;
            String rev = null;
            while (rs.next()) {
                id = rs.getString(1);
                rev = rs.getString(2);
                if (id == null) continue;
                resultVector.addElement(id + sep + rev);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SQLException("DBUtil.getAllDocidsByType(). " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        return resultVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<String> getAllDocids(String scope) throws SQLException {
        Vector<String> resultVector = new Vector<String>();
        String sep = ".";
        try {
            PropertyService.getProperty("document.accNumSeparator");
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("could not get property 'accNumSeparator'.  setting to '.': " + pnfe.getMessage()));
        }
        Statement pstmt = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBUtil.getAllDocids");
            serialNumber = dbConn.getCheckOutSerialNumber();
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT docid, rev FROM ( SELECT docid, rev FROM xml_documents ");
            if (scope != null) {
                sb.append("WHERE docid LIKE ? ");
            }
            sb.append("UNION SELECT docid, rev FROM xml_revisions ");
            if (scope != null) {
                sb.append("WHERE docid LIKE ?");
            }
            sb.append(") subquery GROUP BY docid, rev");
            pstmt = dbConn.prepareStatement(sb.toString());
            if (scope != null) {
                pstmt.setString(1, scope + sep + "%");
                pstmt.setString(2, scope + sep + "%");
            }
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            String id = null;
            String rev = null;
            while (rs.next()) {
                id = rs.getString(1);
                rev = rs.getString(2);
                if (id == null) continue;
                resultVector.addElement(id + sep + rev);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SQLException("DBUtil.getAllDocids - SQL error:  " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        return resultVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findDataSetDocIdForGivenDocument(String givenDocId) {
        Statement pStmt = null;
        ResultSet resultSet = null;
        String dataSetDocId = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        String sqlCommand = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBUtil.findDataSetDocIdForGivenDocument");
            serialNumber = dbConn.getCheckOutSerialNumber();
            sqlCommand = "select docid from xml_relation where object like ? or subject like ?";
            pStmt = dbConn.prepareStatement(sqlCommand);
            pStmt.setString(1, givenDocId);
            pStmt.setString(2, givenDocId);
            pStmt.execute();
            resultSet = pStmt.getResultSet();
            if (resultSet.next()) {
                String string = dataSetDocId = resultSet.getString(1);
                return string;
            }
            String string = dataSetDocId;
            return string;
        }
        catch (SQLException e) {
            logMetacat.error((Object)("DBUtil.findDataSetDocIdForGivenDocument - SQL error: " + e.getMessage()));
            String string = dataSetDocId;
            return string;
        }
        finally {
            try {
                resultSet.close();
                pStmt.close();
            }
            catch (SQLException e) {
                logMetacat.error((Object)("DBUtil.findDataSetDocIdForGivenDocument - error closing db resources: " + e.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentRevisionAndDocTypeForGivenDocument(String givenDocId) throws SQLException {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        String docIdWithoutRevision = null;
        String sqlCommand = null;
        ResultSet rs = null;
        String revision = null;
        String docType = null;
        docIdWithoutRevision = DocumentUtil.getDocIdFromString(givenDocId);
        sqlCommand = "select rev, doctype from xml_documents where docid like ?";
        try {
            dbConn = DBConnectionPool.getDBConnection("DBUtil.getCurrentRevisionAndDocTypeForGivenDocument");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement(sqlCommand);
            pstmt.setString(1, docIdWithoutRevision);
            pstmt.execute();
            rs = pstmt.getResultSet();
            if (rs.next()) {
                revision = rs.getString(1);
                docType = rs.getString(2);
            } else {
                Vector<Integer> revisionList = DBUtil.getRevListFromRevisionTable(docIdWithoutRevision);
                if (revisionList == null || revisionList.isEmpty()) {
                    throw new SQLException("DBUtil.getCurrentRevisionAndDocTypeForGivenDocument - There is no record for given docid: " + givenDocId);
                }
                int maxRev = DBUtil.getMaxmumNumber(revisionList);
                if (maxRev == -2) {
                    throw new SQLException("DBUtil.getCurrentRevisionAndDocTypeForGivenDocument - There is no record for given docid: " + givenDocId);
                }
                revision = new Integer(maxRev).toString();
                sqlCommand = "select doctype from xml_revisions where docid like '" + docIdWithoutRevision + "' and rev=" + maxRev;
                pstmt = dbConn.prepareStatement(sqlCommand);
                pstmt.execute();
                rs = pstmt.getResultSet();
                if (rs.next()) {
                    docType = rs.getString(1);
                }
            }
        }
        finally {
            try {
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                logMetacat.error((Object)("DBUtil.getCurrentRevisionAndDocTypeForGivenDocument - Error closing db resources: " + e.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        return revision + ";" + docType;
    }

    private static int getMaxmumNumber(Vector<Integer> list) {
        Integer max = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    max = list.elementAt(i);
                    continue;
                }
                if (max == null) {
                    max = list.elementAt(i);
                    continue;
                }
                Integer current = list.elementAt(i);
                if (current == null || current <= max) continue;
                max = current;
            }
        }
        if (max != null) {
            return max;
        }
        return -2;
    }

    public static int getMaxRevFromRevisionTable(String docIdWithoutRev) throws SQLException {
        int rev = -1;
        Vector<Integer> revList = DBUtil.getRevListFromRevisionTable(docIdWithoutRev);
        for (Integer currentRev : revList) {
            if (currentRev <= rev) continue;
            rev = currentRev;
        }
        return rev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Integer> getRevListFromRevisionTable(String docIdWithoutRev) throws SQLException {
        Vector<Integer> list = new Vector<Integer>();
        int rev = 1;
        Statement pStmt = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("getRevListFromRevisionTable");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pStmt = dbConn.prepareStatement("SELECT rev FROM xml_revisions WHERE docid = ? ORDER BY rev ASC");
            pStmt.setString(1, docIdWithoutRev);
            pStmt.execute();
            ResultSet rs = pStmt.getResultSet();
            boolean hasRow = rs.next();
            while (hasRow) {
                rev = rs.getInt(1);
                logMetacat.info((Object)("DBUtil.getRevListFromRevisionTable - rev: " + rev + " is added to list for docid: " + docIdWithoutRev));
                list.add(new Integer(rev));
                hasRow = rs.next();
            }
            pStmt.close();
        }
        finally {
            try {
                pStmt.close();
            }
            catch (Exception ee) {
                logMetacat.error((Object)("DBUtil.getRevListFromRevisionTable - Error closing prepared statement: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLatestRevisionInDocumentTable(String docIdWithoutRev) throws SQLException {
        int rev = 1;
        Statement pStmt = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBUtil.getLatestRevisionInDocumentTable");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pStmt = dbConn.prepareStatement("SELECT rev FROM xml_documents WHERE docid = ?");
            pStmt.setString(1, docIdWithoutRev);
            pStmt.execute();
            ResultSet rs = pStmt.getResultSet();
            boolean hasRow = rs.next();
            if (hasRow) {
                rev = rs.getInt(1);
                pStmt.close();
            } else {
                rev = -1;
                pStmt.close();
            }
        }
        finally {
            try {
                pStmt.close();
            }
            catch (Exception ee) {
                logMetacat.error((Object)("DBUtil.getLatestRevisionInDocumentTable - Error closing  prepared statement: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        return rev;
    }
}

