/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.AccessionNumber;
import edu.ucsb.nceas.metacat.AccessionNumberException;
import edu.ucsb.nceas.metacat.DBDTDHandler;
import edu.ucsb.nceas.metacat.DBEntityResolver;
import edu.ucsb.nceas.metacat.DBQuery;
import edu.ucsb.nceas.metacat.DBSAXHandler;
import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.ElementNode;
import edu.ucsb.nceas.metacat.Eml200SAXHandler;
import edu.ucsb.nceas.metacat.Eml210SAXHandler;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.IndexingQueue;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.NodeComparator;
import edu.ucsb.nceas.metacat.NodeRecord;
import edu.ucsb.nceas.metacat.PathIndexEntry;
import edu.ucsb.nceas.metacat.PermissionController;
import edu.ucsb.nceas.metacat.RelationHandler;
import edu.ucsb.nceas.metacat.XMLQueryresultAccess;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlList;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.common.query.EnabledQueryEngines;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.database.DatabaseService;
import edu.ucsb.nceas.metacat.dataone.SyncAccessPolicy;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.replication.ForceReplicationHandler;
import edu.ucsb.nceas.metacat.replication.ReplicationService;
import edu.ucsb.nceas.metacat.service.XMLSchema;
import edu.ucsb.nceas.metacat.service.XMLSchemaService;
import edu.ucsb.nceas.metacat.shared.AccessException;
import edu.ucsb.nceas.metacat.spatial.SpatialHarvester;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.UtilException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.log4j.Logger;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DocumentImpl {
    public static final String SCHEMA = "Schema";
    public static final String DTD = "DTD";
    public static final String EML200 = "eml200";
    public static final String EML210 = "eml210";
    public static final String EXTERNALSCHEMALOCATIONPROPERTY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String REVISIONTABLE = "xml_revisions";
    public static final String DOCUMENTTABLE = "xml_documents";
    public static final String DECLARATIONHANDLERPROPERTY = "http://xml.org/sax/properties/declaration-handler";
    public static final String LEXICALPROPERTY = "http://xml.org/sax/properties/lexical-handler";
    public static final String VALIDATIONFEATURE = "http://xml.org/sax/features/validation";
    public static final String SCHEMAVALIDATIONFEATURE = "http://apache.org/xml/features/validation/schema";
    public static final String FULLSCHEMAVALIDATIONFEATURE = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String NAMESPACEFEATURE = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACEPREFIXESFEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String EML2_0_0NAMESPACE;
    public static final String EML2_0_1NAMESPACE;
    public static final String EML2_1_0NAMESPACE;
    public static final String EML2_1_1NAMESPACE;
    public static final String RDF_SYNTAX_NAMESPACE;
    public static final String DOCNAME = "docname";
    public static final String PUBLICID = "publicid";
    public static final String SYSTEMID = "systemid";
    static final int ALL = 1;
    static final int WRITE = 2;
    static final int READ = 4;
    protected DBConnection connection = null;
    protected String docname = null;
    protected String doctype = null;
    private String validateType = null;
    private Date createdate = null;
    private Date updatedate = null;
    private String system_id = null;
    private String userowner = null;
    private String userupdated = null;
    protected String docid = null;
    private int rev;
    private int serverlocation;
    private String docHomeServer;
    private String publicaccess;
    protected long rootnodeid;
    private ElementNode rootNode = null;
    private TreeSet<NodeRecord> nodeRecordList = null;
    private Vector<String> pathsForIndexing = null;
    private static Logger logMetacat;
    private static Logger logReplication;

    public DocumentImpl() {
    }

    public DocumentImpl(String accNum, boolean readNodes) throws McdbException {
        try {
            this.docid = DocumentUtil.getDocIdFromAccessionNumber(accNum);
            this.rev = DocumentUtil.getRevisionFromAccessionNumber(accNum);
            this.pathsForIndexing = SystemUtil.getPathsForIndexing();
            this.getDocumentInfo(this.docid, this.rev);
            if (readNodes) {
                this.nodeRecordList = this.getNodeRecordList(this.rootnodeid);
            }
        }
        catch (McdbException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new McdbException("Error reading document: " + this.docid);
        }
    }

    public DocumentImpl(String docid) throws McdbException {
        this(docid, true);
    }

    public DocumentImpl(DBConnection conn, long rootNodeId, String docName, String docType, String docId, String newRevision, String action, String user, String pub, String catalogId, int serverCode, Date createDate, Date updateDate) throws SQLException, Exception {
        this.connection = conn;
        this.rootnodeid = rootNodeId;
        this.docname = docName;
        this.doctype = docType;
        this.docid = docId;
        this.rev = new Integer(newRevision);
        this.pathsForIndexing = SystemUtil.getPathsForIndexing();
        this.writeDocumentToDB(action, user, pub, catalogId, serverCode, createDate, updateDate);
    }

    public static void registerDocument(String docname, String doctype, String accnum, String user, String[] groupnames) throws SQLException, AccessionNumberException, Exception {
        int serverLocation = DocumentImpl.getServerLocationNumber(accnum);
        DocumentImpl.registerDocument(docname, doctype, accnum, user, groupnames, serverLocation);
    }

    public static void registerDocument(String docname, String doctype, String accnum, String user, String[] groups, int serverCode) throws SQLException, AccessionNumberException, Exception {
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("DocumentImpl.registerDocumentInreplication");
            serialNumber = conn.getCheckOutSerialNumber();
            conn.setAutoCommit(false);
            String action = null;
            String docIdWithoutRev = DocumentUtil.getDocIdFromAccessionNumber(accnum);
            int userSpecifyRev = DocumentUtil.getRevisionFromAccessionNumber(accnum);
            action = DocumentImpl.checkRevInXMLDocuments(docIdWithoutRev, userSpecifyRev);
            logMetacat.debug((Object)("after check rev, the action is " + action));
            if (action.equals("UPDATE")) {
                int latestRevision = DBUtil.getLatestRevisionInDocumentTable(docIdWithoutRev);
                String previousDocid = docIdWithoutRev + PropertyService.getProperty("document.accNumSeparator") + latestRevision;
                if (!DocumentImpl.hasWritePermission(user, groups, previousDocid)) {
                    throw new Exception("User " + user + " does not have permission to update the document" + accnum);
                }
                DocumentImpl.archiveDocRevision(docIdWithoutRev, user, conn);
            }
            String rev = Integer.toString(userSpecifyRev);
            DocumentImpl.modifyRecordsInGivenTable(DOCUMENTTABLE, action, docIdWithoutRev, doctype, docname, user, rev, serverCode, null, null, conn);
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e) {
            conn.rollback();
            conn.setAutoCommit(true);
            throw e;
        }
        finally {
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
    }

    public static void registerDocumentInReplication(String docname, String doctype, String accnum, String user, int serverCode, String tableName, Date createDate, Date updateDate) throws SQLException, AccessionNumberException, Exception {
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("DocumentImpl.registerDocumentInreplication");
            serialNumber = conn.getCheckOutSerialNumber();
            conn.setAutoCommit(false);
            String action = null;
            String docIdWithoutRev = DocumentUtil.getDocIdFromAccessionNumber(accnum);
            int userSpecifyRev = DocumentUtil.getRevisionFromAccessionNumber(accnum);
            if (tableName.equals(DOCUMENTTABLE)) {
                action = DocumentImpl.checkRevInXMLDocuments(docIdWithoutRev, userSpecifyRev);
                if (action.equals("UPDATE")) {
                    DocumentImpl.archiveDocRevision(docIdWithoutRev, user, conn);
                }
            } else if (tableName.equals(REVISIONTABLE)) {
                action = DocumentImpl.checkXMLRevisionTable(docIdWithoutRev, userSpecifyRev);
            } else {
                throw new Exception("Couldn't handle this table name " + tableName);
            }
            String rev = Integer.toString(userSpecifyRev);
            DocumentImpl.modifyRecordsInGivenTable(tableName, action, docIdWithoutRev, doctype, docname, user, rev, serverCode, createDate, updateDate, conn);
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e) {
            conn.rollback();
            conn.setAutoCommit(true);
            throw e;
        }
        finally {
            DBConnectionPool.returnDBConnection(conn, serialNumber);
        }
    }

    private static void modifyRecordsInGivenTable(String tableName, String action, String docid, String doctype, String docname, String user, String rev, int serverCode, Date createDate, Date updateDate, DBConnection dbconn) throws Exception {
        Statement pstmt = null;
        int revision = new Integer(rev);
        String sqlDateString = DatabaseService.getInstance().getDBAdapter().getDateTimeFunction();
        Date today = new Date(Calendar.getInstance().getTimeInMillis());
        if (createDate == null) {
            createDate = today;
        }
        if (updateDate == null) {
            updateDate = today;
        }
        try {
            StringBuffer sql = new StringBuffer();
            if (action != null && action.equals("INSERT")) {
                sql.append("insert into ");
                sql.append(tableName);
                sql.append(" (docid, docname, doctype, ");
                sql.append("user_owner, user_updated, server_location, rev, date_created, ");
                sql.append("date_updated, public_access) values (");
                sql.append("?, ");
                sql.append("?, ");
                sql.append("?, ");
                sql.append("?, ");
                sql.append("?, ");
                sql.append("?, ");
                sql.append("?, ");
                sql.append("?, ");
                sql.append("?, ");
                sql.append("'0')");
                pstmt = dbconn.prepareStatement(sql.toString());
                pstmt.setString(1, docid);
                pstmt.setString(2, docname);
                pstmt.setString(3, doctype);
                pstmt.setString(4, user);
                pstmt.setString(5, user);
                pstmt.setInt(6, serverCode);
                pstmt.setInt(7, revision);
                pstmt.setTimestamp(8, new Timestamp(createDate.getTime()));
                pstmt.setTimestamp(9, new Timestamp(updateDate.getTime()));
            } else if (action != null && action.equals("UPDATE")) {
                sql.append("update xml_documents set docname = ?,");
                sql.append("user_updated = ?, ");
                sql.append("server_location= ?, ");
                sql.append("rev = ?, ");
                sql.append("date_updated = ?");
                sql.append(" where docid = ? ");
                pstmt = dbconn.prepareStatement(sql.toString());
                pstmt.setString(1, docname);
                pstmt.setString(2, user);
                pstmt.setInt(3, serverCode);
                pstmt.setInt(4, revision);
                pstmt.setTimestamp(5, new Timestamp(updateDate.getTime()));
                pstmt.setString(6, docid);
            }
            logMetacat.debug((Object)("DocumentImpl.modifyRecordsInGivenTable - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception e) {
            logMetacat.debug((Object)("Caught a general exception: " + e.getMessage()));
            throw e;
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public static void writeDataFileInReplication(InputStream input, String filePath, String docname, String doctype, String accnum, String user, String docHomeServer, String notificationServer, String tableName, boolean timedReplication, Date createDate, Date updateDate) throws SQLException, AccessionNumberException, Exception {
        int serverCode = -2;
        if (filePath == null || filePath.equals("")) {
            throw new Exception("Please specify the directory where file will be store");
        }
        if (accnum == null || accnum.equals("")) {
            throw new Exception("Please specify the stored file name");
        }
        DocumentImpl.insertServerIntoReplicationTable(docHomeServer);
        serverCode = DocumentImpl.getServerCode(docHomeServer);
        File dataDirectory = new File(filePath);
        File newFile = null;
        try {
            newFile = new File(dataDirectory, accnum);
            FileOutputStream fos = new FileOutputStream(newFile);
            BufferedOutputStream outPut = new BufferedOutputStream(fos);
            BufferedInputStream bis = null;
            bis = new BufferedInputStream(input);
            byte[] buf = new byte[4096];
            int b = bis.read(buf);
            while (b != -1) {
                outPut.write(buf, 0, b);
                b = bis.read(buf);
            }
            bis.close();
            outPut.close();
            fos.close();
            DocumentImpl.registerDocumentInReplication(docname, doctype, accnum, user, serverCode, tableName, createDate, updateDate);
        }
        catch (Exception ee) {
            newFile.delete();
            throw ee;
        }
        if (!timedReplication) {
            ForceReplicationHandler forceReplication = new ForceReplicationHandler(accnum, false, notificationServer);
            logMetacat.info((Object)("ForceReplicationHandler created: " + forceReplication.toString()));
        }
    }

    private static String checkRevInXMLDocuments(String docid, int userSpecifyRev) throws Exception {
        String action = null;
        logMetacat.debug((Object)("The docid without rev is " + docid));
        logMetacat.debug((Object)("The user specifyRev: " + userSpecifyRev));
        int revInDataBase = DBUtil.getLatestRevisionInDocumentTable(docid);
        logMetacat.debug((Object)("The rev in data base: " + revInDataBase));
        if (revInDataBase == -1 && userSpecifyRev >= 0) {
            action = "INSERT";
        } else if (userSpecifyRev > revInDataBase && revInDataBase >= 0) {
            action = "UPDATE";
        } else {
            if (userSpecifyRev < revInDataBase && revInDataBase > 0) {
                throw new Exception("Local server: " + SystemUtil.getSecureServerURL() + " has newer revision of doc: " + docid + "." + revInDataBase + ". Please notify it.");
            }
            throw new Exception("The docid" + docid + "'s revision number couldn't be " + userSpecifyRev);
        }
        return action;
    }

    private static String checkXMLRevisionTable(String docid, int rev) throws Exception {
        String action = "INSERT";
        Vector<Integer> localrev = null;
        try {
            localrev = DBUtil.getRevListFromRevisionTable(docid);
        }
        catch (SQLException e) {
            logMetacat.error((Object)("Local rev for docid " + docid + " could not " + " be found because " + e.getMessage()));
            logReplication.error((Object)("Docid " + docid + " could not be " + "written because error happend to find it's local revision"));
            throw new Exception(e.getMessage());
        }
        logMetacat.debug((Object)("rev list in xml_revision table for docid " + docid + " is " + localrev.toString()));
        if (localrev.contains(new Integer(rev))) {
            throw new Exception("The docid and rev is already in xml_revision table");
        }
        return action;
    }

    public static boolean getDataFileLockGrant(String accnum) throws Exception {
        int serverLocation = DocumentImpl.getServerLocationNumber(accnum);
        return DocumentImpl.getDataFileLockGrant(accnum, serverLocation);
    }

    public static boolean getDataFileLockGrant(String accnum, int serverCode) throws Exception {
        boolean flag = true;
        String docid = DocumentUtil.getDocIdFromString(accnum);
        int rev = DocumentUtil.getVersionFromString(accnum);
        if (serverCode == 1) {
            flag = true;
            return flag;
        }
        if (serverCode != 1) {
            String server = ReplicationService.getServerNameForServerCode(serverCode);
            logReplication.info((Object)("attempting to lock " + accnum));
            URL u = new URL("https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=getlock&updaterev=" + rev + "&docid=" + docid);
            String serverResStr = ReplicationService.getURLContent(u);
            String openingtag = serverResStr.substring(0, serverResStr.indexOf(">") + 1);
            if (openingtag.equals("<lockgranted>")) {
                logReplication.info((Object)("lock granted for " + accnum + " from " + server));
                flag = true;
                return flag;
            }
            if (openingtag.equals("<filelocked>")) {
                logReplication.error((Object)("lock denied for " + accnum + " on " + server + " reason: file already locked"));
                throw new Exception("The file specified is already locked by another user.  Please wait 30 seconds, checkout the newer document, merge your changes and try again.");
            }
            if (openingtag.equals("<outdatedfile>")) {
                logReplication.error((Object)("lock denied for " + accnum + " on " + server + " reason: local file outdated"));
                throw new Exception("The file you are trying to update is an outdated version.  Please checkout the newest document, merge your changes and try again.");
            }
        }
        return flag;
    }

    public String getDocname() {
        return this.docname;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public String getSystemID() {
        return this.system_id;
    }

    public long getRootNodeID() {
        return this.rootnodeid;
    }

    public Date getCreateDate() {
        return this.createdate;
    }

    public Date getUpdateDate() {
        return this.updatedate;
    }

    public String getDocID() {
        return this.docid;
    }

    public String getUserowner() {
        return this.userowner;
    }

    public String getUserupdated() {
        return this.userupdated;
    }

    public int getServerlocation() {
        return this.serverlocation;
    }

    public String getDocHomeServer() {
        return this.docHomeServer;
    }

    public String getPublicaccess() {
        return this.publicaccess;
    }

    public int getRev() {
        return this.rev;
    }

    public String getValidateType() {
        return this.validateType;
    }

    public String toString(String user, String[] groups, boolean withInlinedata) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.toXml(out, user, groups, withInlinedata);
        }
        catch (McdbException mcdbe) {
            return null;
        }
        String encoding = null;
        String document = null;
        try {
            XmlStreamReader xsr = new XmlStreamReader((InputStream)new ByteArrayInputStream(out.toByteArray()));
            encoding = xsr.getEncoding();
            document = out.toString(encoding);
        }
        catch (Exception e) {
            document = out.toString();
        }
        return document;
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String userName = null;
        String[] groupNames = null;
        boolean withInlineData = true;
        try {
            this.toXml(out, userName, groupNames, withInlineData);
        }
        catch (McdbException mcdbe) {
            logMetacat.warn((Object)("Could not convert documentImpl to xml: " + mcdbe.getMessage()));
            return null;
        }
        String encoding = null;
        String document = null;
        try {
            XmlStreamReader xsr = new XmlStreamReader((InputStream)new ByteArrayInputStream(out.toByteArray()));
            encoding = xsr.getEncoding();
            document = out.toString(encoding);
        }
        catch (Exception e) {
            document = out.toString();
        }
        return document;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String userName = null;
        String[] groupNames = null;
        boolean withInlineData = true;
        try {
            this.toXml(out, userName, groupNames, withInlineData);
        }
        catch (McdbException mcdbe) {
            logMetacat.warn((Object)("Could not convert documentImpl to xml: " + mcdbe.getMessage()));
            return null;
        }
        return out.toByteArray();
    }

    public String readUsingSlowAlgorithm() throws McdbException {
        StringBuffer doc = new StringBuffer();
        if (this.nodeRecordList == null) {
            this.nodeRecordList = this.getNodeRecordList(this.rootnodeid);
        }
        this.rootNode = new ElementNode(this.nodeRecordList, this.rootnodeid);
        doc.append("<?xml version=\"1.0\"?>\n");
        if (this.docname != null) {
            if (this.doctype != null && this.system_id != null) {
                doc.append("<!DOCTYPE " + this.docname + " PUBLIC \"" + this.doctype + "\" \"" + this.system_id + "\">\n");
            } else {
                doc.append("<!DOCTYPE " + this.docname + ">\n");
            }
        }
        doc.append(this.rootNode.toString());
        return doc.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream toXml(OutputStream out, String user, String[] groups, boolean withInLineData) throws McdbException {
        String documentDir = null;
        String documentPath = null;
        FileOutputStream fos = null;
        try {
            String separator = PropertyService.getProperty("document.accNumSeparator");
            documentDir = PropertyService.getProperty("application.documentfilepath");
            documentPath = documentDir + FileUtil.getFS() + this.docid + separator + this.rev;
            if (FileUtil.getFileStatus((String)documentPath) == FileUtil.DOES_NOT_EXIST || FileUtil.getFileSize((String)documentPath) == 0L) {
                fos = new FileOutputStream(documentPath);
                this.toXmlFromDb(fos, user, groups, true);
                fos.close();
            }
        }
        catch (PropertyNotFoundException pnfe) {
            try {
                throw new McdbException("Could not write file: " + documentPath + " : " + pnfe.getMessage());
                catch (IOException ioe) {
                    throw new McdbException("Could not write file: " + documentPath + " : " + ioe.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        if (FileUtil.getFileSize((String)documentPath) != 0L) {
            return this.readFromFileSystem(out, user, groups, documentPath);
        }
        throw new McdbException("Attempting to read a zero length document from disk: " + documentPath);
    }

    public void toXmlFromDb(OutputStream outputStream, String user, String[] groups, boolean withInLineData) throws McdbException, IOException {
        boolean proccessEml2 = false;
        boolean storedDTD = false;
        boolean firstElement = true;
        String dbDocName = null;
        String dbPublicID = null;
        String dbSystemID = null;
        if (this.doctype != null && (this.doctype.equals(EML2_0_0NAMESPACE) || this.doctype.equals(EML2_0_1NAMESPACE) || this.doctype.equals(EML2_1_0NAMESPACE) || this.doctype.equals(EML2_1_1NAMESPACE))) {
            proccessEml2 = true;
        }
        boolean processInlineData = false;
        TreeSet<NodeRecord> nodeRecordLists = null;
        String encoding = "UTF-8";
        OutputStreamWriter out = new OutputStreamWriter(outputStream, encoding);
        nodeRecordLists = this.nodeRecordList == null ? this.getNodeRecordList(this.rootnodeid) : this.nodeRecordList;
        Stack<NodeRecord> openElements = new Stack<NodeRecord>();
        boolean atRootElement = true;
        boolean previousNodeWasElement = false;
        for (NodeRecord currentNode : nodeRecordLists) {
            logMetacat.debug((Object)("[Got Node ID: " + currentNode.getNodeId() + " (" + currentNode.getParentNodeId() + ", " + currentNode.getNodeIndex() + ", " + currentNode.getNodeType() + ", " + currentNode.getNodeName() + ", " + currentNode.getNodeData() + ")]"));
            if (!atRootElement) {
                NodeRecord currentElement = (NodeRecord)openElements.peek();
                if (currentNode.getParentNodeId() != currentElement.getNodeId()) {
                    while (currentNode.getParentNodeId() != currentElement.getNodeId()) {
                        currentElement = (NodeRecord)openElements.pop();
                        logMetacat.debug((Object)("\n POPPED: " + currentElement.getNodeName()));
                        if (previousNodeWasElement) {
                            out.write(">");
                            previousNodeWasElement = false;
                        }
                        if (currentElement.getNodePrefix() != null) {
                            out.write("</" + currentElement.getNodePrefix() + ":" + currentElement.getNodeName() + ">");
                        } else {
                            out.write("</" + currentElement.getNodeName() + ">");
                        }
                        currentElement = (NodeRecord)openElements.peek();
                    }
                }
            }
            if (currentNode.getNodeType().equals("DOCUMENT")) {
                out.write("<?xml version=\"1.0\"?>");
            } else if (currentNode.getNodeType().equals("ELEMENT")) {
                if (atRootElement) {
                    atRootElement = false;
                } else if (previousNodeWasElement) {
                    out.write(">");
                }
                if (!storedDTD & firstElement && this.docname != null && this.validateType != null && this.validateType.equals(DTD)) {
                    if (this.doctype != null && this.system_id != null) {
                        out.write("<!DOCTYPE " + this.docname + " PUBLIC \"" + this.doctype + "\" \"" + this.system_id + "\">");
                    } else {
                        out.write("<!DOCTYPE " + this.docname + ">");
                    }
                }
                firstElement = false;
                openElements.push(currentNode);
                logMetacat.debug((Object)("\n PUSHED: " + currentNode.getNodeName()));
                previousNodeWasElement = true;
                if (currentNode.getNodePrefix() != null) {
                    out.write("<" + currentNode.getNodePrefix() + ":" + currentNode.getNodeName());
                } else {
                    out.write("<" + currentNode.getNodeName());
                }
                if (currentNode.getNodeName() != null && currentNode.getNodeName().equals("inline") && proccessEml2) {
                    processInlineData = true;
                }
            } else if (currentNode.getNodeType().equals("ATTRIBUTE")) {
                if (currentNode.getNodePrefix() != null) {
                    out.write(" " + currentNode.getNodePrefix() + ":" + currentNode.getNodeName() + "=\"" + currentNode.getNodeData() + "\"");
                } else {
                    out.write(" " + currentNode.getNodeName() + "=\"" + currentNode.getNodeData() + "\"");
                }
            } else if (currentNode.getNodeType().equals("NAMESPACE")) {
                String nsprefix = " xmlns:";
                if (currentNode.getNodeName() == null || currentNode.getNodeName().trim().equals("")) {
                    nsprefix = " xmlns";
                }
                out.write(nsprefix + currentNode.getNodeName() + "=\"" + currentNode.getNodeData() + "\"");
            } else if (currentNode.getNodeType().equals("TEXT")) {
                if (previousNodeWasElement) {
                    out.write(">");
                }
                if (!processInlineData) {
                    out.write(currentNode.getNodeData());
                } else {
                    String fileName;
                    String accessfileName = fileName = currentNode.getNodeData();
                    boolean readInlinedata = false;
                    try {
                        Hashtable<String, String> unReadableInlineDataList = PermissionController.getUnReadableInlineDataIdList(accessfileName, user, groups);
                        if (!unReadableInlineDataList.containsValue(fileName)) {
                            readInlinedata = true;
                        }
                    }
                    catch (Exception e) {
                        throw new McdbException(e.getMessage());
                    }
                    if (readInlinedata) {
                        Reader reader = Eml200SAXHandler.readInlineDataFromFileSystem(fileName, encoding);
                        char[] characterArray = new char[4096];
                        try {
                            int length = reader.read(characterArray);
                            while (length != -1) {
                                out.write(new String(characterArray, 0, length));
                                ((Writer)out).flush();
                                length = reader.read(characterArray);
                            }
                            reader.close();
                        }
                        catch (IOException e) {
                            throw new McdbException(e.getMessage());
                        }
                    } else {
                        out.write("");
                    }
                    processInlineData = false;
                }
                previousNodeWasElement = false;
            } else if (currentNode.getNodeType().equals("COMMENT")) {
                if (previousNodeWasElement) {
                    out.write(">");
                }
                out.write("<!--" + currentNode.getNodeData() + "-->");
                previousNodeWasElement = false;
            } else if (currentNode.getNodeType().equals("PI")) {
                if (previousNodeWasElement) {
                    out.write(">");
                }
                out.write("<?" + currentNode.getNodeName() + " " + currentNode.getNodeData() + "?>");
                previousNodeWasElement = false;
            } else if (currentNode.getNodeType().equals(DTD)) {
                storedDTD = true;
                if (currentNode.getNodeName().equals(DOCNAME)) {
                    dbDocName = currentNode.getNodeData();
                }
                if (currentNode.getNodeName().equals(PUBLICID)) {
                    dbPublicID = currentNode.getNodeData();
                }
                if (currentNode.getNodeName().equals(SYSTEMID)) {
                    dbSystemID = currentNode.getNodeData();
                    if (dbDocName != null) {
                        if (dbPublicID != null && dbSystemID != null) {
                            out.write("<!DOCTYPE " + dbDocName + " PUBLIC \"" + dbPublicID + "\" \"" + dbSystemID + "\">");
                        } else {
                            out.write("<!DOCTYPE " + dbDocName + ">");
                        }
                    }
                    dbDocName = null;
                    dbPublicID = null;
                    dbSystemID = null;
                }
            }
            ((Writer)out).flush();
        }
        while (!openElements.empty()) {
            NodeRecord currentElement = (NodeRecord)openElements.pop();
            logMetacat.debug((Object)("\n POPPED: " + currentElement.getNodeName()));
            if (currentElement.getNodePrefix() != null) {
                out.write("</" + currentElement.getNodePrefix() + ":" + currentElement.getNodeName() + ">");
                continue;
            }
            out.write("</" + currentElement.getNodeName() + ">");
        }
        ((Writer)out).flush();
    }

    public InputStream readFromFileSystem(OutputStream out, String user, String[] groups, String documentPath) throws McdbException {
        String xmlFileContents = null;
        String encoding = null;
        try {
            String fullDocid = this.docid + "." + this.rev;
            Hashtable<String, String> unReadableInlineDataList = PermissionController.getUnReadableInlineDataIdList(fullDocid, user, groups);
            if (unReadableInlineDataList.size() > 0 && this.doctype != null) {
                xmlFileContents = FileUtil.readFileToString((String)documentPath);
                XmlStreamReader xsr = new XmlStreamReader((InputStream)new ByteArrayInputStream(xmlFileContents.getBytes()));
                encoding = xsr.getEncoding();
                xsr.close();
                if (encoding != null) {
                    xmlFileContents = FileUtil.readFileToString((String)documentPath, (String)encoding);
                }
                Set<String> inlineKeySet = unReadableInlineDataList.keySet();
                boolean pre210Doc = this.doctype.equals(EML2_0_0NAMESPACE) || this.doctype.equals(EML2_0_1NAMESPACE);
                for (String inlineKey : inlineKeySet) {
                    String inlineValue = unReadableInlineDataList.get(inlineKey);
                    if (!inlineValue.startsWith(this.docid)) continue;
                    if (pre210Doc) {
                        xmlFileContents = this.stripInline20XData(xmlFileContents, inlineKey);
                        continue;
                    }
                    xmlFileContents = this.stripInline21XData(xmlFileContents, inlineKey);
                }
            }
            InputStream is = null;
            is = xmlFileContents != null ? IOUtils.toInputStream((String)xmlFileContents, encoding) : new FileInputStream(documentPath);
            if (out != null) {
                IOUtils.copyLarge((InputStream)is, (OutputStream)out);
            }
            return is;
        }
        catch (UtilException e) {
            throw new McdbException(e.getMessage());
        }
        catch (IOException e) {
            throw new McdbException(e.getMessage());
        }
    }

    private static void writeToFileSystem(byte[] xml, String accNumber) throws McdbException {
        block9: {
            String documentDir = null;
            String documentPath = null;
            try {
                documentDir = PropertyService.getProperty("application.documentfilepath");
                documentPath = documentDir + FileUtil.getFS() + accNumber;
                if (xml == null || xml.equals("")) {
                    throw new McdbException("Attempting to write a file with no xml content: " + documentPath);
                }
                if (accNumber == null) {
                    throw new McdbException("Could not write document file.  Accession Number number is null");
                }
                if (FileUtil.getFileStatus((String)documentPath) >= FileUtil.EXISTS_ONLY) {
                    throw new McdbException("The file you are trying to write already exists  in metacat.  Please update your version number.");
                }
                if (accNumber == null || FileUtil.getFileStatus((String)documentPath) != FileUtil.DOES_NOT_EXIST && FileUtil.getFileSize((String)documentPath) != 0L) break block9;
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(documentPath);
                    IOUtils.write((byte[])xml, (OutputStream)fos);
                    fos.flush();
                    fos.close();
                }
                catch (IOException ioe) {
                    try {
                        throw new McdbException("Could not write file: " + documentPath + " : " + ioe.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fos);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)fos);
            }
            catch (PropertyNotFoundException pnfe) {
                throw new McdbException("Could not write file: " + documentPath + " : " + pnfe.getMessage());
            }
        }
    }

    private static void deleteFromFileSystem(String accNumber, boolean isXml) throws McdbException {
        if (accNumber == null) {
            throw new McdbException("Could not delete file.  Accession Number number is null");
        }
        String documentPath = null;
        documentPath = DocumentImpl.getFilePath(accNumber, isXml);
        if (accNumber != null && FileUtil.getFileStatus((String)documentPath) != FileUtil.DOES_NOT_EXIST) {
            try {
                FileUtil.deleteFile((String)documentPath);
            }
            catch (IOException ioe) {
                throw new McdbException("Could not delete file: " + documentPath + " : " + ioe.getMessage());
            }
        }
    }

    private static String getFilePath(String accNumber, boolean isXml) throws McdbException {
        if (accNumber == null) {
            throw new McdbException("Could not get the file path since the Accession Number number is null");
        }
        String documentPath = null;
        try {
            String documentDir = null;
            documentDir = isXml ? PropertyService.getProperty("application.documentfilepath") : PropertyService.getProperty("application.datafilepath");
            documentPath = documentDir + FileUtil.getFS() + accNumber;
            return documentPath;
        }
        catch (PropertyNotFoundException pnfe) {
            throw new McdbException(((Object)((Object)pnfe)).getClass().getName() + ": Could not delete file because: " + documentPath + " : " + pnfe.getMessage());
        }
    }

    private String stripInline20XData(String xmlFileContents, String inLineId) throws McdbException {
        String changedString = xmlFileContents;
        Pattern distStartPattern = Pattern.compile("<distribution", 2);
        Pattern distEndPattern = Pattern.compile("</distribution>", 2);
        Pattern idPattern = Pattern.compile("id=\"" + inLineId);
        Pattern inlinePattern = Pattern.compile("<inline>.*</inline>");
        Matcher distStartMatcher = distStartPattern.matcher(xmlFileContents);
        Matcher distEndMatcher = distEndPattern.matcher(xmlFileContents);
        Matcher idMatcher = idPattern.matcher(xmlFileContents);
        Matcher inlineMatcher = inlinePattern.matcher(xmlFileContents);
        while (distStartMatcher.find()) {
            int distStart = distStartMatcher.end();
            if (!distEndMatcher.find(distStart)) {
                throw new McdbException("Could not find end tag for distribution");
            }
            int distEnd = distEndMatcher.start();
            idMatcher.region(distStart, distEnd);
            if (!idMatcher.find()) continue;
            inlineMatcher.region(distStart, distEnd);
            if (inlineMatcher.find()) {
                changedString = inlineMatcher.replaceAll("<inline></inline>");
                continue;
            }
            logMetacat.warn((Object)("Could not find an inline element for distribution: " + inLineId));
        }
        return changedString;
    }

    private String stripInline21XData(String xmlFileContents, String inLineId) throws McdbException {
        int distributionIndex = Integer.valueOf(inLineId);
        String changedString = xmlFileContents;
        Pattern distStartPattern = Pattern.compile("<distribution", 2);
        Pattern distEndPattern = Pattern.compile("</distribution>", 2);
        Pattern inlinePattern = Pattern.compile("<inline>.*</inline>");
        Matcher matcher = distStartPattern.matcher(xmlFileContents);
        for (int i = 0; i < distributionIndex; ++i) {
            if (matcher.find()) continue;
            throw new McdbException("Could not find distribution number " + (i + 1));
        }
        int distStart = matcher.end();
        matcher.usePattern(distEndPattern);
        if (!matcher.find(distStart)) {
            throw new McdbException("Could not find end tag for distribution");
        }
        int distEnd = matcher.start();
        matcher.region(distStart, distEnd);
        matcher.usePattern(inlinePattern);
        if (matcher.find()) {
            changedString = matcher.replaceAll("<inline></inline>");
        } else {
            logMetacat.warn((Object)("Could not find an inline element for distribution: " + inLineId));
        }
        return changedString;
    }

    public void buildIndex() throws McdbException {
        if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
            return;
        }
        logMetacat.info((Object)("DocumentImpl.buildIndex - building index for docid " + this.docid));
        double start = System.currentTimeMillis() / 1000L;
        TreeSet<NodeRecord> nodeRecordLists = this.getNodeRecordList(this.rootnodeid);
        boolean atRootElement = true;
        long rootNodeId = -1L;
        HashMap<Long, NodeRecord> nodeRecordMap = new HashMap<Long, NodeRecord>();
        for (NodeRecord currentNode : nodeRecordLists) {
            Long nodeId = new Long(currentNode.getNodeId());
            nodeRecordMap.put(nodeId, currentNode);
        }
        double afterPutNode = System.currentTimeMillis() / 1000L;
        logMetacat.debug((Object)("DocumentImpl.buildIndex - The time to put node id into map is " + (afterPutNode - start)));
        double afterDelete = 0.0;
        int serialNumber = -1;
        DBConnection dbConn = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("DocumentImpl.buildIndex");
            serialNumber = dbConn.getCheckOutSerialNumber();
            dbConn.setAutoCommit(false);
            this.deleteNodeIndex(dbConn);
            afterDelete = System.currentTimeMillis() / 1000L;
            Iterator<NodeRecord> it = nodeRecordLists.iterator();
            HashMap<String, PathIndexEntry> pathsFound = new HashMap<String, PathIndexEntry>();
            while (it.hasNext()) {
                NodeRecord parentNode;
                NodeRecord currentNode = it.next();
                HashMap<String, PathIndexEntry> pathList = new HashMap<String, PathIndexEntry>();
                if (currentNode.getNodeType().equals("ELEMENT") || currentNode.getNodeType().equals("ATTRIBUTE")) {
                    if (atRootElement) {
                        rootNodeId = currentNode.getNodeId();
                        atRootElement = false;
                    }
                    this.traverseParents(nodeRecordMap, rootNodeId, currentNode.getNodeId(), currentNode.getNodeId(), "", pathList, pathsFound);
                    this.updateNodeIndex(dbConn, pathList);
                } else if (currentNode.getNodeType().equals("TEXT") && (parentNode = nodeRecordMap.get(new Long(currentNode.getParentNodeId()))).getNodeType().equals("ELEMENT")) {
                    currentNode.setNodeType(parentNode.getNodeType());
                    currentNode.setNodeName("");
                    logMetacat.debug((Object)("DocumentImpl.buildIndex - Converted node " + currentNode.getNodeId() + " to type " + parentNode.getNodeType()));
                    this.traverseParents(nodeRecordMap, rootNodeId, currentNode.getNodeId(), currentNode.getNodeId(), "", pathList, pathsFound);
                }
                if (pathsFound.isEmpty()) continue;
                logMetacat.debug((Object)"DocumentImpl.buildIndex - updating path index");
                this.updatePathIndex(dbConn, pathsFound);
                pathsFound.clear();
            }
            dbConn.commit();
        }
        catch (SQLException sqle) {
            logMetacat.error((Object)("DocumentImpl.buildIndex - SQL Exception while indexing document " + this.docid + " : " + sqle.getMessage()));
            try {
                dbConn.rollback();
            }
            catch (SQLException sqle2) {
                logMetacat.error((Object)("DocumentImpl.buildIndex - Error while rolling back: " + sqle2.getMessage()));
            }
            throw new McdbException("SQL error when building Index: " + sqle.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        double finish = System.currentTimeMillis() / 1000L;
        logMetacat.info((Object)("DocumentImpl.buildIndex - The time for inserting is " + (finish - afterDelete)));
        logMetacat.info((Object)("DocumentImpl.buildIndex - BuildIndex complete for docid " + this.docid));
        try {
            if (PropertyService.getProperty("spatial.runSpatialOption").equals("true")) {
                SpatialHarvester spatialHarvester = new SpatialHarvester();
                logMetacat.debug((Object)("DocumentImpl.buildIndex -  Attempting to update the spatial cache for docid " + this.docid));
                spatialHarvester.addToUpdateQue(this.docid);
                spatialHarvester.destroy();
                logMetacat.debug((Object)("DocumentImpl.buildIndex - Finished updating the spatial cache for docid " + this.docid));
            }
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("DocumentImpl.buildIndex - Could not get 'runSpatialOption' property.  Spatial cache not run for docid: " + this.docid + " : " + pnfe.getMessage()));
        }
        catch (StringIndexOutOfBoundsException siobe) {
            logMetacat.error((Object)("DocumentImpl.buildIndex -  String indexing problem.  Spatial cache not run for docid: " + this.docid + " : " + siobe.getMessage()));
        }
    }

    private void traverseParents(HashMap<Long, NodeRecord> records, long rootNodeId, long leafNodeId, long id, String children, HashMap<String, PathIndexEntry> pathList, HashMap<String, PathIndexEntry> pathsFoundForIndexing) {
        Long nodeId = new Long(id);
        NodeRecord current = records.get(nodeId);
        long parentId = current.getParentNodeId();
        String currentName = current.getNodeName();
        NodeRecord leafRecord = records.get(new Long(leafNodeId));
        String leafData = leafRecord.getNodeData();
        long leafParentId = leafRecord.getParentNodeId();
        float leafDataNumerical = leafRecord.getNodeDataNumerical();
        Timestamp leafDataDate = leafRecord.getNodeDataDate();
        if (current.getNodeType().equals("ELEMENT") || current.getNodeType().equals("ATTRIBUTE")) {
            if (children.equals("")) {
                if (current.getNodeType().equals("ATTRIBUTE")) {
                    currentName = "@" + currentName;
                }
                logMetacat.debug((Object)("DocumentImpl.traverseParents - A: " + currentName + "\n"));
                if (currentName != null && !currentName.equals("")) {
                    pathList.put(currentName, new PathIndexEntry(leafNodeId, currentName, this.docid, this.doctype, parentId));
                }
                if (this.pathsForIndexing.contains(currentName) && leafData.trim().length() != 0) {
                    logMetacat.debug((Object)("DocumentImpl.traverseParents - paths found for indexing: " + currentName));
                    pathsFoundForIndexing.put(currentName, new PathIndexEntry(leafNodeId, currentName, this.docid, leafParentId, leafData, leafDataNumerical, leafDataDate));
                }
            }
            if (!currentName.equals("")) {
                currentName = "/" + currentName;
                currentName = currentName + children;
            }
            if (parentId != 0L) {
                this.traverseParents(records, rootNodeId, leafNodeId, parentId, currentName, pathList, pathsFoundForIndexing);
            }
            String path = current.getNodeName() + children;
            if (!children.equals("")) {
                logMetacat.debug((Object)("DocumentImpl.traverseParents - B: " + path + "\n"));
                pathList.put(path, new PathIndexEntry(leafNodeId, path, this.docid, this.doctype, parentId));
                if (this.pathsForIndexing.contains(path) && leafData.trim().length() != 0) {
                    logMetacat.debug((Object)("DocumentImpl.traverseParents - paths found for indexing: " + currentName));
                    pathsFoundForIndexing.put(path, new PathIndexEntry(leafNodeId, path, this.docid, leafParentId, leafData, leafDataNumerical, leafDataDate));
                }
            }
            if (id == rootNodeId) {
                String fullPath = "";
                if (!path.equals("")) {
                    fullPath = '/' + path;
                }
                logMetacat.debug((Object)("DocumentImpl.traverseParents - C: " + fullPath + "\n"));
                pathList.put(fullPath, new PathIndexEntry(leafNodeId, fullPath, this.docid, this.doctype, parentId));
                if (this.pathsForIndexing.contains(fullPath) && leafData.trim().length() != 0) {
                    logMetacat.debug((Object)("DocumentImpl.traverseParents - paths found for indexing: " + currentName));
                    pathsFoundForIndexing.put(fullPath, new PathIndexEntry(leafNodeId, fullPath, this.docid, leafParentId, leafData, leafDataNumerical, leafDataDate));
                }
            }
        }
    }

    private void deleteNodeIndex(DBConnection conn) throws SQLException {
        double start = System.currentTimeMillis() / 1000L;
        String familyId = this.docid;
        String sql = "DELETE FROM xml_index WHERE docid = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        conn.increaseUsageCount(1);
        pstmt.setString(1, familyId);
        logMetacat.debug((Object)("DocumentImpl.deleteNodeIndex - executing SQL: " + pstmt.toString()));
        int rows = pstmt.executeUpdate();
        pstmt.close();
        logMetacat.debug((Object)("DocumentImpl.deleteNodeIndex - Deleted " + rows + " rows from xml_index " + "for document " + this.docid));
        double afterDeleteIndex = System.currentTimeMillis() / 1000L;
        logMetacat.debug((Object)("DocumentImpl.deleteNodeIndex - The delete index time is " + (afterDeleteIndex - start)));
        try {
            XMLQueryresultAccess xmlQueryresultAccess = new XMLQueryresultAccess();
            xmlQueryresultAccess.deleteXMLQueryresulForDoc(this.docid);
        }
        catch (AccessException ae) {
            throw new SQLException("Problem deleting xml query result for docid " + this.docid + " : " + ae.getMessage());
        }
        logMetacat.debug((Object)("DocumentImpl.deleteNodeIndex - Deleted " + rows + " rows from xml_queryresult " + "for document " + this.docid));
        double afterDeleteQueryResult = System.currentTimeMillis() / 1000L;
        logMetacat.debug((Object)("DocumentImpl.deleteNodeIndex - The delete query result time is " + (afterDeleteQueryResult - afterDeleteIndex)));
        pstmt = conn.prepareStatement("DELETE FROM xml_path_index WHERE docid = ?");
        pstmt.setString(1, this.docid);
        logMetacat.debug((Object)("DocumentImpl.deleteNodeIndex - executing SQL: " + pstmt.toString()));
        rows = pstmt.executeUpdate();
        conn.increaseUsageCount(1);
        pstmt.close();
        double afterDeletePathIndex = System.currentTimeMillis() / 1000L;
        logMetacat.info((Object)("DocumentImpl.deleteNodeIndex - The delete path index time is " + (afterDeletePathIndex - afterDeleteQueryResult)));
        logMetacat.info((Object)("DocumentImpl.deleteNodeIndex - Deleted " + rows + " rows from xml_path_index " + "for document " + this.docid));
    }

    private void updateNodeIndex(DBConnection conn, HashMap<String, PathIndexEntry> pathList) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("INSERT INTO xml_index (nodeid, path, docid, doctype, parentnodeid) VALUES (?, ?, ?, ?, ?)");
        conn.increaseUsageCount(1);
        String familyId = this.docid;
        pstmt.setString(3, familyId);
        pstmt.setString(4, this.doctype);
        for (PathIndexEntry entry : pathList.values()) {
            pstmt.setLong(1, entry.nodeId);
            pstmt.setString(2, entry.path);
            pstmt.setLong(5, entry.parentId);
            logMetacat.debug((Object)("DocumentImpl.updateNodeIndex - executing SQL: " + pstmt.toString()));
            pstmt.executeUpdate();
        }
        pstmt.close();
    }

    private void updatePathIndex(DBConnection conn, HashMap<String, PathIndexEntry> pathsFound) throws SQLException {
        conn.increaseUsageCount(1);
        PreparedStatement pstmt = conn.prepareStatement("INSERT INTO xml_path_index (docid, path, nodedata, nodedatanumerical, nodedatadate, parentnodeid) VALUES (?, ?, ?, ?, ?, ?)");
        for (PathIndexEntry entry : pathsFound.values()) {
            if (entry.path.length() > 2784) {
                logMetacat.warn((Object)("DocumentImpl.updatePathIndex - the path for doc id " + entry.docid + " is too long and will db break indexing.  This path was not indexed: " + entry.path));
                continue;
            }
            if (entry.nodeData.length() > 2784) {
                logMetacat.warn((Object)("DocumentImpl.updatePathIndex - the node data for doc id " + entry.docid + " is too long and will break db indexing.  This path was not indexed: " + entry.path));
                continue;
            }
            pstmt.setString(1, entry.docid);
            pstmt.setString(2, entry.path);
            pstmt.setString(3, entry.nodeData);
            pstmt.setFloat(4, entry.nodeDataNumerical);
            pstmt.setTimestamp(5, entry.nodeDataDate);
            pstmt.setLong(6, entry.parentId);
            logMetacat.debug((Object)("DocumentImpl.updatePathIndex - executing SQL: " + pstmt.toString()));
            pstmt.execute();
        }
        pstmt.close();
    }

    private boolean isRevisionOnly(String docid, int revision) throws Exception {
        DBConnection dbconn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        String newid = docid;
        try {
            dbconn = DBConnectionPool.getDBConnection("DocumentImpl.isRevisionOnly");
            serialNumber = dbconn.getCheckOutSerialNumber();
            pstmt = dbconn.prepareStatement("select rev from xml_documents where docid like ?");
            pstmt.setString(1, newid);
            logMetacat.debug((Object)("DocumentImpl.isRevisionOnly - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tablehasrows = rs.next();
            if (tablehasrows) {
                int r = rs.getInt(1);
                pstmt.close();
                if (revision == r) {
                    boolean bl = false;
                    return bl;
                }
                if (revision < r) {
                    boolean bl = true;
                    return bl;
                }
                if (revision > r) {
                    throw new Exception("requested revision cannot be greater than the latest revision number.");
                }
            } else {
                Vector<Integer> revList = DBUtil.getRevListFromRevisionTable(docid);
                if (revList != null && !revList.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
            }
            String missDocId = docid;
            String missRevision = new Integer(revision).toString();
            throw new McdbDocNotFoundException("the requested docid '" + docid.toString() + "' does not exist", missDocId, missRevision);
        }
        finally {
            pstmt.close();
            DBConnectionPool.returnDBConnection(dbconn, serialNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getDocumentInfo(String docid, int revision) throws McdbException, Exception {
        DBConnection dbconn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        String table = DOCUMENTTABLE;
        try {
            if (this.isRevisionOnly(docid, revision)) {
                table = REVISIONTABLE;
            }
        }
        catch (McdbDocNotFoundException notFound) {
            throw notFound;
        }
        catch (Exception e) {
            logMetacat.error((Object)("DocumentImpl.getDocumentInfo - general error: " + e.getMessage()));
            throw e;
        }
        try {
            dbconn = DBConnectionPool.getDBConnection("DocumentImpl.getDocumentInfo");
            serialNumber = dbconn.getCheckOutSerialNumber();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT docname, doctype, rootnodeid, ");
            sql.append("date_created, date_updated, user_owner, user_updated,");
            sql.append(" server_location, public_access, rev");
            sql.append(" FROM ").append(table);
            sql.append(" WHERE docid LIKE ? ");
            sql.append(" and rev = ? ");
            pstmt = dbconn.prepareStatement(sql.toString());
            pstmt.setString(1, docid);
            pstmt.setInt(2, revision);
            logMetacat.debug((Object)("DocumentImpl.getDocumentInfo - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            if (tableHasRows) {
                this.docname = rs.getString(1);
                this.doctype = rs.getString(2);
                this.rootnodeid = rs.getLong(3);
                this.createdate = rs.getTimestamp(4);
                this.updatedate = rs.getTimestamp(5);
                this.userowner = rs.getString(6);
                this.userupdated = rs.getString(7);
                this.serverlocation = rs.getInt(8);
                this.publicaccess = rs.getString(9);
                this.rev = rs.getInt(10);
            }
            pstmt.close();
            pstmt = dbconn.prepareStatement("select server from xml_replication where serverid = ?");
            dbconn.increaseUsageCount(1);
            pstmt.setInt(1, this.serverlocation);
            logMetacat.debug((Object)("DocumentImpl.getDocumentInfo - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            rs = pstmt.getResultSet();
            tableHasRows = rs.next();
            if (tableHasRows) {
                String server = rs.getString(1);
                this.docHomeServer = !server.equals("localhost") ? server : MetacatUtil.getLocalReplicationServerName();
                logMetacat.debug((Object)("DocumentImpl.getDocumentInfo - server: " + this.docHomeServer));
            }
            pstmt.close();
            if (this.doctype != null) {
                pstmt = dbconn.prepareStatement("SELECT system_id, entry_type FROM xml_catalog WHERE public_id = ?");
                dbconn.increaseUsageCount(1);
                pstmt.setString(1, this.doctype);
                logMetacat.debug((Object)("DocumentImpl.getDocumentInfo - executing SQL: " + pstmt.toString()));
                pstmt.execute();
                rs = pstmt.getResultSet();
                tableHasRows = rs.next();
                if (tableHasRows) {
                    this.system_id = rs.getString(1);
                    if (!this.system_id.startsWith("http://")) {
                        this.system_id = SystemUtil.getContextURL() + this.system_id;
                    }
                    this.validateType = rs.getString(2);
                }
                pstmt.close();
            }
        }
        catch (SQLException e) {
            logMetacat.error((Object)("DocumentImpl.getDocumentInfo - Error in DocumentImpl.getDocumentInfo: " + e.getMessage()));
            e.printStackTrace(System.out);
            throw new McdbException("DocumentImpl.getDocumentInfo - Error accessing database connection: ", e);
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("DocumentImpl.getDocumentInfo - General error" + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbconn, serialNumber);
            }
        }
        if (this.docname == null) {
            throw new McdbDocNotFoundException("Document not found: " + docid, docid, new Integer(revision).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TreeSet<NodeRecord> getNodeRecordList(long rootnodeid) throws McdbException {
        Statement pstmt = null;
        DBConnection dbconn = null;
        int serialNumber = -1;
        TreeSet<NodeRecord> nodeRecordList = new TreeSet<NodeRecord>(new NodeComparator());
        long nodeid = 0L;
        long parentnodeid = 0L;
        long nodeindex = 0L;
        String nodetype = null;
        String nodename = null;
        String nodeprefix = null;
        String nodedata = null;
        float nodedatanumerical = -1.0f;
        Timestamp nodedatadate = null;
        String table = "xml_nodes";
        try {
            if (this.isRevisionOnly(this.docid, this.rev)) {
                table = "xml_nodes_revisions";
            }
        }
        catch (McdbDocNotFoundException notFound) {
            throw notFound;
        }
        catch (Exception e) {
            logMetacat.error((Object)("DocumentImpl.getNodeRecordList - General error: " + e.getMessage()));
        }
        try {
            dbconn = DBConnectionPool.getDBConnection("DocumentImpl.getNodeRecordList");
            serialNumber = dbconn.getCheckOutSerialNumber();
            pstmt = dbconn.prepareStatement("SELECT nodeid,parentnodeid,nodeindex, nodetype,nodename,nodeprefix,nodedata, nodedatanumerical, nodedatadate FROM " + table + " WHERE rootnodeid = ?");
            pstmt.setLong(1, rootnodeid);
            logMetacat.debug((Object)("DocumentImpl.getNodeRecordList - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            while (tableHasRows) {
                nodeid = rs.getLong(1);
                parentnodeid = rs.getLong(2);
                nodeindex = rs.getLong(3);
                nodetype = rs.getString(4);
                nodename = rs.getString(5);
                nodeprefix = rs.getString(6);
                nodedata = rs.getString(7);
                try {
                    logMetacat.debug((Object)("DocumentImpl.getNodeRecordList - Node data in read process before normalize=== " + nodedata));
                    nodedata = MetacatUtil.normalize(nodedata);
                    logMetacat.debug((Object)("DocumentImpl.getNodeRecordList - Node data in read process after normalize==== " + nodedata));
                }
                catch (StringIndexOutOfBoundsException SIO) {
                    logMetacat.warn((Object)"DocumentImpl.getNodeRecordList - StringIndexOutOfBoundsException in normalize() while reading the document");
                }
                nodedatanumerical = rs.getFloat(8);
                nodedatadate = rs.getTimestamp(9);
                NodeRecord currentRecord = new NodeRecord(nodeid, parentnodeid, nodeindex, nodetype, nodename, nodeprefix, nodedata, nodedatanumerical, nodedatadate);
                nodeRecordList.add(currentRecord);
                tableHasRows = rs.next();
            }
            pstmt.close();
            return nodeRecordList;
        }
        catch (SQLException e) {
            throw new McdbException("Error in DocumentImpl.getNodeRecordList " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("DocumentImpl.getNodeRecordList - General error: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbconn, serialNumber);
            }
        }
    }

    private void writeDocumentToDB(String action, String user, String pub, String catalogid, int serverCode, Date createDate, Date updateDate) throws SQLException, Exception {
        String sysdate = DatabaseService.getInstance().getDBAdapter().getDateTimeFunction();
        Date today = Calendar.getInstance().getTime();
        if (createDate == null) {
            createDate = today;
        }
        if (updateDate == null) {
            updateDate = today;
        }
        DocumentImpl thisdoc = null;
        try {
            PreparedStatement pstmt = null;
            if (action.equals("INSERT")) {
                String sql = null;
                sql = catalogid != null ? "INSERT INTO xml_documents (docid, rootnodeid, docname, doctype, user_owner, user_updated, date_created, date_updated, public_access, server_location, rev, catalog_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" : "INSERT INTO xml_documents (docid, rootnodeid, docname, doctype, user_owner, user_updated, date_created, date_updated, public_access, server_location, rev) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                pstmt = this.connection.prepareStatement(sql);
                this.connection.increaseUsageCount(1);
                pstmt.setString(1, this.docid);
                pstmt.setLong(2, this.rootnodeid);
                pstmt.setString(3, this.docname);
                pstmt.setString(4, this.doctype);
                pstmt.setString(5, user);
                pstmt.setString(6, user);
                pstmt.setTimestamp(7, new Timestamp(createDate.getTime()));
                pstmt.setTimestamp(8, new Timestamp(updateDate.getTime()));
                pstmt.setInt(9, 0);
                pstmt.setInt(10, serverCode);
                pstmt.setInt(11, this.rev);
                if (catalogid != null) {
                    pstmt.setInt(12, new Integer(catalogid));
                }
            } else if (action.equals("UPDATE")) {
                int thisrev = DBUtil.getLatestRevisionInDocumentTable(this.docid);
                logMetacat.debug((Object)("DocumentImpl.writeDocumentToDB - this revision is: " + thisrev));
                String accNumber = this.docid + PropertyService.getProperty("document.accNumSeparator") + thisrev;
                thisdoc = new DocumentImpl(accNumber, false);
                DocumentImpl.archiveDocAndNodesRevision(this.connection, this.docid, user, thisdoc);
                if (this.rev <= thisrev) {
                    throw new Exception("Next revision number couldn't be less than or equal " + thisrev);
                }
                thisrev = this.rev;
                logMetacat.debug((Object)("DocumentImpl.writeDocumentToDB - final revision is: " + thisrev));
                boolean useXMLIndex = new Boolean(PropertyService.getProperty("database.usexmlindex"));
                if (useXMLIndex) {
                    DocumentImpl.removeDocidFromIndexingQueue(this.docid, String.valueOf(this.rev));
                    double start = System.currentTimeMillis() / 1000L;
                    pstmt = this.connection.prepareStatement("DELETE FROM xml_index WHERE docid='" + this.docid + "'");
                    this.connection.increaseUsageCount(1);
                    logMetacat.debug((Object)("DocumentImpl.writeDocumentToDB - executing SQL: " + pstmt.toString()));
                    pstmt.execute();
                    pstmt.close();
                    double end = System.currentTimeMillis() / 1000L;
                    logMetacat.info((Object)("DocumentImpl.writeDocumentToDB - Time for delete xml_index in UPDATE is " + (end - start)));
                }
                String updateSql = null;
                updateSql = catalogid != null ? "UPDATE xml_documents SET rootnodeid = ?, docname = ?, doctype = ?, user_updated = ?, date_updated = ?, server_location = ?, rev = ?, public_access = ?, catalog_id = ? WHERE docid = ?" : "UPDATE xml_documents SET rootnodeid = ?, docname = ?, doctype = ?, user_updated = ?, date_updated = ?, server_location = ?, rev = ?, public_access = ? WHERE docid = ?";
                pstmt = this.connection.prepareStatement(updateSql);
                this.connection.increaseUsageCount(1);
                pstmt.setLong(1, this.rootnodeid);
                pstmt.setString(2, this.docname);
                pstmt.setString(3, this.doctype);
                pstmt.setString(4, user);
                pstmt.setTimestamp(5, new Timestamp(updateDate.getTime()));
                pstmt.setInt(6, serverCode);
                pstmt.setInt(7, thisrev);
                pstmt.setInt(8, 0);
                if (catalogid != null) {
                    pstmt.setInt(9, new Integer(catalogid));
                    pstmt.setString(10, this.docid);
                } else {
                    pstmt.setString(9, this.docid);
                }
            } else {
                logMetacat.error((Object)("DocumentImpl.writeDocumentToDB - Action not supported: " + action));
            }
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToDB - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            pstmt.close();
            if (action.equals("UPDATE")) {
                logMetacat.debug((Object)("DocumentImpl.writeDocumentToDB - Deleting xml nodes for docid: " + thisdoc.getDocID() + " using root node ID: " + thisdoc.getRootNodeID()));
                DocumentImpl.deleteXMLNodes(this.connection, thisdoc.getRootNodeID());
            }
        }
        catch (SQLException sqle) {
            logMetacat.error((Object)("DocumentImpl.writeDocumentToDB - SQL error: " + sqle.getMessage()));
            sqle.printStackTrace();
            throw sqle;
        }
        catch (Exception e) {
            logMetacat.error((Object)("DocumentImpl.writeDocumentToDB - General error: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    public static String write(DBConnection conn, String xmlString, String pub, Reader dtd, String action, String docid, String user, String[] groups, String ruleBase, boolean needValidation, boolean writeAccessRules, byte[] xmlBytes, String formatId) throws Exception {
        int serverLocation = DocumentImpl.getServerLocationNumber(docid);
        return DocumentImpl.write(conn, xmlString, pub, dtd, action, docid, user, groups, serverLocation, false, ruleBase, needValidation, writeAccessRules, xmlBytes, formatId);
    }

    public static String write(DBConnection conn, String xmlString, String pub, Reader dtd, String action, String accnum, String user, String[] groups, int serverCode, boolean override, String ruleBase, boolean needValidation, boolean writeAccessRules, byte[] xmlBytes, String formatId) throws Exception {
        String latestDocId;
        int latestRev;
        String docIdWithoutRev;
        StringReader xmlReader = new StringReader(xmlString);
        XmlStreamReader xsr = null;
        xsr = xmlBytes == null || xmlBytes.length == 0 ? new XmlStreamReader((InputStream)new ByteArrayInputStream(xmlString.getBytes())) : new XmlStreamReader((InputStream)new ByteArrayInputStream(xmlBytes));
        String encoding = xsr.getEncoding();
        if (xmlBytes == null || xmlBytes.length == 0) {
            xmlBytes = xmlString.getBytes(encoding);
        }
        logMetacat.debug((Object)("DocumentImpl.write - conn usage count before writing: " + conn.getUsageCount()));
        AccessionNumber ac = new AccessionNumber(accnum, action);
        String docid = ac.getDocid();
        String rev = ac.getRev();
        logMetacat.debug((Object)("DocumentImpl.write - action: " + action + " servercode: " + serverCode + " override: " + override));
        if (serverCode != 1 && action.equals("UPDATE") && !override) {
            docIdWithoutRev = DocumentUtil.getSmartDocId(accnum);
            latestRev = DBUtil.getLatestRevisionInDocumentTable(docIdWithoutRev);
            latestDocId = docIdWithoutRev + PropertyService.getProperty("document.accNumSeparator") + latestRev;
            if (!DocumentImpl.hasWritePermission(user, groups, latestDocId)) {
                throw new Exception("User " + user + " does not have permission to update XML Document #" + accnum);
            }
            int revision = DocumentUtil.getRevisionFromAccessionNumber(accnum);
            String updaterev = new Integer(revision).toString();
            String server = ReplicationService.getServerNameForServerCode(serverCode);
            logReplication.info((Object)("attempting to lock " + accnum));
            URL u = new URL("https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=getlock&updaterev=" + updaterev + "&docid=" + docid);
            String openingtag = null;
            try {
                String serverResStr = ReplicationService.getURLContent(u);
                openingtag = serverResStr.substring(0, serverResStr.indexOf(">") + 1);
            }
            catch (IOException e) {
                String msg = "Error during replication lock request on server=" + server;
                logReplication.error((Object)msg);
                throw new Exception(msg, e);
            }
            if (openingtag.equals("<lockgranted>")) {
                XMLReader parser = null;
                try {
                    logReplication.info((Object)("lock granted for " + accnum + " from " + server));
                    Vector<String> guidsToSync = new Vector<String>();
                    logMetacat.debug((Object)"DocumentImpl.write - initializing parser");
                    parser = DocumentImpl.initializeParser(conn, action, docid, xmlReader, updaterev, user, groups, pub, serverCode, dtd, ruleBase, needValidation, false, null, null, encoding, writeAccessRules, guidsToSync, formatId);
                    conn.setAutoCommit(false);
                    logMetacat.debug((Object)"DocumentImpl.write - parsing xml");
                    parser.parse(new InputSource(xmlReader));
                    conn.commit();
                    conn.setAutoCommit(true);
                    DocumentImpl.updateNodeValues(conn, docid);
                    logMetacat.debug((Object)"DocumentImpl.write - Writing xml to file system");
                    DocumentImpl.writeToFileSystem(xmlBytes, accnum);
                    DocumentImpl.addDocidToIndexingQueue(docid, rev);
                    if (guidsToSync.size() > 0) {
                        try {
                            SyncAccessPolicy syncAP = new SyncAccessPolicy();
                            syncAP.sync(guidsToSync);
                        }
                        catch (Exception e) {
                            logMetacat.error((Object)("Error syncing pids with CN:  Exception " + e.getMessage()));
                            e.printStackTrace(System.out);
                        }
                    }
                }
                catch (Exception e) {
                    ContentHandler handler;
                    e.printStackTrace();
                    logMetacat.error((Object)("DocumentImpl.write - Problem with parsing: " + e.getMessage()));
                    conn.rollback();
                    conn.setAutoCommit(true);
                    if (parser != null && (handler = parser.getContentHandler()) instanceof Eml200SAXHandler) {
                        Eml200SAXHandler eml = (Eml200SAXHandler)handler;
                        eml.deleteInlineFiles();
                    }
                    throw e;
                }
                DocumentImpl.runRelationAndAccessHandler(accnum, user, groups, serverCode);
                ForceReplicationHandler frh = new ForceReplicationHandler(accnum, true, null);
                logMetacat.debug((Object)("DocumentImpl.write - ForceReplicationHandler created: " + frh.toString()));
                return accnum;
            }
            if (openingtag.equals("<filelocked>")) {
                logReplication.error((Object)("DocumentImpl.write - lock denied for " + accnum + " on " + server + " reason: file already locked"));
                throw new Exception("The file specified is already locked by another user.  Please wait 30 seconds, checkout the newer document, merge your changes and try again.");
            }
            if (openingtag.equals("<outdatedfile>")) {
                logReplication.info((Object)("DocumentImpl.write - lock denied for " + accnum + " on " + server + " reason: local file outdated"));
                throw new Exception("The file you are trying to update is an outdated version.  Please checkout the newest document, merge your changes and try again.");
            }
        }
        if (action.equals("UPDATE")) {
            docIdWithoutRev = DocumentUtil.getSmartDocId(accnum);
            latestRev = DBUtil.getLatestRevisionInDocumentTable(docIdWithoutRev);
            latestDocId = docIdWithoutRev + PropertyService.getProperty("document.accNumSeparator") + latestRev;
            if (!DocumentImpl.hasWritePermission(user, groups, latestDocId) && !AuthUtil.isAdministrator(user, groups)) {
                throw new Exception("User " + user + " does not have permission to update XML Document #" + latestDocId);
            }
        }
        XMLReader parser = null;
        try {
            Vector<String> guidsToSync = new Vector<String>();
            parser = DocumentImpl.initializeParser(conn, action, docid, xmlReader, rev, user, groups, pub, serverCode, dtd, ruleBase, needValidation, false, null, null, encoding, writeAccessRules, guidsToSync, formatId);
            conn.setAutoCommit(false);
            logMetacat.debug((Object)("DocumentImpl.write - XML to be parsed: " + xmlString));
            parser.parse(new InputSource(xmlReader));
            conn.commit();
            conn.setAutoCommit(true);
            DocumentImpl.updateNodeValues(conn, docid);
            DocumentImpl.writeToFileSystem(xmlBytes, accnum);
            DocumentImpl.addDocidToIndexingQueue(docid, rev);
            if (guidsToSync.size() > 0) {
                try {
                    SyncAccessPolicy syncAP = new SyncAccessPolicy();
                    syncAP.sync(guidsToSync);
                }
                catch (Exception e) {
                    logMetacat.error((Object)("Error syncing pids with CN:  Exception " + e.getMessage()));
                    e.printStackTrace(System.out);
                }
            }
        }
        catch (Exception e) {
            ContentHandler handler;
            logMetacat.error((Object)("DocumentImpl.write - Problem with parsing: " + e.getMessage()));
            e.printStackTrace();
            conn.rollback();
            conn.setAutoCommit(true);
            if (parser != null && (handler = parser.getContentHandler()) instanceof Eml200SAXHandler) {
                Eml200SAXHandler eml = (Eml200SAXHandler)handler;
                eml.deleteInlineFiles();
            }
            throw e;
        }
        DocumentImpl.runRelationAndAccessHandler(accnum, user, groups, serverCode);
        if (action.equals("UPDATE")) {
            try {
                try {
                    XMLQueryresultAccess xmlQueryresultAccess = new XMLQueryresultAccess();
                    xmlQueryresultAccess.deleteXMLQueryresulForDoc(docid);
                }
                catch (AccessException ae) {
                    throw new SQLException("Problem deleting xml query result for docid " + docid + " : " + ae.getMessage());
                }
            }
            catch (Exception e) {
                logMetacat.error((Object)("DocumentImpl.write - Error in deleting enteries from xml_queryresult where docid is " + docid + " in DBQuery.write: " + e.getMessage()));
            }
        }
        ForceReplicationHandler frh = new ForceReplicationHandler(accnum, action, true, null);
        logMetacat.debug((Object)("DocumentImpl.write - ForceReplicationHandler created: " + frh.toString()));
        if (PropertyService.getProperty("database.queryCacheOn").equals("true")) {
            DBQuery.clearQueryResultCache();
        }
        logMetacat.info((Object)("DocumentImpl.write - Conn Usage count after writing: " + conn.getUsageCount()));
        return accnum;
    }

    private static void addDocidToIndexingQueue(String docid, String rev) throws PropertyNotFoundException {
        boolean useXMLIndex = new Boolean(PropertyService.getProperty("database.usexmlindex"));
        if (useXMLIndex) {
            IndexingQueue.getInstance().add(docid, rev);
        }
    }

    private static void removeDocidFromIndexingQueue(String docid, String rev) throws PropertyNotFoundException {
        boolean useXMLIndex = new Boolean(PropertyService.getProperty("database.usexmlindex"));
        if (useXMLIndex) {
            IndexingQueue.getInstance().remove(docid, rev);
        }
    }

    public static String writeReplication(DBConnection conn, String xmlString, byte[] xmlBytes, String pub, Reader dtd, String action, String accnum, String user, String[] groups, String homeServer, String notifyServer, String ruleBase, boolean needValidation, String tableName, boolean timedReplication, Date createDate, Date updateDate, String formatId) throws Exception {
        long rootId;
        StringReader xmlReader = new StringReader(xmlString);
        String docType = null;
        String docName = null;
        String catalogId = null;
        logMetacat.debug((Object)("DocumentImpl.writeReplication - user in replication" + user));
        String docid = DocumentUtil.getDocIdFromAccessionNumber(accnum);
        logMetacat.debug((Object)("DocumentImpl.writeReplication - The docid without rev is " + docid));
        int userSpecifyRev = DocumentUtil.getRevisionFromAccessionNumber(accnum);
        logMetacat.debug((Object)("DocumentImpl.writeReplication - The user specifyRev: " + userSpecifyRev));
        int revInDataBase = DBUtil.getLatestRevisionInDocumentTable(docid);
        logMetacat.debug((Object)("DocumentImpl.writeReplication - The rev in data base: " + revInDataBase));
        String rev = new Integer(userSpecifyRev).toString();
        if (tableName.equals(DOCUMENTTABLE)) {
            action = DocumentImpl.checkRevInXMLDocuments(docid, userSpecifyRev);
        } else if (tableName.equals(REVISIONTABLE)) {
            action = DocumentImpl.checkXMLRevisionTable(docid, userSpecifyRev);
        } else {
            throw new Exception("The table name is not support " + tableName);
        }
        int serverCode = -2;
        DocumentImpl.insertServerIntoReplicationTable(homeServer);
        serverCode = DocumentImpl.getServerCode(homeServer);
        logMetacat.info((Object)("DocumentImpl.writeReplication - Document " + docid + "." + rev + " " + action + " into local" + " metacat with servercode: " + serverCode));
        XMLReader parser = null;
        boolean isRevision = false;
        try {
            if (tableName.equals(REVISIONTABLE)) {
                isRevision = true;
            }
            XmlStreamReader xsr = new XmlStreamReader((InputStream)new ByteArrayInputStream(xmlBytes));
            String encoding = xsr.getEncoding();
            boolean writeAccessRules = false;
            Vector<String> guidsToSync = new Vector<String>();
            parser = DocumentImpl.initializeParser(conn, action, docid, xmlReader, rev, user, groups, pub, serverCode, dtd, ruleBase, needValidation, isRevision, createDate, updateDate, encoding, writeAccessRules, guidsToSync, formatId);
            conn.setAutoCommit(false);
            parser.parse(new InputSource(xmlReader));
            conn.commit();
            conn.setAutoCommit(true);
            DocumentImpl.writeToFileSystem(xmlBytes, accnum);
            if (!isRevision) {
                DocumentImpl.addDocidToIndexingQueue(docid, rev);
            }
            DBSAXHandler dbx = (DBSAXHandler)parser.getContentHandler();
            rootId = dbx.getRootNodeId();
            docType = dbx.getDocumentType();
            docName = dbx.getDocumentName();
            catalogId = dbx.getCatalogId();
        }
        catch (Exception e) {
            ContentHandler handler;
            logMetacat.error((Object)("DocumentImpl.writeReplication - Problem with parsing: " + e.getMessage()));
            conn.rollback();
            conn.setAutoCommit(true);
            if (parser != null && (handler = parser.getContentHandler()) instanceof Eml200SAXHandler) {
                Eml200SAXHandler eml = (Eml200SAXHandler)handler;
                eml.deleteInlineFiles();
            }
            throw e;
        }
        try {
            conn.setAutoCommit(false);
            if (!isRevision) {
                DocumentImpl.runRelationAndAccessHandler(accnum, user, groups, serverCode);
            } else {
                DocumentImpl.moveNodesToNodesRevision(conn, rootId);
                DocumentImpl.deleteXMLNodes(conn, rootId);
                DocumentImpl.writeDocumentToRevisionTable(conn, docid, rev, docType, docName, user, catalogId, serverCode, rootId, createDate, updateDate);
            }
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception ee) {
            conn.rollback();
            conn.setAutoCommit(true);
            if (tableName.equals(REVISIONTABLE)) {
                DocumentImpl.deleteXMLNodes(conn, rootId);
            }
            logReplication.error((Object)("DocumentImpl.writeReplication - Failed to create access rule for package: " + accnum + " because " + ee.getMessage()));
            logMetacat.error((Object)("DocumentImpl.writeReplication - Failed to  create access rule for package: " + accnum + " because " + ee.getMessage()));
        }
        if (!timedReplication) {
            ForceReplicationHandler forceReplication = new ForceReplicationHandler(accnum, action, true, notifyServer);
            logMetacat.debug((Object)("DocumentImpl.writeReplication - ForceReplicationHandler created: " + forceReplication.toString()));
        }
        if (PropertyService.getProperty("database.queryCacheOn").equals("true")) {
            DBQuery.clearQueryResultCache();
        }
        return accnum;
    }

    private static void runRelationAndAccessHandler(String accnumber, String userName, String[] group, int servercode) throws Exception {
        DBConnection dbconn = null;
        int serialNumber = -1;
        String documenttype = DocumentImpl.getDocTypeFromDBForCurrentDocument(accnumber);
        try {
            String packagedoctype = PropertyService.getProperty("xml.packagedoctype");
            Vector<Object> packagedoctypes = new Vector();
            packagedoctypes = MetacatUtil.getOptionList(packagedoctype);
            String docIdWithoutRev = DocumentUtil.getDocIdFromAccessionNumber(accnumber);
            int revision = DocumentUtil.getRevisionFromAccessionNumber(accnumber);
            if (documenttype != null && packagedoctypes.contains(documenttype)) {
                dbconn = DBConnectionPool.getDBConnection("DocumentImpl.runRelationAndAccessHandeler");
                serialNumber = dbconn.getCheckOutSerialNumber();
                dbconn.setAutoCommit(false);
                String aclidWithRev = RelationHandler.getAccessFileIDWithRevision(docIdWithoutRev);
                if (aclidWithRev != null) {
                    String aclid = DocumentUtil.getDocIdFromAccessionNumber(aclidWithRev);
                    revision = DocumentUtil.getRevisionFromAccessionNumber(aclidWithRev);
                    if (aclid != null) {
                        DocumentImpl.runAccessControlList(dbconn, aclid, revision, userName, group, servercode);
                    }
                }
                dbconn.commit();
                dbconn.setAutoCommit(true);
            } else if (documenttype != null && MetacatUtil.getOptionList(PropertyService.getProperty("xml.accessdoctype")).contains(documenttype)) {
                dbconn = DBConnectionPool.getDBConnection("DocumentImpl.runRelationAndAccessHandeler");
                serialNumber = dbconn.getCheckOutSerialNumber();
                dbconn.setAutoCommit(false);
                DocumentImpl.runAccessControlList(dbconn, docIdWithoutRev, revision, userName, group, servercode);
                dbconn.commit();
                dbconn.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            if (dbconn != null) {
                dbconn.rollback();
                dbconn.setAutoCommit(true);
            }
            logMetacat.error((Object)("DocumentImpl.runRelationAndAccessHandler - Error in DocumentImple.runRelationAndAccessHandler " + e.getMessage()));
            throw e;
        }
        finally {
            if (dbconn != null) {
                DBConnectionPool.returnDBConnection(dbconn, serialNumber);
            }
        }
    }

    private static void runAccessControlList(DBConnection conn, String aclid, int rev, String users, String[] group, int servercode) throws Exception {
        AccessControlList aclobj = new AccessControlList(conn, aclid, rev, users, group, servercode);
    }

    private static String getDocTypeFromDBForCurrentDocument(String accnumber) throws SQLException {
        String documentType = null;
        String docid = null;
        Statement pstate = null;
        ResultSet rs = null;
        String sql = "SELECT doctype FROM xml_documents where docid = ?";
        DBConnection dbConnection = null;
        int serialNumber = -1;
        try {
            docid = DocumentUtil.getDocIdFromString(accnumber);
            dbConnection = DBConnectionPool.getDBConnection("DocumentImpl.getDocTypeFromDBForCurrentDoc");
            serialNumber = dbConnection.getCheckOutSerialNumber();
            pstate = dbConnection.prepareStatement(sql);
            pstate.setString(1, docid);
            logMetacat.debug((Object)("DocumentImpl.getDocTypeFromDBForCurrentDocument - executing SQL: " + pstate.toString()));
            pstate.execute();
            rs = pstate.getResultSet();
            if (rs.next()) {
                documentType = rs.getString(1);
            }
            rs.close();
            pstate.close();
        }
        catch (SQLException e) {
            logMetacat.error((Object)("DocumentImpl.getDocTypeFromDBForCurrentDocument - SQL error: " + e.getMessage()));
            throw e;
        }
        finally {
            pstate.close();
            DBConnectionPool.returnDBConnection(dbConnection, serialNumber);
        }
        logMetacat.debug((Object)("DocumentImpl.getDocTypeFromDBForCurrentDocument - The current doctype from db is: " + documentType));
        return documentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String accnum, String user, String[] groups, String notifyServer, boolean removeAll) throws SQLException, InsufficientKarmaException, McdbDocNotFoundException, Exception {
        DBConnection conn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        boolean isXML = true;
        boolean inRevisionTable = false;
        try {
            SystemMetadata sysMeta;
            ResultSet rs;
            conn = DBConnectionPool.getDBConnection("DocumentImpl.delete");
            serialNumber = conn.getCheckOutSerialNumber();
            String docid = DocumentUtil.getDocIdFromAccessionNumber(accnum);
            int rev = DocumentUtil.getRevisionFromAccessionNumber(accnum);
            if (!removeAll) {
                logMetacat.info((Object)("DocumentImp.delete - archive the document " + accnum));
                pstmt = conn.prepareStatement("SELECT rev, docid FROM xml_documents WHERE docid = ?");
                pstmt.setString(1, docid);
                logMetacat.debug((Object)("DocumentImpl.delete - executing SQL: " + pstmt.toString()));
                pstmt.execute();
                rs = pstmt.getResultSet();
                if (!rs.next()) {
                    rs.close();
                    pstmt.close();
                    conn.increaseUsageCount(1);
                    throw new McdbDocNotFoundException("Docid " + accnum + " does not exist. Please check that you have also " + "specified the revision number of the document.");
                }
                int revFromTable = rs.getInt(1);
                if (revFromTable > rev) {
                    logMetacat.info((Object)("DocumentImpl.delete - in the archive the user specified rev - " + rev + "is less than the version in xml_document table - " + revFromTable + ". We will use the one from table."));
                    rev = revFromTable;
                }
                rs.close();
                pstmt.close();
                conn.increaseUsageCount(1);
            } else {
                logMetacat.info((Object)("DocumentImp.delete - complete delete the document " + accnum));
                pstmt = conn.prepareStatement("SELECT * FROM xml_documents WHERE docid = ? and rev = ?");
                pstmt.setString(1, docid);
                pstmt.setInt(2, rev);
                logMetacat.debug((Object)("DocumentImpl.delete - executing SQL: " + pstmt.toString()));
                pstmt.execute();
                rs = pstmt.getResultSet();
                if (!rs.next()) {
                    logMetacat.debug((Object)("DocumentImpl.delete - look at the docid " + accnum + " in the xml_revision table"));
                    pstmt = conn.prepareStatement("SELECT * FROM xml_revisions WHERE docid = ? AND rev = ?");
                    pstmt.setString(1, docid);
                    pstmt.setInt(2, rev);
                    logMetacat.debug((Object)("DocumentImpl.delete - executing SQL: " + pstmt.toString()));
                    pstmt.execute();
                    rs = pstmt.getResultSet();
                    if (!rs.next()) {
                        rs.close();
                        pstmt.close();
                        conn.increaseUsageCount(1);
                        throw new McdbDocNotFoundException("Docid " + accnum + " does not exist. Please check and try to delete it again.");
                    }
                    rs.close();
                    pstmt.close();
                    conn.increaseUsageCount(1);
                    inRevisionTable = true;
                } else {
                    rs.close();
                    pstmt.close();
                    conn.increaseUsageCount(1);
                }
            }
            String type = null;
            type = !inRevisionTable ? DocumentImpl.getDocTypeFromDB(conn, DOCUMENTTABLE, docid) : DocumentImpl.getDocTypeFromDB(conn, REVISIONTABLE, docid);
            logMetacat.info((Object)("DocumentImpl.delete - the deleting doc type is " + type + "..."));
            if (type != null && type.trim().equals("BIN")) {
                isXML = false;
            }
            logMetacat.info((Object)("DocumentImpl.delete - Start deleting doc " + docid + "..."));
            double start = System.currentTimeMillis() / 1000L;
            if (!DocumentImpl.hasAllPermission(user, groups, accnum) && !AuthUtil.isAdministrator(user, groups)) {
                throw new InsufficientKarmaException("User " + user + " does not have permission to delete XML Document #" + accnum);
            }
            conn.setAutoCommit(false);
            DocumentImpl.removeDocidFromIndexingQueue(docid, String.valueOf(rev));
            if (!inRevisionTable) {
                if (!removeAll) {
                    DocumentImpl.archiveDocAndNodesRevision(conn, docid, user, null);
                    logMetacat.info((Object)"DocumentImpl.delete - calling archiveDocAndNodesRevision");
                }
                double afterArchiveDocAndNode = System.currentTimeMillis() / 1000L;
                logMetacat.info((Object)("DocumentImpl.delete - The time for archiveDocAndNodesRevision is " + (afterArchiveDocAndNode - start)));
                pstmt = conn.prepareStatement("DELETE FROM xml_index WHERE docid = ?");
                pstmt.setString(1, docid);
                logMetacat.debug((Object)("DocumentImpl.delete - executing SQL: " + pstmt.toString()));
                pstmt.execute();
                pstmt.close();
                conn.increaseUsageCount(1);
                double afterDeleteIndex = System.currentTimeMillis() / 1000L;
                logMetacat.info((Object)("DocumentImpl.delete - The deleting xml_index time is " + (afterDeleteIndex - afterArchiveDocAndNode)));
                double afterDeleteXmlAccess2 = System.currentTimeMillis() / 1000L;
                try {
                    XMLQueryresultAccess xmlQueryresultAccess = new XMLQueryresultAccess();
                    xmlQueryresultAccess.deleteXMLQueryresulForDoc(docid);
                }
                catch (AccessException ae) {
                    throw new SQLException("Problem deleting xml query result for docid " + docid + " : " + ae.getMessage());
                }
                double afterDeleteQueryResult = System.currentTimeMillis() / 1000L;
                logMetacat.info((Object)("DocumentImpl.delete - The deleting xml_queryresult time is " + (afterDeleteQueryResult - afterDeleteXmlAccess2)));
                pstmt = conn.prepareStatement("DELETE FROM xml_relation WHERE docid = ?");
                pstmt.setString(1, docid);
                logMetacat.debug((Object)("DocumentImpl.delete - running sql: " + pstmt.toString()));
                pstmt.execute();
                pstmt.close();
                conn.increaseUsageCount(1);
                double afterXMLRelation = System.currentTimeMillis() / 1000L;
                logMetacat.info((Object)("DocumentImpl.delete - The deleting time  relation is " + (afterXMLRelation - afterDeleteQueryResult)));
                logMetacat.info((Object)"DocumentImpl.delete - deleting from xml_path_index");
                pstmt = conn.prepareStatement("DELETE FROM xml_path_index WHERE docid = ?");
                pstmt.setString(1, docid);
                logMetacat.debug((Object)("DocumentImpl.delete - running sql: " + pstmt.toString()));
                pstmt.execute();
                pstmt.close();
                conn.increaseUsageCount(1);
                logMetacat.info((Object)"DocumentImpl.delete - deleting from xml_accesssubtree");
                pstmt = conn.prepareStatement("DELETE FROM xml_accesssubtree WHERE docid = ?");
                pstmt.setString(1, docid);
                logMetacat.debug((Object)("DocumentImpl.delete - running sql: " + pstmt.toString()));
                pstmt.execute();
                pstmt.close();
                conn.increaseUsageCount(1);
                logMetacat.info((Object)"DocumentImpl.delete - deleting from xml_documents");
                pstmt = conn.prepareStatement("DELETE FROM xml_documents WHERE docid = ?");
                pstmt.setString(1, docid);
                logMetacat.debug((Object)("DocumentImpl.delete - running sql: " + pstmt.toString()));
                pstmt.execute();
                pstmt.close();
                conn.increaseUsageCount(1);
                double afterDeleteDoc = System.currentTimeMillis() / 1000L;
                logMetacat.info((Object)("DocumentImpl.delete - the time to delete  xml_path_index,  xml_accesssubtree, xml_documents time is " + (afterDeleteDoc - afterXMLRelation)));
                pstmt = conn.prepareStatement("DELETE FROM xml_nodes WHERE docid = ?");
                conn.increaseUsageCount(1);
                pstmt.setString(1, docid);
                logMetacat.debug((Object)("DocumentImpl.delete - running sql: " + pstmt.toString()));
                pstmt.execute();
                pstmt.close();
                double afterDeleteXMLNodes = System.currentTimeMillis() / 1000L;
                logMetacat.info((Object)("DocumentImpl.delete - Deleting xml_nodes time is " + (afterDeleteXMLNodes - afterDeleteDoc)));
            } else {
                long rootnodeid = DocumentImpl.getRevisionRootNodeId(conn, docid, rev);
                logMetacat.info((Object)"DocumentImpl.delete - deleting from xml_revisions");
                pstmt = conn.prepareStatement("DELETE FROM xml_revisions WHERE docid = ? AND rev = ?");
                pstmt.setString(1, docid);
                pstmt.setInt(2, rev);
                logMetacat.debug((Object)("DocumentImpl.delete - running sql: " + pstmt.toString()));
                pstmt.execute();
                pstmt.close();
                conn.increaseUsageCount(1);
                logMetacat.info((Object)"DocumentImpl.delete - deleting from xml_nodes_revisions");
                pstmt = conn.prepareStatement("DELETE FROM xml_nodes_revisions WHERE rootnodeid = ?");
                pstmt.setLong(1, rootnodeid);
                logMetacat.debug((Object)("DocumentImpl.delete - running sql: " + pstmt.toString()));
                pstmt.execute();
                pstmt.close();
                conn.increaseUsageCount(1);
            }
            String pid = IdentifierManager.getInstance().getGUID(docid, rev);
            Identifier guid = new Identifier();
            guid.setValue(pid);
            if (removeAll) {
                logMetacat.info((Object)"DocumentImpl.delete - deleting from xml_access");
                pstmt = conn.prepareStatement("DELETE FROM xml_access WHERE guid = ?");
                pstmt.setString(1, guid.getValue());
                logMetacat.debug((Object)("DocumentImpl.delete - running sql: " + pstmt.toString()));
                pstmt.execute();
                pstmt.close();
                conn.increaseUsageCount(1);
            }
            if (PropertyService.getProperty("database.queryCacheOn").equals("true")) {
                DBQuery.clearQueryResultCache();
            }
            if ((sysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)guid)) != null) {
                sysMeta.setSerialVersion(sysMeta.getSerialVersion().add(BigInteger.ONE));
                sysMeta.setArchived(Boolean.valueOf(true));
                sysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
                if (!removeAll) {
                    HazelcastService.getInstance().getSystemMetadataMap().put((Object)guid, (Object)sysMeta);
                    MetacatSolrIndex.getInstance().submit(guid, sysMeta, null, false);
                } else {
                    try {
                        logMetacat.debug((Object)("the system metadata contains the key - guid " + guid.getValue() + " before removing is " + HazelcastService.getInstance().getSystemMetadataMap().containsKey((Object)guid)));
                        HazelcastService.getInstance().getSystemMetadataMap().remove((Object)guid);
                        logMetacat.debug((Object)("the system metadata contains the guid " + guid.getValue() + " after removing is " + HazelcastService.getInstance().getSystemMetadataMap().containsKey((Object)guid)));
                        MetacatSolrIndex.getInstance().submit(guid, sysMeta, null, false);
                    }
                    catch (RuntimeException ee) {
                        logMetacat.warn((Object)("we catch the run time exception in deleting system metadata " + ee.getMessage()));
                        throw new Exception("DocumentImpl.delete -" + ee.getMessage());
                    }
                }
            }
            conn.commit();
            conn.setAutoCommit(true);
            if (removeAll) {
                logMetacat.debug((Object)("the identifier set contains " + guid.getValue() + " is " + HazelcastService.getInstance().getIdentifiers().contains((Object)guid)));
                HazelcastService.getInstance().getIdentifiers().remove((Object)guid);
                logMetacat.debug((Object)("the identifier set contains " + guid.getValue() + " after removing is " + HazelcastService.getInstance().getIdentifiers().contains((Object)guid)));
                DocumentImpl.deleteFromFileSystem(accnum, isXML);
            }
            String deleteAction = "forcereplicatedelete";
            if (removeAll) {
                deleteAction = "forcereplicatedeleteall";
            }
            ForceReplicationHandler frh = new ForceReplicationHandler(accnum, deleteAction, isXML, notifyServer);
            logMetacat.debug((Object)("DocumentImpl.delete - ForceReplicationHandler created: " + frh.toString()));
            double end = System.currentTimeMillis() / 1000L;
            logMetacat.info((Object)("DocumentImpl.delete - total delete time is:  " + (end - start)));
        }
        catch (Exception e) {
            conn.rollback();
            logMetacat.error((Object)("DocumentImpl.delete -  Error: " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
    }

    private static String getDocTypeFromDB(DBConnection conn, String tableName, String docidWithoutRev) throws SQLException {
        String type = null;
        String sql = "SELECT DOCTYPE FROM " + tableName + " WHERE docid LIKE ?";
        PreparedStatement stmt = null;
        stmt = conn.prepareStatement(sql);
        stmt.setString(1, docidWithoutRev);
        ResultSet result = stmt.executeQuery();
        boolean hasResult = result.next();
        if (hasResult) {
            type = result.getString(1);
        }
        logMetacat.debug((Object)("DocumentImpl.delete - The type of deleting docid " + docidWithoutRev + " is " + type));
        return type;
    }

    public static boolean hasWritePermission(String user, String[] groups, String docid) throws SQLException, Exception {
        PermissionController controller = new PermissionController(docid);
        return controller.hasPermission(user, groups, "WRITE");
    }

    public static boolean hasReadPermission(String user, String[] groups, String docId) throws SQLException, McdbException {
        PermissionController controller = new PermissionController(docId);
        return controller.hasPermission(user, groups, "READ");
    }

    public static boolean hasAllPermission(String user, String[] groups, String docid) throws SQLException, Exception {
        PermissionController controller = new PermissionController(docid);
        boolean hasAll = controller.hasPermission(user, groups, "ALL");
        boolean hasChmod = controller.hasPermission(user, groups, "CHANGEPERMISSION");
        return hasAll || hasChmod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static XMLReader initializeParser(DBConnection dbconn, String action, String docid, Reader xml, String rev, String user, String[] groups, String pub, int serverCode, Reader dtd, String ruleBase, boolean needValidation, boolean isRevision, Date createDate, Date updateDate, String encoding, boolean writeAccessRules, Vector<String> guidsToSync, String formatId) throws Exception {
        XMLReader parser = null;
        String parserName = PropertyService.getProperty("xml.saxparser");
        parser = XMLReaderFactory.createXMLReader(parserName);
        XMLSchemaService.getInstance().populateRegisteredSchemaList();
        if (ruleBase != null && ruleBase.equals(EML200)) {
            logMetacat.info((Object)"DocumentImpl.initalizeParser - Using eml 2.0.0 parser");
            Eml200SAXHandler chandler = new Eml200SAXHandler(dbconn, action, docid, rev, user, groups, pub, serverCode, createDate, updateDate, writeAccessRules, guidsToSync);
            chandler.setIsRevisionDoc(isRevision);
            chandler.setEncoding(encoding);
            parser.setContentHandler(chandler);
            parser.setErrorHandler(chandler);
            parser.setProperty(DECLARATIONHANDLERPROPERTY, chandler);
            parser.setProperty(LEXICALPROPERTY, chandler);
            parser.setFeature(VALIDATIONFEATURE, true);
            parser.setFeature(NAMESPACEFEATURE, true);
            parser.setFeature(SCHEMAVALIDATIONFEATURE, true);
            String externalSchemaLocation = null;
            logMetacat.debug((Object)("DocumentImpl.initalizeParser - the final formatId of the object " + docid + " is " + formatId));
            externalSchemaLocation = XMLSchemaService.getInstance().getNameSpaceAndLocation(formatId);
            if (externalSchemaLocation == null) {
                logMetacat.info((Object)("DocumentImpl.initalizeParser - there is no register schemas for the formatid " + formatId + ". So we will use the old way." + " Put all registred schema/location paris for the validation."));
                externalSchemaLocation = XMLSchemaService.getInstance().getNameSpaceAndLocationStringWithoutFormatId();
            }
            logMetacat.info((Object)("DocumentImpl.initalizeParser - 2.0.0 external schema location: " + externalSchemaLocation));
            if (externalSchemaLocation == null || externalSchemaLocation.trim().equals("")) {
                throw new Exception("The schema for the format id " + formatId + " can't be found in any place. So we can't validate the xml instance.");
            }
            parser.setProperty(EXTERNALSCHEMALOCATIONPROPERTY, externalSchemaLocation);
            logMetacat.debug((Object)"DocumentImpl.initalizeParser - 2.0.0 parser configured");
            return parser;
        } else if (ruleBase != null && ruleBase.equals(EML210)) {
            logMetacat.info((Object)"DocumentImpl.initalizeParser - Using eml 2.1.0 parser");
            Eml210SAXHandler chandler = new Eml210SAXHandler(dbconn, action, docid, rev, user, groups, pub, serverCode, createDate, updateDate, writeAccessRules, guidsToSync);
            chandler.setIsRevisionDoc(isRevision);
            chandler.setEncoding(encoding);
            parser.setContentHandler(chandler);
            parser.setErrorHandler(chandler);
            parser.setProperty(DECLARATIONHANDLERPROPERTY, chandler);
            parser.setProperty(LEXICALPROPERTY, chandler);
            parser.setFeature(VALIDATIONFEATURE, true);
            parser.setFeature(NAMESPACEFEATURE, true);
            parser.setFeature(SCHEMAVALIDATIONFEATURE, true);
            String externalSchemaLocation = null;
            logMetacat.debug((Object)("DocumentImpl.initalizeParser - the final formatId of the object " + docid + " is " + formatId));
            externalSchemaLocation = XMLSchemaService.getInstance().getNameSpaceAndLocation(formatId);
            if (externalSchemaLocation == null) {
                logMetacat.info((Object)("DocumentImpl.initalizeParser - there is no register schemas for the formatid " + formatId + ". So we will use the old way." + " Put all registred schema/location paris for the validation."));
                externalSchemaLocation = XMLSchemaService.getInstance().getNameSpaceAndLocationStringWithoutFormatId();
            }
            logMetacat.info((Object)("DocumentImpl.initalizeParser - 2.1.0 external schema location: " + externalSchemaLocation));
            if (externalSchemaLocation == null || externalSchemaLocation.trim().equals("")) {
                throw new Exception("The schema for the format id " + formatId + " can't be found in any place. So we can't validate the xml instance.");
            }
            parser.setProperty(EXTERNALSCHEMALOCATIONPROPERTY, externalSchemaLocation);
            logMetacat.debug((Object)"DocumentImpl.initalizeParser - Using eml 2.1.0 parser configured");
            return parser;
        } else {
            DBSAXHandler chandler = new DBSAXHandler(dbconn, action, docid, rev, user, groups, pub, serverCode, createDate, updateDate, writeAccessRules);
            chandler.setIsRevisionDoc(isRevision);
            chandler.setEncoding(encoding);
            parser.setContentHandler(chandler);
            parser.setErrorHandler(chandler);
            parser.setProperty(DECLARATIONHANDLERPROPERTY, chandler);
            parser.setProperty(LEXICALPROPERTY, chandler);
            if (ruleBase != null && ruleBase.equals(SCHEMA) && needValidation) {
                XMLSchemaService xmlss = XMLSchemaService.getInstance();
                xmlss.doRefresh();
                logMetacat.info((Object)"DocumentImpl.initalizeParser - Using General schema parser");
                parser.setFeature(VALIDATIONFEATURE, true);
                parser.setFeature(NAMESPACEFEATURE, true);
                parser.setFeature(SCHEMAVALIDATIONFEATURE, true);
                Vector<XMLSchema> schemaList = XMLSchemaService.findSchemasInXML((StringReader)xml);
                boolean allSchemasRegistered = XMLSchemaService.areAllSchemasRegistered(schemaList);
                if (xmlss.useFullSchemaValidation() && !allSchemasRegistered) {
                    parser.setFeature(FULLSCHEMAVALIDATIONFEATURE, true);
                }
                String externalSchemaLocation = null;
                logMetacat.debug((Object)("DocumentImpl.initalizeParser - the final formatId of the object " + docid + " is " + formatId));
                externalSchemaLocation = XMLSchemaService.getInstance().getNameSpaceAndLocation(formatId);
                if (externalSchemaLocation == null) {
                    logMetacat.info((Object)("DocumentImpl.initalizeParser - there is no register schemas for the formatid " + formatId + ". So we will use the old way." + " Put all registred schema/location paris for the validation."));
                    externalSchemaLocation = XMLSchemaService.getInstance().getNameSpaceAndLocationStringWithoutFormatId();
                }
                logMetacat.info((Object)("DocumentImpl.initalizeParser - Generic external schema location: " + externalSchemaLocation));
                if (externalSchemaLocation == null || externalSchemaLocation.trim().equals("")) throw new Exception("The schema for the format id " + formatId + " can't be found in any place. So we can't validate the xml instance.");
                parser.setProperty(EXTERNALSCHEMALOCATIONPROPERTY, externalSchemaLocation);
                return parser;
            } else if (ruleBase != null && ruleBase.equals(DTD) && needValidation) {
                logMetacat.info((Object)"DocumentImpl.initalizeParser - Using dtd parser");
                parser.setFeature(VALIDATIONFEATURE, true);
                DBEntityResolver eresolver = new DBEntityResolver(dbconn, chandler, dtd);
                DBDTDHandler dtdhandler = new DBDTDHandler(dbconn);
                parser.setEntityResolver(eresolver);
                parser.setDTDHandler(dtdhandler);
                return parser;
            } else {
                logMetacat.info((Object)"DocumentImpl.initalizeParser - Using other parser");
                parser.setFeature(VALIDATIONFEATURE, false);
                DBEntityResolver eresolver = new DBEntityResolver(dbconn, chandler, dtd);
                DBDTDHandler dtdhandler = new DBDTDHandler(dbconn);
                parser.setEntityResolver(eresolver);
                parser.setDTDHandler(dtdhandler);
            }
        }
        return parser;
    }

    private static void archiveDocAndNodesRevision(DBConnection dbconn, String docid, String user, DocumentImpl doc) {
        try {
            if (doc == null) {
                String accNumber = docid + PropertyService.getProperty("document.accNumSeparator") + DBUtil.getLatestRevisionInDocumentTable(docid);
                doc = new DocumentImpl(accNumber);
            }
            long rootNodeId = doc.getRootNodeID();
            DocumentImpl.archiveDocAndNodesRevison(dbconn, docid, user, rootNodeId);
        }
        catch (Exception e) {
            logMetacat.error((Object)("DocumentImpl.archiveDocAndNodesRevision - Error in DocumentImpl.archiveDocRevision : " + e.getMessage()));
        }
    }

    private static void archiveDocAndNodesRevison(DBConnection dbconn, String docid, String user, long rootNodeId) throws Exception {
        String sysdate = DatabaseService.getInstance().getDBAdapter().getDateTimeFunction();
        Statement pstmt = null;
        try {
            DocumentImpl.moveNodesToNodesRevision(dbconn, rootNodeId);
            double start = System.currentTimeMillis() / 1000L;
            pstmt = dbconn.prepareStatement("INSERT INTO xml_revisions (docid, rootnodeid, docname, doctype, user_owner, user_updated, date_created, date_updated, server_location, rev, public_access, catalog_id) SELECT ?, rootnodeid, docname, doctype, user_owner, ?, date_created, date_updated, server_location, rev, public_access, catalog_id FROM xml_documents WHERE docid = ?");
            dbconn.increaseUsageCount(1);
            pstmt.setString(1, docid);
            pstmt.setString(2, user);
            pstmt.setString(3, docid);
            logMetacat.debug((Object)("DocumentImpl.archiveDocAndNodesRevison - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            pstmt.close();
            double end = System.currentTimeMillis() / 1000L;
            logMetacat.debug((Object)("DocumentImpl.archiveDocAndNodesRevision - moving docs from xml_documents to xml_revision takes " + (end - start)));
        }
        catch (SQLException e) {
            logMetacat.error((Object)("DocumentImpl.archiveDocAndNodesRevision - SQL error: " + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            logMetacat.error((Object)("DocumentImpl.archiveDocAndNodesRevision - General error: " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("DocumentImpl.archiveDocAndNodesRevision - SQL error when closing prepared statement: " + ee.getMessage()));
            }
        }
    }

    private static void updateNodeValues(DBConnection dbConnection, String docid) throws SQLException {
        PreparedStatement sqlStatement = null;
        PreparedStatement pstmt = null;
        ResultSet rset = null;
        sqlStatement = dbConnection.prepareStatement("SELECT DISTINCT NODEID, NODEDATA FROM xml_nodes WHERE nodedata IS NOT NULL AND docid = ?");
        sqlStatement.setString(1, docid);
        rset = sqlStatement.executeQuery();
        int count = 0;
        while (rset.next()) {
            String nodeid = rset.getString(1);
            String nodedata = rset.getString(2);
            try {
                if (nodedata.trim().equals("")) continue;
                try {
                    double dataNumeric = Double.parseDouble(nodedata);
                    pstmt = dbConnection.prepareStatement("UPDATE xml_nodes  SET nodedatanumerical = ? WHERE nodeid = " + nodeid);
                    pstmt.setDouble(1, dataNumeric);
                    pstmt.execute();
                    pstmt.close();
                }
                catch (Exception e) {
                    try {
                        Calendar dataDateValue = DatatypeConverter.parseDateTime((String)nodedata);
                        Timestamp dataTimestamp = new Timestamp(dataDateValue.getTimeInMillis());
                        pstmt = dbConnection.prepareStatement("UPDATE xml_nodes  SET nodedatadate = ? WHERE nodeid = " + nodeid);
                        pstmt.setTimestamp(1, dataTimestamp);
                        pstmt.execute();
                        pstmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (++count % 5 != 0) continue;
                logMetacat.info((Object)(count + "..."));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rset.close();
        sqlStatement.close();
    }

    private static void moveNodesToNodesRevision(DBConnection dbconn, long rootNodeId) throws Exception {
        logMetacat.debug((Object)("DocumentImpl.moveNodesToNodesRevision - the root node id is " + rootNodeId + " will be moved from xml_nodes to xml_node_revision table"));
        PreparedStatement pstmt = null;
        double start = System.currentTimeMillis() / 1000L;
        pstmt = dbconn.prepareStatement("INSERT INTO xml_nodes_revisions (nodeid, nodeindex, nodetype, nodename, nodeprefix, nodedata, parentnodeid, rootnodeid, docid, date_created, date_updated, nodedatanumerical, nodedatadate) SELECT nodeid, nodeindex, nodetype, nodename, nodeprefix, nodedata, parentnodeid, rootnodeid, docid, date_created, date_updated, nodedatanumerical, nodedatadate FROM xml_nodes WHERE rootnodeid = ?");
        dbconn.increaseUsageCount(1);
        pstmt.setLong(1, rootNodeId);
        logMetacat.debug((Object)("DocumentImpl.moveNodesToNodesRevision - executing SQL: " + pstmt.toString()));
        pstmt.execute();
        pstmt.close();
        double end = System.currentTimeMillis() / 1000L;
        logMetacat.debug((Object)("DocumentImpl.moveNodesToNodesRevision - Moving nodes from xml_nodes to xml_nodes_revision takes " + (end - start)));
    }

    private static void archiveDocRevision(String docid, String user, DBConnection conn) throws Exception {
        String sysdate = DatabaseService.getInstance().getDBAdapter().getDateTimeFunction();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("INSERT INTO xml_revisions (docid, rootnodeid, docname, doctype, user_owner, user_updated, date_created, date_updated, server_location, rev, public_access, catalog_id) SELECT ?, rootnodeid, docname, doctype, user_owner, ?, date_created, date_updated, server_location, rev, public_access, catalog_id FROM xml_documents WHERE docid = ?");
            conn.increaseUsageCount(1);
            pstmt.setString(1, docid);
            pstmt.setString(2, user);
            pstmt.setString(3, docid);
            logMetacat.debug((Object)("DocumentImpl.archiveDocRevision - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            logMetacat.error((Object)("DocumentImpl.archiveDocRevision - SQL error: " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("DocumentImpl.archiveDocRevision - SQL Error: " + ee.getMessage()));
                throw ee;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteXMLDocuments(String docId) throws SQLException {
        DBConnection conn = null;
        int serialNumber = -1;
        Statement pStmt = null;
        try {
            conn = DBConnectionPool.getDBConnection("DocumentImpl.deleteXMLDocuments");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement("DELETE FROM xml_documents WHERE docid = ? ");
            pStmt.setString(1, docId);
            logMetacat.debug((Object)("DocumentImpl.deleteXMLDocuments - executing SQL: " + pStmt.toString()));
            pStmt.execute();
        }
        finally {
            try {
                pStmt.close();
            }
            catch (SQLException e) {
                logMetacat.error((Object)("DocumentImpl.deleteXMLDocuments - SQL error: " + e.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getServerLocationNumber(String accNum) throws SQLException {
        String docId = DocumentUtil.getDocIdFromString(accNum);
        Statement pStmt = null;
        int serverLocation = 1;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("DocumentImpl.getServerLocationNumber");
            serialNumber = conn.getCheckOutSerialNumber();
            pStmt = conn.prepareStatement("SELECT server_location FROM xml_documents WHERE docid = ?");
            pStmt.setString(1, docId);
            pStmt.execute();
            ResultSet rs = pStmt.getResultSet();
            boolean hasRow = rs.next();
            if (hasRow) {
                serverLocation = rs.getInt(1);
                pStmt.close();
            } else {
                serverLocation = 1;
                pStmt.close();
            }
        }
        finally {
            try {
                pStmt.close();
            }
            catch (Exception ee) {
                logMetacat.error((Object)("DocumentImpl.getServerLocationNumber - General error: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        return serverLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getServerCode(String serverName) {
        Statement pStmt = null;
        int serverLocation = -2;
        DBConnection dbConn = null;
        int serialNumber = -1;
        if (serverName.equals(MetacatUtil.getLocalReplicationServerName())) {
            return 1;
        }
        try {
            dbConn = DBConnectionPool.getDBConnection("DocumentImpl.getServerCode");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pStmt = dbConn.prepareStatement("SELECT serverid FROM xml_replication WHERE server = ?");
            pStmt.setString(1, serverName);
            pStmt.execute();
            ResultSet rs = pStmt.getResultSet();
            boolean hasRow = rs.next();
            if (hasRow) {
                serverLocation = rs.getInt(1);
                pStmt.close();
                return serverLocation;
            }
            serverLocation = -1;
            pStmt.close();
            return serverLocation;
        }
        catch (Exception e) {
            logMetacat.error((Object)("DocumentImpl.getServerCode - General Error: " + e.getMessage()));
            return serverLocation;
        }
        finally {
            try {
                pStmt.close();
            }
            catch (Exception ee) {
                logMetacat.error((Object)("DocumentImpl.getServerCode - General error: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void insertServerIntoReplicationTable(String server) {
        Statement pStmt = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        int replicate = 0;
        int dataReplicate = 0;
        int hub = 0;
        try {
            dbConn = DBConnectionPool.getDBConnection("DocumentImpl.insertServIntoReplicationTable");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pStmt = dbConn.prepareStatement("SELECT serverid FROM xml_replication WHERE server = ?");
            pStmt.setString(1, server);
            pStmt.execute();
            ResultSet rs = pStmt.getResultSet();
            boolean hasRow = rs.next();
            pStmt.close();
            rs.close();
            if (hasRow) return;
            if (server.equals(MetacatUtil.getLocalReplicationServerName())) return;
            dbConn.setAutoCommit(false);
            Calendar cal = Calendar.getInstance();
            cal.set(1980, 1, 1);
            pStmt = dbConn.prepareStatement("INSERT INTO xml_replication (server, last_checked, replicate, datareplicate, hub) VALUES (?, ?, ?, ?, ?)");
            pStmt.setString(1, server);
            pStmt.setTimestamp(2, new Timestamp(cal.getTimeInMillis()));
            pStmt.setInt(3, replicate);
            pStmt.setInt(4, dataReplicate);
            pStmt.setInt(5, hub);
            logMetacat.debug((Object)("DocumentImpl.insertServerIntoReplicationTable - executing SQL: " + pStmt.toString()));
            pStmt.execute();
            dbConn.commit();
            dbConn.increaseUsageCount(1);
            pStmt.close();
            return;
        }
        catch (Exception e) {
            logMetacat.error((Object)("DocumentImpl.insertServerIntoReplicationTable - General error: " + e.getMessage()));
            return;
        }
        finally {
            try {
                dbConn.setAutoCommit(true);
                pStmt.close();
            }
            catch (Exception ee) {
                logMetacat.error((Object)("DocumentImpl.insertServerIntoReplicationTable - General error: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void writeDocumentToRevisionTable(DBConnection con, String docId, String rev, String docType, String docName, String user, String catalogid, int serverCode, long rootNodeId, Date createDate, Date updateDate) throws SQLException, Exception {
        try {
            Date today = Calendar.getInstance().getTime();
            if (createDate == null) {
                createDate = today;
            }
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - the create date is " + createDate));
            if (updateDate == null) {
                updateDate = today;
            }
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - the update date is " + updateDate));
            PreparedStatement pstmt = null;
            String sql = null;
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - the root node id is " + rootNodeId));
            sql = rootNodeId <= 0L ? "INSERT INTO xml_revisions (docid, docname, doctype, user_owner, user_updated, date_created, date_updated, public_access, server_location, rev) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" : (catalogid != null ? "INSERT INTO xml_revisions (docid, docname, doctype, user_owner, user_updated, date_created, date_updated, public_access, server_location, rev, catalog_id, rootnodeid ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" : "INSERT INTO xml_revisions (docid, docname, doctype, user_owner, user_updated, date_created, date_updated, public_access, server_location, rev, rootnodeid ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            pstmt = con.prepareStatement(sql);
            con.increaseUsageCount(1);
            pstmt.setString(1, docId);
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - docid is " + docId));
            pstmt.setString(2, docName);
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - docname is " + docName));
            pstmt.setString(3, docType);
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - docType is " + docType));
            pstmt.setString(4, user);
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - onwer is " + user));
            pstmt.setString(5, user);
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - update user is " + user));
            pstmt.setTimestamp(6, new Timestamp(createDate.getTime()));
            pstmt.setTimestamp(7, new Timestamp(updateDate.getTime()));
            pstmt.setInt(8, 0);
            pstmt.setInt(9, serverCode);
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - server code is " + serverCode));
            pstmt.setInt(10, Integer.parseInt(rev));
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - rev is " + rev));
            if (rootNodeId > 0L) {
                if (catalogid != null) {
                    pstmt.setInt(11, new Integer(catalogid));
                    logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - catalog id is " + catalogid));
                    pstmt.setLong(12, rootNodeId);
                    logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - root id is " + rootNodeId));
                } else {
                    pstmt.setLong(11, rootNodeId);
                    logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - root id is " + rootNodeId));
                }
            }
            logMetacat.debug((Object)("DocumentImpl.writeDocumentToRevisionTable - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            pstmt.close();
            logMetacat.debug((Object)"DocumentImpl.writeDocumentToRevisionTable - end of write into revisons");
        }
        catch (SQLException sqle) {
            logMetacat.error((Object)("DocumentImpl.writeDocumentToRevisionTable - SQL error: " + sqle.getMessage()));
            sqle.printStackTrace();
            throw sqle;
        }
        catch (Exception e) {
            logMetacat.error((Object)("DocumentImpl.writeDocumentToRevisionTable - General error: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerDeletedDataFile(String docname, String doctype, String accnum, String user, int serverCode, Date createDate, Date updateDate) throws Exception {
        DBConnection dbconn = null;
        int serialNumber = -1;
        try {
            dbconn = DBConnectionPool.getDBConnection("DeletedDocumentImpl.registerDeletedDataFile");
            serialNumber = dbconn.getCheckOutSerialNumber();
            String docIdWithoutRev = DocumentUtil.getDocIdFromAccessionNumber(accnum);
            String rev = DocumentUtil.getRevisionStringFromString(accnum);
            DocumentImpl.writeDocumentToRevisionTable(dbconn, docIdWithoutRev, rev, doctype, docname, user, null, serverCode, -1L, createDate, updateDate);
            dbconn.close();
        }
        finally {
            DBConnectionPool.returnDBConnection(dbconn, serialNumber);
        }
    }

    private static void deleteXMLNodes(DBConnection dbconn, long rootId) throws Exception {
        logMetacat.debug((Object)("DocumentImpl.deleteXMLNodes - for root Id: " + rootId));
        PreparedStatement pstmt = null;
        double start = System.currentTimeMillis() / 1000L;
        String sql = "DELETE FROM xml_nodes WHERE rootnodeid = ? ";
        pstmt = dbconn.prepareStatement(sql);
        pstmt.setLong(1, rootId);
        dbconn.increaseUsageCount(1);
        logMetacat.debug((Object)("DocumentImpl.deleteXMLNodes - executing SQL: " + pstmt.toString()));
        pstmt.execute();
        pstmt.close();
        double end = System.currentTimeMillis() / 1000L;
        logMetacat.info((Object)("DocumentImpl.deleteXMLNodes - The time to delete xml_nodes in UPDATE is " + (end - start)));
    }

    private static long getRevisionRootNodeId(DBConnection conn, String docid, int rev) throws SQLException {
        long rootnodeid = -1L;
        String sql = "SELECT rootnodeid FROM xml_revisions WHERE docid = ? and rev = ?";
        PreparedStatement stmt = null;
        stmt = conn.prepareStatement(sql);
        stmt.setString(1, docid);
        stmt.setInt(2, rev);
        ResultSet result = stmt.executeQuery();
        boolean hasResult = result.next();
        if (hasResult) {
            rootnodeid = result.getLong(1);
        }
        logMetacat.debug((Object)("DocumentImpl.getRevisionRootNodeId - The root node id of docid " + docid + "." + rev + " is " + rootnodeid));
        return rootnodeid;
    }

    static {
        String eml200NameSpace = null;
        String eml201NameSpace = null;
        String eml210NameSpace = null;
        String eml211NameSpace = null;
        String rdfNameSpace = null;
        try {
            eml200NameSpace = PropertyService.getProperty("xml.eml2_0_0namespace");
            eml201NameSpace = PropertyService.getProperty("xml.eml2_0_1namespace");
            eml210NameSpace = PropertyService.getProperty("xml.eml2_1_0namespace");
            eml211NameSpace = PropertyService.getProperty("xml.eml2_1_1namespace");
            rdfNameSpace = PropertyService.getProperty("xml.rdf_syntax_namespace");
        }
        catch (PropertyNotFoundException pnfe) {
            System.err.println("Could not get property in static block: " + pnfe.getMessage());
        }
        EML2_1_1NAMESPACE = eml211NameSpace;
        EML2_1_0NAMESPACE = eml210NameSpace;
        EML2_0_1NAMESPACE = eml201NameSpace;
        EML2_0_0NAMESPACE = eml200NameSpace;
        RDF_SYNTAX_NAMESPACE = rdfNameSpace;
        logMetacat = Logger.getLogger(DocumentImpl.class);
        logReplication = Logger.getLogger((String)"ReplicationLogging");
    }
}

