/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.AccessionNumber;
import edu.ucsb.nceas.metacat.DBSAXHandler;
import edu.ucsb.nceas.metacat.DBSAXNode;
import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.NodeRecord;
import edu.ucsb.nceas.metacat.PermissionController;
import edu.ucsb.nceas.metacat.SchemaLocationResolver;
import edu.ucsb.nceas.metacat.accesscontrol.AccessRule;
import edu.ucsb.nceas.metacat.accesscontrol.AccessSection;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.access.AccessControlInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Eml200SAXHandler
extends DBSAXHandler
implements AccessControlInterface {
    private boolean processTopLevelAccess = false;
    private boolean processAdditionalAccess = false;
    private boolean processOtherAccess = false;
    private Vector<String> guidsToSync;
    private AccessSection accessObject = null;
    private AccessRule accessRule = null;
    private Vector describesId = new Vector();
    private Hashtable onlineURLDistributionIdList = new Hashtable();
    private Vector onlineURLDistributionListWithoutId = new Vector();
    private Hashtable onlineOtherDistributionIdList = new Hashtable();
    private Hashtable inlineDistributionIdList = new Hashtable();
    private Hashtable offlineDistributionIdList = new Hashtable();
    private Hashtable distributionAllIdList = new Hashtable();
    private String distributionId = null;
    private boolean proccessDistribution = false;
    private Hashtable distributionReferenceList = new Hashtable();
    private boolean needToCheckAccessModule = false;
    private AccessSection topAccessSubTreeFromDB = null;
    private Vector additionalAccessSubTreeListFromDB = new Vector();
    private Hashtable referencedAccessSubTreeListFromDB = new Hashtable();
    private AccessSection topAccessSection;
    private Vector additionalAccessVector = new Vector();
    private Hashtable possibleReferencedAccessHash = new Hashtable();
    private Stack storedAccessNodeStack = new Stack();
    private Vector onlineDataFileIdInRelationVector = new Vector();
    private boolean handleInlineData = false;
    private Hashtable inlineDataNameSpace = null;
    private Writer inlineDataFileWriter = null;
    private String inlineDataFileName = null;
    private int inLineDataIndex = 0;
    private Vector inlineFileIDList = new Vector();
    private boolean inAdditionalMetaData = false;
    private boolean unWritableInlineDataObject = false;
    private boolean unReadableInlineDataObject = false;
    private Hashtable previousUnreadableInlineDataObjectHash = new Hashtable();
    private Hashtable previousUnwritableInlineDataObjectHash = new Hashtable();
    private Hashtable accessSubTreeAlreadyWriteDBList = new Hashtable();
    private Hashtable onlineURLIdHasadditionalAccess = new Hashtable();
    private boolean firstDescribesInAdditionalMetadata = true;
    private long firstDescribesNodeId = -1L;
    private int numberOfHitUnWritableInlineData = 0;
    private static final String EML = "eml";
    private static final String DESCRIBES = "describes";
    private static final String ADDITIONALMETADATA = "additionalMetadata";
    private static final String ORDER = "order";
    private static final String ID = "id";
    private static final String REFERENCES = "references";
    public static final String INLINE = "inline";
    private static final String ONLINE = "online";
    private static final String OFFLINE = "offline";
    private static final String CONNECTION = "connection";
    private static final String CONNECTIONDEFINITION = "connectionDefinition";
    private static final String URL = "url";
    private static final String PERMISSIONERROR = "User tried to update a subtree when they don't have write permission!";
    private static final String UPDATEACCESSERROR = "User tried to update an access module when they don't have \"ALL\" permission!";
    public static final String TOPLEVEL = "top";
    public static final String DATAACCESSLEVEL = "dataAccess";
    private static final String REFERENCEDLEVEL = "referenced";
    private static final String RELATION = "Provides info for";
    private static final String DISTRIBUTION = "distribution";
    private Logger logMetacat = Logger.getLogger(Eml200SAXHandler.class);

    public Eml200SAXHandler(DBConnection conn, String action, String docid, String revision, String user, String[] groups, String pub, int serverCode, Date createDate, Date updateDate, boolean writeAccessRules, Vector<String> guidsToSync) throws SAXException {
        super(conn, action, docid, revision, user, groups, pub, serverCode, createDate, updateDate, writeAccessRules);
        this.guidsToSync = guidsToSync;
        try {
            if (action != null && action.equals("UPDATE")) {
                int latestRevision = DBUtil.getLatestRevisionInDocumentTable(docid);
                String previousDocid = docid + PropertyService.getProperty("document.accNumSeparator") + latestRevision;
                PermissionController control = new PermissionController(previousDocid);
                if (!(control.hasPermission(user, groups, "ALL") || control.hasPermission(user, groups, "CHANGEPERMISSION") || AuthUtil.isAdministrator(user, groups))) {
                    this.needToCheckAccessModule = true;
                    this.topAccessSubTreeFromDB = this.getTopAccessSubTreeFromDB();
                    this.additionalAccessSubTreeListFromDB = this.getAdditionalAccessSubTreeListFromDB();
                    this.referencedAccessSubTreeListFromDB = this.getReferencedAccessSubTreeListFromDB();
                }
                this.previousUnreadableInlineDataObjectHash = PermissionController.getUnReadableInlineDataIdList(previousDocid, user, groups);
                this.previousUnwritableInlineDataObjectHash = PermissionController.getUnWritableInlineDataIdList(previousDocid, user, groups, true);
            }
        }
        catch (Exception e) {
            this.logMetacat.error((Object)("error in Eml200SAXHandler is " + e.getMessage()));
            throw new SAXException(e.getMessage());
        }
    }

    private AccessSection getTopAccessSubTreeFromDB() throws SAXException {
        AccessSection topAccess = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT subtreeid, startnodeid, endnodeid FROM xml_accesssubtree WHERE docid like ? AND controllevel like ?";
        try {
            pstmt = this.connection.prepareStatement(sql);
            this.connection.increaseUsageCount(1);
            pstmt.setString(1, this.docid);
            pstmt.setString(2, TOPLEVEL);
            this.logMetacat.debug((Object)("Eml200SAXHandler.getTopAccessSubTreeFromDB - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            rs = pstmt.getResultSet();
            if (rs.next()) {
                String sectionId = rs.getString(1);
                long startNodeId = rs.getLong(2);
                long endNodeId = rs.getLong(3);
                topAccess = new AccessSection();
                topAccess.setControlLevel(TOPLEVEL);
                topAccess.setDocId(this.docid);
                topAccess.setSubTreeId(sectionId);
                topAccess.setStartNodeId(startNodeId);
                topAccess.setEndNodeId(endNodeId);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.getTopAccessSubTreeFromDB(): " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.getTopAccessSubTreeFromDB(): " + ee.getMessage());
            }
        }
        return topAccess;
    }

    private Vector getAdditionalAccessSubTreeListFromDB() throws Exception {
        Vector<AccessSection> result = new Vector<AccessSection>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT subtreeid, startnodeid, endnodeid FROM xml_accesssubtree WHERE docid like ? AND controllevel like ? ORDER BY startnodeid ASC";
        try {
            pstmt = this.connection.prepareStatement(sql);
            this.connection.increaseUsageCount(1);
            pstmt.setString(1, this.docid);
            pstmt.setString(2, DATAACCESSLEVEL);
            pstmt.execute();
            rs = pstmt.getResultSet();
            while (rs.next()) {
                String sectionId = rs.getString(1);
                long startNodeId = rs.getLong(2);
                long endNodeId = rs.getLong(3);
                AccessSection accessObj = new AccessSection();
                accessObj.setControlLevel(DATAACCESSLEVEL);
                accessObj.setDocId(this.docid);
                accessObj.setSubTreeId(sectionId);
                accessObj.setStartNodeId(startNodeId);
                accessObj.setEndNodeId(endNodeId);
                result.add(accessObj);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.getadditionalAccessSubTreeListFromDB(): " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.getAccessSubTreeListFromDB(): " + ee.getMessage());
            }
        }
        return result;
    }

    private Hashtable getReferencedAccessSubTreeListFromDB() throws Exception {
        Hashtable<String, AccessSection> result = new Hashtable<String, AccessSection>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT subtreeid, startnodeid, endnodeid FROM xml_accesssubtree WHERE docid like ? AND controllevel like ? ORDER BY startnodeid ASC";
        try {
            pstmt = this.connection.prepareStatement(sql);
            this.connection.increaseUsageCount(1);
            pstmt.setString(1, this.docid);
            pstmt.setString(2, REFERENCEDLEVEL);
            pstmt.execute();
            rs = pstmt.getResultSet();
            while (rs.next()) {
                String sectionId = rs.getString(1);
                long startNodeId = rs.getLong(2);
                long endNodeId = rs.getLong(3);
                AccessSection accessObj = new AccessSection();
                accessObj.setControlLevel(DATAACCESSLEVEL);
                accessObj.setDocId(this.docid);
                accessObj.setSubTreeId(sectionId);
                accessObj.setStartNodeId(startNodeId);
                accessObj.setEndNodeId(endNodeId);
                if (sectionId == null || sectionId.trim().equals("")) continue;
                result.put(sectionId, accessObj);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.getReferencedAccessSubTreeListFromDB(): " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.getReferencedSubTreeListFromDB(): " + ee.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.logMetacat.debug((Object)("Start ELEMENT(qName) " + qName));
        this.logMetacat.debug((Object)("Start ELEMENT(localName) " + localName));
        this.logMetacat.debug((Object)("Start ELEMENT(uri) " + uri));
        DBSAXNode parentNode = null;
        DBSAXNode currentNode = null;
        if (!this.handleInlineData) {
            try {
                parentNode = (DBSAXNode)this.nodeStack.peek();
            }
            catch (EmptyStackException e) {
                parentNode = null;
            }
            if (qName.equals(INLINE) && !this.inAdditionalMetaData) {
                this.handleInlineData = true;
                ++this.inLineDataIndex;
                this.inlineDataNameSpace = new Hashtable();
                String docidWithoutRev = DocumentUtil.getDocIdFromString(this.docid);
                String seperator = ".";
                try {
                    seperator = PropertyService.getProperty("document.accNumSeparator");
                }
                catch (PropertyNotFoundException pnfe) {
                    this.logMetacat.error((Object)("Could not get property 'accNumSeparator'.  Setting separator to '.': " + pnfe.getMessage()));
                }
                this.inlineDataFileName = docidWithoutRev + seperator + this.revision + seperator + this.inLineDataIndex;
                this.inlineDataFileWriter = this.createInlineDataFileWriter(this.inlineDataFileName, this.encoding);
                this.inlineFileIDList.add(this.inlineDataFileName);
                if (this.distributionId != null) {
                    if (!this.previousUnreadableInlineDataObjectHash.isEmpty() && this.previousUnreadableInlineDataObjectHash.containsKey(this.distributionId)) {
                        this.unReadableInlineDataObject = true;
                    }
                    if (!this.previousUnwritableInlineDataObjectHash.isEmpty() && this.previousUnwritableInlineDataObjectHash.containsKey(this.distributionId)) {
                        this.unWritableInlineDataObject = true;
                        ++this.numberOfHitUnWritableInlineData;
                    }
                    this.inlineDistributionIdList.put(this.distributionId, this.inlineDataFileName);
                }
            }
            if (this.hitTextNode && parentNode != null) {
                if (this.needToCheckAccessModule && (this.processAdditionalAccess || this.processOtherAccess || this.processTopLevelAccess)) {
                    NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "TEXT", null, null, MetacatUtil.normalize(this.textBuffer.toString()));
                    this.storedAccessNodeStack.push(nodeElement);
                }
                this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, parentNode);
                this.hitTextNode = false;
                this.textBuffer = null;
                this.textBuffer = new StringBuffer();
            }
            if (this.atFirstElement) {
                this.atFirstElement = false;
                if (this.docname == null) {
                    this.docname = localName;
                    this.doctype = uri != null && !uri.trim().equals("") ? uri : this.docname;
                    this.logMetacat.info((Object)("DOCNAME-a: " + this.docname));
                    this.logMetacat.info((Object)("DOCTYPE-a: " + this.doctype));
                } else if (this.doctype == null) {
                    this.doctype = this.docname;
                    this.logMetacat.info((Object)("DOCTYPE-b: " + this.doctype));
                }
                this.rootNode.writeNodename(this.docname);
                try {
                    DBConnection dbConn = null;
                    int serialNumber = -1;
                    try {
                        dbConn = DBConnectionPool.getDBConnection("DBSAXHandler.startElement");
                        serialNumber = dbConn.getCheckOutSerialNumber();
                        String sql = "SELECT catalog_id FROM xml_catalog WHERE entry_type = 'Schema' AND public_id = ?";
                        PreparedStatement pstmt = dbConn.prepareStatement(sql);
                        pstmt.setString(1, this.doctype);
                        ResultSet rs = pstmt.executeQuery();
                        boolean hasRow = rs.next();
                        if (hasRow) {
                            this.catalogid = rs.getString(1);
                        }
                        pstmt.close();
                    }
                    finally {
                        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                    }
                    if (!super.getIsRevisionDoc()) {
                        this.logMetacat.debug((Object)("EML200SaxHandler.startElement - creating new DocumentImple for " + this.docid));
                        this.currentDocument = new DocumentImpl(this.connection, this.rootNode.getNodeID(), this.docname, this.doctype, this.docid, this.revision, this.action, this.user, this.pub, this.catalogid, this.serverCode, this.createDate, this.updateDate);
                    }
                }
                catch (Exception ane) {
                    throw new SAXException("EML200SaxHandler.startElement - error with action " + this.action + " : " + ane.getMessage());
                }
            }
            currentNode = new DBSAXNode(this.connection, qName, localName, parentNode, this.rootNode.getNodeID(), this.docid, this.doctype);
            long startNodeId = currentNode.getNodeID();
            String prefix = null;
            String nsuri = null;
            Enumeration prefixes = this.namespaces.keys();
            while (prefixes.hasMoreElements()) {
                prefix = (String)prefixes.nextElement();
                nsuri = (String)this.namespaces.get(prefix);
                this.endNodeId = currentNode.setNamespace(prefix, nsuri, this.docid);
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                String attributeName = atts.getQName(i);
                String attributeValue = atts.getValue(i);
                this.endNodeId = currentNode.setAttribute(attributeName, attributeValue, this.docid);
                if (attributeName != null && attributeName.indexOf(":schemaLocation") != -1) {
                    SchemaLocationResolver resolver = new SchemaLocationResolver(attributeValue);
                    resolver.resolveNameSpace();
                    continue;
                }
                if (attributeName == null || !attributeName.equals(ID) || !currentNode.getTagName().equals(DISTRIBUTION) || this.inAdditionalMetaData) continue;
                this.distributionId = attributeValue;
                this.distributionAllIdList.put(this.distributionId, this.distributionId);
            }
            if (localName.equals("access")) {
                DBSAXNode tmpNode = (DBSAXNode)this.nodeStack.pop();
                DBSAXNode grandParentNode = (DBSAXNode)this.nodeStack.peek();
                this.nodeStack.push(tmpNode);
                String grandParentTag = grandParentNode.getTagName();
                if (grandParentTag.equals(EML) && !this.inAdditionalMetaData) {
                    this.processTopLevelAccess = true;
                } else if (!this.inAdditionalMetaData) {
                    this.processOtherAccess = true;
                } else {
                    this.processAdditionalAccess = true;
                }
                this.accessObject = new AccessSection();
                String permOrder = currentNode.getAttribute(ORDER);
                this.accessObject.setPermissionOrder(permOrder);
                String accessId = currentNode.getAttribute(ID);
                this.accessObject.setSubTreeId(accessId);
                if (this.processAdditionalAccess) {
                    this.accessObject.setStartedDescribesNodeId(this.firstDescribesNodeId);
                    this.accessObject.setControlLevel(DATAACCESSLEVEL);
                } else if (this.processTopLevelAccess) {
                    this.accessObject.setControlLevel(TOPLEVEL);
                } else if (this.processOtherAccess) {
                    this.accessObject.setControlLevel(REFERENCEDLEVEL);
                }
                this.accessObject.setStartNodeId(startNodeId);
                this.accessObject.setDocId(this.docid);
            } else if (parentNode.getTagName() != null && parentNode.getTagName().equals("access") && localName.equals("allow")) {
                this.accessRule = new AccessRule();
                this.accessRule.setPermissionType("allow");
            } else if (parentNode.getTagName() != null && parentNode.getTagName().equals("access") && localName.equals("deny")) {
                this.accessRule = new AccessRule();
                this.accessRule.setPermissionType("deny");
            }
            this.nodeStack.push(currentNode);
            this.nodeIndex.addElement(currentNode);
            if (this.needToCheckAccessModule && (this.processAdditionalAccess || this.processOtherAccess || this.processTopLevelAccess)) {
                NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "ELEMENT", localName, prefix, MetacatUtil.normalize(null));
                this.storedAccessNodeStack.push(nodeElement);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attributeName = atts.getQName(i);
                    String attributeValue = atts.getValue(i);
                    NodeRecord nodeAttribute = new NodeRecord(-2L, -2L, -2L, "ATTRIBUTE", attributeName, null, MetacatUtil.normalize(attributeValue));
                    this.storedAccessNodeStack.push(nodeAttribute);
                }
            }
            if (currentNode.getTagName().equals(ADDITIONALMETADATA)) {
                this.inAdditionalMetaData = true;
            } else if (currentNode.getTagName().equals(DESCRIBES) && parentNode.getTagName().equals(ADDITIONALMETADATA) && this.firstDescribesInAdditionalMetadata) {
                this.firstDescribesNodeId = startNodeId;
                NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "ELEMENT", localName, prefix, MetacatUtil.normalize(null));
                this.storedAccessNodeStack.push(nodeElement);
                this.processAdditionalAccess = true;
                this.logMetacat.info((Object)"set processAdditonalAccess true when meet describe");
            } else if (this.inAdditionalMetaData && this.processAdditionalAccess && parentNode.getTagName().equals(ADDITIONALMETADATA) && !currentNode.getTagName().equals(DESCRIBES) && !currentNode.getTagName().equals("access")) {
                this.processAdditionalAccess = false;
                this.logMetacat.warn((Object)"set processAddtionAccess false if the there is no access in additional");
            } else if (currentNode.getTagName().equals(DISTRIBUTION) && !this.inAdditionalMetaData) {
                this.proccessDistribution = true;
            }
            this.namespaces = null;
            this.namespaces = new Hashtable();
        } else {
            StringBuffer inlineElements = new StringBuffer();
            inlineElements.append("<").append(qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                String attributeName = atts.getQName(i);
                String attributeValue = atts.getValue(i);
                inlineElements.append(" ");
                inlineElements.append(attributeName);
                inlineElements.append("=\"");
                inlineElements.append(attributeValue);
                inlineElements.append("\"");
            }
            String prefix = null;
            String nsuri = null;
            Enumeration prefixes = this.inlineDataNameSpace.keys();
            while (prefixes.hasMoreElements()) {
                prefix = (String)prefixes.nextElement();
                nsuri = (String)this.inlineDataNameSpace.get(prefix);
                inlineElements.append(" ");
                inlineElements.append("xmlns:");
                inlineElements.append(prefix);
                inlineElements.append("=\"");
                inlineElements.append(nsuri);
                inlineElements.append("\"");
            }
            inlineElements.append(">");
            this.inlineDataNameSpace = null;
            this.inlineDataNameSpace = new Hashtable();
            this.logMetacat.info((Object)("the inline element data is: " + inlineElements.toString()));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, inlineElements);
        }
    }

    @Override
    public void characters(char[] cbuf, int start, int len) throws SAXException {
        this.logMetacat.info((Object)"CHARACTERS");
        if (!this.handleInlineData) {
            this.textBuffer.append(new String(cbuf, start, len));
            this.hitTextNode = true;
            if (this.textBuffer.length() >= 4000) {
                this.logMetacat.info((Object)"Write text into DB in charaters when text buffer size is greater than maxmum number");
                DBSAXNode currentNode = (DBSAXNode)this.nodeStack.peek();
                this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, currentNode);
                if (this.needToCheckAccessModule && (this.processAdditionalAccess || this.processOtherAccess || this.processTopLevelAccess)) {
                    NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "TEXT", null, null, MetacatUtil.normalize(this.textBuffer.toString()));
                    this.storedAccessNodeStack.push(nodeElement);
                }
                this.textBuffer = null;
                this.textBuffer = new StringBuffer();
            }
        } else {
            StringBuffer inlineText = new StringBuffer();
            inlineText.append(new String(cbuf, start, len));
            this.logMetacat.info((Object)("The inline text data write into file system: " + inlineText.toString()));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, inlineText);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.logMetacat.info((Object)("End ELEMENT " + qName));
        if (localName.equals(INLINE) && this.handleInlineData) {
            DBSAXNode currentNode = (DBSAXNode)this.nodeStack.pop();
            String currentTag = currentNode.getTagName();
            this.logMetacat.info((Object)"End of inline data");
            try {
                this.inlineDataFileWriter.close();
                this.handleInlineData = false;
            }
            catch (IOException ioe) {
                throw new SAXException(ioe.getMessage());
            }
            if (this.unWritableInlineDataObject) {
                if (this.unReadableInlineDataObject) {
                    if (!this.inlineDataIsEmpty(this.inlineDataFileName)) {
                        this.logMetacat.info((Object)"inline data was changed by a user who doesn't have permission");
                        throw new SAXException(PERMISSIONERROR);
                    }
                    this.copyInlineFile(this.distributionId, this.inlineDataFileName);
                } else if (this.modifiedInlineData(this.distributionId, this.inlineDataFileName)) {
                    this.logMetacat.info((Object)"inline data was changed by a user who doesn't have permission");
                    throw new SAXException(PERMISSIONERROR);
                }
            } else if (this.unReadableInlineDataObject && this.inlineDataIsEmpty(this.inlineDataFileName)) {
                this.copyInlineFile(this.distributionId, this.inlineDataFileName);
            }
            this.textBuffer = new StringBuffer(this.inlineDataFileName);
            this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, currentNode);
            this.textBuffer = null;
            this.textBuffer = new StringBuffer();
            this.inlineDataFileName = null;
            this.unWritableInlineDataObject = false;
            this.unReadableInlineDataObject = false;
            return;
        }
        if (this.handleInlineData) {
            StringBuffer endElement = new StringBuffer();
            endElement.append("</");
            endElement.append(qName);
            endElement.append(">");
            this.logMetacat.info((Object)("inline endElement: " + endElement.toString()));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, endElement);
            return;
        }
        DBSAXNode currentNode = (DBSAXNode)this.nodeStack.pop();
        String currentTag = currentNode.getTagName();
        if (this.hitTextNode) {
            DBSAXNode parentNode;
            String data = null;
            if (currentTag.equals("principal") && this.accessRule != null) {
                data = this.textBuffer.toString().trim();
                this.accessRule.addPrincipal(data);
            } else if (currentTag.equals("permission") && this.accessRule != null) {
                data = this.textBuffer.toString().trim();
                int permission = this.accessRule.getPermission();
                if (data.toUpperCase().equals("READ")) {
                    permission |= 4;
                } else if (data.toUpperCase().equals("WRITE")) {
                    permission |= 2;
                } else if (data.toUpperCase().equals("CHANGEPERMISSION")) {
                    permission |= 1;
                } else if (data.toUpperCase().equals("ALL")) {
                    permission |= 7;
                }
                this.accessRule.setPermission(permission);
            } else if (currentTag.equals(DESCRIBES)) {
                data = this.textBuffer.toString().trim();
                this.describesId.add(data);
            } else if (currentTag.equals(REFERENCES) && (this.processTopLevelAccess || this.processAdditionalAccess || this.processOtherAccess)) {
                data = this.textBuffer.toString().trim();
                this.accessObject.setReferences(data);
            } else if (currentTag.equals(REFERENCES) && this.proccessDistribution) {
                data = this.textBuffer.toString().trim();
                if (this.distributionId != null) {
                    this.distributionReferenceList.put(this.distributionId, data);
                }
            } else if (currentTag.equals(URL) && !this.inAdditionalMetaData && (parentNode = (DBSAXNode)this.nodeStack.peek()) != null && parentNode.getTagName() != null && parentNode.getTagName().equals(ONLINE)) {
                data = this.textBuffer.toString().trim();
                if (this.distributionId != null) {
                    this.onlineURLDistributionIdList.put(this.distributionId, data);
                } else {
                    this.onlineURLDistributionListWithoutId.add(data);
                }
            }
            this.logMetacat.info((Object)"Write text into DB in End Element");
            this.endNodeId = this.writeTextForDBSAXNode(this.endNodeId, this.textBuffer, currentNode);
            if (this.needToCheckAccessModule && (this.processAdditionalAccess || this.processOtherAccess || this.processTopLevelAccess)) {
                NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "TEXT", null, null, MetacatUtil.normalize(this.textBuffer.toString()));
                this.storedAccessNodeStack.push(nodeElement);
            }
        }
        this.hitTextNode = false;
        this.textBuffer = null;
        this.textBuffer = new StringBuffer();
        if (currentTag.equals("allow") || currentTag.equals("deny")) {
            AccessRule newRule = this.accessRule;
            this.accessObject.addAccessRule(newRule);
            this.accessRule = null;
            return;
        }
        if (currentTag.equals("access")) {
            this.accessObject.setEndNodeId(this.endNodeId);
            AccessSection newAccessObject = this.accessObject;
            newAccessObject.setStoredTmpNodeStack(this.storedAccessNodeStack);
            if (newAccessObject != null) {
                if (this.processTopLevelAccess) {
                    this.topAccessSection = newAccessObject;
                } else if (this.processAdditionalAccess) {
                    newAccessObject.setDescribedIdList(this.describesId);
                    this.additionalAccessVector.add(newAccessObject);
                } else if (this.processOtherAccess && newAccessObject.getSubTreeId() != null && !newAccessObject.getSubTreeId().trim().equals("")) {
                    this.possibleReferencedAccessHash.put(newAccessObject.getSubTreeId(), newAccessObject);
                }
            }
            this.accessObject = null;
            this.storedAccessNodeStack = null;
            this.storedAccessNodeStack = new Stack();
            this.processAdditionalAccess = false;
            this.processTopLevelAccess = false;
            this.processOtherAccess = false;
            return;
        }
        if (currentTag.equals(ADDITIONALMETADATA)) {
            this.describesId = null;
            this.describesId = new Vector();
            this.inAdditionalMetaData = false;
            this.firstDescribesNodeId = -1L;
            this.storedAccessNodeStack = null;
            this.storedAccessNodeStack = new Stack();
            return;
        }
        if (currentTag.equals(DISTRIBUTION) && !this.inAdditionalMetaData) {
            this.distributionId = null;
            this.proccessDistribution = false;
            return;
        }
        if (currentTag.equals(OFFLINE) && !this.inAdditionalMetaData) {
            if (this.distributionId == null) return;
            this.offlineDistributionIdList.put(this.distributionId, this.distributionId);
            return;
        }
        if ((currentTag.equals(CONNECTION) || currentTag.equals(CONNECTIONDEFINITION)) && !this.inAdditionalMetaData) {
            DBSAXNode parentNode = (DBSAXNode)this.nodeStack.peek();
            if (parentNode == null) return;
            if (parentNode.getTagName() == null) return;
            if (!parentNode.getTagName().equals(ONLINE)) return;
            if (this.distributionId == null) return;
            this.onlineOtherDistributionIdList.put(this.distributionId, this.distributionId);
            return;
        }
        if (!currentTag.equals(DESCRIBES)) return;
        this.firstDescribesInAdditionalMetadata = false;
    }

    private boolean modifiedInlineData(String inlineDistributionId, String newInlineInternalFileName) throws SAXException {
        boolean modified = true;
        if (inlineDistributionId == null || newInlineInternalFileName == null) {
            return modified;
        }
        String oldInlineInternalFileName = (String)this.previousUnwritableInlineDataObjectHash.get(inlineDistributionId);
        if (oldInlineInternalFileName == null || oldInlineInternalFileName.trim().equals("")) {
            return modified;
        }
        this.logMetacat.info((Object)"in handle inline data");
        this.logMetacat.info((Object)("the inline data file name from xml_access is: " + oldInlineInternalFileName));
        try {
            modified = !this.compareInlineDataFiles(oldInlineInternalFileName, newInlineInternalFileName);
        }
        catch (Exception e) {
            modified = true;
        }
        if (modified) {
            this.deleteInlineDataFile(newInlineInternalFileName);
        }
        return modified;
    }

    private boolean inlineDataIsEmpty(String fileName) throws SAXException {
        boolean isEmpty = true;
        if (fileName == null) {
            throw new SAXException("The inline file name is null");
        }
        try {
            String path = PropertyService.getProperty("application.inlinedatafilepath");
            File inlineDataDirectory = new File(path);
            File inlineDataFile = new File(inlineDataDirectory, fileName);
            InputStreamReader inlineFileReader = new InputStreamReader((InputStream)new FileInputStream(inlineDataFile), this.encoding);
            BufferedReader inlineStringReader = new BufferedReader(inlineFileReader);
            String string = inlineStringReader.readLine();
            while (string != null) {
                string = inlineStringReader.readLine();
                if (string == null || string.trim().equals("")) continue;
                isEmpty = false;
                break;
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
        return isEmpty;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.logMetacat.info((Object)"COMMENT");
        if (!this.handleInlineData) {
            if (!this.processingDTD) {
                DBSAXNode currentNode = (DBSAXNode)this.nodeStack.peek();
                String str = new String(ch, start, length);
                if (!this.processTopLevelAccess || this.needToCheckAccessModule) {
                    // empty if block
                }
                this.endNodeId = currentNode.writeChildNodeToDB("COMMENT", null, str, this.docid);
                if (this.needToCheckAccessModule && (this.processAdditionalAccess || this.processOtherAccess || this.processTopLevelAccess)) {
                    NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "COMMENT", null, null, MetacatUtil.normalize(str));
                    this.storedAccessNodeStack.push(nodeElement);
                }
            }
        } else {
            StringBuffer inlineComment = new StringBuffer();
            inlineComment.append("<!--");
            inlineComment.append(new String(ch, start, length));
            inlineComment.append("-->");
            this.logMetacat.info((Object)("inline data comment: " + inlineComment.toString()));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, inlineComment);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.logMetacat.info((Object)"PI");
        if (!this.handleInlineData) {
            DBSAXNode currentNode = (DBSAXNode)this.nodeStack.peek();
            this.endNodeId = currentNode.writeChildNodeToDB("PI", target, data, this.docid);
        } else {
            StringBuffer inlinePI = new StringBuffer();
            inlinePI.append("<?");
            inlinePI.append(target);
            inlinePI.append(" ");
            inlinePI.append(data);
            inlinePI.append("?>");
            this.logMetacat.info((Object)("inline data pi is: " + inlinePI.toString()));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, inlinePI);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.logMetacat.info((Object)"NAMESPACE");
        this.logMetacat.info((Object)("NAMESPACE prefix " + prefix));
        this.logMetacat.info((Object)("NAMESPACE uri " + uri));
        if (!this.handleInlineData) {
            this.namespaces.put(prefix, uri);
        } else {
            this.inlineDataNameSpace.put(prefix, uri);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cbuf, int start, int len) throws SAXException {
        this.logMetacat.info((Object)"IGNORABLEWHITESPACE");
        if (!this.handleInlineData) {
            DBSAXNode currentNode = (DBSAXNode)this.nodeStack.peek();
            String data = new String(cbuf, start, len);
            if (!this.processTopLevelAccess || this.needToCheckAccessModule) {
                // empty if block
            }
            if (this.needToCheckAccessModule && (this.processAdditionalAccess || this.processOtherAccess || this.processTopLevelAccess)) {
                NodeRecord nodeElement = new NodeRecord(-2L, -2L, -2L, "TEXT", null, null, MetacatUtil.normalize(data));
                this.storedAccessNodeStack.push(nodeElement);
            }
            this.endNodeId = currentNode.writeChildNodeToDB("TEXT", null, data, this.docid);
        } else {
            StringBuffer inlineWhiteSpace = new StringBuffer(new String(cbuf, start, len));
            this.writeInlineDataIntoFile(this.inlineDataFileWriter, inlineWhiteSpace);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.logMetacat.info((Object)"end Document");
        if (this.needToCheckAccessModule) {
            this.compareAllAccessModules();
        }
        if (this.numberOfHitUnWritableInlineData != this.previousUnwritableInlineDataObjectHash.size()) {
            throw new SAXException("user deleted some inline block it couldn't");
        }
        if (!super.getIsRevisionDoc()) {
            if (this.writeAccessRules) {
                this.writeAccessRuleToDB();
            }
            this.deleteRelations();
            for (int i = 0; i < this.onlineDataFileIdInRelationVector.size(); ++i) {
                String id = (String)this.onlineDataFileIdInRelationVector.elementAt(i);
                this.writeOnlineDataFileIdIntoRelationTable(id);
            }
        }
        this.accessSubTreeAlreadyWriteDBList = new Hashtable();
    }

    private void compareAllAccessModules() throws SAXException {
        this.compareAccessSubtree(this.topAccessSubTreeFromDB, this.topAccessSection);
        int oldSize = this.additionalAccessSubTreeListFromDB.size();
        int newSize = this.additionalAccessVector.size();
        if (oldSize != newSize) {
            throw new SAXException(UPDATEACCESSERROR);
        }
        for (int i = 0; i < newSize; ++i) {
            AccessSection fromDB = (AccessSection)this.additionalAccessSubTreeListFromDB.elementAt(i);
            AccessSection fromParser = (AccessSection)this.additionalAccessVector.elementAt(i);
            this.compareAccessSubtree(fromDB, fromParser);
        }
        Enumeration em = this.referencedAccessSubTreeListFromDB.keys();
        while (em.hasMoreElements()) {
            String id = (String)em.nextElement();
            AccessSection fromDB = (AccessSection)this.referencedAccessSubTreeListFromDB.get(id);
            AccessSection fromParser = (AccessSection)this.possibleReferencedAccessHash.get(id);
            this.compareAccessSubtree(fromDB, fromParser);
        }
    }

    private void compareAccessSubtree(AccessSection fromDBTable, AccessSection fromParser) throws SAXException {
        if (fromDBTable == null || fromParser == null) {
            throw new SAXException(UPDATEACCESSERROR);
        }
        Stack<NodeRecord> nodeStackFromDBTable = fromDBTable.getSubTreeNodeStack();
        Stack<NodeRecord> nodeStackFromParser = fromParser.getStoredTmpNodeStack();
        Stack<NodeRecord> tempStack = new Stack<NodeRecord>();
        while (!nodeStackFromDBTable.isEmpty()) {
            tempStack.push(nodeStackFromDBTable.pop());
        }
        this.comparingNodeStacks(tempStack, nodeStackFromParser);
    }

    private void comparingNodeStacks(Stack stack1, Stack stack2) throws SAXException {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            this.logMetacat.info((Object)"Because stack is empty!");
            throw new SAXException(UPDATEACCESSERROR);
        }
        while (!stack1.isEmpty()) {
            NodeRecord record1 = (NodeRecord)stack1.pop();
            NodeRecord record2 = null;
            try {
                record2 = (NodeRecord)stack2.pop();
            }
            catch (EmptyStackException ee) {
                this.logMetacat.error((Object)"Node stack2 is empty but stack1 isn't!");
                throw new SAXException(UPDATEACCESSERROR);
            }
            if (record1.contentEquals(record2)) continue;
            this.logMetacat.info((Object)("Two records from new and old stack are not same!" + record1 + "--" + record2));
            throw new SAXException(UPDATEACCESSERROR);
        }
        if (!stack2.isEmpty()) {
            this.logMetacat.info((Object)"stack2 still have some elements while stack1 is empty! ");
            throw new SAXException(UPDATEACCESSERROR);
        }
    }

    private void writeAccessRuleToDB() throws SAXException {
        this.deleteAccessSubTreeRecord(this.docid);
        this.writeadditionalAccessRuleToDB();
        if (this.topAccessSection != null) {
            this.writeTopLevelAccessRuleToDB();
        }
    }

    private AccessSection resolveAccessRuleReference(AccessSection access) throws SAXException {
        String reference;
        if (access == null) {
            this.logMetacat.info((Object)"access module is null in resolveAccessRulesReference");
            throw new SAXException("An access modules is null");
        }
        String subTreeId = access.getSubTreeId();
        if (subTreeId == null || subTreeId != null && !this.accessSubTreeAlreadyWriteDBList.contains(subTreeId)) {
            this.writeAccessSubTreeIntoDB(access);
            if (subTreeId != null) {
                this.accessSubTreeAlreadyWriteDBList.put(subTreeId, subTreeId);
            }
        }
        if ((reference = access.getReferences()) != null) {
            String topSubtreeId = this.topAccessSection.getSubTreeId();
            if (topSubtreeId != null && topSubtreeId.equals(reference)) {
                return this.resolveAccessRuleReference(this.topAccessSection);
            }
            for (int i = 0; i < this.additionalAccessVector.size(); ++i) {
                AccessSection additionalAccess = (AccessSection)this.additionalAccessVector.elementAt(i);
                String additionId = additionalAccess.getSubTreeId();
                if (additionId == null || !additionId.equals(reference)) continue;
                return this.resolveAccessRuleReference(additionalAccess);
            }
            if (this.possibleReferencedAccessHash.containsKey(reference)) {
                AccessSection referenceAccess = (AccessSection)this.possibleReferencedAccessHash.get(reference);
                return this.resolveAccessRuleReference(referenceAccess);
            }
            throw new SAXException("No access module's id match the reference id");
        }
        AccessSection newAccessSection = new AccessSection();
        access.copyPermOrderAndAccessRules(newAccessSection);
        return newAccessSection;
    }

    private String resolveDistributionReference(String givenId) {
        if (givenId == null) {
            return null;
        }
        if (!this.distributionReferenceList.containsKey(givenId)) {
            return givenId;
        }
        String referencedId = (String)this.distributionReferenceList.get(givenId);
        while (this.distributionReferenceList.containsKey(referencedId)) {
            referencedId = (String)this.distributionReferenceList.get(referencedId);
        }
        return referencedId;
    }

    private void writeadditionalAccessRuleToDB() throws SAXException {
        if (!this.needToCheckAccessModule) {
            this.deleteAllInlineDataAccessRules();
        }
        for (int i = 0; i < this.additionalAccessVector.size(); ++i) {
            AccessSection access = (AccessSection)this.additionalAccessVector.elementAt(i);
            Vector<String> describeIdList = access.getDescribedIdList();
            AccessSection newAccess = this.resolveAccessRuleReference(access);
            String permOrder = newAccess.getPermissionOrder();
            if (permOrder.equals("denyFirst") && this.ignoreDenyFirst) {
                this.logMetacat.warn((Object)"Metacat no longer supports EML 'denyFirst' access rules - ignoring this access block");
                return;
            }
            Vector<AccessRule> accessRule = newAccess.getAccessRules();
            if (describeIdList == null || describeIdList.isEmpty()) continue;
            for (int j = 0; j < describeIdList.size(); ++j) {
                String subreeid = describeIdList.elementAt(j);
                this.logMetacat.info((Object)("describe id in additional access " + subreeid));
                subreeid = this.resolveDistributionReference(subreeid);
                if (subreeid == null || subreeid.trim().equals("")) continue;
                this.logMetacat.info((Object)("subtree id is " + subreeid + " after resolve reference id"));
                if (this.inlineDistributionIdList.containsKey(subreeid)) {
                    String inlineFileName = (String)this.inlineDistributionIdList.get(subreeid);
                    this.deleteSubtreeAccessRule(subreeid);
                    this.logMetacat.info((Object)("Write inline data access into xml_access table for" + inlineFileName));
                    this.writeGivenAccessRuleIntoDB(permOrder, accessRule, inlineFileName, subreeid);
                    String dataGuid = inlineFileName;
                    try {
                        String dataDocid = DocumentUtil.getDocIdFromAccessionNumber(inlineFileName);
                        int dataRev = DocumentUtil.getRevisionFromAccessionNumber(inlineFileName);
                        dataGuid = IdentifierManager.getInstance().getGUID(dataDocid, dataRev);
                    }
                    catch (McdbDocNotFoundException e) {
                        this.logMetacat.warn((Object)("No pid found for [assumed] data docid: " + inlineFileName));
                    }
                    this.guidsToSync.add(dataGuid);
                    continue;
                }
                if (!this.onlineURLDistributionIdList.containsKey(subreeid)) continue;
                String url = (String)this.onlineURLDistributionIdList.get(subreeid);
                String dataFileName = this.handleOnlineUrlDataFile(url);
                this.logMetacat.info((Object)("The data fileName in online url " + dataFileName));
                if (dataFileName == null) continue;
                this.deletePermissionsInAccessTableForDoc(dataFileName);
                this.writeGivenAccessRuleIntoDB(permOrder, accessRule, dataFileName, null);
                this.logMetacat.info((Object)("Write online data access into xml_access table for " + dataFileName));
                String dataGuid = dataFileName;
                try {
                    String dataDocid = DocumentUtil.getDocIdFromAccessionNumber(dataFileName);
                    int dataRev = DocumentUtil.getRevisionFromAccessionNumber(dataFileName);
                    dataGuid = IdentifierManager.getInstance().getGUID(dataDocid, dataRev);
                }
                catch (McdbDocNotFoundException e) {
                    this.logMetacat.warn((Object)("No pid found for [assumed] data docid: " + dataFileName));
                }
                this.guidsToSync.add(dataGuid);
                this.onlineURLIdHasadditionalAccess.put(subreeid, subreeid);
            }
        }
    }

    private void writeTopLevelAccessRuleToDB() throws SAXException {
        String url;
        String onlineDataId;
        AccessSection newAccess = this.resolveAccessRuleReference(this.topAccessSection);
        String permOrder = newAccess.getPermissionOrder();
        if (permOrder.equals("denyFirst") && this.ignoreDenyFirst) {
            this.logMetacat.warn((Object)"Metacat no longer supports EML 'denyFirst' access rules - ignoring this access block");
            return;
        }
        Vector<AccessRule> accessRule = newAccess.getAccessRules();
        String subtree = null;
        String guid = null;
        try {
            guid = IdentifierManager.getInstance().getGUID(this.docid, Integer.valueOf(this.revision));
        }
        catch (NumberFormatException e) {
            throw new SAXException(e.getMessage(), e);
        }
        catch (McdbDocNotFoundException e) {
            guid = this.docid + "." + this.revision;
            IdentifierManager.getInstance().createMapping(guid, guid);
        }
        this.deletePermissionsInAccessTableForDoc(guid);
        this.writeGivenAccessRuleIntoDB(permOrder, accessRule, guid, subtree);
        Enumeration em = this.onlineURLDistributionIdList.keys();
        while (em.hasMoreElements()) {
            String onlineSubtreeId = (String)em.nextElement();
            if (this.onlineURLIdHasadditionalAccess.containsKey(onlineSubtreeId) || (onlineDataId = this.handleOnlineUrlDataFile(url = (String)this.onlineURLDistributionIdList.get(onlineSubtreeId))) == null) continue;
            this.deletePermissionsInAccessTableForDoc(onlineDataId);
            this.writeGivenAccessRuleIntoDB(permOrder, accessRule, onlineDataId, subtree);
        }
        for (int i = 0; i < this.onlineURLDistributionListWithoutId.size(); ++i) {
            url = (String)this.onlineURLDistributionListWithoutId.elementAt(i);
            onlineDataId = this.handleOnlineUrlDataFile(url);
            if (onlineDataId == null) continue;
            this.deletePermissionsInAccessTableForDoc(onlineDataId);
            this.writeGivenAccessRuleIntoDB(permOrder, accessRule, onlineDataId, subtree);
        }
    }

    private void writeGivenAccessRuleIntoDB(String permOrder, Vector accessRules, String dataId, String subTreeId) throws SAXException {
        if (permOrder == null || permOrder.trim().equals("") || dataId == null || dataId.trim().equals("") || accessRules == null || accessRules.isEmpty()) {
            this.logMetacat.info((Object)"The access object is null and tried to  write to xml_access table");
            throw new SAXException("The access object is null");
        }
        String guid = null;
        try {
            guid = IdentifierManager.getInstance().getGUID(this.docid, Integer.valueOf(this.revision));
        }
        catch (NumberFormatException e) {
            throw new SAXException(e.getMessage(), e);
        }
        catch (McdbDocNotFoundException e) {
            guid = this.docid + "." + this.revision;
            IdentifierManager.getInstance().createMapping(guid, guid);
        }
        String sql = null;
        PreparedStatement pstmt = null;
        sql = "INSERT INTO xml_access (guid, principal_name, permission, perm_type, perm_order, accessfileid, subtreeid) VALUES  (?, ?, ?, ?, ?, ?, ?)";
        try {
            pstmt = this.connection.prepareStatement(sql);
            this.connection.increaseUsageCount(1);
            pstmt.setString(1, dataId);
            this.logMetacat.info((Object)("guid in accesstable: " + dataId));
            pstmt.setString(6, guid);
            this.logMetacat.info((Object)("Accessfileid in accesstable: " + guid));
            pstmt.setString(5, permOrder);
            this.logMetacat.info((Object)("PermOder in accesstable: " + permOrder));
            pstmt.setString(7, subTreeId);
            this.logMetacat.info((Object)("subtree id in accesstable: " + subTreeId));
            for (int i = 0; i < accessRules.size(); ++i) {
                AccessRule rule = (AccessRule)accessRules.elementAt(i);
                String permType = rule.getPermissionType();
                int permission = rule.getPermission();
                pstmt.setInt(3, permission);
                this.logMetacat.info((Object)("permission in accesstable: " + permission));
                pstmt.setString(4, permType);
                this.logMetacat.info((Object)("Permtype in accesstable: " + permType));
                Vector<String> nameVector = rule.getPrincipal();
                for (int j = 0; j < nameVector.size(); ++j) {
                    String prName = nameVector.elementAt(j);
                    pstmt.setString(2, prName);
                    this.logMetacat.info((Object)("Principal in accesstable: " + prName));
                    this.logMetacat.debug((Object)("running sql: " + pstmt.toString()));
                    pstmt.execute();
                }
            }
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.writeAccessRuletoDB(): " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.writeAccessRuletoDB(): " + ee.getMessage());
            }
        }
        HazelcastService.getInstance().refreshSystemMetadataEntry(guid);
        HazelcastService.getInstance().refreshSystemMetadataEntry(dataId);
    }

    private void deletePermissionsInAccessTableForDoc(String guid) throws SAXException {
        Statement pstmt = null;
        try {
            String sql = "DELETE FROM xml_access WHERE guid = ? ";
            pstmt = this.connection.prepareStatement(sql);
            pstmt.setString(1, guid);
            this.connection.increaseUsageCount(1);
            pstmt.execute();
        }
        catch (SQLException e) {
            throw new SAXException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException(ee.getMessage());
            }
        }
    }

    private void deleteSubtreeAccessRule(String subtreeid) throws SAXException {
        Statement pstmt = null;
        try {
            String sql = "DELETE FROM xml_access WHERE accessfileid IN (SELECT guid from identifier where docid = ? and rev = ?) AND subtreeid = ?";
            pstmt = this.connection.prepareStatement(sql);
            pstmt.setString(1, this.docid);
            pstmt.setInt(2, Integer.valueOf(this.revision));
            pstmt.setString(3, subtreeid);
            this.connection.increaseUsageCount(1);
            pstmt.execute();
        }
        catch (SQLException e) {
            throw new SAXException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException(ee.getMessage());
            }
        }
    }

    private void deleteAllInlineDataAccessRules() throws SAXException {
        Statement pstmt = null;
        try {
            String sql = "DELETE FROM xml_access WHERE accessfileid IN (SELECT guid from identifier where docid = ? and rev = ?) AND subtreeid IS NOT NULL";
            pstmt = this.connection.prepareStatement(sql);
            pstmt.setString(1, this.docid);
            pstmt.setInt(2, Integer.valueOf(this.revision));
            this.connection.increaseUsageCount(1);
            pstmt.execute();
        }
        catch (SQLException e) {
            throw new SAXException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException(ee.getMessage());
            }
        }
    }

    private void writeAccessSubTreeIntoDB(AccessSection accessSection) throws SAXException {
        if (accessSection == null) {
            this.logMetacat.info((Object)"Access object is null and tried to write into access subtree table");
            throw new SAXException("The access object is null to write access sbutree");
        }
        String sql = null;
        PreparedStatement pstmt = null;
        sql = "INSERT INTO xml_accesssubtree (docid, rev, controllevel, subtreeid, startnodeid, endnodeid) VALUES  (?, ?, ?, ?, ?, ?)";
        try {
            pstmt = this.connection.prepareStatement(sql);
            this.connection.increaseUsageCount(1);
            String level = accessSection.getControlLevel();
            long startNodeId = -1L;
            if (level != null && level.equals(DATAACCESSLEVEL)) {
                startNodeId = accessSection.getStartedDescribesNodeId();
                if (startNodeId == -1L) {
                    startNodeId = accessSection.getStartNodeId();
                }
            } else {
                startNodeId = accessSection.getStartNodeId();
            }
            long endNodeId = accessSection.getEndNodeId();
            String sectionId = accessSection.getSubTreeId();
            if (startNodeId == -1L || endNodeId == -1L) {
                throw new SAXException("Don't find start node or end node id for the access subtee");
            }
            pstmt.setString(1, this.docid);
            this.logMetacat.info((Object)("Docid in access-subtreetable: " + this.docid));
            pstmt.setInt(2, new Integer(this.revision));
            this.logMetacat.info((Object)("rev in accesssubtreetable: " + this.revision));
            pstmt.setString(3, level);
            this.logMetacat.info((Object)("contorl level in access-subtree table: " + level));
            pstmt.setString(4, sectionId);
            this.logMetacat.info((Object)("Subtree id in access-subtree table: " + sectionId));
            pstmt.setLong(5, startNodeId);
            this.logMetacat.info((Object)("Start node id is: " + startNodeId));
            pstmt.setLong(6, endNodeId);
            this.logMetacat.info((Object)("End node id is: " + endNodeId));
            this.logMetacat.debug((Object)("Eml200SAXHandler.writeAccessSubTreeIntoDB - executing SQL: " + pstmt.toString()));
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.writeAccessSubTreeIntoDB(): " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.writeAccessSubTreeIntoDB(): " + ee.getMessage());
            }
        }
    }

    private void deleteAccessSubTreeRecord(String docId) throws SAXException {
        Statement pstmt = null;
        try {
            String sql = "DELETE FROM xml_accesssubtree WHERE docid = ?";
            pstmt = this.connection.prepareStatement(sql);
            pstmt.setString(1, docId);
            this.connection.increaseUsageCount(1);
            this.logMetacat.debug((Object)("running sql: " + sql));
            pstmt.execute();
        }
        catch (SQLException e) {
            throw new SAXException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException(ee.getMessage());
            }
        }
    }

    private Writer createInlineDataFileWriter(String fileName, String encoding) throws SAXException {
        String path;
        OutputStreamWriter writer = null;
        try {
            path = PropertyService.getProperty("application.inlinedatafilepath");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new SAXException(pnfe.getMessage());
        }
        String newFile = path + "/" + fileName;
        this.logMetacat.info((Object)("inline file name: " + newFile));
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile, true), encoding);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe.getMessage());
        }
        return writer;
    }

    private void writeInlineDataIntoFile(Writer writer, StringBuffer data) throws SAXException {
        try {
            writer.write(data.toString());
            writer.flush();
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    public boolean compareInlineDataFiles(String oldFileName, String newFileName) throws McdbException {
        boolean same = true;
        String data = null;
        try {
            String path = PropertyService.getProperty("application.inlinedatafilepath");
            File inlineDataDirectory = new File(path);
            File oldDataFile = new File(inlineDataDirectory, oldFileName);
            File newDataFile = new File(inlineDataDirectory, newFileName);
            InputStreamReader oldFileReader = new InputStreamReader((InputStream)new FileInputStream(oldDataFile), this.encoding);
            BufferedReader oldStringReader = new BufferedReader(oldFileReader);
            InputStreamReader newFileReader = new InputStreamReader((InputStream)new FileInputStream(newDataFile), this.encoding);
            BufferedReader newStringReader = new BufferedReader(newFileReader);
            String oldString = oldStringReader.readLine();
            String newString = newStringReader.readLine();
            while (oldString != null) {
                oldString = oldStringReader.readLine();
                if (oldString.equals(newString = newStringReader.readLine())) continue;
                same = false;
                break;
            }
            if (same && newString != null) {
                same = false;
            }
        }
        catch (Exception e) {
            throw new McdbException(e.getMessage());
        }
        this.logMetacat.info((Object)("the inline data retrieve from file: " + data));
        return same;
    }

    public void copyInlineFile(String inlineDistributionId, String newFileName) throws SAXException {
        if (inlineDistributionId == null || newFileName == null) {
            throw new SAXException("Could not copy inline file from old one to new one!");
        }
        String oldInlineInternalFileName = (String)this.previousUnreadableInlineDataObjectHash.get(inlineDistributionId);
        if (oldInlineInternalFileName == null || oldInlineInternalFileName.trim().equals("")) {
            throw new SAXException("Could not copy inline file from old one to new one because can't find old file name");
        }
        this.logMetacat.info((Object)"in handle inline data");
        this.logMetacat.info((Object)("the inline data file name from xml_access is: " + oldInlineInternalFileName));
        InputStream oldFileReader = null;
        OutputStream newFileWriter = null;
        try {
            String path = PropertyService.getProperty("application.inlinedatafilepath");
            File inlineDataDirectory = new File(path);
            File oldDataFile = new File(inlineDataDirectory, oldInlineInternalFileName);
            File newDataFile = new File(inlineDataDirectory, newFileName);
            oldFileReader = new FileInputStream(oldDataFile);
            newFileWriter = new FileOutputStream(newDataFile);
            byte[] buf = new byte[4096];
            int b = oldFileReader.read(buf);
            while (b != -1) {
                newFileWriter.write(buf, 0, b);
                b = oldFileReader.read(buf);
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
        finally {
            if (oldFileReader != null) {
                try {
                    oldFileReader.close();
                }
                catch (Exception ee) {
                    throw new SAXException(ee.getMessage());
                }
            }
            if (newFileWriter != null) {
                try {
                    newFileWriter.close();
                }
                catch (Exception ee) {
                    throw new SAXException(ee.getMessage());
                }
            }
        }
    }

    public void deleteInlineFiles() throws SAXException {
        if (!this.inlineFileIDList.isEmpty()) {
            for (int i = 0; i < this.inlineFileIDList.size(); ++i) {
                String fileName = (String)this.inlineFileIDList.elementAt(i);
                this.deleteInlineDataFile(fileName);
            }
        }
    }

    private void deleteInlineDataFile(String fileName) throws SAXException {
        String path;
        try {
            path = PropertyService.getProperty("application.inlinedatafilepath");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new SAXException("Could not find inline data file path: " + pnfe.getMessage());
        }
        File inlineDataDirectory = new File(path);
        File newFile = new File(inlineDataDirectory, fileName);
        newFile.delete();
    }

    public static Reader readInlineDataFromFileSystem(String fileName, String encoding) throws McdbException {
        InputStreamReader fileReader = null;
        try {
            String path = PropertyService.getProperty("application.inlinedatafilepath");
            File inlineDataDirectory = new File(path);
            File dataFile = new File(inlineDataDirectory, fileName);
            fileReader = new InputStreamReader((InputStream)new FileInputStream(dataFile), encoding);
        }
        catch (Exception e) {
            throw new McdbException(e.getMessage());
        }
        return fileReader;
    }

    private void deleteRelations() throws SAXException {
        PreparedStatement pStmt = null;
        String sql = "DELETE FROM xml_relation where docid =?";
        try {
            pStmt = this.connection.prepareStatement(sql);
            pStmt.setString(1, this.docid);
            this.logMetacat.debug((Object)("Eml200SAXHandler.deleteRelations - executing SQL: " + pStmt.toString()));
            pStmt.execute();
            pStmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.deleteRelations(): " + e.getMessage());
        }
        finally {
            try {
                pStmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.deleteRelations: " + ee.getMessage());
            }
        }
    }

    private void writeOnlineDataFileIdIntoRelationTable(String dataId) throws SAXException {
        PreparedStatement pStmt = null;
        String sql = "INSERT into xml_relation (docid, packagetype, subject, relationship, object) values (?, ?, ?, ?, ?)";
        try {
            pStmt = this.connection.prepareStatement(sql);
            pStmt.setString(1, this.docid);
            pStmt.setString(2, this.doctype);
            pStmt.setString(3, this.docid);
            pStmt.setString(4, RELATION);
            pStmt.setString(5, dataId);
            this.logMetacat.debug((Object)("Eml200SAXHandler.writeOnlineDataFileIdIntoRelationTable - executing SQL: " + pStmt.toString()));
            pStmt.execute();
            pStmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("EMLSAXHandler.writeOnlineDataFileIdIntoRelationTable(): " + e.getMessage());
        }
        finally {
            try {
                pStmt.close();
            }
            catch (SQLException ee) {
                throw new SAXException("EMLSAXHandler.writeOnlineDataFileIdIntoRelationTable(): " + ee.getMessage());
            }
        }
    }

    private String handleOnlineUrlDataFile(String url) throws SAXException {
        this.logMetacat.warn((Object)("The url is " + url));
        String docid = null;
        String guid = null;
        String accessionNumber = DocumentUtil.getAccessionNumberFromEcogridIdentifier(url);
        int rev = 0;
        if (accessionNumber != null) {
            try {
                docid = DocumentUtil.getDocIdFromAccessionNumber(accessionNumber);
                rev = DocumentUtil.getRevisionFromAccessionNumber(accessionNumber);
            }
            catch (Exception e) {
                this.logMetacat.warn((Object)(e.getClass().getName() + " - Problem parsing accession number for: " + accessionNumber + ". Message: " + e.getMessage()));
                accessionNumber = null;
            }
        }
        if (accessionNumber != null) {
            try {
                guid = IdentifierManager.getInstance().getGUID(docid, rev);
            }
            catch (McdbDocNotFoundException e1) {
                guid = docid + "." + rev;
                IdentifierManager.getInstance().createMapping(guid, guid);
            }
            this.onlineDataFileIdInRelationVector.add(docid);
            try {
                String previousDocid;
                PermissionController controller;
                if (!AccessionNumber.accNumberUsed(docid)) {
                    return guid;
                }
                int previousRevision = rev;
                Vector<Integer> revisions = DBUtil.getRevListFromRevisionTable(docid);
                if (revisions != null && revisions.size() > 0) {
                    previousRevision = revisions.get(revisions.size() - 1);
                }
                if ((controller = new PermissionController(previousDocid = docid + PropertyService.getProperty("document.accNumSeparator") + previousRevision)).hasPermission(this.user, this.groups, "ALL") || controller.hasPermission(this.user, this.groups, "CHANGEPERMISSION")) {
                    return guid;
                }
                throw new SAXException("User: " + this.user + " does not have permission to update " + "access rules for data file " + guid);
            }
            catch (Exception e) {
                this.logMetacat.error((Object)("Error in Eml200SAXHanlder.handleOnlineUrlDataFile is " + e.getMessage()));
                throw new SAXException(e.getMessage());
            }
        }
        return guid;
    }

    private void compareElementNameSpaceAttributes(Stack unchangableNodeStack, Hashtable nameSpaces, Attributes attributes, String localName, String error) throws SAXException {
        NodeRecord elementNode = null;
        try {
            elementNode = (NodeRecord)unchangableNodeStack.pop();
        }
        catch (EmptyStackException ee) {
            this.logMetacat.error((Object)"Node stack is empty for element data");
            throw new SAXException(error);
        }
        this.logMetacat.info((Object)"current node type from xml is ELEMENT");
        this.logMetacat.info((Object)("node type from stack: " + elementNode.getNodeType()));
        this.logMetacat.info((Object)("node name from xml document: " + localName));
        this.logMetacat.info((Object)("node name from stack: " + elementNode.getNodeName()));
        this.logMetacat.info((Object)("node data from stack: " + elementNode.getNodeData()));
        this.logMetacat.info((Object)("node id is: " + elementNode.getNodeId()));
        if (!elementNode.getNodeType().equals("ELEMENT") || !localName.equals(elementNode.getNodeName())) {
            this.logMetacat.info((Object)"Inconsistence happend: ");
            this.logMetacat.info((Object)"current node type from xml is ELEMENT");
            this.logMetacat.info((Object)("node type from stack: " + elementNode.getNodeType()));
            this.logMetacat.info((Object)("node name from xml document: " + localName));
            this.logMetacat.info((Object)("node name from stack: " + elementNode.getNodeName()));
            this.logMetacat.info((Object)("node data from stack: " + elementNode.getNodeData()));
            this.logMetacat.info((Object)("node id is: " + elementNode.getNodeId()));
            throw new SAXException(error);
        }
        Enumeration nameEn = nameSpaces.keys();
        while (nameEn.hasMoreElements()) {
            NodeRecord nameNode = null;
            try {
                nameNode = (NodeRecord)unchangableNodeStack.pop();
            }
            catch (EmptyStackException ee) {
                this.logMetacat.error((Object)"Node stack is empty for namespace data");
                throw new SAXException(error);
            }
            String prefixName = (String)nameEn.nextElement();
            String nameSpaceUri = (String)nameSpaces.get(prefixName);
            if (nameNode.getNodeType().equals("NAMESPACE") && prefixName.equals(nameNode.getNodeName()) && nameSpaceUri.equals(nameNode.getNodeData())) continue;
            this.logMetacat.info((Object)"Inconsistence happend: ");
            this.logMetacat.info((Object)"current node type from xml is NAMESPACE");
            this.logMetacat.info((Object)("node type from stack: " + nameNode.getNodeType()));
            this.logMetacat.info((Object)("current node name from xml is: " + prefixName));
            this.logMetacat.info((Object)("node name from stack: " + nameNode.getNodeName()));
            this.logMetacat.info((Object)("current node data from xml is: " + nameSpaceUri));
            this.logMetacat.info((Object)("node data from stack: " + nameNode.getNodeData()));
            this.logMetacat.info((Object)("node id is: " + nameNode.getNodeId()));
            throw new SAXException(error);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            NodeRecord attriNode = null;
            try {
                attriNode = (NodeRecord)unchangableNodeStack.pop();
            }
            catch (EmptyStackException ee) {
                this.logMetacat.error((Object)"Node stack is empty for attribute data");
                throw new SAXException(error);
            }
            String attributeName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            this.logMetacat.info((Object)"current node type from xml is ATTRIBUTE ");
            this.logMetacat.info((Object)("node type from stack: " + attriNode.getNodeType()));
            this.logMetacat.info((Object)("current node name from xml is: " + attributeName));
            this.logMetacat.info((Object)("node name from stack: " + attriNode.getNodeName()));
            this.logMetacat.info((Object)("current node data from xml is: " + attributeValue));
            this.logMetacat.info((Object)("node data from stack: " + attriNode.getNodeData()));
            this.logMetacat.info((Object)("node id  is: " + attriNode.getNodeId()));
            if (attriNode.getNodeType().equals("ATTRIBUTE") && attributeName.equals(attriNode.getNodeName()) && attributeValue.equals(attriNode.getNodeData())) continue;
            this.logMetacat.info((Object)"Inconsistence happend: ");
            this.logMetacat.info((Object)"current node type from xml is ATTRIBUTE ");
            this.logMetacat.info((Object)("node type from stack: " + attriNode.getNodeType()));
            this.logMetacat.info((Object)("current node name from xml is: " + attributeName));
            this.logMetacat.info((Object)("node name from stack: " + attriNode.getNodeName()));
            this.logMetacat.info((Object)("current node data from xml is: " + attributeValue));
            this.logMetacat.info((Object)("node data from stack: " + attriNode.getNodeData()));
            this.logMetacat.info((Object)("node is: " + attriNode.getNodeId()));
            throw new SAXException(error);
        }
    }

    private void compareTextNode(Stack nodeStack, StringBuffer text, String error) throws SAXException {
        NodeRecord node = null;
        try {
            node = (NodeRecord)nodeStack.pop();
        }
        catch (EmptyStackException ee) {
            this.logMetacat.error((Object)"Node stack is empty for text data in startElement");
            throw new SAXException(error);
        }
        this.logMetacat.info((Object)"current node type from xml is TEXT in start element");
        this.logMetacat.info((Object)("node type from stack: " + node.getNodeType()));
        this.logMetacat.info((Object)("current node data from xml is: " + text.toString()));
        this.logMetacat.info((Object)("node data from stack: " + node.getNodeData()));
        this.logMetacat.info((Object)("node name from stack: " + node.getNodeName()));
        this.logMetacat.info((Object)("node is: " + node.getNodeId()));
        if (!node.getNodeType().equals("TEXT") || !text.toString().equals(node.getNodeData())) {
            this.logMetacat.info((Object)"Inconsistence happend: ");
            this.logMetacat.info((Object)"current node type from xml is TEXT in start element");
            this.logMetacat.info((Object)("node type from stack: " + node.getNodeType()));
            this.logMetacat.info((Object)("current node data from xml is: " + text.toString()));
            this.logMetacat.info((Object)("node data from stack: " + node.getNodeData()));
            this.logMetacat.info((Object)("node name from stack: " + node.getNodeName()));
            this.logMetacat.info((Object)("node is: " + node.getNodeId()));
            throw new SAXException(error);
        }
    }

    private void compareCommentNode(Stack nodeStack, String string, String error) throws SAXException {
        NodeRecord node = null;
        try {
            node = (NodeRecord)nodeStack.pop();
        }
        catch (EmptyStackException ee) {
            this.logMetacat.error((Object)"the stack is empty for comment data");
            throw new SAXException(error);
        }
        this.logMetacat.info((Object)"current node type from xml is COMMENT");
        this.logMetacat.info((Object)("node type from stack: " + node.getNodeType()));
        this.logMetacat.info((Object)("current node data from xml is: " + string));
        this.logMetacat.info((Object)("node data from stack: " + node.getNodeData()));
        this.logMetacat.info((Object)("node is from stack: " + node.getNodeId()));
        if (!node.getNodeType().equals("COMMENT") || !string.equals(node.getNodeData())) {
            this.logMetacat.info((Object)"Inconsistence happend: ");
            this.logMetacat.info((Object)"current node type from xml is COMMENT");
            this.logMetacat.info((Object)("node type from stack: " + node.getNodeType()));
            this.logMetacat.info((Object)("current node data from xml is: " + string));
            this.logMetacat.info((Object)("node data from stack: " + node.getNodeData()));
            this.logMetacat.info((Object)("node is from stack: " + node.getNodeId()));
            throw new SAXException(error);
        }
    }

    private void compareWhiteSpace(Stack nodeStack, String string, String error) throws SAXException {
        NodeRecord node = null;
        try {
            node = (NodeRecord)nodeStack.pop();
        }
        catch (EmptyStackException ee) {
            this.logMetacat.error((Object)"the stack is empty for whitespace data");
            throw new SAXException(error);
        }
        if (!node.getNodeType().equals("TEXT") || !string.equals(node.getNodeData())) {
            this.logMetacat.info((Object)"Inconsistence happend: ");
            this.logMetacat.info((Object)"current node type from xml is WHITESPACE TEXT");
            this.logMetacat.info((Object)("node type from stack: " + node.getNodeType()));
            this.logMetacat.info((Object)("current node data from xml is: " + string));
            this.logMetacat.info((Object)("node data from stack: " + node.getNodeData()));
            this.logMetacat.info((Object)("node is from stack: " + node.getNodeId()));
            throw new SAXException(error);
        }
    }
}

