/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import au.com.bytecode.opencsv.CSVWriter;
import edu.ucsb.nceas.metacat.AccessionNumberException;
import edu.ucsb.nceas.metacat.AuthSession;
import edu.ucsb.nceas.metacat.ContentTypeProvider;
import edu.ucsb.nceas.metacat.DBQuery;
import edu.ucsb.nceas.metacat.DBTransform;
import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DBValidate;
import edu.ucsb.nceas.metacat.DocumentIdQuery;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.DocumentImplWrapper;
import edu.ucsb.nceas.metacat.EventLog;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.MetacatResultSet;
import edu.ucsb.nceas.metacat.PermissionController;
import edu.ucsb.nceas.metacat.RemoteDocument;
import edu.ucsb.nceas.metacat.Sitemap;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlException;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlForSingleFile;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlList;
import edu.ucsb.nceas.metacat.cart.CartManager;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.common.query.EnabledQueryEngines;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.dataone.D1NodeService;
import edu.ucsb.nceas.metacat.dataone.SyncAccessPolicy;
import edu.ucsb.nceas.metacat.dataone.SystemMetadataFactory;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.dataquery.DataQuery;
import edu.ucsb.nceas.metacat.event.MetacatDocumentEvent;
import edu.ucsb.nceas.metacat.event.MetacatEventService;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.replication.ForceReplicationHandler;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.service.XMLSchemaService;
import edu.ucsb.nceas.metacat.shared.HandlerException;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.spatial.SpatialHarvester;
import edu.ucsb.nceas.metacat.spatial.SpatialQuery;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SessionData;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.LSIDUtil;
import edu.ucsb.nceas.utilities.ParseLSIDException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.ecoinformatics.eml.EMLParser;

public class MetacatHandler {
    private static boolean _sitemapScheduled = false;
    private static Logger logMetacat = Logger.getLogger(MetacatHandler.class);
    private static final String PROLOG = "<?xml version=\"1.0\"?>";
    private static final String SUCCESS = "<success>";
    private static final String SUCCESSCLOSE = "</success>";
    private static final String ERROR = "<error>";
    private static final String ERRORCLOSE = "</error>";
    public static final String FGDCDOCTYPE = "metadata";
    private Timer timer;

    public MetacatHandler(Timer timer) {
        this.timer = timer;
    }

    protected void handleDataquery(Hashtable<String, String[]> params, HttpServletResponse response, String sessionId) throws PropertyNotFoundException, IOException {
        DataQuery dq = null;
        dq = sessionId != null ? new DataQuery(sessionId) : new DataQuery();
        String dataqueryXML = params.get("dataquery")[0];
        ResultSet rs = null;
        try {
            rs = dq.executeQuery(dataqueryXML);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String qformat = "csv";
        String[] temp = params.get("qformat");
        if (temp != null && temp.length > 0) {
            qformat = temp[0];
        }
        String fileName = "query-results." + qformat;
        if (qformat != null && qformat.equalsIgnoreCase("csv")) {
            response.setContentType("text/csv");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream());
            CSVWriter csv = new CSVWriter((Writer)writer, ',', '\u0000');
            try {
                csv.writeAll(rs, true);
                csv.flush();
                response.flushBuffer();
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    protected void handleEditCart(Hashtable<String, String[]> params, HttpServletResponse response, String sessionId) throws PropertyNotFoundException, IOException {
        CartManager cm = null;
        cm = sessionId != null ? new CartManager(sessionId) : new CartManager();
        String editOperation = params.get("operation")[0];
        String[] docids = params.get("docid");
        String[] field = params.get("field");
        String[] path = params.get("path");
        HashMap<String, String> fields = null;
        if (field != null && path != null) {
            fields = new HashMap<String, String>();
            fields.put(field[0], path[0]);
        }
        cm.editCart(editOperation, docids, fields);
    }

    protected void handleSpatialQuery(Writer out, Hashtable<String, String[]> params, HttpServletResponse response, String username, String[] groupnames, String sess_id) throws PropertyNotFoundException, HandlerException {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        if (!PropertyService.getProperty("spatial.runSpatialOption").equals("true")) {
            response.setContentType("text/html");
            try {
                out.write("<html> Metacat Spatial Option is turned off </html>");
                out.close();
            }
            catch (IOException e) {
                throw new HandlerException(e.getMessage());
            }
            return;
        }
        float _xmax = Float.valueOf(params.get("xmax")[0]).floatValue();
        float _ymax = Float.valueOf(params.get("ymax")[0]).floatValue();
        float _xmin = Float.valueOf(params.get("xmin")[0]).floatValue();
        float _ymin = Float.valueOf(params.get("ymin")[0]).floatValue();
        SpatialQuery sq = new SpatialQuery();
        Vector<String> docids = sq.filterByBbox(_xmin, _ymin, _xmax, _ymax);
        String[] docidArray = new String[docids.size()];
        docids.toArray(docidArray);
        String squery = DocumentIdQuery.createDocidQuery(docidArray);
        String[] queryArray = new String[]{squery};
        params.put("query", queryArray);
        String[] qformatArray = new String[1];
        try {
            String _skin;
            qformatArray[0] = _skin = params.get("skin")[0];
        }
        catch (NullPointerException e) {
            logMetacat.warn((Object)"MetacatHandler.handleSpatialQuery - No SKIN specified for metacat actions=spatial_query... defaulting to 'knp' skin !\n");
            qformatArray[0] = "knp";
        }
        params.put("qformat", qformatArray);
        String[] actionArray = new String[]{"squery"};
        params.put("action", actionArray);
        if (docids.size() == 0) {
            docids.add("");
        }
        DBQuery queryobj = new DBQuery(docids);
        queryobj.findDocuments(response, out, params, username, groupnames, sess_id);
    }

    public void handleLoginAction(Writer out, Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        AuthSession sess = null;
        if (params.get("username") == null) {
            response.setContentType("text/xml");
            out.write(PROLOG);
            out.write(ERROR);
            out.write("Username not specified");
            out.write(ERRORCLOSE);
            return;
        }
        if (params.get("password") == null) {
            response.setContentType("text/xml");
            out.write(PROLOG);
            out.write(ERROR);
            out.write("Password not specified");
            out.write(ERRORCLOSE);
            return;
        }
        String un = params.get("username")[0];
        logMetacat.info((Object)("MetacatHandler.handleLoginAction - user " + un + " is trying to login"));
        String pw = params.get("password")[0];
        String qformat = "xml";
        if (params.get("qformat") != null) {
            qformat = params.get("qformat")[0];
        }
        try {
            sess = new AuthSession();
        }
        catch (Exception e) {
            String errorMsg = "MetacatServlet.handleLoginAction - Problem in MetacatServlet.handleLoginAction() authenicating session: " + e.getMessage();
            logMetacat.error((Object)errorMsg);
            out.write(errorMsg);
            e.printStackTrace(System.out);
            return;
        }
        boolean isValid = sess.authenticate(request, un, pw);
        if (isValid) {
            HttpSession session = sess.getSessions();
            String id = session.getId();
            logMetacat.debug((Object)("MetacatHandler.handleLoginAction - Store session id " + id + " which has username" + session.getAttribute("username") + " into hash in login method"));
            try {
                System.out.println("registering session with id " + id);
                System.out.println("username: " + (String)session.getAttribute("username"));
                SessionService.getInstance().registerSession(id, (String)session.getAttribute("username"), (String[])session.getAttribute("groupnames"), (String)session.getAttribute("password"), (String)session.getAttribute("name"));
            }
            catch (ServiceException se) {
                String errorMsg = "MetacatServlet.handleLoginAction - service problem registering session: " + se.getMessage();
                logMetacat.error((Object)("MetacatHandler.handleLoginAction - " + errorMsg));
                out.write(errorMsg);
                se.printStackTrace(System.out);
                return;
            }
        }
        if (qformat.equals("xml")) {
            response.setContentType("text/xml");
            out.write(sess.getMessage());
        } else {
            try {
                DBTransform trans = new DBTransform();
                response.setContentType("text/html");
                trans.transformXMLDocument(sess.getMessage(), "-//NCEAS//login//EN", "-//W3C//HTML//EN", qformat, out, null, null);
            }
            catch (Exception e) {
                logMetacat.error((Object)("MetacatHandler.handleLoginAction - General error" + e.getMessage()));
                e.printStackTrace(System.out);
            }
        }
    }

    public void handleLogoutAction(Writer out, Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        String qformat = "xml";
        if (params.get("qformat") != null) {
            qformat = params.get("qformat")[0];
        }
        HttpSession sess = request.getSession(false);
        logMetacat.info((Object)"MetacatHandler.handleLogoutAction - After get session in logout request");
        if (sess != null) {
            logMetacat.info((Object)("MetacatHandler.handleLogoutAction - The session id " + sess.getId() + " will be invalidate in logout action"));
            logMetacat.info((Object)("MetacatHandler.handleLogoutAction - The session contains user " + sess.getAttribute("username") + " will be invalidate in logout action"));
            sess.invalidate();
            SessionService.getInstance().unRegisterSession(sess.getId());
        }
        StringBuffer output = new StringBuffer();
        output.append(PROLOG);
        output.append("<logout>");
        output.append("User logged out");
        output.append("</logout>");
        if (qformat.equals("xml")) {
            response.setContentType("text/xml");
            out.write(output.toString());
        } else {
            try {
                DBTransform trans = new DBTransform();
                response.setContentType("text/html");
                trans.transformXMLDocument(output.toString(), "-//NCEAS//login//EN", "-//W3C//HTML//EN", qformat, out, null, null);
            }
            catch (Exception e) {
                logMetacat.error((Object)("MetacatHandler.handleLogoutAction - General error: " + e.getMessage()));
                e.printStackTrace(System.out);
            }
        }
    }

    protected void handleSQuery(Writer out, Hashtable<String, String[]> params, HttpServletResponse response, String user, String[] groups, String sessionid) throws PropertyNotFoundException {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        long squeryWarnLimit = Long.parseLong(PropertyService.getProperty("database.squeryTimeWarnLimit"));
        long startTime = System.currentTimeMillis();
        DBQuery queryobj = new DBQuery();
        queryobj.findDocuments(response, out, params, user, groups, sessionid);
        long outPutTime = System.currentTimeMillis();
        long runTime = outPutTime - startTime;
        if (runTime > squeryWarnLimit) {
            logMetacat.warn((Object)("MetacatHandler.handleSQuery - Long running squery.  Total time: " + runTime + " ms, squery: " + params.get("query")[0]));
        }
        logMetacat.debug((Object)("MetacatHandler.handleSQuery - squery: " + params.get("query")[0] + " ran in " + runTime + " ms"));
    }

    protected void handleQuery(Writer out, Hashtable<String, String[]> params, HttpServletResponse response, String user, String[] groups, String sessionid) throws PropertyNotFoundException, UnsupportedEncodingException, IOException {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        long queryWarnLimit = Long.parseLong(PropertyService.getProperty("database.queryTimeWarnLimit"));
        String xmlquery = DBQuery.createSQuery(params);
        String[] queryArray = new String[]{xmlquery};
        params.put("query", queryArray);
        long startTime = System.currentTimeMillis();
        DBQuery queryobj = new DBQuery();
        queryobj.findDocuments(response, out, params, user, groups, sessionid);
        long outPutTime = System.currentTimeMillis();
        long runTime = outPutTime - startTime;
        if (runTime > queryWarnLimit) {
            logMetacat.warn((Object)("MetacatHandler.handleQuery - Long running squery.  Total time: " + runTime + " ms, squery: " + params.get("query")[0]));
        }
        logMetacat.debug((Object)("MetacatHandler.handleQuery - query: " + params.get("query")[0] + " ran in " + runTime + " ms"));
    }

    protected void handleExportAction(Hashtable<String, String[]> params, HttpServletResponse response, String user, String[] groups, String passWord) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        ServletOutputStream out = null;
        ZipOutputStream zOut = null;
        DBQuery queryObj = null;
        String[] docs = new String[10];
        String docId = "";
        try {
            if (params.containsKey("docid")) {
                docs = params.get("docid");
            }
            queryObj = new DBQuery();
            String qformat = null;
            if (params.containsKey("qformat")) {
                qformat = params.get("qformat")[0];
                queryObj.setQformat(qformat);
            }
            if ((docId = docs[0]) == null || docId.equals("")) {
                response.setContentType("text/xml");
                PrintWriter pw = response.getWriter();
                pw.println(PROLOG);
                pw.println(ERROR);
                pw.println("You didn't specify requested docid");
                pw.println(ERRORCLOSE);
                pw.close();
                return;
            }
            response.setContentType("application/zip");
            response.setHeader("Content-Disposition", "attachment; filename=" + docId + ".zip");
            out = response.getOutputStream();
            zOut = new ZipOutputStream((OutputStream)out);
            zOut = queryObj.getZippedPackage(docId, out, user, groups, passWord);
            zOut.finish();
            zOut.close();
        }
        catch (Exception e) {
            try {
                response.setContentType("text/xml");
                if (out != null) {
                    PrintWriter pw = new PrintWriter((OutputStream)out);
                    pw.println(PROLOG);
                    pw.println(ERROR);
                    pw.println(e.getMessage());
                    pw.println(ERRORCLOSE);
                    pw.close();
                    out.close();
                }
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (IOException ioe) {
                logMetacat.error((Object)("MetacatHandler.handleExportAction - Problem with the servlet output: " + ioe.getMessage()));
                e.printStackTrace(System.out);
            }
            logMetacat.error((Object)("MetacatHandler.handleExportAction - General error: " + e.getMessage()));
            e.printStackTrace(System.out);
        }
    }

    protected void handleReadInlineDataAction(Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response, String user, String passWord, String[] groups) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        String[] docs = new String[10];
        String inlineDataId = null;
        String docId = "";
        ServletOutputStream out = null;
        try {
            if (params.containsKey("inlinedataid")) {
                docs = params.get("inlinedataid");
            }
            if ((inlineDataId = docs[0]) == null || inlineDataId.equals("")) {
                throw new Exception("You didn't specify requested inlinedataid");
            }
            docId = DocumentUtil.getDocIdFromInlineDataID(inlineDataId);
            PermissionController controller = new PermissionController(docId);
            if (!controller.hasPermission(user, groups, "READ")) {
                throw new Exception("User " + user + " doesn't have permission " + " to read document " + docId);
            }
            Hashtable<String, String> unReadableInlineDataList = PermissionController.getUnReadableInlineDataIdList(docId, user, groups);
            if (unReadableInlineDataList.containsValue(inlineDataId)) {
                throw new Exception("User " + user + " doesn't have permission " + " to read inlinedata " + inlineDataId);
            }
            out = response.getOutputStream();
            String inlinePath = PropertyService.getProperty("application.inlinedatafilepath");
            File lineData = new File(inlinePath, inlineDataId);
            FileInputStream input = new FileInputStream(lineData);
            byte[] buffer = new byte[4096];
            int bytes = input.read(buffer);
            while (bytes != -1) {
                out.write(buffer, 0, bytes);
                bytes = input.read(buffer);
            }
            out.close();
            EventLog.getInstance().log(request.getRemoteAddr(), request.getHeader("User-Agent"), user, inlineDataId, "readinlinedata");
        }
        catch (Exception e) {
            try {
                PrintWriter pw = null;
                pw = out != null ? new PrintWriter((OutputStream)out) : response.getWriter();
                pw.println(PROLOG);
                pw.println(ERROR);
                pw.println(e.getMessage());
                pw.println(ERRORCLOSE);
                pw.close();
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                logMetacat.error((Object)("MetacatHandler.handleReadInlineDataAction - Problem with the servlet output: " + ioe.getMessage()));
                e.printStackTrace(System.out);
            }
            logMetacat.error((Object)("MetacatHandler.handleReadInlineDataAction - General error: " + e.getMessage()));
            e.printStackTrace(System.out);
        }
    }

    public void handleReadAction(Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response, String user, String passWord, String[] groups) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        ServletOutputStream out = null;
        ZipOutputStream zout = null;
        PrintWriter pw = null;
        boolean zip = false;
        boolean withInlineData = true;
        try {
            int i;
            String[] docs = new String[]{};
            String docid = "";
            String qformat = "";
            if (params.containsKey("docid")) {
                docs = params.get("docid");
            }
            if (params.containsKey("qformat")) {
                qformat = params.get("qformat")[0];
            }
            if (params.containsKey("pid")) {
                docs = params.get("pid");
                for (i = 0; i < docs.length; ++i) {
                    String localId;
                    String pid = docs[i];
                    docs[i] = localId = IdentifierManager.getInstance().getLocalId(pid);
                }
                params.put("docid", docs);
            }
            if (docs.length > 1 || qformat.equals("zip")) {
                zip = true;
                out = response.getOutputStream();
                response.setContentType("application/zip");
                zout = new ZipOutputStream((OutputStream)out);
            }
            for (i = 0; i < docs.length; ++i) {
                String providedFileName = null;
                if (params.containsKey(docs[i])) {
                    providedFileName = params.get(docs[i])[0];
                }
                try {
                    URL murl = new URL(docs[i]);
                    Hashtable<String, String> murlQueryStr = MetacatUtil.parseQuery(murl.getQuery());
                    if (murlQueryStr.containsKey("docid")) {
                        docid = murlQueryStr.get("docid");
                        if (zip) {
                            this.addDocToZip(request, docid, providedFileName, zout, user, groups);
                            continue;
                        }
                        this.readFromMetacat(request.getRemoteAddr(), request.getHeader("User-Agent"), response, (OutputStream)response.getOutputStream(), docid, qformat, user, groups, withInlineData, params);
                        continue;
                    }
                    docid = docs[i];
                    if (zip) {
                        this.addDocToZip(request, docid, providedFileName, zout, user, groups);
                        continue;
                    }
                    this.readFromURLConnection(response, docid);
                    continue;
                }
                catch (MalformedURLException mue) {
                    docid = docs[i];
                    if (zip) {
                        this.addDocToZip(request, docid, providedFileName, zout, user, groups);
                        continue;
                    }
                    if (out == null) {
                        out = response.getOutputStream();
                    }
                    this.readFromMetacat(request.getRemoteAddr(), request.getHeader("User-Agent"), response, (OutputStream)out, docid, qformat, user, groups, withInlineData, params);
                }
            }
            if (zip) {
                zout.finish();
                zout.close();
            }
        }
        catch (McdbDocNotFoundException notFoundE) {
            String notFoundDocId = notFoundE.getUnfoundDocId();
            String notFoundRevision = notFoundE.getUnfoundRevision();
            logMetacat.warn((Object)("MetacatHandler.handleReadAction - Missed id: " + notFoundDocId));
            logMetacat.warn((Object)("MetacatHandler.handleReadAction - Missed rev: " + notFoundRevision));
            try {
                this.readFromRemoteMetaCat(response, notFoundDocId, notFoundRevision, user, passWord, out, zip, zout);
                if (zout != null) {
                    zout.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exc) {
                logMetacat.error((Object)("MetacatHandler.handleReadAction - General error: " + exc.getMessage()));
                exc.printStackTrace(System.out);
                try {
                    if (out != null) {
                        response.setContentType("text/xml");
                        pw = new PrintWriter((OutputStream)out);
                        pw.println(PROLOG);
                        pw.println(ERROR);
                        pw.println(notFoundE.getMessage());
                        pw.println(ERRORCLOSE);
                        pw.close();
                        out.close();
                    } else {
                        response.setContentType("text/xml");
                        if (pw == null) {
                            pw = response.getWriter();
                        }
                        pw.println(PROLOG);
                        pw.println(ERROR);
                        pw.println(notFoundE.getMessage());
                        pw.println(ERRORCLOSE);
                        pw.close();
                    }
                    if (zout != null) {
                        zout.close();
                    }
                }
                catch (IOException ie) {
                    logMetacat.error((Object)("MetacatHandler.handleReadAction - Problem with the servlet output: " + ie.getMessage()));
                    ie.printStackTrace(System.out);
                }
            }
        }
        catch (Exception e) {
            try {
                if (out != null) {
                    response.setContentType("text/xml");
                    pw = new PrintWriter((OutputStream)out);
                    pw.println(PROLOG);
                    pw.println(ERROR);
                    pw.println(e.getMessage());
                    pw.println(ERRORCLOSE);
                    pw.close();
                    out.close();
                } else {
                    response.setContentType("text/xml");
                    if (pw == null) {
                        pw = response.getWriter();
                    }
                    pw.println(PROLOG);
                    pw.println(ERROR);
                    pw.println(e.getMessage());
                    pw.println(ERRORCLOSE);
                    pw.close();
                }
                if (zout != null) {
                    zout.close();
                }
            }
            catch (Exception e2) {
                logMetacat.error((Object)("MetacatHandler.handleReadAction - Problem with the servlet output: " + e2.getMessage()));
                e2.printStackTrace(System.out);
            }
            logMetacat.error((Object)("MetacatHandler.handleReadAction - General error: " + e.getMessage()));
            e.printStackTrace(System.out);
        }
    }

    public MetacatResultSet query(String metacatUrl, Hashtable<String, String[]> params, String username, String[] groups, String sessionid) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        this.handleQuery(out, params, null, username, groups, sessionid);
        ((Writer)out).flush();
        baos.flush();
        MetacatResultSet rs = new MetacatResultSet(baos.toString("UTF-8"));
        return rs;
    }

    public void setAccess(String metacatUrl, String username, String docid, String principal, String permission, String permissionType, String permissionOrder) throws Exception {
        Hashtable<String, String[]> params = new Hashtable<String, String[]>();
        params.put("principal", new String[]{principal});
        params.put("permission", new String[]{permission});
        params.put("permType", new String[]{permissionType});
        params.put("permOrder", new String[]{permissionOrder});
        params.put("docid", new String[]{docid});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        this.handleSetAccessAction(out, params, username, null, null);
        String resp = baos.toString();
    }

    public static InputStream read(String docid) throws ParseLSIDException, PropertyNotFoundException, McdbException, SQLException, ClassNotFoundException, IOException {
        DocumentImpl doc;
        logMetacat.debug((Object)"MetacatHandler.read() called.");
        InputStream inputStream = null;
        if (docid.startsWith("urn:")) {
            try {
                docid = LSIDUtil.getDocId((String)docid, (boolean)true);
            }
            catch (ParseLSIDException ple) {
                logMetacat.debug((Object)("There was a problem parsing the LSID. The error message was: " + ple.getMessage()));
                throw ple;
            }
        }
        if ((doc = new DocumentImpl(docid = DocumentUtil.appendRev(docid), false)).getRootNodeID() == 0L) {
            try {
                String filepath = PropertyService.getProperty("application.datafilepath");
                if (!filepath.endsWith("/")) {
                    filepath = filepath + "/";
                }
                String filename = filepath + docid;
                inputStream = MetacatHandler.readFromFilesystem(filename);
            }
            catch (PropertyNotFoundException pnf) {
                logMetacat.debug((Object)("There was a problem finding the application.datafilepath property. The error message was: " + pnf.getMessage()));
                throw pnf;
            }
        }
        try {
            OutputStream nout = null;
            inputStream = doc.toXml(nout, null, null, true);
        }
        catch (McdbException e) {
            logMetacat.error((Object)("MetacatHandler.readFromMetacat() - could not read document " + docid + ": " + e.getMessage()), (Throwable)e);
        }
        return inputStream;
    }

    private static FileInputStream readFromFilesystem(String filename) throws FileNotFoundException {
        logMetacat.debug((Object)"MetacatHandler.readFromFilesystem() called.");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filename);
        }
        catch (FileNotFoundException fnfe) {
            logMetacat.debug((Object)("There was an error reading the file " + filename + ". The error was: " + fnfe.getMessage()));
            throw fnfe;
        }
        return fileInputStream;
    }

    private void deleteFromMetacat(PrintWriter out, HttpServletRequest request, HttpServletResponse response, String docid, String user, String[] groups) throws McdbDocNotFoundException {
        try {
            DocumentImpl.delete(docid, user, groups, null, false);
            EventLog.getInstance().log(request.getRemoteAddr(), request.getHeader("User-Agent"), user, docid, "delete");
            response.setContentType("text/xml");
            out.println(PROLOG);
            out.println(SUCCESS);
            out.println("Document deleted.");
            out.println(SUCCESSCLOSE);
            logMetacat.info((Object)"MetacatHandler.handleDeleteAction - Document deleted.");
            try {
                if (PropertyService.getProperty("spatial.runSpatialOption").equals("true")) {
                    SpatialHarvester sh = new SpatialHarvester();
                    sh.addToDeleteQue(DocumentUtil.getSmartDocId(docid));
                    sh.destroy();
                }
            }
            catch (PropertyNotFoundException pnfe) {
                logMetacat.error((Object)"MetacatHandler.deleteFromMetacat() - Couldn't find spatial.runSpatialOption property during document deletion.");
            }
        }
        catch (AccessionNumberException ane) {
            response.setContentType("text/xml");
            out.println(PROLOG);
            out.println(ERROR);
            out.println(ane.getMessage());
            out.println(ERRORCLOSE);
            logMetacat.error((Object)("MetacatHandler.deleteFromMetacat() - Document could not be deleted: " + ane.getMessage()));
            ane.printStackTrace(System.out);
        }
        catch (SQLException sqle) {
            response.setContentType("text/xml");
            out.println(PROLOG);
            out.println(ERROR);
            out.println(sqle.getMessage());
            out.println(ERRORCLOSE);
            logMetacat.error((Object)("MetacatHandler.deleteFromMetacat() - Document could not be deleted: " + sqle.getMessage()));
            sqle.printStackTrace(System.out);
        }
        catch (McdbDocNotFoundException dnfe) {
            throw dnfe;
        }
        catch (InsufficientKarmaException ike) {
            response.setContentType("text/xml");
            out.println(PROLOG);
            out.println(ERROR);
            out.println(ike.getMessage());
            out.println(ERRORCLOSE);
            logMetacat.error((Object)("MetacatHandler.deleteFromMetacat() - Document could not be deleted: " + ike.getMessage()));
            ike.printStackTrace(System.out);
        }
        catch (Exception e) {
            response.setContentType("text/xml");
            out.println(PROLOG);
            out.println(ERROR);
            out.println(e.getMessage());
            out.println(ERRORCLOSE);
            logMetacat.error((Object)("MetacatHandler.deleteFromMetacat() - Document could not be deleted: " + e.getMessage()));
            e.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromMetacat(String ipAddress, String userAgent, HttpServletResponse response, OutputStream out, String docid, String qformat, String user, String[] groups, boolean withInlineData, Hashtable<String, String[]> params) throws ClassNotFoundException, IOException, SQLException, McdbException, PropertyNotFoundException, ParseLSIDException, InsufficientKarmaException {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        if (docid.startsWith("urn:")) {
            docid = LSIDUtil.getDocId((String)docid, (boolean)true);
        }
        docid = DocumentUtil.appendRev(docid);
        DocumentImpl doc = new DocumentImpl(docid, false);
        if (!DocumentImpl.hasReadPermission(user, groups, docid)) {
            InsufficientKarmaException e = new InsufficientKarmaException("User " + user + " does not have permission" + " to read the document with the docid " + docid);
            throw e;
        }
        if (doc.getRootNodeID() == 0L) {
            String filepath = PropertyService.getProperty("application.datafilepath");
            if (!filepath.endsWith("/")) {
                filepath = filepath + "/";
            }
            String filename = filepath + docid;
            FileInputStream fin = null;
            fin = new FileInputStream(filename);
            if (response != null) {
                String contentType = new MimetypesFileTypeMap().getContentType(filename);
                if (contentType == null) {
                    ContentTypeProvider provider = new ContentTypeProvider(docid);
                    contentType = provider.getContentType();
                    logMetacat.info((Object)("MetacatHandler.readFromMetacat - Final contenttype is: " + contentType));
                }
                response.setContentType(contentType);
                String outputname = this.generateOutputName(docid, params, doc);
                response.setHeader("Content-Disposition", "attachment; filename=\"" + outputname + "\"");
            }
            try {
                byte[] buf = new byte[4096];
                int b = fin.read(buf);
                while (b != -1) {
                    out.write(buf, 0, b);
                    b = fin.read(buf);
                }
                fin.close();
            }
            finally {
                IOUtils.closeQuietly((InputStream)fin);
            }
        } else if (qformat.equals("xml") || qformat.equals("")) {
            if (response != null) {
                response.setContentType("text/xml");
                response.setHeader("Content-Disposition", "attachment; filename=" + docid + ".xml");
            }
            try {
                doc.toXml(out, user, groups, withInlineData);
            }
            catch (McdbException e) {
                logMetacat.error((Object)("MetacatHandler.readFromMetacat - could not read from document file " + docid + ": " + e.getMessage()));
                e.printStackTrace(System.out);
                doc.toXmlFromDb(out, user, groups, withInlineData);
            }
        } else {
            logMetacat.debug((Object)("User: \n" + user));
            if (!user.equals("public")) {
                if (DocumentImpl.hasReadPermission("public", null, docid)) {
                    params.put("publicRead", new String[]{"true"});
                } else {
                    params.put("publicRead", new String[]{"false"});
                }
            }
            if (doc.getDoctype() != null && doc.getDoctype().equals(FGDCDOCTYPE)) {
                PermissionController controller = new PermissionController(docid);
                if (controller.hasPermission(user, groups, "WRITE")) {
                    params.put("enableFGDCediting", new String[]{"true"});
                } else {
                    params.put("enableFGDCediting", new String[]{"false"});
                }
            }
            if (response != null) {
                response.setContentType("text/html");
            }
            String docString = doc.toString(user, groups, withInlineData);
            XmlStreamReader xsr = new XmlStreamReader((InputStream)new ByteArrayInputStream(doc.getBytes()));
            String encoding = xsr.getEncoding();
            OutputStreamWriter w = null;
            w = encoding != null ? new OutputStreamWriter(out, encoding) : new OutputStreamWriter(out);
            String doctype = doc.getDoctype();
            DBTransform dbt = new DBTransform();
            dbt.transformXMLDocument(docString, doctype, "-//W3C//HTML//EN", qformat, w, params, null);
        }
        EventLog.getInstance().log(ipAddress, userAgent, user, docid, "read");
    }

    private String generateOutputName(String docid, Hashtable<String, String[]> params, DocumentImpl doc) {
        String outputname = null;
        String metadatadocid = null;
        Vector<String> nameparts = new Vector<String>();
        if (params.containsKey("metadatadocid")) {
            metadatadocid = params.get("metadatadocid")[0];
        }
        if (metadatadocid != null && !metadatadocid.equals("")) {
            nameparts.add(metadatadocid);
        }
        String doctype = doc.getDoctype();
        nameparts.add(docid);
        String docname = doc.getDocname();
        if (docname != null && !docname.equals("")) {
            nameparts.add(docname);
        }
        String delimiter = "-";
        Iterator iter = nameparts.iterator();
        StringBuffer buffer = new StringBuffer((String)iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append((String)iter.next());
        }
        outputname = buffer.toString();
        return outputname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromURLConnection(HttpServletResponse response, String docid) throws IOException, MalformedURLException {
        ServletOutputStream out = response.getOutputStream();
        String contentType = new MimetypesFileTypeMap().getContentType(docid);
        if (contentType == null) {
            File f;
            contentType = docid.endsWith(".xml") ? "text/xml" : (docid.endsWith(".css") ? "text/css" : (docid.endsWith(".dtd") ? "text/plain" : (docid.endsWith(".xsd") ? "text/xml" : (docid.endsWith("/") ? "text/html" : ((f = new File(docid)).isDirectory() ? "text/html" : "application/octet-stream")))));
        }
        response.setContentType(contentType);
        URL url = new URL(docid);
        try (BufferedInputStream bis = null;){
            bis = new BufferedInputStream(url.openStream());
            byte[] buf = new byte[4096];
            int b = bis.read(buf);
            while (b != -1) {
                out.write(buf, 0, b);
                b = bis.read(buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocToZip(HttpServletRequest request, String docid, String providedFileName, ZipOutputStream zout, String user, String[] groups) throws ClassNotFoundException, IOException, SQLException, McdbException, Exception {
        byte[] bytestring = null;
        ZipEntry zentry = null;
        try {
            URL url = new URL(docid);
            zentry = providedFileName != null && providedFileName.length() > 1 ? new ZipEntry(providedFileName) : new ZipEntry(docid);
            zout.putNextEntry(zentry);
            try (BufferedInputStream bis = null;){
                bis = new BufferedInputStream(url.openStream());
                byte[] buf = new byte[4096];
                int b = bis.read(buf);
                while (b != -1) {
                    zout.write(buf, 0, b);
                    b = bis.read(buf);
                }
            }
            zout.closeEntry();
        }
        catch (MalformedURLException mue) {
            DocumentImpl doc = new DocumentImpl(docid, false);
            if (!DocumentImpl.hasReadPermission(user, groups, docid)) {
                Exception e = new Exception("User " + user + " does not have " + "permission to read the document with the docid " + docid);
                throw e;
            }
            if (doc.getRootNodeID() == 0L) {
                String filepath = PropertyService.getProperty("application.datafilepath");
                if (!filepath.endsWith("/")) {
                    filepath = filepath + "/";
                }
                String filename = filepath + docid;
                FileInputStream fin = null;
                fin = new FileInputStream(filename);
                try {
                    zentry = providedFileName != null && providedFileName.length() > 1 ? new ZipEntry(providedFileName) : new ZipEntry(docid);
                    zout.putNextEntry(zentry);
                    byte[] buf = new byte[4096];
                    int b = fin.read(buf);
                    while (b != -1) {
                        zout.write(buf, 0, b);
                        b = fin.read(buf);
                    }
                    fin.close();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)fin);
                }
                zout.closeEntry();
            } else {
                bytestring = doc.getBytes();
                zentry = providedFileName != null && providedFileName.length() > 1 ? new ZipEntry(providedFileName) : new ZipEntry(docid + ".xml");
                zentry.setSize(bytestring.length);
                zout.putNextEntry(zentry);
                zout.write(bytestring, 0, bytestring.length);
                zout.closeEntry();
            }
            EventLog.getInstance().log(request.getRemoteAddr(), request.getHeader("User-Agent"), user, docid, "read");
        }
    }

    private void readFromRemoteMetaCat(HttpServletResponse response, String docid, String rev, String user, String password, ServletOutputStream out, boolean zip, ZipOutputStream zout) throws Exception {
        RemoteDocument remoteDoc = new RemoteDocument(docid, rev, user, password, "");
        String docType = remoteDoc.getDocType();
        if (docType.equals("BIN")) {
            if (zip) {
                remoteDoc.readDocumentFromRemoteServerByZip(zout);
            } else {
                if (out == null) {
                    out = response.getOutputStream();
                }
                response.setContentType("application/octet-stream");
                remoteDoc.readDocumentFromRemoteServer(out);
            }
        } else {
            throw new Exception("Docid: " + docid + "." + rev + " couldn't find");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String handleInsertOrUpdateAction(String ipAddress, String userAgent, HttpServletResponse response, PrintWriter out, Hashtable<String, String[]> params, String user, String[] groups, boolean generateSystemMetadata, boolean writeAccessRules, byte[] xmlBytes, String formatId) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        DBConnection dbConn = null;
        int serialNumber = -1;
        String output = "";
        String qformat = null;
        if (params.containsKey("qformat")) {
            qformat = params.get("qformat")[0];
        }
        if (params.get("docid") == null) {
            String msg = PROLOG + ERROR + "Docid not specified" + ERRORCLOSE;
            if (out == null) return msg;
            out.println(msg);
            logMetacat.error((Object)"MetacatHandler.handleInsertOrUpdateAction - Docid not specified");
            return msg;
        }
        try {
            if (!AuthUtil.canInsertOrUpdate(user, groups)) {
                String msg = PROLOG + ERROR + "User '" + user + "' not allowed to insert and update" + ERRORCLOSE;
                if (out != null) {
                    out.println(msg);
                }
                logMetacat.error((Object)("MetacatHandler.handleInsertOrUpdateAction - User '" + user + "' not allowed to insert and update"));
                return msg;
            }
        }
        catch (MetacatUtilException ue) {
            logMetacat.error((Object)("MetacatHandler.handleInsertOrUpdateAction - Could not determine if user could insert or update: " + ue.getMessage()));
            ue.printStackTrace(System.out);
        }
        try {
            logMetacat.debug((Object)("MetacatHandler.handleInsertOrUpdateAction - params: " + params.toString()));
            String[] doctext = params.get("doctext");
            String pub = null;
            if (params.containsKey("public")) {
                pub = params.get("public")[0];
            }
            StringReader dtd = null;
            if (params.containsKey("dtdtext")) {
                String[] dtdtext = params.get("dtdtext");
                try {
                    if (!dtdtext[0].equals("")) {
                        dtd = new StringReader(dtdtext[0]);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (doctext == null) {
                String msg = PROLOG + ERROR + "Document text not submitted." + ERRORCLOSE;
                if (out == null) return msg;
                out.println(msg);
                return msg;
            }
            logMetacat.debug((Object)("MetacatHandler.handleInsertOrUpdateAction - the xml document in metacat servlet (before parsing):\n" + doctext[0]));
            StringReader xmlReader = new StringReader(doctext[0]);
            boolean validate = false;
            DocumentImplWrapper documentWrapper = null;
            String namespace = null;
            try {
                String newdocid;
                block37: {
                    block36: {
                        block39: {
                            EMLParser parser;
                            String rule;
                            block38: {
                                validate = MetacatHandler.needDTDValidation(xmlReader);
                                if (!validate) break block38;
                                rule = "DTD";
                                documentWrapper = new DocumentImplWrapper(rule, validate, writeAccessRules);
                                break block36;
                            }
                            namespace = XMLSchemaService.findDocumentNamespace(xmlReader);
                            if (namespace == null) break block39;
                            if (namespace.compareTo(DocumentImpl.EML2_0_0NAMESPACE) == 0 || namespace.compareTo(DocumentImpl.EML2_0_1NAMESPACE) == 0) {
                                rule = "eml200";
                                parser = new EMLParser(doctext[0]);
                                documentWrapper = new DocumentImplWrapper(rule, true, writeAccessRules);
                                break block36;
                            } else if (namespace.compareTo(DocumentImpl.EML2_1_0NAMESPACE) == 0 || namespace.compareTo(DocumentImpl.EML2_1_1NAMESPACE) == 0) {
                                rule = "eml210";
                                parser = new EMLParser(doctext[0]);
                                documentWrapper = new DocumentImplWrapper(rule, true, writeAccessRules);
                                break block36;
                            } else {
                                rule = "Schema";
                                documentWrapper = new DocumentImplWrapper(rule, true, writeAccessRules);
                            }
                            break block36;
                        }
                        documentWrapper = new DocumentImplWrapper("", false, writeAccessRules);
                    }
                    String[] action = params.get("action");
                    String[] docid = params.get("docid");
                    newdocid = null;
                    String doAction = null;
                    if (action[0].equals("insert") || action[0].equals("insertmultipart")) {
                        doAction = "INSERT";
                    } else if (action[0].equals("update")) {
                        doAction = "UPDATE";
                    }
                    try {
                        dbConn = DBConnectionPool.getDBConnection("Metacathandler.handleInsertOrUpdateAction");
                        serialNumber = dbConn.getCheckOutSerialNumber();
                        String accNumber = docid[0];
                        logMetacat.debug((Object)("MetacatHandler.handleInsertOrUpdateAction - " + doAction + " " + accNumber + "..."));
                        Identifier identifier = new Identifier();
                        identifier.setValue(accNumber);
                        if (!D1NodeService.isValidIdentifier(identifier)) {
                            String error = "The docid " + accNumber + " is not valid since it is null or contians the white space(s).";
                            logMetacat.warn((Object)("MetacatHandler.handleInsertOrUpdateAction - " + error));
                            throw new Exception(error);
                        }
                        newdocid = documentWrapper.write(dbConn, doctext[0], pub, dtd, doAction, accNumber, user, groups, xmlBytes, formatId);
                        EventLog.getInstance().log(ipAddress, userAgent, user, accNumber, action[0]);
                        MetacatDocumentEvent mde = new MetacatDocumentEvent();
                        mde.setDocid(accNumber);
                        mde.setDoctype(namespace);
                        mde.setAction(doAction);
                        mde.setUser(user);
                        mde.setGroups(groups);
                        MetacatEventService.getInstance().notifyMetacatEventObservers(mde);
                        if (!generateSystemMetadata) break block37;
                        SystemMetadata sysMeta = null;
                        try {
                            String docidWithoutRev = DocumentUtil.getSmartDocId(newdocid);
                            int rev = IdentifierManager.getInstance().getLatestRevForLocalId(newdocid);
                            String guid = IdentifierManager.getInstance().getGUID(docidWithoutRev, rev);
                            sysMeta = IdentifierManager.getInstance().getSystemMetadata(guid);
                        }
                        catch (McdbDocNotFoundException mnfe) {
                            try {
                                boolean reindexDataObject = true;
                                sysMeta = SystemMetadataFactory.createSystemMetadata(reindexDataObject, newdocid, true, false);
                                HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysMeta.getIdentifier(), (Object)sysMeta);
                                MetacatSolrIndex.getInstance().submit(sysMeta.getIdentifier(), sysMeta, null, true);
                                Identifier potentialOreIdentifier = new Identifier();
                                potentialOreIdentifier.setValue("resourceMap_" + sysMeta.getIdentifier().getValue());
                                SystemMetadata oreSystemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)potentialOreIdentifier);
                                if (oreSystemMetadata != null) {
                                    MetacatSolrIndex.getInstance().submit(oreSystemMetadata.getIdentifier(), oreSystemMetadata, null, true);
                                }
                            }
                            catch (McdbDocNotFoundException dnfe) {
                                logMetacat.debug((Object)("There was a problem finding the localId " + newdocid + "The error was: " + dnfe.getMessage()));
                                throw dnfe;
                            }
                            catch (AccessionNumberException ane) {
                                logMetacat.debug((Object)("There was a problem creating the accession number for " + newdocid + ". The error was: " + ane.getMessage()));
                                throw ane;
                            }
                        }
                    }
                    finally {
                        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                    }
                }
                output = output + PROLOG;
                output = output + SUCCESS;
                output = output + "<docid>" + newdocid + "</docid>";
                output = output + SUCCESSCLOSE;
            }
            catch (NullPointerException npe) {
                output = output + PROLOG;
                output = output + ERROR;
                output = output + npe.getMessage();
                output = output + ERRORCLOSE;
                logMetacat.warn((Object)("MetacatHandler.handleInsertOrUpdateAction - Null pointer error when writing eml document to the database: " + npe.getMessage()));
                npe.printStackTrace();
            }
        }
        catch (Exception e) {
            output = output + PROLOG;
            output = output + ERROR;
            output = output + e.getMessage();
            output = output + ERRORCLOSE;
            logMetacat.warn((Object)("MetacatHandler.handleInsertOrUpdateAction - General error when writing eml document to the database: " + e.getMessage()));
            e.printStackTrace();
        }
        if (qformat == null || qformat.equals("xml")) {
            if (response == null) return output;
            response.setContentType("text/xml");
            out.println(output);
            return output;
        }
        try {
            DBTransform trans = new DBTransform();
            response.setContentType("text/html");
            trans.transformXMLDocument(output, "message", "-//W3C//HTML//EN", qformat, out, null, null);
            return null;
        }
        catch (Exception e) {
            logMetacat.error((Object)("MetacatHandler.handleInsertOrUpdateAction - General error: " + e.getMessage()));
            e.printStackTrace(System.out);
        }
        return null;
    }

    private static boolean needDTDValidation(StringReader xmlreader) throws IOException {
        int c;
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        StringBuffer cbuff = new StringBuffer();
        Stack<String> st = new Stack<String>();
        boolean validate = false;
        boolean commented = false;
        while ((st.empty() || st.size() < 4) && (c = xmlreader.read()) != -1) {
            cbuff.append((char)c);
            int inx = cbuff.toString().indexOf("<!--");
            if (inx != -1) {
                commented = true;
            }
            if ((inx = cbuff.toString().indexOf("<!DOCTYPE")) != -1) {
                cbuff = new StringBuffer();
                st.push("<!DOCTYPE");
            }
            if ((inx = cbuff.toString().indexOf("PUBLIC")) != -1) {
                cbuff = new StringBuffer();
                st.push("PUBLIC");
            }
            if ((inx = cbuff.toString().indexOf("SYSTEM")) != -1) {
                cbuff = new StringBuffer();
                st.push("SYSTEM");
            }
            if ((inx = cbuff.toString().indexOf(">")) == -1) continue;
            cbuff = new StringBuffer();
            st.push(">");
        }
        xmlreader.reset();
        if (st.size() == 4 && ((String)st.pop()).equals(">") && ((String)st.peek()).equals("PUBLIC") | ((String)st.pop()).equals("SYSTEM") && ((String)st.pop()).equals("<!DOCTYPE")) {
            validate = !commented;
        }
        logMetacat.info((Object)("MetacatHandler.needDTDValidation - Validation for dtd is " + validate));
        return validate;
    }

    public void handleDeleteAction(PrintWriter out, Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response, String user, String[] groups) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        String[] docid = params.get("docid");
        if (docid == null) {
            response.setContentType("text/xml");
            out.println(PROLOG);
            out.println(ERROR);
            out.println("Docid not specified.");
            out.println(ERRORCLOSE);
            logMetacat.error((Object)"MetacatHandler.handleDeleteAction - Docid not specified for the document to be deleted.");
        } else {
            String localId = null;
            try {
                IdentifierManager im = IdentifierManager.getInstance();
                localId = im.getLocalId(docid[0]);
                this.deleteFromMetacat(out, request, response, localId, user, groups);
            }
            catch (McdbDocNotFoundException mdnfe) {
                try {
                    localId = docid[0];
                    this.deleteFromMetacat(out, request, response, localId, user, groups);
                }
                catch (McdbDocNotFoundException dnfe) {
                    response.setContentType("text/xml");
                    out.println(PROLOG);
                    out.println(ERROR);
                    out.println(dnfe.getMessage());
                    out.println(ERRORCLOSE);
                    logMetacat.error((Object)("MetacatHandler.handleDeleteAction - Document could not be deleted: " + dnfe.getMessage()));
                    dnfe.printStackTrace(System.out);
                    return;
                }
            }
            catch (SQLException sqle) {
                response.setContentType("text/xml");
                out.println(PROLOG);
                out.println(ERROR);
                out.println(sqle.getMessage());
                out.println(ERRORCLOSE);
                logMetacat.error((Object)("MetacatHandler.handleDeleteAction - Document could not be deleted: " + sqle.getMessage()));
                sqle.printStackTrace(System.out);
                return;
            }
            MetacatDocumentEvent mde = new MetacatDocumentEvent();
            mde.setDocid(localId);
            mde.setDoctype(null);
            mde.setAction("delete");
            mde.setUser(user);
            mde.setGroups(groups);
            MetacatEventService.getInstance().notifyMetacatEventObservers(mde);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleValidateAction(PrintWriter out, Hashtable<String, String[]> params) {
        String valtext = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            valtext = params.get("valtext")[0];
        }
        catch (Exception nullpe) {
            String docid = null;
            try {
                docid = params.get("docid")[0];
                DocumentImpl xmldoc = new DocumentImpl(docid, false);
                valtext = xmldoc.toString();
            }
            catch (NullPointerException npe) {
                out.println("<error>Error getting document ID: " + StringEscapeUtils.escapeXml((String)docid) + ERRORCLOSE);
                return;
            }
            catch (Exception e) {
                out.println(e.getMessage());
            }
        }
        try {
            dbConn = DBConnectionPool.getDBConnection("MetacatHandler.handleValidateAction");
            serialNumber = dbConn.getCheckOutSerialNumber();
            DBValidate valobj = new DBValidate(dbConn);
            out.println(valobj.returnErrors());
        }
        catch (NullPointerException npe2) {
            out.println("<error>Error validating document.</error>");
        }
        catch (Exception e) {
            out.println(e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGetDocid(Hashtable<String, String[]> params, HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        try (ServletOutputStream out = response.getOutputStream();){
            String pid = null;
            if (params.containsKey("pid")) {
                pid = params.get("pid")[0];
            }
            String docid = IdentifierManager.getInstance().getLocalId(pid);
            out.println(PROLOG);
            out.print("<docid>");
            out.print(docid);
            out.print("</docid>");
        }
    }

    protected void handleGetRevisionAndDocTypeAction(PrintWriter out, Hashtable<String, String[]> params) {
        String[] docs = new String[10];
        String givenDocId = null;
        if (params.containsKey("docid")) {
            docs = params.get("docid");
        }
        givenDocId = docs[0];
        try {
            if (givenDocId == null || givenDocId.equals("")) {
                throw new Exception("User didn't specify docid!");
            }
            DBUtil dbutil = new DBUtil();
            String revAndDocType = dbutil.getCurrentRevisionAndDocTypeForGivenDocument(givenDocId);
            out.println(revAndDocType);
        }
        catch (Exception e) {
            out.println(PROLOG);
            out.println(ERROR);
            out.println(e.getMessage());
            out.println(ERRORCLOSE);
        }
    }

    protected void handleGetAccessControlAction(PrintWriter out, Hashtable<String, String[]> params, HttpServletResponse response, String username, String[] groupnames) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        String docid = params.get("docid")[0];
        if (docid.startsWith("urn:")) {
            try {
                String actualDocId;
                docid = actualDocId = LSIDUtil.getDocId((String)docid, (boolean)false);
            }
            catch (ParseLSIDException ple) {
                logMetacat.error((Object)("MetacatHandler.handleGetAccessControlAction - could not parse lsid: " + docid + " : " + ple.getMessage()));
                ple.printStackTrace(System.out);
            }
        }
        String qformat = "xml";
        if (params.get("qformat") != null) {
            qformat = params.get("qformat")[0];
        }
        try {
            AccessControlForSingleFile acfsf = new AccessControlForSingleFile(docid);
            String acltext = acfsf.getACL(username, groupnames);
            if (qformat.equals("xml")) {
                response.setContentType("text/xml");
                out.println(acltext);
            } else {
                DBTransform trans = new DBTransform();
                response.setContentType("text/html");
                trans.transformXMLDocument(acltext, "-//NCEAS//getaccesscontrol//EN", "-//W3C//HTML//EN", qformat, out, params, null);
            }
        }
        catch (Exception e) {
            out.println(PROLOG);
            out.println(ERROR);
            out.println(e.getMessage());
            out.println(ERRORCLOSE);
        }
    }

    protected void handleGetPrincipalsAction(Writer out, String user, String password) throws IOException {
        try {
            AuthSession auth = new AuthSession();
            String principals = auth.getPrincipals(user, password);
            out.write(principals);
        }
        catch (Exception e) {
            out.write(PROLOG);
            out.write(ERROR);
            out.write(e.getMessage());
            out.write(ERRORCLOSE);
        }
    }

    protected void handleGetDoctypesAction(PrintWriter out, Hashtable<String, String[]> params, HttpServletResponse response) {
        try {
            DBUtil dbutil = new DBUtil();
            String doctypes = dbutil.readDoctypes();
            out.println(doctypes);
        }
        catch (Exception e) {
            out.println(PROLOG);
            out.println(ERROR);
            out.println(e.getMessage());
            out.println(ERRORCLOSE);
        }
    }

    protected void handleGetDTDSchemaAction(PrintWriter out, Hashtable<String, String[]> params, HttpServletResponse response) {
        String doctype = null;
        String[] doctypeArr = params.get("doctype");
        if (doctypeArr != null) {
            doctype = params.get("doctype")[0];
        }
        try {
            DBUtil dbutil = new DBUtil();
            String dtdschema = dbutil.readDTDSchema(doctype);
            out.println(dtdschema);
        }
        catch (Exception e) {
            out.println(PROLOG);
            out.println(ERROR);
            out.println(e.getMessage());
            out.println(ERRORCLOSE);
        }
    }

    public void handleIdIsRegisteredAction(PrintWriter out, Hashtable<String, String[]> params, HttpServletResponse response) {
        String id = null;
        boolean exists = false;
        if (params.get("docid") != null) {
            id = params.get("docid")[0];
        }
        try {
            DBUtil dbutil = new DBUtil();
            exists = dbutil.idExists(id);
        }
        catch (Exception e) {
            out.println(PROLOG);
            out.println(ERROR);
            out.println(e.getMessage());
            out.println(ERRORCLOSE);
        }
        out.println(PROLOG);
        out.println("<isRegistered>");
        out.println("<docid>" + StringEscapeUtils.escapeXml((String)id) + "</docid>");
        out.println("<exists>" + exists + "</exists>");
        out.println("</isRegistered>");
    }

    public void handleGetAllDocidsAction(PrintWriter out, Hashtable<String, String[]> params, HttpServletResponse response) {
        String scope = null;
        if (params.get("scope") != null) {
            scope = params.get("scope")[0];
        }
        try {
            Vector<String> docids = DBUtil.getAllDocids(scope);
            out.println(PROLOG);
            out.println("<idList>");
            out.println("  <scope>" + StringEscapeUtils.escapeXml((String)scope) + "</scope>");
            for (int i = 0; i < docids.size(); ++i) {
                String docid = docids.elementAt(i);
                out.println("  <docid>" + docid + "</docid>");
            }
            out.println("</idList>");
        }
        catch (Exception e) {
            out.println(PROLOG);
            out.println(ERROR);
            out.println(e.getMessage());
            out.println(ERRORCLOSE);
        }
    }

    public void handleGetMaxDocidAction(PrintWriter out, Hashtable<String, String[]> params, HttpServletResponse response) {
        String scope = params.get("scope")[0];
        if (scope == null) {
            scope = params.get("username")[0];
        }
        try {
            DBUtil dbutil = new DBUtil();
            String lastDocid = dbutil.getMaxDocid(scope);
            out.println(PROLOG);
            out.println("<lastDocid>");
            out.println("  <scope>" + StringEscapeUtils.escapeXml((String)scope) + "</scope>");
            out.println("  <docid>" + lastDocid + "</docid>");
            out.println("</lastDocid>");
        }
        catch (Exception e) {
            out.println(PROLOG);
            out.println(ERROR);
            out.println(e.getMessage());
            out.println(ERRORCLOSE);
        }
    }

    protected void handleGetLogAction(Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response, String username, String[] groups, String sessionId) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        try {
            PrintWriter out = null;
            String[] qformatParam = params.get("qformat");
            String qformat = null;
            if (qformatParam != null && qformatParam.length > 0) {
                qformat = qformatParam[0];
            }
            String[] ipAddress = params.get("ipaddress");
            String[] principal = params.get("principal");
            String[] docid = params.get("docid");
            String[] event = params.get("event");
            String[] startArray = params.get("start");
            String[] endArray = params.get("end");
            String start = null;
            String end = null;
            if (startArray != null) {
                start = startArray[0];
            }
            if (endArray != null) {
                end = endArray[0];
            }
            Timestamp startDate = null;
            Timestamp endDate = null;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                if (start != null) {
                    startDate = new Timestamp(format.parse(start).getTime());
                }
                if (end != null) {
                    endDate = new Timestamp(format.parse(end).getTime());
                }
            }
            catch (ParseException e) {
                logMetacat.error((Object)"MetacatHandler.handleGetLogAction - Failed to created Timestamp from input.");
                e.printStackTrace(System.out);
            }
            boolean anon = false;
            if (!AuthUtil.isAdministrator(username, groups)) {
                anon = true;
                if (docid == null || docid.length == 0) {
                    response.setContentType("text/xml");
                    out = response.getWriter();
                    out.print(ERROR);
                    out.print("The user \"" + username + "\" is not authorized for this action.");
                    out.print(ERRORCLOSE);
                    return;
                }
            }
            String report = EventLog.getInstance().getReport(ipAddress, principal, docid, event, startDate, endDate, anon);
            if (qformat != null && !qformat.equals("xml")) {
                response.setContentType("text/html");
                out = response.getWriter();
                try {
                    DBTransform trans = new DBTransform();
                    trans.transformXMLDocument(report, "-//NCEAS//log//EN", "-//W3C//HTML//EN", qformat, out, params, sessionId);
                }
                catch (Exception e) {
                    logMetacat.error((Object)("MetacatHandler.handleGetLogAction - General error" + e.getMessage()));
                    e.printStackTrace(System.out);
                }
            } else {
                response.setContentType("text/xml");
                out = response.getWriter();
                out.println(report);
                out.close();
            }
        }
        catch (IOException e) {
            logMetacat.error((Object)("MetacatHandler.handleGetLogAction - Could not open http response for writing: " + e.getMessage()));
            e.printStackTrace(System.out);
        }
        catch (MetacatUtilException ue) {
            logMetacat.error((Object)("MetacatHandler.handleGetLogAction - Could not determine if user is administrator: " + ue.getMessage()));
            ue.printStackTrace(System.out);
        }
    }

    protected void handleBuildIndexAction(Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response, String username, String[] groups) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        String[] docid = params.get("docid");
        try {
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
                out.print(ERROR);
                out.print("The Metacat Path Query Engine is turned off. If you want to turn it on, please contact the administrator.");
                out.print(ERRORCLOSE);
                return;
            }
            if (!AuthUtil.isAdministrator(username, groups)) {
                out.print(ERROR);
                out.print("The user \"" + username + "\" is not authorized for this action.");
                out.print(ERRORCLOSE);
                return;
            }
            out.println(SUCCESS);
            if (docid == null || docid.length == 0) {
                try {
                    Vector<String> documents = this.getDocumentList();
                    for (String id : documents) {
                        System.out.println("building doc index for all documents");
                        this.buildDocumentIndex(id, out);
                        System.out.println("done building doc index for all documents");
                    }
                }
                catch (SQLException se) {
                    out.print(ERROR);
                    out.print(se.getMessage());
                    out.println(ERRORCLOSE);
                }
            } else {
                for (int i = 0; i < docid.length; ++i) {
                    System.out.println("building doc index for document " + docid[i]);
                    this.buildDocumentIndex(docid[i], out);
                    System.out.println("done building doc index for document " + docid[i]);
                }
            }
            out.println(SUCCESSCLOSE);
            out.close();
        }
        catch (IOException e) {
            logMetacat.error((Object)("MetacatHandler.handleBuildIndexAction - Could not open http response for writing: " + e.getMessage()));
            e.printStackTrace(System.out);
        }
        catch (MetacatUtilException ue) {
            logMetacat.error((Object)("MetacatHandler.handleBuildIndexAction - Could not determine if user is administrator: " + ue.getMessage()));
            ue.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReindexAction(Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response, String username, String[] groups) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        String[] pid = params.get("pid");
        PrintWriter out = null;
        StringBuffer results = new StringBuffer();
        try {
            response.setContentType("text/xml");
            out = response.getWriter();
            if (pid == null || pid.length == 0) {
                results = new StringBuffer();
                results.append(ERROR);
                results.append("The parameter - pid is missing. Please check your parameter list.");
                results.append(ERRORCLOSE);
                return;
            }
            boolean isAuthorized = true;
            String docid = IdentifierManager.getInstance().getLocalId(pid[0]);
            isAuthorized = DocumentImpl.hasWritePermission(username, groups, docid);
            if (!isAuthorized) {
                isAuthorized = AuthUtil.isAdministrator(username, groups);
            }
            if (!isAuthorized) {
                results.append(ERROR);
                results.append("The user \"" + username + "\" is not authorized for this action.");
                results.append(ERRORCLOSE);
                return;
            }
            Vector<String> successList = new Vector<String>();
            Vector<String> failedList = new Vector<String>();
            for (int i = 0; i < pid.length; ++i) {
                String id = pid[i];
                logMetacat.info((Object)("queueing doc index for pid " + id));
                Identifier identifier = new Identifier();
                identifier.setValue(id);
                SystemMetadata sysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)identifier);
                if (sysMeta == null) {
                    failedList.add(id);
                    logMetacat.info((Object)("no system metadata was found for pid " + id));
                    continue;
                }
                try {
                    Map<String, List<Object>> fields = EventLog.getInstance().getIndexFields(identifier, Event.READ.xmlValue());
                    MetacatSolrIndex.getInstance().submit(identifier, sysMeta, fields, false);
                }
                catch (Exception e) {
                    failedList.add(id);
                    logMetacat.info((Object)("Error submitting to index for pid " + id));
                    continue;
                }
                successList.add(id);
                logMetacat.info((Object)("done queueing doc index for pid " + id));
            }
            results.append("<results>\n");
            if (successList.size() > 0) {
                results.append("<success>\n");
                for (String id : successList) {
                    results.append("<pid>" + id + "</pid>\n");
                }
                results.append(SUCCESSCLOSE);
            }
            if (failedList.size() > 0) {
                results.append("<error>\n");
                for (String id : failedList) {
                    results.append("<pid>" + id + "</pid>\n");
                }
                results.append(ERRORCLOSE);
            }
            results.append("</results>\n");
        }
        catch (Exception e) {
            logMetacat.error((Object)("MetacatHandler.handleReindex action - " + e.getMessage()));
            e.printStackTrace();
            results.append(ERROR);
            results.append("There was an error - " + e.getMessage());
            results.append(ERRORCLOSE);
        }
        finally {
            logMetacat.debug((Object)"================= in the finally statement");
            if (out != null) {
                logMetacat.debug((Object)"================= in the finally statement which out is not null");
                out.print(results.toString());
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReindexAllAction(Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response, String username, String[] groups) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        PrintWriter out = null;
        StringBuffer results = new StringBuffer();
        try {
            response.setContentType("text/xml");
            out = response.getWriter();
            if (!AuthUtil.isAdministrator(username, groups)) {
                out.print(ERROR);
                out.print("The user \"" + username + "\" is not authorized for this action.");
                out.print(ERRORCLOSE);
                out.close();
                return;
            }
            logMetacat.info((Object)"queueing doc index for all documents");
            try {
                List<String> allIdentifiers = IdentifierManager.getInstance().getAllSystemMetadataGUIDs();
                Iterator<String> it = allIdentifiers.iterator();
                results.append(SUCCESS);
                while (it.hasNext()) {
                    String id = it.next();
                    Identifier identifier = new Identifier();
                    identifier.setValue(id);
                    SystemMetadata sysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)identifier);
                    if (sysMeta == null) continue;
                    Map<String, List<Object>> fields = EventLog.getInstance().getIndexFields(identifier, Event.READ.xmlValue());
                    MetacatSolrIndex.getInstance().submit(identifier, sysMeta, fields, false);
                    results.append("<pid>" + id + "</pid>\n");
                    logMetacat.debug((Object)("queued SystemMetadata for index on pid: " + id));
                }
                results.append(SUCCESSCLOSE);
                logMetacat.info((Object)"done queueing index for all documents");
            }
            catch (Exception e) {
                results = new StringBuffer();
                results.append(ERROR);
                results.append(e.getMessage());
                results.append(ERRORCLOSE);
            }
        }
        catch (IOException e) {
            logMetacat.error((Object)("MetacatHandler.handleBuildIndexAction - Could not open http response for writing: " + e.getMessage()));
            e.printStackTrace();
        }
        catch (MetacatUtilException ue) {
            logMetacat.error((Object)("MetacatHandler.handleBuildIndexAction - Could not determine if user is administrator: " + ue.getMessage()));
            ue.printStackTrace();
        }
        finally {
            if (out != null) {
                out.print(results.toString());
                out.close();
            }
        }
    }

    private void buildDocumentIndex(String docid, PrintWriter out) {
        if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
            return;
        }
        try {
            DocumentImpl doc = new DocumentImpl(docid, false);
            doc.buildIndex();
            out.print("<docid>" + StringEscapeUtils.escapeXml((String)docid));
            out.println("</docid>");
        }
        catch (McdbException me) {
            out.print(ERROR);
            out.print(me.getMessage());
            out.println(ERRORCLOSE);
        }
    }

    protected void handleMultipartForm(HttpServletRequest request, HttpServletResponse response) {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        PrintWriter out = null;
        String action = null;
        File tempFile = null;
        Hashtable<String, String[]> params = new Hashtable<String, String[]>();
        Hashtable<String, String> fileList = new Hashtable<String, String>();
        int sizeLimit = 1000;
        String tmpDir = "/tmp";
        try {
            sizeLimit = new Integer(PropertyService.getProperty("replication.datafilesizelimit"));
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("MetacatHandler.handleMultipartForm - Could not determine data file size limit.  Using 1000. " + pnfe.getMessage()));
            pnfe.printStackTrace(System.out);
        }
        try {
            tmpDir = PropertyService.getProperty("application.tempDir");
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("MetacatHandler.handleMultipartForm - Could not determine temp dir, using default. " + pnfe.getMessage()));
            pnfe.printStackTrace(System.out);
        }
        logMetacat.debug((Object)("MetacatHandler.handleMultipartForm - The size limit of uploaded data files is: " + sizeLimit));
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            DiskFileItemFactory factory = new DiskFileItemFactory();
            File repository = new File(tmpDir);
            factory.setRepository(repository);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                String name = item.getFieldName();
                if (item.isFormField()) {
                    String[] values = new String[]{item.getString()};
                    params.put(name, values);
                    if (!name.equals("action")) continue;
                    action = values[0];
                    continue;
                }
                String fileName = item.getName();
                tempFile = MetacatUtil.writeTempUploadFile(item, fileName);
                fileList.put(name, tempFile.getAbsolutePath());
                fileList.put("filename", fileName);
                fileList.put("name", tempFile.getAbsolutePath());
            }
        }
        catch (Exception ioe) {
            try {
                out = response.getWriter();
            }
            catch (IOException ioe2) {
                logMetacat.fatal((Object)"MetacatHandler.handleMultipartForm - Fatal Error: couldn't get response output stream.");
            }
            out.println(PROLOG);
            out.println(ERROR);
            out.println("Error: problem reading multipart data: " + ioe.getMessage());
            out.println(ERRORCLOSE);
            out.close();
            return;
        }
        String username = "public";
        String password = null;
        String[] groupnames = null;
        String sess_id = null;
        SessionData sessionData = RequestUtil.getSessionData(request);
        if (sessionData != null) {
            username = sessionData.getUserName();
            password = sessionData.getPassword();
            groupnames = sessionData.getGroupNames();
            sess_id = sessionData.getId();
        }
        try {
            out = response.getWriter();
        }
        catch (IOException ioe2) {
            logMetacat.error((Object)"MetacatHandler.handleMultipartForm - Fatal Error: couldn't get response output stream.");
            ioe2.printStackTrace(System.out);
        }
        if (action.equals("upload")) {
            if (username != null && !username.equals("public")) {
                this.handleUploadAction(request, out, params, fileList, username, groupnames, response);
            } else {
                out.println(PROLOG);
                out.println(ERROR);
                out.println("Permission denied for upload action");
                out.println(ERRORCLOSE);
            }
        } else if (action.equals("insertmultipart")) {
            if (username != null && !username.equals("public")) {
                logMetacat.debug((Object)"MetacatHandler.handleMultipartForm - handling multipart insert");
                this.handleInsertMultipartAction(request, response, out, params, fileList, username, groupnames);
            } else {
                out.println(PROLOG);
                out.println(ERROR);
                out.println("Permission denied for insertmultipart action");
                out.println(ERRORCLOSE);
            }
        } else {
            out.println(PROLOG);
            out.println(ERROR);
            out.println("Error: action not registered.  Please report this error.");
            out.println(ERRORCLOSE);
        }
        if (tempFile != null && tempFile.exists()) {
            tempFile.delete();
        }
        out.close();
    }

    private void handleInsertMultipartAction(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Hashtable<String, String[]> params, Hashtable<String, String> fileList, String username, String[] groupnames) {
        block20: {
            Logger logMetacat = Logger.getLogger(MetacatHandler.class);
            Object action = null;
            String docid = null;
            String qformat = null;
            String output = "";
            if (params.containsKey("qformat")) {
                qformat = params.get("qformat")[0];
            }
            if (params.containsKey("docid")) {
                docid = params.get("docid")[0];
            }
            Identifier identifier = new Identifier();
            identifier.setValue(docid);
            if (!D1NodeService.isValidIdentifier(identifier)) {
                output = output + PROLOG;
                output = output + ERROR;
                output = output + "The docid " + docid + " is not valid since it is null or contians the white space(s).";
                output = output + ERRORCLOSE;
                logMetacat.warn((Object)("MetacatHandler.handleInsertMultipartAction - The docid " + docid + " is not valid since it is null or contians the white space(s)."));
                if (qformat == null || qformat.equals("xml")) {
                    response.setContentType("text/xml");
                    String cleanMessage = StringEscapeUtils.escapeXml((String)output);
                    out.println(cleanMessage);
                } else {
                    try {
                        DBTransform trans = new DBTransform();
                        response.setContentType("text/html");
                        trans.transformXMLDocument(output, "message", "-//W3C//HTML//EN", qformat, out, null, null);
                    }
                    catch (Exception e) {
                        logMetacat.error((Object)("MetacatHandler.handleInsertMultipartAction - General error: " + e.getMessage()));
                        e.printStackTrace(System.out);
                    }
                }
                return;
            }
            if (docid != null && fileList.containsKey("datafile")) {
                logMetacat.info((Object)("MetacatHandler.handleInsertMultipartAction - Uploading data docid: " + docid));
                String fileName = fileList.get("filename");
                logMetacat.debug((Object)("MetacatHandler.handleInsertMultipartAction - Uploading filename: " + fileName));
                if (fileName != null) {
                    try {
                        if (!DocumentImpl.getDataFileLockGrant(docid)) break block20;
                        String datafilepath = PropertyService.getProperty("application.datafilepath");
                        File dataDirectory = new File(datafilepath);
                        dataDirectory.mkdirs();
                        File newFile = null;
                        String tempFileName = fileList.get("name");
                        String newFileName = dataDirectory + File.separator + docid;
                        long size = 0L;
                        boolean fileExists = false;
                        newFile = new File(newFileName);
                        fileExists = newFile.exists();
                        logMetacat.info((Object)("MetacatHandler.handleInsertMultipartAction - new file status is: " + fileExists));
                        if (fileExists) {
                            newFile.delete();
                            newFile.createNewFile();
                            fileExists = false;
                        }
                        if (!fileExists) {
                            try {
                                MetacatUtil.copyFile(tempFileName, newFileName);
                            }
                            catch (IOException ioe) {
                                logMetacat.error((Object)("MetacatHandler.handleInsertMultipartAction - IO Exception copying file: " + ioe.getMessage()));
                                ioe.printStackTrace(System.out);
                            }
                            size = newFile.length();
                            if (size == 0L) {
                                throw new IOException("MetacatHandler.handleInsertMultipartAction - Uploaded file is 0 bytes!");
                            }
                        }
                        logMetacat.info((Object)("MetacatHandler.handleInsertMultipartAction - Uploading the following to Metacat:" + fileName + ", " + docid + ", " + username + ", " + groupnames));
                        XmlStreamReader xsr = new XmlStreamReader((InputStream)new FileInputStream(newFile));
                        String encoding = xsr.getEncoding();
                        InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(newFile), encoding);
                        char[] c = new char[1024];
                        int numread = ((Reader)fr).read(c, 0, 1024);
                        StringBuffer sb = new StringBuffer();
                        while (numread != -1) {
                            sb.append(c, 0, numread);
                            numread = ((Reader)fr).read(c, 0, 1024);
                        }
                        Enumeration<String> keys = params.keys();
                        while (keys.hasMoreElements()) {
                            String key = keys.nextElement();
                            String[] paramValue = params.get(key);
                            String[] s = new String[]{paramValue[0]};
                            params.put(key, s);
                        }
                        String doctext = sb.toString();
                        String[] doctextArr = new String[]{doctext};
                        params.put("doctext", doctextArr);
                        boolean writeAccessRules = true;
                        String formatId = null;
                        this.handleInsertOrUpdateAction(request.getRemoteAddr(), request.getHeader("User-Agent"), response, out, params, username, groupnames, true, writeAccessRules, null, formatId);
                    }
                    catch (Exception e) {
                        logMetacat.error((Object)("MetacatHandler.handleInsertMultipartAction - error uploading text file via multipart: " + e.getMessage()));
                        e.printStackTrace(System.out);
                    }
                }
            }
        }
    }

    private void handleUploadAction(HttpServletRequest request, PrintWriter out, Hashtable<String, String[]> params, Hashtable<String, String> fileList, String username, String[] groupnames, HttpServletResponse response) {
        String output;
        String qformat;
        Logger logMetacat;
        block21: {
            logMetacat = Logger.getLogger(MetacatHandler.class);
            String docid = null;
            qformat = null;
            output = "";
            if (params.containsKey("docid")) {
                docid = params.get("docid")[0];
            }
            Identifier identifier = new Identifier();
            identifier.setValue(docid);
            if (!D1NodeService.isValidIdentifier(identifier)) {
                output = output + PROLOG;
                output = output + ERROR;
                output = output + "The docid " + docid + " is not valid since it is null or contians the white space(s).";
                output = output + ERRORCLOSE;
                logMetacat.warn((Object)("MetacatHandler.handleUploadAction - The docid " + docid + " is not valid since it is null or contians the white space(s)."));
            } else if (docid != null && fileList.containsKey("datafile")) {
                logMetacat.info((Object)("MetacatHandler.handleUploadAction - Uploading data docid: " + docid));
                String fileName = fileList.get("filename");
                logMetacat.info((Object)("MetacatHandler.handleUploadAction - Uploading filename: " + fileName));
                if (fileName != null) {
                    try {
                        if (!DocumentImpl.getDataFileLockGrant(docid)) break block21;
                        String datafilepath = PropertyService.getProperty("application.datafilepath");
                        File dataDirectory = new File(datafilepath);
                        dataDirectory.mkdirs();
                        File newFile = null;
                        String tempFileName = fileList.get("name");
                        String newFileName = dataDirectory + File.separator + docid;
                        long size = 0L;
                        boolean fileExists = false;
                        try {
                            newFile = new File(newFileName);
                            fileExists = newFile.exists();
                            logMetacat.info((Object)("MetacatHandler.handleUploadAction - new file status is: " + fileExists));
                            if (!fileExists) {
                                try {
                                    MetacatUtil.copyFile(tempFileName, newFileName);
                                }
                                catch (IOException ioe) {
                                    logMetacat.error((Object)("IO Exception copying file: " + ioe.getMessage()));
                                    ioe.printStackTrace(System.out);
                                }
                                size = newFile.length();
                                if (size == 0L) {
                                    throw new IOException("Uploaded file is 0 bytes!");
                                }
                            }
                            logMetacat.info((Object)("MetacatHandler.handleUploadAction - Uploading the following to Metacat:" + fileName + ", " + docid + ", " + username + ", " + groupnames));
                            DocumentImpl.registerDocument(fileName, "BIN", docid, username, groupnames);
                            SystemMetadata sm = SystemMetadataFactory.createSystemMetadata(docid, false, false);
                            HazelcastService.getInstance().getSystemMetadataMap().put((Object)sm.getIdentifier(), (Object)sm);
                            MetacatSolrIndex.getInstance().submit(sm.getIdentifier(), sm, null, true);
                        }
                        catch (Exception ee) {
                            if (!fileExists) {
                                newFile.delete();
                            }
                            logMetacat.info((Object)("MetacatHandler.handleUploadAction - in Exception: fileExists is " + fileExists));
                            logMetacat.error((Object)("MetacatHandler.handleUploadAction - Upload Error: " + ee.getMessage()));
                            throw ee;
                        }
                        EventLog.getInstance().log(request.getRemoteAddr(), request.getHeader("User-Agent"), username, docid, "upload");
                        ForceReplicationHandler frh = new ForceReplicationHandler(docid, "insert", false, null);
                        logMetacat.debug((Object)("MetacatHandler.handleUploadAction - ForceReplicationHandler created: " + frh.toString()));
                        output = output + PROLOG;
                        output = output + SUCCESS;
                        output = output + "<docid>" + docid + "</docid>";
                        output = output + "<size>" + size + "</size>";
                        output = output + SUCCESSCLOSE;
                    }
                    catch (Exception e) {
                        output = output + PROLOG;
                        output = output + ERROR;
                        output = output + e.getMessage();
                        output = output + ERRORCLOSE;
                    }
                } else {
                    output = output + PROLOG;
                    output = output + ERROR;
                    output = output + "The uploaded data did not contain a valid file.";
                    output = output + ERRORCLOSE;
                }
            } else {
                output = output + PROLOG;
                output = output + ERROR;
                output = output + "The uploaded data did not contain a valid docid or valid file.";
                output = output + ERRORCLOSE;
            }
        }
        if (params.containsKey("qformat")) {
            qformat = params.get("qformat")[0];
        }
        if (qformat == null || qformat.equals("xml")) {
            response.setContentType("text/xml");
            out.println(output);
        } else {
            try {
                DBTransform trans = new DBTransform();
                response.setContentType("text/html");
                trans.transformXMLDocument(output, "message", "-//W3C//HTML//EN", qformat, out, null, null);
            }
            catch (Exception e) {
                logMetacat.error((Object)("MetacatHandler.handleUploadAction - General error: " + e.getMessage()));
                e.printStackTrace(System.out);
            }
        }
    }

    protected void handleSetAccessAction(PrintWriter out, Hashtable<String, String[]> params, String username, HttpServletRequest request, HttpServletResponse response) {
        String permission = null;
        String permType = null;
        String permOrder = null;
        Vector<String> errorList = new Vector<String>();
        String error = null;
        Vector<String> successList = new Vector<String>();
        Object success = null;
        boolean isEmlPkgMember = false;
        Object mnSysMeta = null;
        Object session = null;
        Identifier pid = new Identifier();
        String guid = null;
        Object mnAccessPolicy = null;
        Object cnSysMeta = null;
        String[] docList = params.get("docid");
        String[] principalList = params.get("principal");
        String[] permissionList = params.get("permission");
        String[] permTypeList = params.get("permType");
        String[] permOrderList = params.get("permOrder");
        String[] qformatList = params.get("qformat");
        String[] accessBlock = params.get("accessBlock");
        if (accessBlock != null) {
            if (docList == null) {
                errorList.addElement("MetacatHandler.handleSetAccessAction - Doc id missing.  Please check your parameter list, it should look like: ?action=setaccess&docid=<doc_id>&accessBlock=<access_section>");
                this.outputResponse(successList, errorList, out);
                return;
            }
            guid = docList[0];
            try {
                String docid = DocumentUtil.getDocIdFromAccessionNumber(docList[0]);
                int rev = DocumentUtil.getRevisionFromAccessionNumber(docList[0]);
                guid = IdentifierManager.getInstance().getGUID(docid, rev);
                logMetacat.debug((Object)("Setting access on found pid: " + guid));
            }
            catch (McdbDocNotFoundException e) {
                logMetacat.warn((Object)("No pid found for [assumed] docid: " + docList[0]));
            }
            catch (Exception e) {
                logMetacat.warn((Object)("Error looking up pid for [assumed] dociid: " + docList[0]));
            }
            try {
                logMetacat.debug((Object)("Setting access for docid: " + docList[0]));
                AccessControlForSingleFile accessControl = new AccessControlForSingleFile(docList[0]);
                accessControl.insertPermissions(accessBlock[0]);
                successList.addElement("MetacatHandler.handleSetAccessAction - successfully replaced access block for doc id: " + docList[0]);
                HazelcastService.getInstance().refreshSystemMetadataEntry(guid);
                logMetacat.debug((Object)("Setting CN access policy for pid: " + guid));
                try {
                    ArrayList<String> guids = new ArrayList<String>(Arrays.asList(guid));
                    SyncAccessPolicy syncAP = new SyncAccessPolicy();
                    logMetacat.debug((Object)("Trying to syncing access policy for pid: " + guid));
                    syncAP.sync(guids);
                }
                catch (Exception e) {
                    logMetacat.error((Object)("Error syncing pid: " + guid + " Exception " + e.getMessage()));
                    e.printStackTrace(System.out);
                }
            }
            catch (AccessControlException ace) {
                errorList.addElement("MetacatHandler.handleSetAccessAction - access control error when setting access block: " + ace.getMessage());
            }
            this.outputResponse(successList, errorList, out);
            return;
        }
        if (docList == null || principalList == null || permTypeList == null || permissionList == null) {
            error = "MetacatHandler.handleSetAccessAction - Please check your parameter list, it should look like: ?action=setaccess&docid=pipeline.1.1&principal=public&permission=read&permType=allow&permOrder=allowFirst";
            errorList.addElement(error);
            this.outputResponse(successList, errorList, out);
            return;
        }
        permission = permissionList[0];
        permType = permTypeList[0];
        System.out.println("permission in MetacatHandler.handleSetAccessAction: " + permission);
        if (permOrderList != null) {
            permOrder = permOrderList[0];
        }
        Vector<String> packageSet = null;
        try {
            packageSet = MetacatUtil.getOptionList(PropertyService.getProperty("xml.packagedoctypeset"));
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("MetacatHandler.handleSetAccessAction - Could not find package doctype set.  Setting to null: " + pnfe.getMessage()));
        }
        if (packageSet != null) {
            for (int i = 0; i < packageSet.size(); ++i) {
                logMetacat.debug((Object)("MetacatHandler.handleSetAccessAction - doctype in package set: " + packageSet.elementAt(i)));
            }
        }
        for (int i = 0; i < docList.length; ++i) {
            String docid = docList[i];
            if (docid.startsWith("urn:")) {
                try {
                    String actualDocId;
                    docid = actualDocId = LSIDUtil.getDocId((String)docid, (boolean)false);
                }
                catch (ParseLSIDException ple) {
                    logMetacat.error((Object)("MetacatHandler.handleSetAccessAction - could not parse lsid: " + docid + " : " + ple.getMessage()));
                    ple.printStackTrace(System.out);
                }
            }
            String accessionNumber = docid;
            String owner = null;
            String publicId = null;
            try {
                owner = this.getFieldValueForDoc(accessionNumber, "user_owner");
                publicId = this.getFieldValueForDoc(accessionNumber, "doctype");
            }
            catch (Exception e) {
                logMetacat.error((Object)("MetacatHandler.handleSetAccessAction - Error in handleSetAccessAction: " + e.getMessage()));
                e.printStackTrace(System.out);
                error = "Error in set access control for document - " + accessionNumber + e.getMessage();
                errorList.addElement(error);
                continue;
            }
            if (username == null || owner == null || !username.equals(owner)) {
                error = "User - " + username + " does not have permission to set " + "access control for docid - " + accessionNumber;
                errorList.addElement(error);
                System.out.println("user " + username + " does not have permission to set " + "access control for docid " + accessionNumber);
                continue;
            }
            if (!isEmlPkgMember) {
                boolean bl = isEmlPkgMember = DBUtil.findDataSetDocIdForGivenDocument(accessionNumber) != null;
            }
            if (publicId != null && packageSet != null && packageSet.contains(publicId) && isEmlPkgMember) {
                error = "Could not set access control to document " + accessionNumber + "because it is in a pakcage and it has a access file for it";
                errorList.addElement(error);
                System.out.println("this is a beta4 or 6 document so we can't set the access element.");
                continue;
            }
            for (int j = 0; j < principalList.length; ++j) {
                String principal = principalList[j];
                try {
                    AccessControlForSingleFile accessControl = new AccessControlForSingleFile(accessionNumber);
                    accessControl.insertPermissions(principal, Integer.valueOf(AccessControlList.intValue(permission)).longValue(), permType, permOrder, null, null);
                    guid = accessionNumber;
                    try {
                        String tempDocid = DocumentUtil.getDocIdFromAccessionNumber(accessionNumber);
                        int rev = DocumentUtil.getRevisionFromAccessionNumber(accessionNumber);
                        guid = IdentifierManager.getInstance().getGUID(tempDocid, rev);
                        logMetacat.debug((Object)("Found pid: " + guid));
                    }
                    catch (Exception e) {
                        logMetacat.warn((Object)("Error looking up pid for [assumed] docid: " + accessionNumber));
                    }
                    HazelcastService.getInstance().refreshSystemMetadataEntry(guid);
                    logMetacat.debug((Object)("Synching CN access policy for pid: " + guid));
                    try {
                        ArrayList<String> guids = new ArrayList<String>(Arrays.asList(guid));
                        SyncAccessPolicy syncAP = new SyncAccessPolicy();
                        logMetacat.debug((Object)("Trying to syncing access policy for pid: " + guid));
                        syncAP.sync(guids);
                    }
                    catch (Exception e) {
                        logMetacat.error((Object)("Error syncing pids: " + guid + " Exception " + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                catch (Exception ee) {
                    logMetacat.error((Object)("MetacatHandler.handleSetAccessAction - Error inserting permission: " + ee.getMessage()), (Throwable)ee);
                    error = "Failed to set access control for document " + accessionNumber + " because " + ee.getMessage();
                    errorList.addElement(error);
                }
            }
            boolean isXml = true;
            if (publicId.equalsIgnoreCase("BIN")) {
                isXml = false;
            }
            ForceReplicationHandler frh = new ForceReplicationHandler(accessionNumber, isXml, null);
            logMetacat.debug((Object)("MetacatHandler.handleSetAccessAction - ForceReplicationHandler created: " + frh.toString()));
        }
        if (errorList.isEmpty()) {
            successList.addElement("MetacatHandler.handleSetAccessAction - successfully added individual access for doc id: " + docList[0]);
        }
        if (params.get("forwardto") != null) {
            try {
                RequestUtil.forwardRequest(request, response, params);
            }
            catch (MetacatUtilException mue) {
                logMetacat.error((Object)"metaCatServlet.handleSetAccessAction - could not forward request. Sending output to response writer");
                mue.printStackTrace(System.out);
                this.outputResponse(successList, errorList, out);
            }
        } else {
            this.outputResponse(successList, errorList, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFieldValueForDoc(String accessionNumber, String fieldName) throws Exception {
        String fieldValue;
        block12: {
            if (accessionNumber == null || accessionNumber.equals("") || fieldName == null || fieldName.equals("")) {
                throw new Exception("Docid or field name was not specified");
            }
            Statement pstmt = null;
            ResultSet rs = null;
            fieldValue = null;
            String docId = null;
            DBConnection conn = null;
            int serialNumber = -1;
            docId = DocumentUtil.getDocIdFromString(accessionNumber);
            try {
                conn = DBConnectionPool.getDBConnection("MetacatHandler.getPublicIdForDoc");
                serialNumber = conn.getCheckOutSerialNumber();
                pstmt = conn.prepareStatement("SELECT " + fieldName + " FROM xml_documents " + "WHERE docid = ? ");
                pstmt.setString(1, docId);
                pstmt.execute();
                rs = pstmt.getResultSet();
                boolean hasRow = rs.next();
                if (hasRow) {
                    fieldValue = rs.getString(1);
                    break block12;
                }
                throw new Exception("Could not find document: " + accessionNumber);
            }
            catch (Exception e) {
                logMetacat.error((Object)("MetacatHandler.getFieldValueForDoc - General error: " + e.getMessage()));
                throw e;
            }
            finally {
                try {
                    rs.close();
                    pstmt.close();
                }
                finally {
                    DBConnectionPool.returnDBConnection(conn, serialNumber);
                }
            }
        }
        return fieldValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector<String> getDocumentList() throws SQLException {
        Logger logMetacat = Logger.getLogger(MetacatHandler.class);
        Vector<String> docList = new Vector<String>();
        Statement pstmt = null;
        ResultSet rs = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("MetacatHandler.getDocumentList");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement("SELECT docid, rev FROM xml_documents ");
            pstmt.execute();
            rs = pstmt.getResultSet();
            while (rs.next()) {
                String docid = rs.getString(1);
                String rev = rs.getString(2);
                docList.add(docid + "." + rev);
            }
            return docList;
        }
        catch (SQLException e) {
            logMetacat.error((Object)("MetacatHandler.getDocumentList - General exception: " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                rs.close();
                pstmt.close();
            }
            catch (SQLException se) {
                logMetacat.error((Object)("MetacatHandler.getDocumentList - General exception: " + se.getMessage()));
                throw se;
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
    }

    private void outputResponse(Vector<String> successList, Vector<String> errorList, Writer out) {
        try {
            int i;
            boolean error = false;
            boolean success = false;
            out.write(PROLOG);
            if (successList != null) {
                for (i = 0; i < successList.size(); ++i) {
                    out.write(SUCCESS);
                    out.write(successList.elementAt(i));
                    out.write(SUCCESSCLOSE);
                    success = true;
                }
            }
            if (errorList != null) {
                for (i = 0; i < errorList.size(); ++i) {
                    out.write(ERROR);
                    out.write(errorList.elementAt(i));
                    out.write(ERRORCLOSE);
                    error = true;
                }
            }
            if (!error && !success) {
                out.write(ERROR);
                out.write("Nothing happend for setaccess action");
                out.write(ERRORCLOSE);
            }
        }
        catch (Exception e) {
            logMetacat.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void scheduleSitemapGeneration(HttpServletRequest request) {
        if (!_sitemapScheduled) {
            String directoryName = null;
            String skin = null;
            long sitemapInterval = 0L;
            try {
                directoryName = SystemUtil.getContextDir() + FileUtil.getFS() + "sitemaps";
                skin = PropertyService.getProperty("application.default-style");
                sitemapInterval = Integer.parseInt(PropertyService.getProperty("sitemap.interval"));
            }
            catch (PropertyNotFoundException pnfe) {
                logMetacat.error((Object)("MetacatHandler.scheduleSitemapGeneration - Could not run site map generation because property could not be found: " + pnfe.getMessage()));
            }
            File directory = new File(directoryName);
            directory.mkdirs();
            String urlRoot = request.getRequestURL().toString();
            Sitemap smap = new Sitemap(directory, urlRoot, skin);
            long firstDelay = 60000L;
            this.timer.schedule((TimerTask)smap, firstDelay, sitemapInterval);
            _sitemapScheduled = true;
        }
    }

    public void set_sitemapScheduled(boolean sitemapScheduled) {
        _sitemapScheduled = sitemapScheduled;
    }
}

