/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.accesscontrol;

import edu.ucsb.nceas.metacat.accesscontrol.PermOrderException;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.shared.AccessException;
import edu.ucsb.nceas.metacat.shared.BaseAccess;
import edu.ucsb.nceas.utilities.access.XMLAccessDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class XMLAccessAccess
extends BaseAccess {
    private Logger logMetacat = Logger.getLogger(XMLAccessAccess.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector<XMLAccessDAO> getXMLAccessForDoc(String guid) throws AccessException {
        Vector<XMLAccessDAO> vector;
        Vector<XMLAccessDAO> xmlAccessList = new Vector<XMLAccessDAO>();
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.getXMLAccessForDoc - doc id must be specified when selecting xml_access record");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLAccessAccess.getXMLAccessForDoc");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "SELECT * FROM xml_access WHERE guid = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, guid);
            String sqlReport = "XMLAccessAccess.getXMLAccessForDoc - SQL: " + sql;
            sqlReport = sqlReport + " [" + guid + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            while (resultSet.next()) {
                XMLAccessDAO xmlAccessDAO = this.populateDAO(resultSet);
                xmlAccessList.add(xmlAccessDAO);
            }
            this.validateDocXMLAccessList(xmlAccessList);
            vector = xmlAccessList;
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLAccessAccess.getXMLAccessForDoc - SQL error when getting access  for id: " + guid + " : " + sqle.getMessage());
                catch (PermOrderException poe) {
                    String errorStr = "XMLAccessAccess.getXMLAccessForDoc - Permission order error when getting access record for doc id: " + guid + " : " + poe.getMessage();
                    this.logMetacat.error((Object)errorStr);
                    throw new AccessException(errorStr);
                }
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
        return vector;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector<XMLAccessDAO> getXMLAccessForPrincipal(String guid, String principalName) throws AccessException {
        Vector<XMLAccessDAO> vector;
        Vector<XMLAccessDAO> xmlAccessList = new Vector<XMLAccessDAO>();
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.getXMLAccessForPrincipal - doc id must be specified when selecting xml_access record");
        }
        if (principalName == null) {
            throw new AccessException("XMLAccessAccess.getXMLAccessForPrincipal - doc id must be specified when selecting xml_access record");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLAccessAccess.getXMLAccessForPrincipal");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "SELECT * FROM xml_access WHERE guid = ? AND principal_name = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, guid);
            pstmt.setString(2, principalName);
            String sqlReport = "XMLAccessAccess.getXMLAccessForPrincipal - SQL: " + sql;
            sqlReport = sqlReport + " [" + guid + "," + principalName + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            while (resultSet.next()) {
                XMLAccessDAO xmlAccessDAO = this.populateDAO(resultSet);
                xmlAccessList.add(xmlAccessDAO);
            }
            this.validatePrincipalXMLAccessList(xmlAccessList);
            vector = xmlAccessList;
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLAccessAccess.getXMLAccessForPrincipal - SQL error when getting access  for id: " + guid + ", principal: " + principalName + " : " + sqle.getMessage());
                catch (PermOrderException poe) {
                    String errorStr = "XMLAccessAccess.getXMLAccessForPrincipal - Permission order error when getting access record for id: " + guid + ", principal: " + principalName + " : " + poe.getMessage();
                    this.logMetacat.error((Object)errorStr);
                    throw new AccessException(errorStr);
                }
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
        return vector;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector<XMLAccessDAO> getXMLAccessForPrincipal(String guid, String principalName, String permType, String permOrder) throws AccessException {
        Vector<XMLAccessDAO> vector;
        Vector<XMLAccessDAO> xmlAccessList = new Vector<XMLAccessDAO>();
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.getXMLAccessForPrincipal - doc id must be specified when selecting xml_access record");
        }
        if (principalName == null) {
            throw new AccessException("XMLAccessAccess.getXMLAccessForPrincipal - doc id must be specified when selecting xml_access record");
        }
        if (permType == null) {
            throw new AccessException("XMLAccessAccess.getXMLAccessForPrincipal - permission type must be specified when selecting xml_access record");
        }
        if (permOrder == null) {
            throw new AccessException("XMLAccessAccess.getXMLAccessForPrincipal - permission order must be specified when selecting xml_access record");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLAccessAccess.getXMLAccessForPrincipal");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "SELECT * FROM xml_access WHERE guid = ? AND principal_name = ? AND perm_type = ? AND perm_order = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, guid);
            pstmt.setString(2, principalName);
            pstmt.setString(3, permType);
            pstmt.setString(4, permOrder);
            String sqlReport = "XMLAccessAccess.getXMLAccessForPrincipal - SQL: " + sql;
            sqlReport = sqlReport + " [" + guid + "," + principalName + "," + permType + "," + permOrder + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            while (resultSet.next()) {
                XMLAccessDAO xmlAccessDAO = this.populateDAO(resultSet);
                xmlAccessList.add(xmlAccessDAO);
            }
            this.validatePrincipalXMLAccessList(xmlAccessList);
            vector = xmlAccessList;
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLAccessAccess.getXMLAccessForPrincipal - SQL error when getting access  for id: " + guid + ", principal: " + principalName + " : " + sqle.getMessage());
                catch (PermOrderException poe) {
                    String errorStr = "XMLAccessAccess.getXMLAccessForPrincipal - Permission order error when getting access record for id: " + guid + ", principal: " + principalName + " : " + poe.getMessage();
                    this.logMetacat.error((Object)errorStr);
                    throw new AccessException(errorStr);
                }
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
        return vector;
    }

    public void addXMLAccess(String guid, String principalName, Long permission, String permType, String permOrder, String accessFileId, String subTreeId) throws AccessException, PermOrderException {
        this.permOrderConflict(guid, permOrder);
        Vector<XMLAccessDAO> xmlAccessList = this.getXMLAccessForPrincipal(guid, principalName, permType, permOrder);
        if (xmlAccessList.size() == 0) {
            this.insertXMLAccess(guid, principalName, permission, permType, permOrder, accessFileId, subTreeId);
            return;
        }
        if (xmlAccessList.size() > 1) {
            this.cleanupXMLAccessForPrincipal(xmlAccessList);
            xmlAccessList = this.getXMLAccessForPrincipal(guid, principalName, permType, permOrder);
        }
        if (xmlAccessList.size() == 0) {
            throw new AccessException("XMLAccessAccess.addXMLAccess - xml access list is empty when it shouldn't be for id: " + guid + ", prinicpal name: " + principalName + ", perm type " + permType + ", perm order: " + permOrder);
        }
        XMLAccessDAO xmlAccessDAO = xmlAccessList.get(0);
        if ((xmlAccessDAO.getPermission() & permission) != permission) {
            this.updateXMLAccessPermission(guid, principalName, xmlAccessDAO.getPermission() | permission);
        }
    }

    public void replaceAccess(String guid, List<XMLAccessDAO> xmlAccessList) throws AccessException {
        this.deleteXMLAccessForDoc(guid);
        this.insertAccess(guid, xmlAccessList);
    }

    public void insertAccess(String guid, List<XMLAccessDAO> xmlAccessList) throws AccessException {
        for (XMLAccessDAO xmlAccessDAO : xmlAccessList) {
            this.insertXMLAccess(guid, xmlAccessDAO.getPrincipalName(), xmlAccessDAO.getPermission(), xmlAccessDAO.getPermType(), xmlAccessDAO.getPermOrder(), xmlAccessDAO.getAccessFileId(), xmlAccessDAO.getSubTreeId());
        }
    }

    private void insertXMLAccess(String guid, String principalName, Long permission, String permType, String permOrder, String accessFileId, String subTreeId) throws AccessException {
        try {
            if (permission == -1L) {
                throw new Exception("Permission is -1 in XMLAccessAccess.insertXMLAccess().");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logMetacat.warn((Object)e.getMessage());
        }
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.insertXMLAccess - id is required when inserting XML access record");
        }
        if (principalName == null) {
            throw new AccessException("XMLAccessAccess.insertXMLAccess - principal is required when inserting XML access record");
        }
        if (permission == null) {
            throw new AccessException("XMLAccessAccess.insertXMLAccess - permission is required when inserting XML access record");
        }
        if (permType == null) {
            throw new AccessException("XMLAccessAccess.insertXMLAccess - permType is required when inserting XML access record");
        }
        if (permOrder == null) {
            permOrder = "allowFirst";
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLAccessAccess.insertXMLAccess");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "INSERT INTO xml_access (guid, principal_name, permission, perm_type, perm_order, accessfileid, subtreeid ) VALUES (?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, guid);
            pstmt.setString(2, principalName);
            pstmt.setLong(3, permission);
            pstmt.setString(4, permType);
            pstmt.setString(5, permOrder);
            pstmt.setString(6, accessFileId);
            pstmt.setString(7, subTreeId);
            String sqlReport = "XMLAccessAccess.insertXMLAccess - SQL: " + sql;
            sqlReport = sqlReport + " [" + guid + "," + principalName + "," + permission + "," + permType + "," + permOrder + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLAccessAccess.insertXMLAccess - SQL error when insertingxml access permissions for id: " + guid + ", principal: " + principalName + ":" + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
    }

    private void updateXMLAccessPermission(String guid, String principalName, Long permission) throws AccessException {
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.updateXMLAccessPermission - id is required when updating XML access record");
        }
        if (principalName == null) {
            throw new AccessException("XMLAccessAccess.updateXMLAccessPermission - principal is required when updating XML access record");
        }
        if (permission == null) {
            throw new AccessException("XMLAccessAccess.updateXMLAccessPermission - permission is required when updating XML access record");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLAccessAccess.updateXMLAccessPermission");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "UPDATE xml_access SET permission = ?WHERE guid = ? AND principal_name = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, permission);
            pstmt.setString(2, guid);
            pstmt.setString(3, principalName);
            String sqlReport = "XMLAccessAccess.updateXMLAccessPermission - SQL: " + sql;
            sqlReport = sqlReport + " [" + permission + "," + guid + "," + principalName + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLAccessAccess.updateXMLAccessPermission - SQL error when updatingxml access permissions for id: " + guid + ", principal: " + principalName + ":" + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
    }

    public void removeXMLAccessForPrincipal(String guid, String principalName, Long permission) throws AccessException {
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.removeXMLAccessForPrincipal - id is required when removing XML access");
        }
        if (principalName == null) {
            throw new AccessException("XMLAccessAccess.removeXMLAccessForPrincipal - principal is required when deleting XML access");
        }
        if (permission == null) {
            throw new AccessException("XMLAccessAccess.removeXMLAccessForPrincipal - permission is required when updating XML access");
        }
        Vector<XMLAccessDAO> xmlAccessList = this.getXMLAccessForPrincipal(guid, principalName);
        if (xmlAccessList.size() == 0) {
            this.logMetacat.warn((Object)("XMLAccessAccess.removeXMLAccessForPrincipal - attempting to remove access when no access record exists for id: " + guid + ", principal: " + principalName));
        } else {
            long permissionMask = 0L;
            for (XMLAccessDAO xmlAccessDAO : xmlAccessList) {
                permissionMask |= xmlAccessDAO.getPermission().longValue();
            }
            if (((permissionMask |= permission.longValue()) & permission) == permission) {
                this.deleteXMLAccessForPrincipal(guid, principalName);
            }
            if (xmlAccessList.size() <= 1) {
                this.updateXMLAccessPermission(guid, principalName, permission);
            }
        }
    }

    public void deleteXMLAccessForDoc(String guid) throws AccessException {
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.deleteXMLAccessForPrincipal - id is required when deleting XML access record");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLAccessAccess.deleteXMLAccessForDoc");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "DELETE FROM xml_access WHERE guid = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, guid);
            String sqlReport = "XMLAccessAccess.deleteXMLAccessForDoc - SQL: " + sql;
            sqlReport = sqlReport + " [" + guid + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLAccessAccess.deleteXMLAccessForDoc - SQL error when deletingxml access permissions for id: " + guid + ":" + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
    }

    private void deleteXMLAccessForPrincipal(String guid, String principalName) throws AccessException {
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.deleteXMLAccessForPrincipal - id is required when deleting XML access record");
        }
        if (principalName == null) {
            throw new AccessException("XMLAccessAccess.deleteXMLAccessForPrincipal - principal is required when deleting XML access record");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLAccessAccess.deleteXMLAccessForPrincipal");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "DELETE FROM xml_access WHERE guid = ? AND principal_name = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, guid);
            pstmt.setString(2, principalName);
            String sqlReport = "XMLAccessAccess.deleteXMLAccessForPrincipal - SQL: " + sql;
            sqlReport = sqlReport + " [" + guid + "," + principalName + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLAccessAccess.deleteXMLAccessForPrincipal - SQL error when deletingxml access permissions for id: " + guid + ", principal: " + principalName + ":" + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
    }

    public void deleteXMLAccessForDoc(String guid, String permType) throws AccessException {
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.deleteXMLAccessForDoc - id is required when deleting XML access record");
        }
        if (permType == null) {
            throw new AccessException("XMLAccessAccess.deleteXMLAccessForDoc - permType is required when deleting XML access record");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLAccessAccess.deleteXMLAccessForDoc");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "DELETE FROM xml_access WHERE guid = ? AND perm_type = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, guid);
            pstmt.setString(2, permType);
            String sqlReport = "XMLAccessAccess.deleteXMLAccessForDoc - SQL: " + sql;
            sqlReport = sqlReport + " [" + guid + "," + permType + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLAccessAccess.deleteXMLAccessForDoc - SQL error when deletingxml access permissions for id: " + guid + ", permType: " + permType + ":" + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
    }

    private void permOrderConflict(String guid, String permOrder) throws AccessException, PermOrderException {
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.permOrderConflict - id is required when determining perm order conflict");
        }
        if (permOrder == null) {
            throw new AccessException("XMLAccessAccess.permOrderConflict - perm order is required when determining perm order conflict");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLAccessAccess.permOrderConflict");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "SELECT * FROM xml_access WHERE guid = ? AND perm_order != ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, guid);
            pstmt.setString(2, permOrder);
            String sqlReport = "XMLAccessAccess.permOrderConflict - SQL: " + sql;
            sqlReport = sqlReport + " [" + guid + "," + permOrder + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            if (resultSet.next()) {
                throw new PermOrderException("XMLAccessAccess.addXMLAccess - cannot add permission record for id: " + guid + "with permOrder: " + permOrder + " due to permOrder conflict");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLAccessAccess.permOrderConflict - SQL error when checkingfor perm order conflict on: " + guid + ":" + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
    }

    private void deleteXMLAccessForPrincipal(String guid, String principalName, String permType, String permOrder) throws AccessException {
        if (guid == null) {
            throw new AccessException("XMLAccessAccess.deleteXMLAccessForPrincipal - id is required when deleting XML access record");
        }
        if (principalName == null) {
            throw new AccessException("XMLAccessAccess.deleteXMLAccessForPrincipal - principal is required when deleting XML access record");
        }
        if (permType == null) {
            throw new AccessException("XMLAccessAccess.deleteXMLAccessForPrincipal - perm type is required when deleting XML access record");
        }
        if (permOrder == null) {
            throw new AccessException("XMLAccessAccess.deleteXMLAccessForPrincipal - perm order is required when deleting XML access record");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLAccessAccess.deleteXMLAccessForPrincipal");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "DELETE FROM xml_access WHERE guid = ? AND principal_name = ? AND perm_type = ? AND perm_order = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, guid);
            pstmt.setString(2, principalName);
            pstmt.setString(3, permType);
            pstmt.setString(4, permOrder);
            String sqlReport = "XMLAccessAccess.deleteXMLAccessForPrincipal - SQL: " + sql;
            sqlReport = sqlReport + " [" + guid + "," + principalName + "," + permType + "," + permOrder + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLAccessAccess.deleteXMLAccessForPrincipal - SQL error when deletingxml access permissions for id: " + guid + ", principal: " + principalName + ":" + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
    }

    private void cleanupXMLAccessForPrincipal(Vector<XMLAccessDAO> xmlAccessList) throws AccessException {
        int numAllowRecords = 0;
        int numDenyRecords = 0;
        long allowPermissionMask = 0L;
        long denyPermissionMask = 0L;
        String guid = null;
        String principalName = null;
        String permType = null;
        String permOrder = null;
        String accessFileId = null;
        String subTreeId = null;
        for (XMLAccessDAO xmlAccessDAO : xmlAccessList) {
            String daoId = xmlAccessDAO.getGuid();
            if (guid == null) {
                guid = daoId;
            } else if (!guid.equals(daoId)) {
                throw new AccessException("XMLAccessAccess.cleanupXMLAccessForPrincipal -  Conflicting ids " + daoId + " and " + guid);
            }
            if (principalName == null) {
                principalName = xmlAccessDAO.getPrincipalName();
            } else if (!principalName.equals(xmlAccessDAO.getPrincipalName())) {
                throw new AccessException("XMLAccessAccess.cleanupXMLAccessForPrincipal -  Conflicting prinicpal names " + xmlAccessDAO.getPrincipalName() + " and principalName " + principalName);
            }
            if (permType == null) {
                permType = xmlAccessDAO.getPermType();
            } else if (!permType.equals(xmlAccessDAO.getPermType())) {
                throw new AccessException("XMLAccessAccess.cleanupXMLAccessForPrincipal -  Conflicting permission orders for document " + daoId + "principalName " + principalName + ". Database intervention required ");
            }
            if (permOrder == null) {
                permOrder = xmlAccessDAO.getPermOrder();
            } else if (!permOrder.equals(xmlAccessDAO.getPermOrder())) {
                throw new AccessException("XMLAccessAccess.cleanupXMLAccessForPrincipal -  Conflicting permission types for document " + daoId + "principalName " + principalName + ". Database intervention required ");
            }
            if (permType == null) {
                permType = xmlAccessDAO.getPermType();
            } else if (!permType.equals(xmlAccessDAO.getPermType())) {
                throw new AccessException("XMLAccessAccess.cleanupXMLAccessForPrincipal -  Conflicting permission orders for document " + daoId + "principalName " + principalName + ". Database intervention required ");
            }
            if (permType.equals("allow")) {
                ++numAllowRecords;
                allowPermissionMask |= xmlAccessDAO.getPermission().longValue();
            } else if (permType.equals("deny")) {
                ++numDenyRecords;
                denyPermissionMask |= xmlAccessDAO.getPermission().longValue();
            }
            if (accessFileId == null) {
                accessFileId = xmlAccessDAO.getAccessFileId();
            }
            if (subTreeId != null) continue;
            subTreeId = xmlAccessDAO.getSubTreeId();
        }
        if (numAllowRecords > 1) {
            this.deleteXMLAccessForPrincipal(guid, principalName, "allow", permOrder);
            this.insertXMLAccess(guid, principalName, allowPermissionMask, "allow", permOrder, accessFileId, subTreeId);
        }
        if (numDenyRecords > 1) {
            this.deleteXMLAccessForPrincipal(guid, principalName, "deny", permOrder);
            this.insertXMLAccess(guid, principalName, denyPermissionMask, "deny", permOrder, accessFileId, subTreeId);
        }
    }

    private void validateDocXMLAccessList(Vector<XMLAccessDAO> xmlAccessList) throws PermOrderException {
        String permOrder = null;
        for (XMLAccessDAO xmlAccessDAO : xmlAccessList) {
            String daoId = xmlAccessDAO.getGuid();
            if (permOrder == null) {
                permOrder = xmlAccessDAO.getPermOrder();
                continue;
            }
            if (permOrder.equals(xmlAccessDAO.getPermOrder())) continue;
            throw new PermOrderException("XMLAccessAccess.validateXMLAccessList -  Conflicting permission orders for document " + daoId + ". Database intervention required ");
        }
    }

    private void validatePrincipalXMLAccessList(Vector<XMLAccessDAO> xmlAccessList) throws PermOrderException {
        boolean allowFirst = false;
        boolean denyFirst = false;
        String guid = null;
        Vector<XMLAccessDAO> allowFirstAllows = new Vector<XMLAccessDAO>();
        Vector<XMLAccessDAO> allowFirstDenys = new Vector<XMLAccessDAO>();
        Vector<XMLAccessDAO> denyFirstAllows = new Vector<XMLAccessDAO>();
        Vector<XMLAccessDAO> denyFirstDenys = new Vector<XMLAccessDAO>();
        for (XMLAccessDAO xmlAccessDAO : xmlAccessList) {
            String daoId = xmlAccessDAO.getGuid();
            if (guid == null) {
                guid = daoId;
            }
            if (xmlAccessDAO.getPermOrder().equals("allowFirst")) {
                allowFirst = true;
                if (xmlAccessDAO.getPermType().equals("allow")) {
                    allowFirstAllows.add(xmlAccessDAO);
                    continue;
                }
                if (xmlAccessDAO.getPermType().equals("deny")) {
                    allowFirstDenys.add(xmlAccessDAO);
                    continue;
                }
                throw new PermOrderException("XMLAccessAccess.validatePrincipalXMLAccessList -  Invalid permission type: " + xmlAccessDAO.getPermType() + " for document " + daoId + ". Database intervention required ");
            }
            if (xmlAccessDAO.getPermOrder().equals("denyFirst")) {
                denyFirst = true;
                if (xmlAccessDAO.getPermType().equals("allow")) {
                    denyFirstAllows.add(xmlAccessDAO);
                    continue;
                }
                if (xmlAccessDAO.getPermType().equals("deny")) {
                    denyFirstDenys.add(xmlAccessDAO);
                    continue;
                }
                throw new PermOrderException("XMLAccessAccess.validatePrincipalXMLAccessList -  Invalid permission type: " + xmlAccessDAO.getPermType() + " for document " + daoId + ". Database intervention required ");
            }
            throw new PermOrderException("XMLAccessAccess.validatePrincipalXMLAccessList -  Invalid permission order: " + xmlAccessDAO.getPermOrder() + " for document " + daoId + ". Database intervention required ");
        }
        if (allowFirst && denyFirst) {
            throw new PermOrderException("XMLAccessAccess.validatePrincipalXMLAccessList -  Conflicting permission orders for document " + guid + ". Database intervention required ");
        }
    }

    protected XMLAccessDAO populateDAO(ResultSet resultSet) throws SQLException {
        XMLAccessDAO xmlAccessDAO = new XMLAccessDAO();
        xmlAccessDAO.setGuid(resultSet.getString("guid"));
        xmlAccessDAO.setAccessFileId(resultSet.getString("accessfileid"));
        xmlAccessDAO.setPrincipalName(resultSet.getString("principal_name"));
        xmlAccessDAO.setPermission(Long.valueOf(resultSet.getLong("permission")));
        xmlAccessDAO.setPermType(resultSet.getString("perm_type"));
        xmlAccessDAO.setPermOrder(resultSet.getString("perm_order"));
        xmlAccessDAO.setBeginTime(resultSet.getDate("begin_time"));
        xmlAccessDAO.setEndTime(resultSet.getDate("end_time"));
        xmlAccessDAO.setTicketCount(Long.valueOf(resultSet.getLong("ticket_count")));
        xmlAccessDAO.setSubTreeId(resultSet.getString("subtreeid"));
        xmlAccessDAO.setStartNodeId(resultSet.getString("startnodeid"));
        xmlAccessDAO.setEndNodeId(resultSet.getString("endnodeid"));
        return xmlAccessDAO;
    }
}

