/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.scheduler;

import edu.ucsb.nceas.metacat.scheduler.ScheduledJobAccess;
import edu.ucsb.nceas.metacat.scheduler.ScheduledJobDAO;
import edu.ucsb.nceas.metacat.scheduler.ScheduledJobParamDAO;
import edu.ucsb.nceas.metacat.shared.AccessException;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.DateUtil;
import edu.ucsb.nceas.utilities.StatusUtil;
import edu.ucsb.nceas.utilities.UtilException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerService
extends BaseService {
    private static SchedulerService schedulerService = null;
    private static Logger logMetacat = Logger.getLogger(SchedulerService.class);
    private static Scheduler sched = null;

    private SchedulerService() throws ServiceException {
        this.start();
    }

    public static SchedulerService getInstance() throws ServiceException {
        if (schedulerService == null) {
            schedulerService = new SchedulerService();
        }
        return schedulerService;
    }

    @Override
    public boolean refreshable() {
        return true;
    }

    @Override
    public void doRefresh() throws ServiceException {
        this.stop();
        this.start();
    }

    public void start() throws ServiceException {
        try {
            StdSchedulerFactory schedFact = new StdSchedulerFactory();
            sched = schedFact.getScheduler();
            sched.start();
            ScheduledJobAccess jobAccess = new ScheduledJobAccess();
            HashMap<Long, ScheduledJobDAO> allJobsMap = jobAccess.getAllJobs(null);
            for (Long jobId : allJobsMap.keySet()) {
                ScheduledJobDAO jobDAO = allJobsMap.get(jobId);
                String[] groups = new String[]{"scheduler_group"};
                if (!jobDAO.getStatus().equals(StatusUtil.SCHEDULED)) continue;
                this.rescheduleJob(jobDAO, "scheduler_user", groups, false);
            }
        }
        catch (AccessException ae) {
            throw new ServiceException("SchedulerService.start - DB Access issue when starting scheduler: ", ae);
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.start - Scheduler engine issue when starting scheduler: " + se.getMessage());
        }
    }

    @Override
    public void stop() throws ServiceException {
        try {
            sched.shutdown();
            sched = null;
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.stop - Could not shut down scheduler: " + se.getMessage());
        }
    }

    protected Vector<String> getStatus() throws ServiceException {
        return new Vector<String>();
    }

    public String scheduleJob(ScheduledJobDAO jobDAO, String username, String[] groups) throws ServiceException {
        Calendar startTimeCal = Calendar.getInstance();
        startTimeCal.setTime(jobDAO.getStartTime());
        Calendar endTimeCal = Calendar.getInstance();
        endTimeCal.setTime(jobDAO.getEndTime());
        HashMap<String, String> jobParams = new HashMap<String, String>();
        HashMap<String, ScheduledJobParamDAO> jobParamDAOs = jobDAO.getAllJobParams();
        for (String paramName : jobParamDAOs.keySet()) {
            jobParams.put(paramName, jobParamDAOs.get(paramName).getValue());
        }
        return this.scheduleJob(jobDAO.getName(), startTimeCal, endTimeCal, jobDAO.getIntervalValue(), jobDAO.getIntervalUnit(), jobDAO.getClassName(), jobDAO.getGroupName(), jobParams);
    }

    public String scheduleJob(String jobName, Calendar startCal, Calendar endCal, int intervalValue, String intervalUnit, String jobClassName, String jobGroup, HashMap<String, String> jobParams) throws ServiceException {
        Class<Job> jobClass = null;
        try {
            jobClass = Class.forName(jobClassName);
            String startTimeStr = DateUtil.getHumanReadable((Calendar)startCal);
            logMetacat.info((Object)("SchedulerService.scheduleJob - Scheduling job -- name: " + jobName + ", class: " + jobClassName + ", start time: " + startTimeStr + ", interval value: " + intervalValue + ", interval unit: " + intervalUnit));
            this.startJob(jobName, startCal, endCal, intervalValue, intervalUnit, jobClass, jobGroup, jobParams);
            ScheduledJobAccess jobAccess = new ScheduledJobAccess();
            jobAccess.createJob(jobName, jobName, jobGroup, jobClass, startCal, endCal, intervalValue, intervalUnit, jobParams);
        }
        catch (AccessException ae) {
            try {
                this.deleteJob(jobName);
            }
            catch (Exception e) {
                logMetacat.error((Object)("SchedulerService.scheduleJob - An access exception was thrown when writing job: " + jobName + "to the db, and another exception was thrown when trying to remove the " + "job from the scheduler.  The db and scheduler may be out of sync: " + e.getMessage()));
            }
            throw new ServiceException("SchedulerService.scheduleJob - Error accessing db: ", ae);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceException("SchedulerService.scheduleJob - Could not find class with name: " + jobClassName + " : " + cnfe.getMessage());
        }
        catch (UtilException ue) {
            throw new ServiceException("SchedulerService.scheduleJob - Could not schedule job due to a utility issue: " + ue.getMessage());
        }
        return "Scheduled: " + jobName;
    }

    public String scheduleDelayedJob(String jobName, String delay, String jobClassName, String jobGroup, HashMap<String, String> jobParams, String username, String[] groups) throws ServiceException {
        Class<Job> jobClass = null;
        try {
            jobClass = Class.forName(jobClassName);
            Calendar startCal = this.getStartDateFromDelay(delay);
            logMetacat.info((Object)("SchedulerService.scheduleDelayedJob - Scheduling job -- name: " + jobName + ", delay: " + delay + ", job class name: " + jobClassName));
            this.startOneTimeJob(jobName, startCal, jobClass, jobGroup, jobParams);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceException("SchedulerService.scheduleJob - Could not find class with name: " + jobClassName + " : " + cnfe.getMessage());
        }
        return "Scheduled: " + jobName;
    }

    public String unscheduleJob(String jobName, String username, String[] groups) throws ServiceException {
        ScheduledJobDAO jobDAO = null;
        try {
            ScheduledJobAccess jobAccess = new ScheduledJobAccess();
            jobDAO = jobAccess.getJobByName(jobName);
            if (jobDAO == null) {
                throw new ServiceException("SchedulerService.unscheduleJob - Could not find job with name: " + jobName);
            }
            sched.deleteJob(jobDAO.getName(), jobDAO.getGroupName());
            jobDAO.setStatus(StatusUtil.UNSCHEDULED);
            jobAccess.updateJobStatus(jobDAO);
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.unscheduleJob - Could not create scheduled job because of service issue: " + se.getMessage());
        }
        catch (AccessException ae) {
            throw new ServiceException("SchedulerService.unscheduleJob - Could not create scheduled job : " + jobDAO.getName() + " because of db access issue: ", ae);
        }
        return "Unscheduled: " + jobName;
    }

    public String rescheduleJob(ScheduledJobDAO jobDAO, String username, String[] groups) throws ServiceException {
        return this.rescheduleJob(jobDAO, username, groups, true);
    }

    public String rescheduleJob(ScheduledJobDAO jobDAO, String username, String[] groups, boolean checkStatus) throws ServiceException {
        try {
            ScheduledJobAccess jobAccess = new ScheduledJobAccess();
            if (jobDAO == null) {
                throw new ServiceException("SchedulerService.reScheduleJob - Cannot reschedule nonexistant job.");
            }
            if (checkStatus && !jobDAO.getStatus().equals(StatusUtil.UNSCHEDULED)) {
                throw new ServiceException("SchedulerService.reScheduleJob - Cannot reschedule a job with status: " + jobDAO.getStatus() + ". Status must be 'unscheduled'.");
            }
            Calendar startCal = Calendar.getInstance();
            startCal.setTime(jobDAO.getStartTime());
            Calendar endCal = Calendar.getInstance();
            endCal.setTime(jobDAO.getEndTime());
            HashMap<String, String> jobParams = new HashMap<String, String>();
            HashMap<String, ScheduledJobParamDAO> jobParamDAOs = jobDAO.getAllJobParams();
            for (String paramName : jobParamDAOs.keySet()) {
                jobParams.put(paramName, jobParamDAOs.get(paramName).getValue());
            }
            Class<Job> jobClass = null;
            String jobClassName = jobDAO.getClassName();
            try {
                jobClass = Class.forName(jobClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServiceException("SchedulerService.scheduleJob - Could not find class with name: " + jobDAO.getClassName() + " : " + cnfe.getMessage());
            }
            String startTimeStr = DateUtil.getHumanReadable((Calendar)startCal);
            logMetacat.info((Object)("SchedulerService.rescheduleJob - name: " + jobDAO.getName() + ", class: " + jobClassName + ", start time: " + startTimeStr + ", interval value: " + jobDAO.getIntervalValue() + ", interval unit: " + jobDAO.getIntervalUnit()));
            this.startJob(jobDAO.getName(), startCal, endCal, jobDAO.getIntervalValue(), jobDAO.getIntervalUnit(), jobClass, jobDAO.getGroupName(), jobParams);
            jobDAO.setStatus(StatusUtil.SCHEDULED);
            jobAccess.updateJobStatus(jobDAO);
        }
        catch (AccessException ae) {
            throw new ServiceException("SchedulerService.reScheduleJob - Could not reschedule job : " + jobDAO.getName() + " because of db access issue: ", ae);
        }
        catch (UtilException ue) {
            throw new ServiceException("SchedulerService.reScheduleJob - Could not reschedule job : " + jobDAO.getName() + " due to a utility issue: " + ue.getMessage());
        }
        return "Rescheduled: " + jobDAO.getName();
    }

    public String deleteJob(String jobName) throws ServiceException {
        ScheduledJobDAO jobDAO = null;
        try {
            ScheduledJobAccess jobAccess = new ScheduledJobAccess();
            jobDAO = jobAccess.getJobByName(jobName);
        }
        catch (AccessException ae) {
            throw new ServiceException("SchedulerService.deleteJob - Could not delete scheduled job : " + jobDAO.getName() + " because of db access issue: ", ae);
        }
        return this.deleteJob(jobDAO);
    }

    public String deleteJob(ScheduledJobDAO jobDAO) throws ServiceException {
        String groupName = "";
        try {
            sched.deleteJob(jobDAO.getName(), groupName);
            jobDAO.setStatus(StatusUtil.DELETED);
            ScheduledJobAccess jobAccess = new ScheduledJobAccess();
            jobAccess.updateJobStatus(jobDAO);
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.deleteJob - Could not delete job: " + jobDAO.getName() + " for group: " + groupName + " : " + se.getMessage());
        }
        catch (AccessException ae) {
            throw new ServiceException("SchedulerService.deleteJob - Could not delete scheduled job: " + jobDAO.getName() + " because of db access issue: ", ae);
        }
        return "Deleted: " + jobDAO.getName();
    }

    public String getJobInfoXML(Long jobId) throws ServiceException {
        String jobInfoXML = "";
        try {
            ScheduledJobAccess jobAccess = new ScheduledJobAccess();
            ScheduledJobDAO scheduledJobDAO = jobAccess.getJob(jobId);
            jobInfoXML = jobInfoXML + "<scheduledJobs>" + this.jobToXML(scheduledJobDAO) + "</scheduledJobs>";
        }
        catch (AccessException ae) {
            throw new ServiceException("SchedulerService.getJobInfoXML - Could not get job info for job: " + jobId, ae);
        }
        return jobInfoXML;
    }

    public String getJobsInfoXML(String groupName, String paramName, String paramValue) throws ServiceException {
        String jobInfoXML = "";
        try {
            ScheduledJobAccess jobAccess = new ScheduledJobAccess();
            HashMap<Long, ScheduledJobDAO> JobDAOMap = jobAccess.getJobsWithParameter(groupName, paramName, paramValue);
            jobInfoXML = jobInfoXML + "<scheduledWorkflowResultset>";
            for (Long jobDAOId : JobDAOMap.keySet()) {
                ScheduledJobParamDAO jobParamDAO;
                ScheduledJobDAO jobDAO = JobDAOMap.get(jobDAOId);
                if (paramValue == null || paramName == null || (jobParamDAO = jobDAO.getJobParam(paramName)) == null || !jobParamDAO.getValue().equals(paramValue)) continue;
                jobInfoXML = jobInfoXML + this.jobToXML(JobDAOMap.get(jobDAOId));
            }
            jobInfoXML = jobInfoXML + "</scheduledWorkflowResultset>";
        }
        catch (AccessException ae) {
            throw new ServiceException("SchedulerService.getJobInfoXML - Could not get jobs info for group: " + groupName, ae);
        }
        return jobInfoXML;
    }

    public void getJobsInfoXML(String groupName, String paramName, String paramValue, PrintWriter pw) throws ServiceException {
        try {
            ScheduledJobAccess jobAccess = new ScheduledJobAccess();
            HashMap<Long, ScheduledJobDAO> JobDAOMap = jobAccess.getJobsWithParameter(groupName, paramName, paramValue);
            pw.print("<scheduledWorkflowResultset>");
            for (Long jobDAOId : JobDAOMap.keySet()) {
                ScheduledJobParamDAO jobParamDAO;
                ScheduledJobDAO jobDAO = JobDAOMap.get(jobDAOId);
                if (paramValue == null || paramName == null || (jobParamDAO = jobDAO.getJobParam(paramName)) == null || !jobParamDAO.getValue().equals(paramValue)) continue;
                pw.print(this.jobToXML(JobDAOMap.get(jobDAOId)));
            }
            pw.print("</scheduledWorkflowResultset>");
        }
        catch (AccessException ae) {
            throw new ServiceException("SchedulerService.getJobInfoXML - Could not get jobs info for group: " + groupName, ae);
        }
    }

    public String jobToXML(ScheduledJobDAO scheduledJobDAO) throws ServiceException {
        String jobXML = "";
        if (scheduledJobDAO != null) {
            jobXML = jobXML + "<scheduledJob>";
            jobXML = jobXML + "<id>" + scheduledJobDAO.getId() + "</id>";
            jobXML = jobXML + "<createTime>" + scheduledJobDAO.getCreateTime() + "</createTime>";
            jobXML = jobXML + "<modTime>" + scheduledJobDAO.getModTime() + "</modTime>";
            jobXML = jobXML + "<status>" + scheduledJobDAO.getStatus() + "</status>";
            jobXML = jobXML + "<name>" + scheduledJobDAO.getName() + "</name>";
            jobXML = jobXML + "<triggerName>" + scheduledJobDAO.getName() + "</triggerName>";
            jobXML = jobXML + "<groupName>" + scheduledJobDAO.getGroupName() + "</groupName>";
            jobXML = jobXML + "<className>" + scheduledJobDAO.getClassName() + "</className>";
            String startTimeString = null;
            try {
                startTimeString = DateUtil.getHumanReadable((Timestamp)scheduledJobDAO.getStartTime());
            }
            catch (UtilException ue) {
                throw new ServiceException("SchedulerService.jobToXML - error getting human readable date for job: " + scheduledJobDAO.getId() + " ; " + ue.getMessage());
            }
            jobXML = jobXML + "<startTime>" + startTimeString + "</startTime>";
            String endTimeString = null;
            try {
                if (scheduledJobDAO.getEndTime() != null) {
                    endTimeString = DateUtil.getHumanReadable((Timestamp)scheduledJobDAO.getEndTime());
                }
            }
            catch (UtilException ue) {
                throw new ServiceException("SchedulerService.jobToXML - error getting human readable date for job: " + scheduledJobDAO.getId() + " ; " + ue.getMessage());
            }
            jobXML = jobXML + "<endTime>" + endTimeString + "</endTime>";
            jobXML = jobXML + "<intervalValue>" + scheduledJobDAO.getIntervalValue() + "</intervalValue>";
            jobXML = jobXML + "<intervalUnit>" + scheduledJobDAO.getIntervalUnit() + "</intervalUnit>";
            HashMap<String, ScheduledJobParamDAO> jobParams = scheduledJobDAO.getAllJobParams();
            for (String jobParamKey : jobParams.keySet()) {
                jobXML = jobXML + "<jobParam name='" + jobParams.get(jobParamKey).getKey() + "'>";
                jobXML = jobXML + "<id>" + jobParams.get(jobParamKey).getId() + "</id>";
                jobXML = jobXML + "<createTime>" + jobParams.get(jobParamKey).getCreateTime() + "</createTime>";
                jobXML = jobXML + "<modTime>" + jobParams.get(jobParamKey).getModTime() + "</modTime>";
                jobXML = jobXML + "<status>" + jobParams.get(jobParamKey).getStatus() + "</status>";
                jobXML = jobXML + "<jobId>" + jobParams.get(jobParamKey).getJobId() + "</jobId>";
                jobXML = jobXML + "<key>" + jobParams.get(jobParamKey).getKey() + "</key>";
                jobXML = jobXML + "<value>" + jobParams.get(jobParamKey).getValue() + "</value>";
                jobXML = jobXML + "</jobParam>";
            }
            jobXML = jobXML + "</scheduledJob>";
        }
        return jobXML;
    }

    private void startJob(String jobName, Calendar startCal, Calendar endCal, int intervalValue, String intervalUnit, Class<Job> jobClass, String jobGroup, HashMap<String, String> jobParams) throws ServiceException {
        JobDetail jobDetail = new JobDetail(jobName, jobGroup, jobClass);
        jobDetail.setJobDataMap(new JobDataMap(jobParams));
        if (intervalUnit.equals("sec")) {
            this.scheduleSecondlyJob(jobName, jobClass, startCal, endCal, intervalValue, jobGroup, jobDetail);
        } else if (intervalUnit.equals("min")) {
            this.scheduleMinutelyJob(jobName, jobClass, startCal, endCal, intervalValue, jobGroup, jobDetail);
        } else if (intervalUnit.equals("hour")) {
            this.scheduleHourlyJob(jobName, jobClass, startCal, endCal, intervalValue, jobGroup, jobDetail);
        } else if (intervalUnit.equals("day")) {
            this.scheduleDailyJob(jobName, jobClass, startCal, endCal, intervalValue, jobGroup, jobDetail);
        } else if (intervalUnit.equals("week")) {
            this.scheduleWeeklyJob(jobName, jobClass, startCal, endCal, intervalValue, jobGroup, jobDetail);
        } else if (intervalUnit.equals("mon")) {
            this.scheduleMonthlyJob(jobName, jobClass, startCal, endCal, intervalValue, jobGroup, jobDetail);
        } else {
            throw new ServiceException("SchedulerService.scheduleJob - Could not interpret interval unit: " + intervalUnit + ". Unit must be sec, min, hour, day, week or mon");
        }
    }

    private void startOneTimeJob(String jobName, Calendar startTime, Class<Job> jobClass, String jobGroup, HashMap<String, String> jobParams) throws ServiceException {
        JobDetail jobDetail = new JobDetail(jobName, jobGroup, jobClass);
        jobDetail.setJobDataMap(new JobDataMap(jobParams));
        SimpleTrigger trigger = new SimpleTrigger();
        trigger.setName(jobName);
        trigger.setStartTime(startTime.getTime());
        trigger.setRepeatCount(1);
        try {
            sched.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.scheduleSecondlyJob - Could not create scheduler: " + se.getMessage());
        }
    }

    private void scheduleSecondlyJob(String jobName, Class<Job> jobClass, Calendar startTime, Calendar endTime, int interval, String jobGroup, JobDetail jobDetail) throws ServiceException {
        Trigger trigger = TriggerUtils.makeSecondlyTrigger((int)interval);
        trigger.setName(jobName);
        trigger.setStartTime(startTime.getTime());
        if (endTime != null) {
            trigger.setEndTime(endTime.getTime());
        }
        try {
            sched.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.scheduleSecondlyJob - Could not create scheduler: " + se.getMessage());
        }
    }

    private void scheduleMinutelyJob(String jobName, Class<Job> jobClass, Calendar startTime, Calendar endTime, int interval, String jobGroup, JobDetail jobDetail) throws ServiceException {
        Trigger trigger = TriggerUtils.makeMinutelyTrigger((int)interval);
        trigger.setName(jobName);
        trigger.setStartTime(startTime.getTime());
        if (endTime != null) {
            trigger.setEndTime(endTime.getTime());
        }
        try {
            sched.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.scheduleMinutelyJob - Could not create scheduler: " + se.getMessage());
        }
    }

    private void scheduleHourlyJob(String jobName, Class<Job> jobClass, Calendar startTime, Calendar endTime, int interval, String jobGroup, JobDetail jobDetail) throws ServiceException {
        Trigger trigger = TriggerUtils.makeHourlyTrigger((int)interval);
        trigger.setName(jobName);
        trigger.setStartTime(startTime.getTime());
        if (endTime != null) {
            trigger.setEndTime(endTime.getTime());
        }
        try {
            sched.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.scheduleHourlyJob - Could not create scheduler: " + se.getMessage());
        }
    }

    private void scheduleDailyJob(String jobName, Class<Job> jobClass, Calendar startTime, Calendar endTime, int interval, String jobGroup, JobDetail jobDetail) throws ServiceException {
        Trigger trigger = TriggerUtils.makeDailyTrigger((int)startTime.get(10), (int)startTime.get(12));
        trigger.setName(jobName);
        trigger.setStartTime(startTime.getTime());
        if (endTime != null) {
            trigger.setEndTime(endTime.getTime());
        }
        try {
            sched.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.scheduleHourlyJob - Could not create scheduler: " + se.getMessage());
        }
    }

    private void scheduleWeeklyJob(String jobName, Class<Job> jobClass, Calendar startTime, Calendar endTime, int interval, String jobGroup, JobDetail jobDetail) throws ServiceException {
        Trigger trigger = TriggerUtils.makeWeeklyTrigger((int)startTime.get(7), (int)startTime.get(10), (int)startTime.get(12));
        trigger.setName(jobName);
        trigger.setStartTime(startTime.getTime());
        if (endTime != null) {
            trigger.setEndTime(endTime.getTime());
        }
        try {
            sched.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.scheduleHourlyJob - Could not create scheduler: " + se.getMessage());
        }
    }

    private void scheduleMonthlyJob(String jobName, Class<Job> jobClass, Calendar startTime, Calendar endTime, int interval, String jobGroup, JobDetail jobDetail) throws ServiceException {
        Trigger trigger = TriggerUtils.makeMonthlyTrigger((int)startTime.get(5), (int)startTime.get(10), (int)startTime.get(12));
        trigger.setName(jobName);
        trigger.setStartTime(startTime.getTime());
        if (endTime != null) {
            trigger.setEndTime(endTime.getTime());
        }
        try {
            sched.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException se) {
            throw new ServiceException("SchedulerService.scheduleHourlyJob - Could not create scheduler: " + se.getMessage());
        }
    }

    public Calendar getStartDateFromDelay(String delay) throws ServiceException {
        int delayValue;
        Calendar cal = Calendar.getInstance();
        char delayUnit = delay.trim().charAt(delay.length() - 1);
        String delayStrValue = delay.trim().substring(0, delay.length() - 1);
        try {
            delayValue = Integer.parseInt(delayStrValue);
        }
        catch (NumberFormatException nfe) {
            throw new ServiceException("SchedulerService.getStartDateFromDelay - Could not parse delay value into an integer: " + delayStrValue + " : " + nfe.getMessage());
        }
        switch (delayUnit) {
            case 'S': 
            case 's': {
                cal.add(13, delayValue);
                break;
            }
            case 'M': 
            case 'm': {
                cal.add(12, delayValue);
                break;
            }
            case 'H': 
            case 'h': {
                cal.add(10, delayValue);
                break;
            }
            case 'D': 
            case 'd': {
                cal.add(6, delayValue);
                break;
            }
            default: {
                throw new ServiceException("SchedulerService.getStartDateFromDelay - Could not interpret delay unit: " + delayUnit + ". Unit must be s, m, h or d");
            }
        }
        return cal;
    }
}

