/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.service;

import edu.ucsb.nceas.metacat.service.XMLSchemaService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import org.apache.log4j.Logger;

public class XMLSchema {
    private String fileNamespace = null;
    private String externalFileUri = null;
    private String fileName = null;
    private String localFileUri = null;
    private String localFileDir = null;
    private String formatId = null;
    private Logger logMetacat = Logger.getLogger(XMLSchema.class);

    public XMLSchema(String fileNamespace, String externalFileUri, String formatId) {
        this.setFileNamespace(fileNamespace);
        this.setExternalFileUri(externalFileUri);
        this.setFormatId(formatId);
    }

    public void setFileName(String fileName) {
        if (fileName.startsWith("/schema/")) {
            fileName = fileName.substring("/schema/".length());
        } else if (fileName.startsWith("http") && fileName.contains("/schema/")) {
            int index = fileName.lastIndexOf("/schema/") + "/schema/".length();
            fileName = fileName.substring(index);
        } else if (fileName.startsWith("http")) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        }
        this.fileName = fileName;
        try {
            this.localFileUri = SystemUtil.getContextURL() + "/schema/" + fileName;
            this.logMetacat.debug((Object)("XMLSchema.setFileName - localFileUri: " + this.localFileUri));
        }
        catch (PropertyNotFoundException pnfe) {
            this.localFileUri = "/schema/" + fileName;
            this.logMetacat.warn((Object)("XMLSchema.setFileName - Could not get context url. Setting localFileUri to: " + this.localFileUri));
        }
        try {
            String fileDir = SystemUtil.getContextDir() + "/schema/" + fileName;
            this.localFileDir = FileUtil.normalizePath((String)fileDir);
            this.logMetacat.debug((Object)("XMLSchema.setFileName - localFileDir: " + this.localFileDir));
        }
        catch (PropertyNotFoundException pnfe) {
            this.localFileDir = "/schema/" + fileName;
            this.logMetacat.warn((Object)("XMLSchema.setFileName - Could not get context directory. Setting localFileDir to: " + this.localFileDir));
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileNamespace(String fileNamespace) {
        this.fileNamespace = fileNamespace;
    }

    public String getFileNamespace() {
        return this.fileNamespace;
    }

    public void setExternalFileUri(String externalFileUri) {
        this.externalFileUri = externalFileUri;
        String fileName = XMLSchemaService.getSchemaFileNameFromUri(externalFileUri);
        this.setFileName(fileName);
    }

    public String getExternalFileUri() {
        return this.externalFileUri;
    }

    public void setLocalFileUri(String localFileUri) {
        if (!localFileUri.startsWith("http://")) {
            try {
                localFileUri = SystemUtil.getContextURL() + "/schema/" + localFileUri;
            }
            catch (PropertyNotFoundException pnfe) {
                this.logMetacat.warn((Object)("XMLSchema.setLocalFileUri - Could not find context url: " + pnfe.getMessage() + ". Setting schema file uri to: " + "/schema/" + localFileUri));
                localFileUri = "/schema/" + localFileUri;
            }
        }
        this.localFileUri = localFileUri;
    }

    public String getLocalFileUri() {
        return this.localFileUri;
    }

    public String getLocalFileDir() {
        return this.localFileDir;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public void setFormatId(String formatId) {
        this.formatId = formatId;
    }
}

