/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.spatial;

import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SldFactory
extends HttpServlet {
    static Document document;
    static String sld;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    private void handleGetOrPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String dataset = request.getParameter("originalSld");
        try {
            String certPath = SystemUtil.getContextDir();
            String filename = certPath + "/data/styles/" + dataset;
            String sld = this.getSld(filename);
            System.out.println(sld);
            response.setContentType("text/xml");
            response.getWriter().write(sld);
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getSld(String filename) throws FileNotFoundException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Vector<String> allowedDocids = new Vector<String>();
        allowedDocids.add("nceas.288");
        allowedDocids.add("nrs.720");
        String rulesString = "";
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(filename));
            Element root = document.getDocumentElement();
            NodeList elemList = document.getElementsByTagName("Rule");
            Node ruleNode = elemList.item(0);
            Element filterElement = this.getFilterElement(document, allowedDocids);
            ruleNode.appendChild(filterElement);
            rulesString = XMLUtilities.getDOMTreeAsString((Node)root, (boolean)true);
        }
        catch (SAXException sxe) {
            sxe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return rulesString;
    }

    private Element getFilterElement(Document inDoc, Vector docids) {
        Element filterElem = inDoc.createElement("ogc:Filter");
        Element orElem = inDoc.createElement("ogc:Or");
        String docid = "";
        for (int i = 0; i < docids.size(); ++i) {
            Element opElem = inDoc.createElement("ogc:PropertyIsEqualTo");
            Element propertyElem = inDoc.createElement("ogc:PropertyName");
            Text propertyText = inDoc.createTextNode("docid");
            propertyElem.appendChild(propertyText);
            Element literalElem = inDoc.createElement("ogc:Literal");
            docid = (String)docids.elementAt(i);
            Text literalText = inDoc.createTextNode(docid);
            literalElem.appendChild(literalText);
            opElem.appendChild(propertyElem);
            opElem.appendChild(literalElem);
            orElem.appendChild(opElem);
        }
        filterElem.appendChild(orElem);
        return filterElem;
    }
}

