/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.graphic.HtmlColor;

public abstract class EntityUtils {
    private static IEntity withNoParent(final IEntity iEntity) {
        if (iEntity.getType() == EntityType.GROUP) {
            throw new IllegalArgumentException();
        }
        return new IEntity(){

            @Override
            public List<Member> getFieldsToDisplay() {
                return iEntity.getFieldsToDisplay();
            }

            @Override
            public String getDisplay() {
                return iEntity.getDisplay();
            }

            @Override
            public Group getParent() {
                return null;
            }

            @Override
            public Stereotype getStereotype() {
                return iEntity.getStereotype();
            }

            @Override
            public void setStereotype(Stereotype stereotype) {
                iEntity.setStereotype(stereotype);
            }

            @Override
            public EntityType getType() {
                return iEntity.getType();
            }

            @Override
            public String getUid() {
                return iEntity.getUid();
            }

            @Override
            public Url getUrl() {
                return iEntity.getUrl();
            }

            @Override
            public List<Member> getMethodsToDisplay() {
                return iEntity.getMethodsToDisplay();
            }

            @Override
            public DrawFile getImageFile() {
                return iEntity.getImageFile();
            }

            @Override
            public HtmlColor getSpecificBackColor() {
                return iEntity.getSpecificBackColor();
            }

            @Override
            public void setSpecificBackcolor(HtmlColor htmlColor) {
                throw new UnsupportedOperationException();
            }

            public int hashCode() {
                return iEntity.hashCode();
            }

            public boolean equals(Object object) {
                return iEntity.equals(object);
            }

            public String toString() {
                return "NoParent " + iEntity.toString();
            }

            @Override
            public String getCode() {
                return iEntity.getCode();
            }

            @Override
            public DrawFile getImageFile(File file) throws IOException {
                return iEntity.getImageFile(file);
            }

            @Override
            public boolean isTop() {
                return iEntity.isTop();
            }

            @Override
            public void setTop(boolean bl) {
                iEntity.setTop(bl);
            }

            @Override
            public boolean hasNearDecoration() {
                return iEntity.hasNearDecoration();
            }

            @Override
            public void setNearDecoration(boolean bl) {
                iEntity.setNearDecoration(bl);
            }

            @Override
            public int compareTo(IEntity iEntity2) {
                return iEntity.compareTo(iEntity2);
            }

            @Override
            public int getIndex() {
                return iEntity.getIndex();
            }

            @Override
            public int getXposition() {
                return iEntity.getXposition();
            }

            @Override
            public void setXposition(int n) {
                iEntity.setXposition(n);
            }
        };
    }
}

