/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.UFont;

public class Stereotype
implements CharSequence {
    private static final Pattern circle = Pattern.compile("\\<\\<\\s*\\(?(\\S)\\s*,\\s*(#[0-9a-fA-F]{6}|\\w+)\\s*(?:[),](.*?))?\\>\\>");
    private final String label;
    private final HtmlColor htmlColor;
    private final char character;
    private final double radius;
    private final UFont circledFont;

    public Stereotype(String string, double d, UFont uFont) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!string.startsWith("<<") || !string.endsWith(">>")) {
            throw new IllegalArgumentException(string);
        }
        this.radius = d;
        this.circledFont = uFont;
        Matcher matcher = circle.matcher(string);
        if (matcher.find()) {
            this.label = StringUtils.isNotEmpty(matcher.group(3)) ? "<<" + matcher.group(3) + ">>" : null;
            String string2 = matcher.group(2);
            this.htmlColor = HtmlColor.getColorIfValid(string2);
            this.character = matcher.group(1).charAt(0);
        } else {
            this.label = string;
            this.character = '\u0000';
            this.htmlColor = null;
        }
    }

    public Stereotype(String string) {
        this.label = string;
        this.htmlColor = null;
        this.character = '\u0000';
        this.radius = 0.0;
        this.circledFont = null;
    }

    public HtmlColor getHtmlColor() {
        return this.htmlColor;
    }

    public char getCharacter() {
        return this.character;
    }

    public String getLabel() {
        assert (this.label == null || this.label.length() > 0);
        return this.label;
    }

    public boolean isSpotted() {
        return this.character != '\u0000';
    }

    public String toString() {
        if (this.label == null) {
            return "" + this.character;
        }
        if (this.character == '\u0000') {
            return this.label;
        }
        return this.character + " " + this.label;
    }

    public char charAt(int n) {
        return this.toString().charAt(n);
    }

    public int length() {
        return this.toString().length();
    }

    public CharSequence subSequence(int n, int n2) {
        return this.toString().subSequence(n, n2);
    }

    public double getRadius() {
        return this.radius;
    }

    public final UFont getCircledFont() {
        return this.circledFont;
    }
}

