/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizMaker;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.png.PngIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupPngMaker {
    private final CucaDiagram diagram;
    private final Group group;
    private final FileFormat fileFormat;

    public GroupPngMaker(CucaDiagram cucaDiagram, Group group, FileFormat fileFormat) throws IOException {
        this.diagram = cucaDiagram;
        this.group = group;
        this.fileFormat = fileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPng(OutputStream outputStream, List<String> list) throws IOException, InterruptedException {
        HashMap<Entity, File> hashMap = new HashMap<Entity, File>();
        try {
            GraphvizMaker graphvizMaker = this.createDotMaker(list);
            String string = graphvizMaker.createDotString();
            Graphviz graphviz = GraphvizUtils.create(string, "png");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            graphviz.createPng(byteArrayOutputStream);
            byteArrayOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
            byteArrayInputStream.close();
            PngIO.write((RenderedImage)bufferedImage, outputStream, this.diagram.getMetadata(), 96);
        }
        finally {
            this.cleanTemporaryFiles(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSvg(List<String> list) throws IOException, InterruptedException {
        HashMap<Entity, File> hashMap = new HashMap<Entity, File>();
        try {
            GraphvizMaker graphvizMaker = this.createDotMaker(list);
            String string = graphvizMaker.createDotString();
            Graphviz graphviz = GraphvizUtils.create(string, "svg");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            graphviz.createPng(byteArrayOutputStream);
            byteArrayOutputStream.close();
            String string2 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            string2 = GroupPngMaker.removeSvgXmlHeader(string2);
            String string3 = string2.replace('\\', '/');
            return string3;
        }
        finally {
            this.cleanTemporaryFiles(hashMap);
        }
    }

    private static String removeSvgXmlHeader(String string) {
        string = string.replaceFirst("(?i)<\\?xml[\\s\\S]*?<svg[^>]*>", "");
        string = string.replaceFirst("(?i)</svg>", "");
        return string;
    }

    private void cleanTemporaryFiles(Map<Entity, File> map) {
        if (!OptionFlags.getInstance().isKeepTmpFiles()) {
            for (File file : map.values()) {
                FileUtils.delete(file);
            }
        }
    }

    GraphvizMaker createDotMaker(List<String> list) {
        List<Link> list2 = this.getPureInnerLinks();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        DotData dotData = new DotData(this.group, list2, this.group.entities(), this.diagram.getUmlDiagramType(), iSkinParam, this.group.getRankdir(), new InnerGroupHierarchy(), this.diagram.getColorMapper());
        return this.diagram.getSkinParam().getStrategy().getGraphvizMaker(dotData, list, this.fileFormat);
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            IEntity iEntity = link.getEntity1();
            IEntity iEntity2 = link.getEntity2();
            if (iEntity.getParent() != this.group || iEntity.getType() == EntityType.GROUP || iEntity2.getParent() != this.group || iEntity2.getType() == EntityType.GROUP) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Collection<Group> getChildrenGroups(Group group) {
            if (group == null) {
                return GroupPngMaker.this.diagram.getChildrenGroups(GroupPngMaker.this.group);
            }
            return GroupPngMaker.this.diagram.getChildrenGroups(group);
        }

        @Override
        public boolean isEmpty(Group group) {
            return GroupPngMaker.this.diagram.isEmpty(group);
        }
    }
}

