/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Note
implements Event,
SpecificBackcolorable {
    private final Participant p;
    private final Participant p2;
    private final List<String> strings;
    private final NotePosition position;
    private final Url url;
    private HtmlColor specificBackcolor;

    public Note(Participant participant, NotePosition notePosition, List<String> list) {
        this(participant, null, notePosition, list);
    }

    public Note(Participant participant, Participant participant2, List<String> list) {
        this(participant, participant2, NotePosition.OVER_SEVERAL, list);
    }

    private Note(Participant participant, Participant participant2, NotePosition notePosition, List<String> list) {
        this.p = participant;
        this.p2 = participant2;
        this.position = notePosition;
        this.url = list != null && list.size() > 0 ? Note.extractUrl(list.get(0)) : null;
        this.strings = this.url == null ? list : list.subList(1, list.size());
    }

    public static Url extractUrl(String string) {
        Pattern pattern = Pattern.compile("(?i)^\\[\\[([^|]*)(?:\\|([^|]*))?\\]\\]$");
        Matcher matcher = pattern.matcher(string.trim());
        if (!matcher.matches()) {
            return null;
        }
        return new Url(matcher.group(1), matcher.group(2));
    }

    public Participant getParticipant() {
        return this.p;
    }

    public Participant getParticipant2() {
        return this.p2;
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public NotePosition getPosition() {
        return this.position;
    }

    @Override
    public HtmlColor getSpecificBackColor() {
        return this.specificBackcolor;
    }

    @Override
    public void setSpecificBackcolor(HtmlColor htmlColor) {
        this.specificBackcolor = htmlColor;
    }

    @Override
    public boolean dealWith(Participant participant) {
        return this.p == participant || this.p2 == participant;
    }

    @Override
    public Url getUrl() {
        return this.url;
    }
}

