/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandActivate
extends SingleLineCommand<SequenceDiagram> {
    public CommandActivate(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram, "(?i)^(activate|deactivate|destroy|create)\\s+([\\p{L}0-9_.]+|\"[^\"]+\")\\s*(#\\w+)?$");
    }

    @Override
    protected CommandExecutionResult executeArg(List<String> list) {
        LifeEventType lifeEventType = LifeEventType.valueOf(list.get(0).toUpperCase());
        Participant participant = ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(1)));
        ((SequenceDiagram)this.getSystem()).activate(participant, lifeEventType, HtmlColor.getColorIfValid(list.get(2)));
        return CommandExecutionResult.ok();
    }
}

