/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverPolygonEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverPolygonEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, EpsGraphics epsGraphics) {
        UPolygon uPolygon = (UPolygon)uShape;
        double[] dArray = new double[uPolygon.getPoints().size() * 2];
        int n = 0;
        for (Point2D.Double double_ : uPolygon.getPoints()) {
            dArray[n++] = ((Point2D)double_).getX() + d;
            dArray[n++] = ((Point2D)double_).getY() + d2;
        }
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null) {
            for (int i = 0; i < dArray.length; i += 2) {
                if (uClip.isInside(dArray[i], dArray[i + 1])) continue;
                return;
            }
        }
        epsGraphics.setFillColor(colorMapper.getMappedColor(uParam.getBackcolor()));
        epsGraphics.setStrokeColor(colorMapper.getMappedColor(uParam.getColor()));
        epsGraphics.epsPolygon(dArray);
    }
}

