/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.shapefile.ShapefileAttributeReader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.index.CloseableCollection;
import org.geotools.index.Data;
import org.opengis.feature.type.AttributeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedShapefileAttributeReader
extends ShapefileAttributeReader
implements RecordNumberTracker {
    protected Iterator<Data> goodRecs;
    private int recno;
    private Data next;
    private CloseableCollection<Data> closeableCollection;

    public IndexedShapefileAttributeReader(List<AttributeDescriptor> attributes, ShapefileReader shp, IndexedDbaseFileReader dbf, CloseableCollection<Data> goodRecs) {
        this(attributes.toArray(new AttributeDescriptor[0]), shp, dbf, goodRecs);
    }

    public IndexedShapefileAttributeReader(AttributeDescriptor[] atts, ShapefileReader shp, IndexedDbaseFileReader dbf, CloseableCollection<Data> goodRecs) {
        super(atts, shp, (DbaseFileReader)dbf);
        if (goodRecs != null) {
            this.goodRecs = goodRecs.iterator();
        }
        this.closeableCollection = goodRecs;
        this.recno = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.closeableCollection != null) {
                this.closeableCollection.closeIterator(this.goodRecs);
                this.closeableCollection.close();
            }
            this.goodRecs = null;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.goodRecs != null) {
            if (this.next != null) {
                return true;
            }
            if (this.goodRecs.hasNext()) {
                this.next = this.goodRecs.next();
                this.recno = (Integer)this.next.getValue(0);
                return true;
            }
            return false;
        }
        return super.hasNext();
    }

    @Override
    public void next() throws IOException {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("No more features in reader");
        }
        if (this.goodRecs != null) {
            this.recno = (Integer)this.next.getValue(0);
            if (this.dbf != null) {
                ((IndexedDbaseFileReader)this.dbf).goTo(this.recno);
            }
            Long l = (Long)this.next.getValue(1);
            this.shp.goTo((int)l.longValue());
            this.next = null;
        } else {
            ++this.recno;
        }
        super.next();
    }

    @Override
    public int getRecordNumber() {
        return this.recno;
    }
}

