/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.server.storage.impl;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApproval;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientApprovalStore;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;

public abstract class FSClientApprovalStore<V extends ClientApproval>
extends FileStore<V>
implements ClientApprovalStore<V> {
    protected FSClientApprovalStore(File storeDirectory, File indexDirectory, IdentifiableProviderImpl<V> idp, MapConverter<V> cp) {
        super(storeDirectory, indexDirectory, idp, cp);
    }

    protected FSClientApprovalStore(File file, IdentifiableProviderImpl<V> idp, MapConverter<V> cp) {
        super(new File(file, "cas"), idp, cp);
    }

    @Override
    public boolean isApproved(Identifier identifier) {
        ClientApproval ca = (ClientApproval)this.get(identifier);
        if (ca == null) {
            return false;
        }
        return ca.isApproved();
    }

    @Override
    public int getUnapprovedCount() {
        int count = 0;
        for (Identifier key : this.keySet()) {
            if (this.isApproved(key)) continue;
            ++count;
        }
        return count;
    }
}

