/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import org.apache.commons.lang.StringEscapeUtils;
import org.dataone.cn.indexer.parser.SolrField;
import org.dataone.cn.indexer.parser.utility.LogicalOrPostProcessor;
import org.dataone.cn.indexer.parser.utility.RootElement;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.w3c.dom.Document;

public class CommonRootSolrField
extends SolrField {
    private RootElement root;
    private LogicalOrPostProcessor orProcessor = new LogicalOrPostProcessor();

    public CommonRootSolrField(String name) {
        this.name = name;
    }

    @Override
    public List<SolrElementField> getFields(Document doc, String identifier) throws Exception {
        ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
        if (this.root != null) {
            List<String> resultValues = this.root.getRootValues(doc, this.isMultivalue());
            for (String value : resultValues) {
                if (this.orProcessor != null) {
                    value = this.orProcessor.process(value);
                }
                if (this.getConverter() != null) {
                    value = this.getConverter().convert(value);
                }
                if (this.isEscapeXML()) {
                    value = StringEscapeUtils.escapeXml((String)value);
                }
                if (value != null && !value.isEmpty()) {
                    fields.add(new SolrElementField(this.name, value));
                }
                if (this.isMultivalue()) continue;
                break;
            }
        }
        return fields;
    }

    @Override
    public void initExpression(XPath xpathObject) {
        this.root.initXPathExpressions(xpathObject);
    }

    public RootElement getRoot() {
        return this.root;
    }

    public void setRoot(RootElement root) {
        this.root = root;
    }
}

