/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.advancedsearch;

import edu.ucsb.nceas.metacat.advancedsearch.AdvancedSearch;
import edu.ucsb.nceas.metacat.advancedsearch.MetacatHelper;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BrowseServlet
extends HttpServlet {
    private static final String CONFIG_DIR = "WEB-INF";
    private static final String CONFIG_NAME = "metacat.properties";
    static final long serialVersionUID = 0L;
    private String contextString = "";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession httpSession = request.getSession();
        Metacat metacat = (Metacat)httpSession.getAttribute("metacat");
        MetacatHelper metacatHelper = new MetacatHelper();
        String qformat = (String)httpSession.getAttribute("qformat");
        String result = "";
        String resultsJSP = metacatHelper.getResultsJSP();
        ServletContext servletContext = httpSession.getServletContext();
        String xslPath = metacatHelper.getResultsetXSL(request);
        String metacatURL = servletContext.getInitParameter("metacatURL");
        if (metacatURL == null || metacatURL.equals("")) {
            String serverName = request.getServerName();
            int serverPort = request.getServerPort();
            metacatURL = metacatHelper.constructMetacatURL(serverName, serverPort, this.contextString);
        }
        response.setContentType("text/html");
        AdvancedSearch advancedSearch = new AdvancedSearch(null);
        String browseValue = request.getParameter("browseValue");
        result = advancedSearch.executeSearch(metacatURL, metacat, qformat, xslPath, browseValue);
        request.setAttribute("result", (Object)result);
        RequestDispatcher dispatcher = request.getRequestDispatcher(resultsJSP);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void init(ServletConfig config) throws ServletException {
        ServletContext context = null;
        super.init(config);
        context = config.getServletContext();
        String dirPath = context.getRealPath(CONFIG_DIR);
        try {
            PropertyService.getInstance();
            this.contextString = PropertyService.getProperty("application.context");
        }
        catch (ServiceException se) {
            System.err.println("Error in loading properties: " + se.getMessage());
        }
        catch (PropertyNotFoundException pnfe) {
            System.err.println("couldn't read property during initialization: " + pnfe.getMessage());
        }
    }
}

