/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone;

import edu.ucsb.nceas.metacat.AccessionNumberException;
import edu.ucsb.nceas.metacat.DBTransform;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.EventLog;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.MetacatHandler;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.common.query.stream.ContentTypeByteArrayInputStream;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.replication.ForceReplicationHandler;
import edu.ucsb.nceas.metacat.util.SkinUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.util.AuthUtils;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.Log;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.OptionList;
import org.dataone.service.types.v2.SystemMetadata;

public abstract class D1NodeService {
    public static final String DELETEDMESSAGE = "The object with the PID has been deleted from the node.";
    private static Logger logMetacat = Logger.getLogger(D1NodeService.class);
    protected HttpServletRequest request;
    protected MetacatHandler handler;
    private Hashtable<String, String[]> params;
    protected static int MAXIMUM_DB_RECORD_COUNT = 7000;
    protected Session session;

    public D1NodeService(HttpServletRequest request) {
        this.request = request;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public DescribeResponse describe(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailureCode = "4931";
        Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        SystemMetadata sysmeta = this.getSystemMetadata(session, pid);
        DescribeResponse describeResponse = new DescribeResponse(sysmeta.getFormatId(), sysmeta.getSize(), sysmeta.getDateSysMetadataModified(), sysmeta.getChecksum(), sysmeta.getSerialVersion());
        return describeResponse;
    }

    public Identifier delete(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String localId = null;
        if (session == null) {
            throw new InvalidToken("1330", "No session has been provided");
        }
        String username = session.getSubject().getValue();
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new ServiceFailure("1350", "The provided identifier was invalid.");
        }
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new NotFound("1340", "The object with the provided identifier was not found.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("1350", "The object with the provided identifier " + pid.getValue() + " couldn't be identified since " + e.getMessage());
        }
        try {
            DocumentImpl.delete(localId, null, null, null, true);
            EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), username, localId, Event.DELETE.xmlValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new NotFound("1340", "The provided identifier was invalid.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("1350", "There was a problem deleting the object.The error message was: " + e.getMessage());
        }
        catch (InsufficientKarmaException e) {
            if (logMetacat.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new NotAuthorized("1320", "The provided identity does not have permission to DELETE objects on the Member Node.");
        }
        catch (Exception e) {
            throw new ServiceFailure("1350", "There was a problem deleting the object.The error message was: " + e.getMessage());
        }
        return pid;
    }

    public Date ping() throws NotImplemented, ServiceFailure, InsufficientResources {
        int serialNumber = -1;
        DBConnection dbConn = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("MNodeService.ping");
            serialNumber = dbConn.getCheckOutSerialNumber();
        }
        catch (SQLException e) {
            ServiceFailure sf = new ServiceFailure("", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return Calendar.getInstance().getTime();
    }

    public Identifier create(Session session, Identifier pid, InputStream object, SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        String localId;
        Identifier resultPid;
        block27: {
            resultPid = null;
            localId = null;
            boolean allowed = false;
            if (session == null) {
                throw new InvalidToken("4894", "Session is required to WRITE to the Node.");
            }
            Subject subject = session.getSubject();
            Subject publicSubject = new Subject();
            publicSubject.setValue("public");
            if (subject == null || subject.getValue() == null || subject.equals((Object)publicSubject)) {
                throw new NotAuthorized("1100", "The provided identity does not have permission to WRITE to the Node.");
            }
            logMetacat.debug((Object)("Comparing pid|sysmeta_pid: " + pid.getValue() + "|" + sysmeta.getIdentifier().getValue()));
            if (!pid.getValue().equals(sysmeta.getIdentifier().getValue())) {
                throw new InvalidSystemMetadata("1180", "The supplied system metadata is invalid. The identifier " + pid.getValue() + " does not match identifier" + "in the system metadata identified by " + sysmeta.getIdentifier().getValue() + ".");
            }
            logMetacat.debug((Object)("Checking if identifier exists: " + pid.getValue()));
            boolean idExists = false;
            try {
                idExists = IdentifierManager.getInstance().identifierExists(pid.getValue());
            }
            catch (SQLException e) {
                throw new ServiceFailure("1190", "The requested identifier " + pid.getValue() + " couldn't be determined if it is unique since : " + e.getMessage());
            }
            if (idExists) {
                throw new IdentifierNotUnique("1120", "The requested identifier " + pid.getValue() + " is already used by another object and" + "therefore can not be used for this object. Clients should choose" + "a new identifier that is unique and retry the operation or " + "use CN.reserveIdentifier() to reserve one.");
            }
            try {
                allowed = this.isAuthorized(session, pid, Permission.WRITE);
            }
            catch (NotFound e) {
                allowed = true;
            }
            if (!allowed) {
                throw new NotAuthorized("1100", "Provited Identity doesn't have the WRITE permission on the pid " + pid.getValue());
            }
            if (object.markSupported()) {
                logMetacat.debug((Object)("Checking checksum for: " + pid.getValue()));
                String checksumAlgorithm = sysmeta.getChecksum().getAlgorithm();
                String checksumValue = sysmeta.getChecksum().getValue();
                try {
                    String computedChecksumValue = ChecksumUtil.checksum((InputStream)object, (String)checksumAlgorithm).getValue();
                    object.reset();
                    if (!computedChecksumValue.equals(checksumValue)) {
                        logMetacat.error((Object)("Checksum for " + pid.getValue() + " does not match system metadata, computed = " + computedChecksumValue));
                        throw new InvalidSystemMetadata("4896", "Checksum given does not match that of the object");
                    }
                    break block27;
                }
                catch (Exception e) {
                    String msg = "Error verifying checksum values";
                    logMetacat.error((Object)msg, (Throwable)e);
                    throw new ServiceFailure("1190", msg + ": " + e.getMessage());
                }
            }
            logMetacat.warn((Object)"mark is not supported on the object's input stream - cannot verify checksum without consuming stream");
        }
        try {
            HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysmeta.getIdentifier(), (Object)sysmeta);
        }
        catch (Exception e) {
            logMetacat.error((Object)("Problem creating system metadata: " + pid.getValue()), (Throwable)e);
            throw new ServiceFailure("1190", e.getMessage());
        }
        logMetacat.debug((Object)("Allowed to insert: " + pid.getValue()));
        if (D1NodeService.isScienceMetadata(sysmeta)) {
            try {
                String formatId = null;
                if (sysmeta.getFormatId() != null) {
                    formatId = sysmeta.getFormatId().getValue();
                }
                localId = this.insertOrUpdateDocument(object, "UTF-8", pid, session, "insert", formatId);
            }
            catch (IOException e) {
                this.removeSystemMeta(pid);
                String msg = "The Node is unable to create the object. There was a problem converting the object to XML";
                logMetacat.info((Object)msg);
                throw new ServiceFailure("1190", msg + ": " + e.getMessage());
            }
            catch (ServiceFailure e) {
                this.removeSystemMeta(pid);
                throw e;
            }
            catch (Exception e) {
                this.removeSystemMeta(pid);
                throw new ServiceFailure("1190", "The node is unable to create the object: " + e.getMessage());
            }
        }
        try {
            localId = this.insertDataObject(object, pid, session);
        }
        catch (ServiceFailure e) {
            this.removeSystemMeta(pid);
            throw e;
        }
        catch (Exception e) {
            this.removeSystemMeta(pid);
            throw new ServiceFailure("1190", "The node is unable to create the object: " + e.getMessage());
        }
        logMetacat.debug((Object)("Done inserting new object: " + pid.getValue()));
        if (localId == null) {
            this.removeSystemMeta(pid);
            throw new ServiceFailure("1190", "The Node is unable to create the object. ");
        }
        try {
            MetacatSolrIndex.getInstance().submit(sysmeta.getIdentifier(), sysmeta, null, true);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Couldn't create solr index for object " + pid.getValue()));
        }
        resultPid = pid;
        logMetacat.debug((Object)("create() complete for object: " + pid.getValue()));
        return resultPid;
    }

    protected void removeSystemMeta(Identifier id) {
        HazelcastService.getInstance().getSystemMetadataMap().remove((Object)id);
    }

    protected void removeSolrIndex(SystemMetadata sysMeta) {
        sysMeta.setSerialVersion(sysMeta.getSerialVersion().add(BigInteger.ONE));
        sysMeta.setArchived(Boolean.valueOf(true));
        sysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
        try {
            MetacatSolrIndex.getInstance().submit(sysMeta.getIdentifier(), sysMeta, null, false);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Can't remove the solr index for pid " + sysMeta.getIdentifier().getValue()));
        }
    }

    public Log getLogRecords(Session session, Date fromDate, Date toDate, String event, String pidFilter, Integer start, Integer count) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        if (!this.isAdminAuthorized(session)) {
            throw new NotAuthorized("1460", "Only the CN or admin is allowed to harvest logs from this node");
        }
        Log log = new Log();
        IdentifierManager im = IdentifierManager.getInstance();
        EventLog el = EventLog.getInstance();
        if (fromDate == null) {
            logMetacat.debug((Object)"setting fromdate from null");
            fromDate = new Date(1L);
        }
        if (toDate == null) {
            logMetacat.debug((Object)"setting todate from null");
            toDate = new Date();
        }
        if (start == null) {
            start = 0;
        }
        if (count == null) {
            count = 1000;
        }
        if (count > MAXIMUM_DB_RECORD_COUNT) {
            count = MAXIMUM_DB_RECORD_COUNT;
        }
        String[] filterDocid = null;
        if (pidFilter != null && !pidFilter.trim().equals("")) {
            Identifier pid = new Identifier();
            pid.setValue(pidFilter);
            String serviceFailureCode = "1490";
            Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
            if (sid != null) {
                pid = sid;
            }
            pidFilter = pid.getValue();
            try {
                String localId = im.getLocalId(pidFilter);
                filterDocid = new String[]{localId};
            }
            catch (Exception ex) {
                String msg = "Could not find localId for given pidFilter '" + pidFilter + "'";
                logMetacat.warn((Object)msg, (Throwable)ex);
                return log;
            }
        }
        logMetacat.debug((Object)("fromDate: " + fromDate));
        logMetacat.debug((Object)("toDate: " + toDate));
        log = el.getD1Report(null, null, filterDocid, event, new Timestamp(fromDate.getTime()), new Timestamp(toDate.getTime()), false, start, count);
        logMetacat.info((Object)"getLogRecords");
        return log;
    }

    public InputStream get(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String localId;
        String serviceFailureCode = "1030";
        Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        InputStream inputStream = null;
        this.handler = new MetacatHandler(new Timer());
        boolean allowed = false;
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new NotFound("1020", "The object specified by " + pid.getValue() + " does not exist at this node.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("1030", "The object specified by " + pid.getValue() + " couldn't be identified at this node since " + e.getMessage());
        }
        try {
            allowed = this.isAuthorized(session, pid, Permission.READ);
        }
        catch (InvalidRequest e) {
            throw new ServiceFailure("1030", e.getDescription());
        }
        if (allowed) {
            try {
                inputStream = MetacatHandler.read(localId);
            }
            catch (McdbDocNotFoundException de) {
                String error = "";
                if (EventLog.getInstance().isDeleted(localId)) {
                    error = DELETEDMESSAGE;
                }
                throw new NotFound("1020", "The object specified by " + pid.getValue() + " does not exist at this node. " + error);
            }
            catch (Exception e) {
                throw new ServiceFailure("1030", "The object specified by " + pid.getValue() + " could not be returned due to error: " + e.getMessage() + ". ");
            }
        }
        if (inputStream == null) {
            String error = "";
            if (EventLog.getInstance().isDeleted(localId)) {
                error = DELETEDMESSAGE;
            }
            throw new NotFound("1020", "The object specified by " + pid.getValue() + " does not exist at this node. " + error);
        }
        String principal = "public";
        if (session != null && session.getSubject() != null) {
            principal = session.getSubject().getValue();
        }
        EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), principal, localId, "read");
        return inputStream;
    }

    public SystemMetadata getSystemMetadata(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailureCode = "1090";
        Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        boolean isAuthorized = false;
        SystemMetadata systemMetadata = null;
        List replicaList = null;
        NodeReference replicaNodeRef = null;
        List<Node> nodeListBySubject = null;
        Subject subject = null;
        if (session != null) {
            subject = session.getSubject();
        }
        NotAuthorized originalAuthorizationException = null;
        if (!isAuthorized) {
            try {
                isAuthorized = this.isAuthorized(session, pid, Permission.READ);
            }
            catch (InvalidRequest e) {
                throw new ServiceFailure("1090", e.getDescription());
            }
            catch (NotAuthorized nae) {
                originalAuthorizationException = nae;
            }
        }
        systemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
        if (!isAuthorized) {
            try {
                if (systemMetadata != null && (replicaList = systemMetadata.getReplicaList()) != null) {
                    block23: {
                        if (subject != null) {
                            try {
                                nodeListBySubject = this.listNodesBySubject(session.getSubject());
                            }
                            catch (BaseException e) {
                                String msg = "Caught an unexpected error while trying to potentially authorize system metadata access based on the session subject. The error was " + e.getMessage();
                                logMetacat.error((Object)msg);
                                if (!logMetacat.isDebugEnabled()) break block23;
                                e.printStackTrace();
                            }
                        }
                    }
                    if (nodeListBySubject != null) {
                        block9: for (Replica replica : replicaList) {
                            replicaNodeRef = replica.getReplicaMemberNode();
                            for (Node node : nodeListBySubject) {
                                if (!node.getIdentifier().equals((Object)replicaNodeRef)) continue;
                                isAuthorized = true;
                                break block9;
                            }
                        }
                    }
                }
                if (!isAuthorized) {
                    throw new NotAuthorized("1400", Permission.READ + " not allowed on " + pid.getValue());
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw new ServiceFailure("1090", "Unexpected error getting system metadata for: " + pid.getValue());
            }
        }
        if (systemMetadata == null) {
            String error = "";
            String localId = null;
            try {
                localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
            }
            catch (Exception e) {
                logMetacat.warn((Object)("Couldn't find the local id for the pid " + pid.getValue()));
            }
            if (localId != null && EventLog.getInstance().isDeleted(localId)) {
                error = DELETEDMESSAGE;
            } else if (localId == null && EventLog.getInstance().isDeleted(pid.getValue())) {
                error = DELETEDMESSAGE;
            }
            throw new NotFound("1420", "No record found for: " + pid.getValue() + ". " + error);
        }
        return systemMetadata;
    }

    public boolean isAuthoritativeMNodeAdmin(Session session, Identifier pid) {
        NodeReference authoritativeMNode;
        SystemMetadata sysMeta;
        boolean allowed = false;
        if (session == null) {
            logMetacat.debug((Object)"D1NodeService.isAuthoritativeMNodeAdmin - the session object is null and return false.");
            return allowed;
        }
        if (pid == null || pid.getValue() == null || pid.getValue().trim().equals("")) {
            logMetacat.debug((Object)"D1NodeService.isAuthoritativeMNodeAdmin - the Identifier object is null (not being specified) and return false.");
            return allowed;
        }
        Subject subject = session.getSubject();
        if (subject != null && (sysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid)) != null && (authoritativeMNode = sysMeta.getAuthoritativeMemberNode()) != null) {
            CNode cn = null;
            try {
                cn = D1Client.getCN();
            }
            catch (BaseException e) {
                logMetacat.error((Object)("D1NodeService.isAuthoritativeMNodeAdmin - couldn't connect to the CN since " + e.getDescription() + ". The false value will be returned for the AuthoritativeMNodeAdmin."));
                return allowed;
            }
            if (cn != null) {
                List nodes = null;
                try {
                    nodes = cn.listNodes().getNodeList();
                }
                catch (NotImplemented e) {
                    logMetacat.error((Object)("D1NodeService.isAuthoritativeMNodeAdmin - couldn't get the member nodes list from the CN since " + e.getDescription() + ". The false value will be returned for the AuthoritativeMNodeAdmin."));
                    return allowed;
                }
                catch (ServiceFailure ee) {
                    logMetacat.error((Object)("D1NodeService.isAuthoritativeMNodeAdmin - couldn't get the member nodes list from the CN since " + ee.getDescription() + ". The false value will be returned for the AuthoritativeMNodeAdmin."));
                    return allowed;
                }
                if (nodes != null) {
                    block5: for (Node node : nodes) {
                        List nodeSubjects;
                        if (node.getType() != NodeType.MN || node.getIdentifier() == null || !node.getIdentifier().equals((Object)authoritativeMNode) || (nodeSubjects = node.getSubjectList()) == null) continue;
                        for (Subject nodeSubject : nodeSubjects) {
                            logMetacat.debug((Object)("D1NodeService.isAuthoritativeMNodeAdmin(), comparing subjects: " + nodeSubject.getValue() + " and " + subject.getValue()));
                            if (nodeSubject == null || !nodeSubject.equals((Object)subject)) continue;
                            allowed = true;
                            continue block5;
                        }
                    }
                }
            }
        }
        return allowed;
    }

    public boolean isAdminAuthorized(Session session) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented {
        boolean allowed = false;
        if (session == null) {
            logMetacat.debug((Object)"In isAdminAuthorized(), session is null ");
            return false;
        }
        logMetacat.debug((Object)("In isAdminAuthorized(), checking CN or MN authorization for " + session.getSubject().getValue()));
        try {
            allowed = this.isNodeAdmin(session);
        }
        catch (Exception e) {
            logMetacat.warn((Object)"We can't determine if the session is a node subject. But we will contiune to check if it is a cn subject.");
        }
        if (!allowed) {
            allowed = this.isCNAdmin(session);
        }
        return allowed;
    }

    protected boolean isCNAdmin(Session session) {
        boolean allowed = false;
        List nodes = null;
        logMetacat.debug((Object)"D1NodeService.isCNAdmin - the beginning");
        try {
            CNode cn = D1Client.getCN();
            logMetacat.debug((Object)"D1NodeService.isCNAdmin - after getting the cn.");
            nodes = cn.listNodes().getNodeList();
            logMetacat.debug((Object)"D1NodeService.isCNAdmin - after getting the node list.");
        }
        catch (Throwable e) {
            logMetacat.warn((Object)("Couldn't get the node list from the cn since " + e.getMessage() + ". So we can't determine if the subject is a CN."));
            return false;
        }
        if (nodes == null) {
            return false;
        }
        block2: for (Node node : nodes) {
            NodeReference nodeReference = node.getIdentifier();
            logMetacat.debug((Object)("In isCNAdmin(), Node reference is: " + nodeReference.getValue()));
            Subject subject = session.getSubject();
            if (node.getType() != NodeType.CN) continue;
            List nodeSubjects = node.getSubjectList();
            for (Subject nodeSubject : nodeSubjects) {
                logMetacat.debug((Object)("In isCNAdmin(), comparing subjects: " + nodeSubject.getValue() + " and " + subject.getValue()));
                if (!nodeSubject.equals((Object)subject)) continue;
                allowed = true;
                continue block2;
            }
        }
        logMetacat.debug((Object)("D1NodeService.isCNAdmin. Is it a cn admin? " + allowed));
        return allowed;
    }

    public boolean isNodeAdmin(Session session) throws NotImplemented, ServiceFailure {
        boolean allowed = false;
        if (session == null) {
            logMetacat.debug((Object)"In isNodeAdmin(), session is null ");
            return false;
        }
        logMetacat.debug((Object)("In isNodeAdmin(), MN authorization for " + session.getSubject().getValue()));
        Node node = MNodeService.getInstance(this.request).getCapabilities();
        NodeReference nodeReference = node.getIdentifier();
        logMetacat.debug((Object)("In isNodeAdmin(), Node reference is: " + nodeReference.getValue()));
        Subject subject = session.getSubject();
        if (node.getType() == NodeType.MN) {
            List nodeSubjects = node.getSubjectList();
            for (Subject nodeSubject : nodeSubjects) {
                logMetacat.debug((Object)("In isNodeAdmin(), comparing subjects: " + nodeSubject.getValue() + " and " + subject.getValue()));
                if (!nodeSubject.equals((Object)subject)) continue;
                allowed = true;
                break;
            }
        }
        logMetacat.debug((Object)("In is NodeAdmin method. Is this a node admin? " + allowed));
        return allowed;
    }

    public boolean isAuthorized(Session session, Identifier pid, Permission permission) throws ServiceFailure, InvalidToken, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        boolean allowed = false;
        if (permission == null) {
            throw new InvalidRequest("1761", "Permission was not provided or is invalid");
        }
        if (this.isAdminAuthorized(session)) {
            allowed = true;
            return allowed;
        }
        String serviceFailureCode = "1760";
        Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        if (this.isAuthoritativeMNodeAdmin(session, pid)) {
            allowed = true;
            return allowed;
        }
        allowed = D1NodeService.userHasPermission(session, pid, permission);
        if (!allowed) {
            StringBuffer includedSubjects = new StringBuffer();
            Set subjects = AuthUtils.authorizedClientSubjects((Session)session);
            for (Subject s : subjects) {
                includedSubjects.append(s.getValue() + "; ");
            }
            throw new NotAuthorized("1820", permission + " not allowed on " + pid.getValue() + " for subject[s]: " + includedSubjects.toString());
        }
        return allowed;
    }

    public static boolean userHasPermission(Session userSession, Identifier pid, Permission permission) throws NotFound {
        boolean allowed;
        block14: {
            allowed = false;
            List<Permission> expandedPermissions = null;
            Set subjects = AuthUtils.authorizedClientSubjects((Session)userSession);
            String pidStr = pid.getValue();
            SystemMetadata systemMetadata = null;
            try {
                systemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
            }
            catch (Exception e) {
                logMetacat.error((Object)("An error occurred while getting system metadata for identifier " + pid.getValue() + ". The error message was: " + e.getMessage()));
                throw new NotFound("1800", "No record found for " + pidStr);
            }
            if (systemMetadata == null) {
                String localId = null;
                String error = "No system metadata could be found for given PID: " + pidStr;
                try {
                    localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
                }
                catch (Exception e) {
                    logMetacat.warn((Object)("Couldn't find the local id for the pid " + pidStr));
                }
                if (localId != null && EventLog.getInstance().isDeleted(localId)) {
                    error = error + ". " + DELETEDMESSAGE;
                } else if (localId == null && EventLog.getInstance().isDeleted(pid.getValue())) {
                    error = error + ". " + DELETEDMESSAGE;
                }
                throw new NotFound("1800", error);
            }
            for (Subject s : subjects) {
                logMetacat.debug((Object)("Comparing \t" + systemMetadata.getRightsHolder().getValue() + " \tagainst \t" + s.getValue()));
                allowed = systemMetadata.getRightsHolder().equals((Object)s);
                if (!allowed) continue;
                return allowed;
            }
            try {
                List allows = systemMetadata.getAccessPolicy().getAllowList();
                for (AccessRule accessRule : allows) {
                    for (Subject s : subjects) {
                        logMetacat.debug((Object)("Checking allow access rule for subject: " + s.getValue()));
                        if (!accessRule.getSubjectList().contains(s)) continue;
                        logMetacat.debug((Object)("Access rule contains subject: " + s.getValue()));
                        for (Permission p : accessRule.getPermissionList()) {
                            logMetacat.debug((Object)("Checking permission: " + p.xmlValue()));
                            expandedPermissions = D1NodeService.expandPermissions(p);
                            allowed = expandedPermissions.contains(permission);
                            if (!allowed) continue;
                            logMetacat.info((Object)("Permission granted: " + p.xmlValue() + " to " + s.getValue()));
                            break block14;
                        }
                    }
                }
            }
            catch (Exception e) {
                logMetacat.error((Object)"Problem checking authorization - defaulting to deny", (Throwable)e);
                allowed = false;
            }
        }
        return allowed;
    }

    private String getLogEntryField(String fieldname, String entry) {
        String begin = "<" + fieldname + ">";
        String end = "</" + fieldname + ">";
        String s = entry.substring(entry.indexOf(begin) + begin.length(), entry.indexOf(end));
        logMetacat.debug((Object)("entry " + fieldname + " : " + s));
        return s;
    }

    public static boolean isScienceMetadata(SystemMetadata sysmeta) {
        ObjectFormat objectFormat = null;
        boolean isScienceMetadata = false;
        try {
            objectFormat = ObjectFormatCache.getInstance().getFormat(sysmeta.getFormatId());
            if (objectFormat.getFormatType().equals("METADATA")) {
                isScienceMetadata = true;
            }
        }
        catch (NotFound e) {
            logMetacat.debug((Object)("There was a problem determining if the object identified by" + sysmeta.getIdentifier().getValue() + " is science metadata: " + e.getMessage()));
        }
        return isScienceMetadata;
    }

    public static boolean isValidIdentifier(Identifier pid) {
        if (pid != null && pid.getValue() != null && pid.getValue().length() > 0) {
            return !pid.getValue().matches(".*\\s+.*");
        }
        return false;
    }

    public String insertOrUpdateDocument(InputStream xmlStream, String encoding, Identifier pid, Session session, String insertOrUpdate, String formatId) throws ServiceFailure, IOException {
        logMetacat.debug((Object)"Starting to insert xml document...");
        IdentifierManager im = IdentifierManager.getInstance();
        String localId = null;
        byte[] xmlBytes = IOUtils.toByteArray((InputStream)xmlStream);
        IOUtils.closeQuietly((InputStream)xmlStream);
        String xmlStr = new String(xmlBytes, encoding);
        if (insertOrUpdate.equals("insert")) {
            localId = im.generateLocalId(pid.getValue(), 1);
        } else {
            try {
                logMetacat.debug((Object)("Updating pid " + pid.getValue()));
                logMetacat.debug((Object)("looking in identifier table for pid " + pid.getValue()));
                localId = im.getLocalId(pid.getValue());
                logMetacat.debug((Object)("localId: " + localId));
                String docid = localId.substring(0, localId.lastIndexOf("."));
                String revS = localId.substring(localId.lastIndexOf(".") + 1, localId.length());
                int rev = new Integer(revS);
                localId = docid = docid + "." + ++rev;
                logMetacat.debug((Object)("incremented localId: " + localId));
            }
            catch (McdbDocNotFoundException e) {
                throw new ServiceFailure("1030", "D1NodeService.insertOrUpdateDocument(): pid " + pid.getValue() + " should have been in the identifier table, but it wasn't: " + e.getMessage());
            }
            catch (SQLException e) {
                throw new ServiceFailure("1030", "D1NodeService.insertOrUpdateDocument() - couldn't identify if the pid " + pid.getValue() + " is in the identifier table since " + e.getMessage());
            }
        }
        this.params = new Hashtable();
        String[] action = new String[]{insertOrUpdate};
        this.params.put("action", action);
        String[] docid = new String[]{localId};
        this.params.put("docid", docid);
        String[] doctext = new String[]{xmlStr};
        this.params.put("doctext", doctext);
        String username = "public";
        String[] groupnames = null;
        if (session != null) {
            username = session.getSubject().getValue();
            Set otherSubjects = AuthUtils.authorizedClientSubjects((Session)session);
            if (otherSubjects != null) {
                groupnames = new String[otherSubjects.size()];
                int i = 0;
                Iterator iter = otherSubjects.iterator();
                while (iter.hasNext()) {
                    groupnames[i] = ((Subject)iter.next()).getValue();
                    ++i;
                }
            }
        }
        this.handler = new MetacatHandler(new Timer());
        String result = this.handler.handleInsertOrUpdateAction(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), null, null, this.params, username, groupnames, false, false, xmlBytes, formatId);
        if (result.indexOf("<error>") != -1) {
            String detailCode = "";
            if (insertOrUpdate.equals("insert")) {
                im.removeMapping(pid.getValue(), localId);
                detailCode = "1190";
            } else if (insertOrUpdate.equals("update")) {
                detailCode = "1310";
            }
            throw new ServiceFailure(detailCode, "Error inserting or updating document: " + result);
        }
        logMetacat.debug((Object)("Finsished inserting xml document with id " + localId));
        return localId;
    }

    public String insertDataObject(InputStream object, Identifier pid, Session session) throws ServiceFailure {
        String username = "public";
        String[] groupnames = null;
        if (session != null) {
            username = session.getSubject().getValue();
            Set otherSubjects = AuthUtils.authorizedClientSubjects((Session)session);
            if (otherSubjects != null) {
                groupnames = new String[otherSubjects.size()];
                int i = 0;
                Iterator iter = otherSubjects.iterator();
                while (iter.hasNext()) {
                    groupnames[i] = ((Subject)iter.next()).getValue();
                    ++i;
                }
            }
        }
        logMetacat.debug((Object)"Generating a pid/localId mapping");
        IdentifierManager im = IdentifierManager.getInstance();
        String localId = im.generateLocalId(pid.getValue(), 1);
        String datafilepath = null;
        try {
            datafilepath = PropertyService.getProperty("application.datafilepath");
        }
        catch (PropertyNotFoundException e) {
            ServiceFailure sf = new ServiceFailure("1190", "Lookup data file path" + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        boolean locked = false;
        try {
            locked = DocumentImpl.getDataFileLockGrant(localId);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("1190", "Could not lock file for writing:" + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        logMetacat.debug((Object)"Case DATA: starting to write to disk.");
        if (locked) {
            File dataDirectory = new File(datafilepath);
            dataDirectory.mkdirs();
            File newFile = this.writeStreamToFile(dataDirectory, localId, object);
            try {
                logMetacat.debug((Object)"Registering document...");
                DocumentImpl.registerDocument(localId, "BIN", localId, username, groupnames);
                logMetacat.debug((Object)"Registration step completed.");
            }
            catch (SQLException e) {
                logMetacat.debug((Object)("SQLE: " + e.getMessage()));
                e.printStackTrace(System.out);
                throw new ServiceFailure("1190", "Registration failed: " + e.getMessage());
            }
            catch (AccessionNumberException e) {
                logMetacat.debug((Object)("ANE: " + e.getMessage()));
                e.printStackTrace(System.out);
                throw new ServiceFailure("1190", "Registration failed: " + e.getMessage());
            }
            catch (Exception e) {
                logMetacat.debug((Object)("Exception: " + e.getMessage()));
                e.printStackTrace(System.out);
                throw new ServiceFailure("1190", "Registration failed: " + e.getMessage());
            }
            logMetacat.debug((Object)"Logging the creation event.");
            EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), username, localId, "create");
            logMetacat.debug((Object)"Scheduling replication.");
            ForceReplicationHandler forceReplicationHandler = new ForceReplicationHandler(localId, "insert", false, null);
        }
        return localId;
    }

    public void insertSystemMetadata(SystemMetadata sysmeta) throws ServiceFailure {
        logMetacat.debug((Object)"Starting to insert SystemMetadata...");
        sysmeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
        logMetacat.debug((Object)("Inserting new system metadata with modified date " + sysmeta.getDateSysMetadataModified()));
        try {
            HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysmeta.getIdentifier(), (Object)sysmeta);
            MetacatSolrIndex.getInstance().submit(sysmeta.getIdentifier(), sysmeta, null, true);
        }
        catch (Exception e) {
            throw new ServiceFailure("1190", e.getMessage());
        }
    }

    public ObjectList listObjects(Session session, Date startTime, Date endTime, ObjectFormatIdentifier objectFormatId, Identifier identifier, NodeReference nodeId, Integer start, Integer count) throws NotAuthorized, InvalidRequest, NotImplemented, ServiceFailure, InvalidToken {
        ObjectList objectList = null;
        try {
            if (count == null || count > MAXIMUM_DB_RECORD_COUNT) {
                count = MAXIMUM_DB_RECORD_COUNT;
            }
            boolean isSid = false;
            if (identifier != null) {
                isSid = IdentifierManager.getInstance().systemMetadataSIDExists(identifier);
            }
            objectList = IdentifierManager.getInstance().querySystemMetadata(startTime, endTime, objectFormatId, nodeId, start, count, identifier, isSid);
        }
        catch (Exception e) {
            throw new ServiceFailure("1580", "Error querying system metadata: " + e.getMessage());
        }
        return objectList;
    }

    protected void updateSystemMetadata(SystemMetadata sysMeta) throws ServiceFailure {
        logMetacat.debug((Object)"D1NodeService.updateSystemMetadata() called.");
        try {
            HazelcastService.getInstance().getSystemMetadataMap().lock((Object)sysMeta.getIdentifier());
            boolean needUpdateModificationDate = true;
            this.updateSystemMetadataWithoutLock(sysMeta, needUpdateModificationDate);
        }
        catch (Exception e) {
            throw new ServiceFailure("4862", e.getMessage());
        }
        finally {
            HazelcastService.getInstance().getSystemMetadataMap().unlock((Object)sysMeta.getIdentifier());
        }
    }

    private void updateSystemMetadataWithoutLock(SystemMetadata sysMeta, boolean needUpdateModificationDate) throws ServiceFailure {
        logMetacat.debug((Object)"D1NodeService.updateSystemMetadataWithoutLock() called.");
        if (needUpdateModificationDate) {
            logMetacat.debug((Object)"D1NodeService.updateSystemMetadataWithoutLock() - update the modification date.");
            sysMeta.setDateSysMetadataModified(new Date());
        }
        try {
            HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysMeta.getIdentifier(), (Object)sysMeta);
            MetacatSolrIndex.getInstance().submit(sysMeta.getIdentifier(), sysMeta, null, true);
        }
        catch (Exception e) {
            throw new ServiceFailure("4862", e.getMessage());
        }
    }

    protected boolean updateSystemMetadata(Session session, Identifier pid, SystemMetadata sysmeta, boolean needUpdateModificationDate, SystemMetadata currentSysmeta, boolean fromCN) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        Object lock = null;
        logMetacat.debug((Object)("Comparing guid|sysmeta_guid: " + pid.getValue() + "|" + sysmeta.getIdentifier().getValue()));
        if (!pid.getValue().equals(sysmeta.getIdentifier().getValue())) {
            throw new InvalidRequest("4863", "The identifier in method call (" + pid.getValue() + ") does not match identifier in system metadata (" + sysmeta.getIdentifier().getValue() + ").");
        }
        logMetacat.debug((Object)("The current dateUploaded is ============" + currentSysmeta.getDateUploaded()));
        logMetacat.debug((Object)("the dateUploaded in the new system metadata is " + sysmeta.getDateUploaded()));
        logMetacat.debug((Object)("The current dateUploaded is (by time) ============" + currentSysmeta.getDateUploaded().getTime()));
        logMetacat.debug((Object)("the dateUploaded in the new system metadata is (by time) " + sysmeta.getDateUploaded().getTime()));
        if (currentSysmeta == null) {
            logMetacat.warn((Object)("D1NodeService.updateSystemMetadata: Currently there is no system metadata in this node associated with the pid " + pid.getValue()));
        } else {
            String obsoletedBy;
            String obsoletes;
            Identifier newSid;
            Identifier currentSid = currentSysmeta.getSeriesId();
            if (currentSid != null) {
                logMetacat.debug((Object)("In the branch that the sid is not null in the current system metadata and the current sid is " + currentSid.getValue()));
                newSid = sysmeta.getSeriesId();
                if (!D1NodeService.isValidIdentifier(newSid)) {
                    throw new InvalidRequest("4869", "The series id in the system metadata is invalid in the request.");
                }
                if (!newSid.getValue().equals(currentSid.getValue())) {
                    throw new InvalidRequest("4869", "The series id " + newSid.getValue() + " in the system metadata doesn't match the current sid " + currentSid.getValue());
                }
            } else {
                newSid = sysmeta.getSeriesId();
                if (newSid != null) {
                    this.checkSidInModifyingSystemMetadata(sysmeta, "4956", "4868");
                }
            }
            this.checkModifiedImmutableFields(currentSysmeta, sysmeta);
            this.checkOneTimeSettableSysmMetaFields(currentSysmeta, sysmeta);
            if (currentSysmeta.getObsoletes() == null && sysmeta.getObsoletes() != null && (obsoletes = this.existsInObsoletes(sysmeta.getObsoletes())) != null) {
                throw new InvalidSystemMetadata("4956", "There is an object with id " + obsoletes + " already obsoletes the pid " + sysmeta.getObsoletes().getValue() + ". You can't set the object " + pid.getValue() + " to obsolete the pid " + sysmeta.getObsoletes().getValue() + " again.");
            }
            if (currentSysmeta.getObsoletedBy() == null && sysmeta.getObsoletedBy() != null && (obsoletedBy = this.existsInObsoletedBy(sysmeta.getObsoletedBy())) != null) {
                throw new InvalidSystemMetadata("4956", "There is an object with id " + obsoletedBy + " already is obsoleted by the pid " + sysmeta.getObsoletedBy().getValue() + ". You can't set the pid " + pid.getValue() + " to be obsoleted by the pid " + sysmeta.getObsoletedBy().getValue() + " again.");
            }
        }
        if (sysmeta.getArchived() != null && sysmeta.getArchived().booleanValue() && (currentSysmeta.getArchived() != null && !currentSysmeta.getArchived().booleanValue() || currentSysmeta.getArchived() == null)) {
            boolean logArchive = false;
            if (fromCN) {
                logMetacat.debug((Object)("D1Node.update - this is to archive a cn object " + pid.getValue()));
                try {
                    this.archiveCNObject(logArchive, session, pid, sysmeta, needUpdateModificationDate);
                }
                catch (NotFound e) {
                    throw new InvalidRequest("4869", "Can't find the pid " + pid.getValue() + " for archive.");
                }
            } else {
                logMetacat.debug((Object)("D1Node.update - this is to archive a MN object " + pid.getValue()));
                try {
                    this.archiveObject(logArchive, session, pid, sysmeta, needUpdateModificationDate);
                }
                catch (NotFound e) {
                    throw new InvalidRequest("4869", "Can't find the pid " + pid.getValue() + " for archive.");
                }
            }
        } else {
            logMetacat.debug((Object)("D1Node.update - regularly update the system metadata of the pid " + pid.getValue()));
            this.updateSystemMetadataWithoutLock(sysmeta, needUpdateModificationDate);
        }
        try {
            String localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
            EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), session.getSubject().getValue(), localId, "updateSystemMetadata");
        }
        catch (McdbDocNotFoundException e) {
            logMetacat.warn((Object)("Could not log 'updateSystemMetadata' event because no localId was found for pid: " + pid.getValue()));
        }
        catch (SQLException e) {
            logMetacat.warn((Object)("Could not log 'updateSystemMetadata' event because the localId couldn't be identified for the pid: " + pid.getValue()));
        }
        return true;
    }

    private void checkModifiedImmutableFields(SystemMetadata orgMeta, SystemMetadata newMeta) throws InvalidRequest {
        logMetacat.debug((Object)"in the start of the checkModifiedImmutableFields method");
        if (orgMeta != null && newMeta != null) {
            logMetacat.debug((Object)"in the checkModifiedImmutableFields method when the org and new system metadata is not null");
            if (newMeta.getIdentifier() == null) {
                throw new InvalidRequest("4869", "The new version of the system metadata is invalid since the identifier is null");
            }
            if (!orgMeta.getIdentifier().equals((Object)newMeta.getIdentifier())) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's identifier " + newMeta.getIdentifier().getValue() + " is " + "different to the orginal one " + orgMeta.getIdentifier().getValue());
            }
            if (newMeta.getSize() == null) {
                throw new InvalidRequest("4869", "The new version of the system metadata is invalid since the size is null");
            }
            if (!orgMeta.getSize().equals(newMeta.getSize())) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's size " + newMeta.getSize().longValue() + " is " + "different to the orginal one " + orgMeta.getSize().longValue());
            }
            if (newMeta.getChecksum() != null && orgMeta.getChecksum() != null && !orgMeta.getChecksum().getValue().equals(newMeta.getChecksum().getValue())) {
                logMetacat.error((Object)("The request is trying to modify an immutable field in the SystemMeta: the new system meta's checksum " + newMeta.getChecksum().getValue() + " is " + "different to the orginal one " + orgMeta.getChecksum().getValue()));
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's checksum " + newMeta.getChecksum().getValue() + " is " + "different to the orginal one " + orgMeta.getChecksum().getValue());
            }
            if (orgMeta.getSubmitter() != null) {
                logMetacat.debug((Object)("in the checkModifiedImmutableFields method and orgMeta.getSubmitter is not null and the orginal submiter is " + orgMeta.getSubmitter().getValue()));
            }
            if (newMeta.getSubmitter() != null) {
                logMetacat.debug((Object)("in the checkModifiedImmutableFields method and newMeta.getSubmitter is not null and the submiter in the new system metadata is " + newMeta.getSubmitter().getValue()));
            }
            if (orgMeta.getSubmitter() != null && newMeta.getSubmitter() != null && !orgMeta.getSubmitter().equals((Object)newMeta.getSubmitter())) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's submitter " + newMeta.getSubmitter().getValue() + " is " + "different to the orginal one " + orgMeta.getSubmitter().getValue());
            }
            if (orgMeta.getDateUploaded() != null && newMeta.getDateUploaded() != null && orgMeta.getDateUploaded().getTime() != newMeta.getDateUploaded().getTime()) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's date of uploaded " + newMeta.getDateUploaded() + " is " + "different to the orginal one " + orgMeta.getDateUploaded());
            }
            if (orgMeta.getOriginMemberNode() != null && newMeta.getOriginMemberNode() != null && !orgMeta.getOriginMemberNode().equals((Object)newMeta.getOriginMemberNode())) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's orginal member node  " + newMeta.getOriginMemberNode().getValue() + " is " + "different to the orginal one " + orgMeta.getOriginMemberNode().getValue());
            }
            if (orgMeta.getOriginMemberNode() != null && newMeta.getOriginMemberNode() == null) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's orginal member node is null and it  is different to the orginal one " + orgMeta.getOriginMemberNode().getValue());
            }
            if (orgMeta.getSeriesId() != null && newMeta.getSeriesId() != null && !orgMeta.getSeriesId().equals((Object)newMeta.getSeriesId())) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's series id  " + newMeta.getSeriesId().getValue() + " is " + "different to the orginal one " + orgMeta.getSeriesId().getValue());
            }
        }
    }

    private void checkOneTimeSettableSysmMetaFields(SystemMetadata orgMeta, SystemMetadata newMeta) throws InvalidRequest {
        if (!(orgMeta.getObsoletedBy() == null || newMeta.getObsoletedBy() != null && orgMeta.getObsoletedBy().equals((Object)newMeta.getObsoletedBy()))) {
            throw new InvalidRequest("4869", "The request is trying to reset the obsoletedBy field in the system metadata of the object " + orgMeta.getIdentifier().getValue() + ". This is illegal since the obsoletedBy filed is set, you can't change it again.");
        }
        if (!(orgMeta.getObsoletes() == null || newMeta.getObsoletes() != null && orgMeta.getObsoletes().equals((Object)newMeta.getObsoletes()))) {
            throw new InvalidRequest("4869", "The request is trying to reset the obsoletes field in the system metadata of the object" + orgMeta.getIdentifier().getValue() + ". This is illegal since the obsoletes filed is set, you can't change it again.");
        }
    }

    protected static List<Permission> expandPermissions(Permission permission) {
        ArrayList<Permission> expandedPermissions = new ArrayList<Permission>();
        if (permission.equals((Object)Permission.READ)) {
            expandedPermissions.add(Permission.READ);
        }
        if (permission.equals((Object)Permission.WRITE)) {
            expandedPermissions.add(Permission.READ);
            expandedPermissions.add(Permission.WRITE);
        }
        if (permission.equals((Object)Permission.CHANGE_PERMISSION)) {
            expandedPermissions.add(Permission.READ);
            expandedPermissions.add(Permission.WRITE);
            expandedPermissions.add(Permission.CHANGE_PERMISSION);
        }
        return expandedPermissions;
    }

    private File writeStreamToFile(File dir, String fileName, InputStream dataStream) throws ServiceFailure {
        File newFile;
        block7: {
            newFile = new File(dir, fileName);
            logMetacat.debug((Object)("Filename for write is: " + newFile.getAbsolutePath()));
            try {
                if (newFile.createNewFile()) {
                    FileOutputStream os = new FileOutputStream(newFile);
                    long length = IOUtils.copyLarge((InputStream)dataStream, (OutputStream)os);
                    os.flush();
                    ((OutputStream)os).close();
                    break block7;
                }
                logMetacat.debug((Object)"File creation failed, or file already exists.");
                throw new ServiceFailure("1190", "File already exists: " + fileName);
            }
            catch (FileNotFoundException e) {
                logMetacat.debug((Object)("FNF: " + e.getMessage()));
                throw new ServiceFailure("1190", "File not found: " + fileName + " " + e.getMessage());
            }
            catch (IOException e) {
                logMetacat.debug((Object)("IOE: " + e.getMessage()));
                throw new ServiceFailure("1190", "File was not written: " + fileName + " " + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)dataStream);
            }
        }
        return newFile;
    }

    protected List<Node> listNodesBySubject(Subject subject) throws ServiceFailure, NotImplemented {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        CNode cn = D1Client.getCN();
        List nodes = cn.listNodes().getNodeList();
        for (Node node : nodes) {
            List nodeSubjects = node.getSubjectList();
            if (nodeSubjects == null) continue;
            for (Subject nodeSubject : nodeSubjects) {
                if (!nodeSubject.equals((Object)subject)) continue;
                nodeList.add(node);
            }
        }
        return nodeList;
    }

    protected Identifier archiveObject(boolean log, Session session, Identifier pid, SystemMetadata sysMeta, boolean needModifyDate) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String localId = null;
        boolean allowed = false;
        String username = "public";
        if (session == null) {
            throw new InvalidToken("1330", "No session has been provided");
        }
        username = session.getSubject().getValue();
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new ServiceFailure("1350", "The provided identifier was invalid.");
        }
        if (sysMeta == null) {
            throw new NotFound("2911", "There is no system metadata associated with " + pid.getValue());
        }
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new NotFound("1340", "The object with the provided identifier was not found.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("1350", "The object with the provided identifier " + pid.getValue() + " couldn't be identified since " + e.getMessage());
        }
        try {
            DocumentImpl.delete(localId, null, null, null, false);
            if (log) {
                try {
                    EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), username, localId, Event.DELETE.xmlValue());
                }
                catch (Exception e) {
                    logMetacat.warn((Object)("D1NodeService.archiveObject - can't log the delete event since " + e.getMessage()));
                }
            }
            sysMeta.setArchived(Boolean.valueOf(true));
            if (needModifyDate) {
                sysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
                sysMeta.setSerialVersion(sysMeta.getSerialVersion().add(BigInteger.ONE));
            }
            HazelcastService.getInstance().getSystemMetadataMap().put((Object)pid, (Object)sysMeta);
        }
        catch (McdbDocNotFoundException e) {
            throw new NotFound("1340", "The provided identifier was invalid.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("1350", "There was a problem archiving the object.The error message was: " + e.getMessage());
        }
        catch (InsufficientKarmaException e) {
            throw new NotAuthorized("1320", "The provided identity does not have permission to archive this object.");
        }
        catch (Exception e) {
            throw new ServiceFailure("1350", "There was a problem archiving the object.The error message was: " + e.getMessage());
        }
        return pid;
    }

    protected void archiveCNObject(boolean log, Session session, Identifier pid, SystemMetadata sysMeta, boolean needModifyDate) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String localId = null;
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
            this.archiveObject(log, session, pid, sysMeta, needModifyDate);
        }
        catch (McdbDocNotFoundException e) {
            try {
                if (sysMeta != null) {
                    sysMeta.setArchived(Boolean.valueOf(true));
                    if (needModifyDate) {
                        sysMeta.setSerialVersion(sysMeta.getSerialVersion().add(BigInteger.ONE));
                        sysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
                    }
                } else {
                    throw new ServiceFailure("4972", "Couldn't archive the object " + pid.getValue() + ". Couldn't obtain the system metadata record.");
                }
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)pid, (Object)sysMeta);
            }
            catch (RuntimeException re) {
                throw new ServiceFailure("4972", "Couldn't archive " + pid.getValue() + ". The error message was: " + re.getMessage());
            }
        }
        catch (SQLException e) {
            throw new ServiceFailure("4972", "Couldn't archive the object " + pid.getValue() + ". The local id of the object with the identifier can't be identified since " + e.getMessage());
        }
    }

    public void checkV1SystemMetaPidExist(Identifier identifier, String serviceFailureCode, String serviceFailureMessage, String noFoundCode, String notFoundMessage) throws ServiceFailure, NotFound {
        boolean exists = false;
        try {
            exists = IdentifierManager.getInstance().systemMetadataPIDExists(identifier);
        }
        catch (SQLException e) {
            throw new ServiceFailure(serviceFailureCode, serviceFailureMessage + " since " + e.getMessage());
        }
        if (!exists) {
            try {
                String localId = IdentifierManager.getInstance().getLocalId(identifier.getValue());
                if (EventLog.getInstance().isDeleted(localId)) {
                    notFoundMessage = notFoundMessage + " " + DELETEDMESSAGE;
                }
            }
            catch (Exception e) {
                logMetacat.info((Object)("Couldn't determine if the not-found identifier " + identifier.getValue() + " was deleted since " + e.getMessage()));
            }
            throw new NotFound(noFoundCode, notFoundMessage);
        }
    }

    protected Identifier getPIDForSID(Identifier sid, String serviceFailureCode) throws ServiceFailure {
        Identifier id;
        block4: {
            id = null;
            String serviceFailureMessage = "The PID  couldn't be identified for the sid " + sid.getValue();
            try {
                if (!IdentifierManager.getInstance().systemMetadataSIDExists(sid)) break block4;
                try {
                    id = IdentifierManager.getInstance().getHeadPID(sid);
                }
                catch (SQLException sqle) {
                    throw new ServiceFailure(serviceFailureCode, serviceFailureMessage + " since " + sqle.getMessage());
                }
            }
            catch (SQLException e) {
                throw new ServiceFailure(serviceFailureCode, serviceFailureMessage + " since " + e.getMessage());
            }
        }
        return id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkSidInModifyingSystemMetadata(SystemMetadata sysmeta, String invalidSystemMetadataCode, String serviceFailureCode) throws InvalidSystemMetadata, ServiceFailure {
        boolean pass = false;
        if (sysmeta == null) {
            throw new InvalidSystemMetadata(invalidSystemMetadataCode, "The system metadata is null in the request.");
        }
        Identifier sid = sysmeta.getSeriesId();
        if (sid == null) return true;
        if (!D1NodeService.isValidIdentifier(sid)) {
            throw new InvalidSystemMetadata(invalidSystemMetadataCode, "The series id in the system metadata is invalid in the request.");
        }
        Identifier pid = sysmeta.getIdentifier();
        if (!D1NodeService.isValidIdentifier(pid)) {
            throw new InvalidSystemMetadata(invalidSystemMetadataCode, "The pid in the system metadata is invalid in the request.");
        }
        if (sid.getValue().equals(pid.getValue())) {
            throw new InvalidSystemMetadata(invalidSystemMetadataCode, "The series id " + sid.getValue() + " in the system metadata shouldn't have the same value of the pid.");
        }
        try {
            if (!IdentifierManager.getInstance().identifierExists(sid.getValue())) return true;
            if (sysmeta.getObsoletes() != null) {
                SystemMetadata obsoletesSysmeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)sysmeta.getObsoletes());
                if (obsoletesSysmeta != null) {
                    Identifier obsoletesSid = obsoletesSysmeta.getSeriesId();
                    if (obsoletesSid != null && obsoletesSid.getValue() != null && !obsoletesSid.getValue().trim().equals("") && sid.getValue().equals(obsoletesSid.getValue())) {
                        return true;
                    }
                } else {
                    logMetacat.warn((Object)("D1NodeService.checkSidInModifyingSystemMetacat - Can't find the system metadata for the pid " + sysmeta.getObsoletes().getValue() + " which is the value of the obsoletes. So we can't check if the sid " + sid.getValue() + " is legitimate "));
                }
            }
            if (!pass && sysmeta.getObsoletedBy() != null) {
                SystemMetadata obsoletedBySysmeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)sysmeta.getObsoletedBy());
                if (obsoletedBySysmeta != null) {
                    Identifier obsoletedBySid = obsoletedBySysmeta.getSeriesId();
                    if (obsoletedBySid != null && obsoletedBySid.getValue() != null && !obsoletedBySid.getValue().trim().equals("") && sid.getValue().equals(obsoletedBySid.getValue())) {
                        return true;
                    }
                } else {
                    logMetacat.warn((Object)("D1NodeService.checkSidInModifyingSystemMetacat - Can't find the system metadata for the pid " + sysmeta.getObsoletes().getValue() + " which is the value of the obsoletedBy. So we can't check if the sid " + sid.getValue() + " is legitimate."));
                }
            }
            if (pass) return pass;
            throw new InvalidSystemMetadata(invalidSystemMetadataCode, "The series id " + sid.getValue() + " in the system metadata exists in the system. And it doesn't match either previous object's sid or the next object's sid.");
        }
        catch (SQLException e) {
            throw new ServiceFailure(serviceFailureCode, "Can't determine if the sid in the system metadata is unique or not since " + e.getMessage());
        }
    }

    public OptionList listViews(Session arg0) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        OptionList views = new OptionList();
        views.setKey("views");
        views.setDescription("List of views for objects on the node");
        Vector<String> skinNames = null;
        try {
            skinNames = SkinUtil.getSkinNames();
        }
        catch (PropertyNotFoundException e) {
            throw new ServiceFailure("2841", e.getMessage());
        }
        for (String skinName : skinNames) {
            views.addOption(skinName);
        }
        return views;
    }

    public OptionList listViews() throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return this.listViews(null);
    }

    public InputStream view(Session session, String format, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        InputStream resultInputStream;
        block9: {
            resultInputStream = null;
            String serviceFailureCode = "2831";
            Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
            if (sid != null) {
                pid = sid;
            }
            SystemMetadata sysMeta = this.getSystemMetadata(session, pid);
            InputStream object = this.get(session, pid);
            try {
                ObjectFormat objectFormat = ObjectFormatCache.getInstance().getFormat(sysMeta.getFormatId());
                if (objectFormat.getFormatType().equals("METADATA")) {
                    DBTransform transformer = new DBTransform();
                    String documentContent = IOUtils.toString((InputStream)object, (String)"UTF-8");
                    String sourceType = objectFormat.getFormatId().getValue();
                    String targetType = "-//W3C//HTML//EN";
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
                    Hashtable<String, String[]> params = new Hashtable<String, String[]>();
                    String localId = null;
                    try {
                        localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
                    }
                    catch (McdbDocNotFoundException e) {
                        throw new NotFound("1020", e.getMessage());
                    }
                    params.put("qformat", new String[]{format});
                    params.put("docid", new String[]{localId});
                    params.put("pid", new String[]{pid.getValue()});
                    transformer.transformXMLDocument(documentContent, sourceType, targetType, format, writer, params, null);
                    resultInputStream = new ContentTypeByteArrayInputStream(baos.toByteArray());
                    ((ContentTypeByteArrayInputStream)resultInputStream).setContentType("text/html");
                    break block9;
                }
                resultInputStream = object;
            }
            catch (IOException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (PropertyNotFoundException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (SQLException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (ClassNotFoundException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
        }
        return resultInputStream;
    }

    protected String existsInObsoletes(Identifier id) throws InvalidRequest, ServiceFailure {
        String guid = this.existsInFields("obsoletes", id);
        return guid;
    }

    protected String existsInObsoletedBy(Identifier id) throws InvalidRequest, ServiceFailure {
        String guid = this.existsInFields("obsoleted_by", id);
        return guid;
    }

    private String existsInFields(String column, Identifier id) throws InvalidRequest, ServiceFailure {
        String guid = null;
        if (id == null) {
            throw new InvalidRequest("4863", "The given identifier is null and we can't determine if the guid exists in the field " + column + " in the systemmetadata table");
        }
        String sql = "SELECT guid FROM systemmetadata WHERE " + column + " = ?";
        int serialNumber = -1;
        DBConnection dbConn = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("D1NodeService.existsInFields");
            serialNumber = dbConn.getCheckOutSerialNumber();
            stmt = dbConn.prepareStatement(sql);
            stmt.setString(1, id.getValue());
            result = stmt.executeQuery();
            if (result.next()) {
                guid = result.getString(1);
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ServiceFailure("4862", "We can't determine if the id " + id.getValue() + " exists in field " + column + " in the systemmetadata table since " + e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logMetacat.warn((Object)("We can close the PreparedStatment in D1NodeService.existsInFields since " + e.getMessage()));
                }
            }
        }
        return guid;
    }

    static {
        try {
            MAXIMUM_DB_RECORD_COUNT = Integer.valueOf(PropertyService.getProperty("database.webResultsetSize"));
        }
        catch (Exception e) {
            logMetacat.warn((Object)"Could not set MAXIMUM_DB_RECORD_COUNT", (Throwable)e);
        }
    }
}

