/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.common.index.IndexTask;
import edu.ucsb.nceas.metacat.common.index.event.IndexEvent;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.FileNotFoundException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;

public class HazelcastService
extends BaseService
implements EntryListener<Identifier, SystemMetadata>,
MembershipListener,
LifecycleListener,
ItemListener<Identifier> {
    private static final String MISSING_PID_PREFIX = "missing-";
    private static Logger logMetacat = Logger.getLogger(HazelcastService.class);
    private static HazelcastService hzService = null;
    private Config hzConfig;
    private String systemMetadataMap;
    private IMap<Identifier, SystemMetadata> systemMetadata;
    private String identifiersSet;
    private ISet<Identifier> identifiers;
    private ISet<Identifier> missingIdentifiers;
    private String hzIndexQueue;
    private IMap<Identifier, IndexTask> indexQueue;
    private String hzIndexEventMap;
    private IMap<Identifier, IndexEvent> indexEventMap;
    private HazelcastInstance hzInstance;

    private HazelcastService() {
        this._serviceName = "HazelcastService";
        try {
            this.init();
        }
        catch (ServiceException se) {
            logMetacat.error((Object)("There was a problem creating the HazelcastService. The error message was: " + se.getMessage()));
        }
    }

    public static HazelcastService getInstance() {
        if (hzService == null) {
            hzService = new HazelcastService();
        }
        return hzService;
    }

    public void init() throws ServiceException {
        String msg;
        logMetacat.debug((Object)"HazelcastService.init() called.");
        String configFileName = null;
        try {
            configFileName = PropertyService.getProperty("dataone.hazelcast.configFilePath");
            this.hzConfig = new FileSystemXmlConfig(configFileName);
        }
        catch (Exception e) {
            configFileName = PropertyService.CONFIG_FILE_DIR + FileUtil.getFS() + "hazelcast.xml";
            logMetacat.warn((Object)("Custom Hazelcast configuration not defined, using default: " + configFileName));
            try {
                this.hzConfig = new FileSystemXmlConfig(configFileName);
            }
            catch (FileNotFoundException e1) {
                String msg2 = e.getMessage();
                logMetacat.error((Object)msg2);
                throw new ServiceException(msg2);
            }
        }
        this.hzInstance = Hazelcast.newHazelcastInstance((Config)this.hzConfig);
        logMetacat.debug((Object)"Initialized hzInstance");
        try {
            this.systemMetadataMap = PropertyService.getProperty("dataone.hazelcast.storageCluster.systemMetadataMap");
            this.identifiersSet = PropertyService.getProperty("dataone.hazelcast.storageCluster.identifiersSet");
            this.systemMetadata = this.hzInstance.getMap(this.systemMetadataMap);
            logMetacat.debug((Object)"Initialized systemMetadata");
            logMetacat.warn((Object)"Retrieving hzIdentifiers from Hazelcast");
            this.identifiers = this.hzInstance.getSet(this.identifiersSet);
            logMetacat.warn((Object)"Retrieved hzIdentifiers from Hazelcast");
            this.missingIdentifiers = this.hzInstance.getSet("hzMissingIdentifiersSet");
            this.missingIdentifiers.addItemListener((ItemListener)this, true);
            this.hzIndexQueue = PropertyService.getProperty("index.hazelcast.indexqueue");
            this.indexQueue = this.hzInstance.getMap(this.hzIndexQueue);
            this.hzIndexEventMap = PropertyService.getProperty("index.hazelcast.indexeventmap");
            this.indexEventMap = this.hzInstance.getMap(this.hzIndexEventMap);
            this.systemMetadata.addEntryListener((EntryListener)this, true);
            this.hzInstance.getCluster().addMembershipListener((MembershipListener)this);
            this.hzInstance.getLifecycleService().addLifecycleListener((LifecycleListener)this);
        }
        catch (PropertyNotFoundException e) {
            msg = "Couldn't find Hazelcast properties for the DataONE clusters. The error message was: " + e.getMessage();
            logMetacat.error((Object)msg);
        }
        try {
            this.resynchInThread();
        }
        catch (Exception e) {
            msg = "Problem resynchronizing system metadata. " + e.getMessage();
            logMetacat.error((Object)msg, (Throwable)e);
        }
    }

    public IMap<Identifier, SystemMetadata> getSystemMetadataMap() {
        return this.systemMetadata;
    }

    public ISet<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public IMap<Identifier, IndexTask> getIndexQueue() {
        return this.indexQueue;
    }

    public IMap<Identifier, IndexEvent> getIndexEventMap() {
        return this.indexEventMap;
    }

    public void refreshSystemMetadataEntry(String guid) {
        Identifier identifier = new Identifier();
        identifier.setValue(guid);
        HazelcastService.getInstance().getSystemMetadataMap().evict((Object)identifier);
    }

    public Lock getLock(String identifier) {
        ILock lock = null;
        try {
            lock = HazelcastService.getInstance().getHazelcastInstance().getLock((Object)identifier);
        }
        catch (RuntimeException e) {
            logMetacat.info((Object)("Couldn't get a lock for identifier " + identifier + " !!"));
        }
        return lock;
    }

    @Override
    public boolean refreshable() {
        return false;
    }

    @Override
    public void stop() throws ServiceException {
        this.hzInstance.getLifecycleService().shutdown();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hzInstance;
    }

    @Override
    protected void doRefresh() throws ServiceException {
        this.hzInstance.getLifecycleService().restart();
    }

    public void entryAdded(EntryEvent<Identifier, SystemMetadata> event) {
        logMetacat.info((Object)("SystemMetadata entry added event on identifier " + ((Identifier)event.getKey()).getValue()));
        this.entryUpdated(event);
    }

    public void entryEvicted(EntryEvent<Identifier, SystemMetadata> event) {
        logMetacat.info((Object)("SystemMetadata entry evicted event on identifier " + ((Identifier)event.getKey()).getValue()));
        if (!this.identifiers.contains(event.getKey())) {
            this.identifiers.add(event.getKey());
        }
    }

    public void entryRemoved(EntryEvent<Identifier, SystemMetadata> event) {
        logMetacat.info((Object)("SystemMetadata entry removed event on identifier " + ((Identifier)event.getKey()).getValue()));
        IdentifierManager.getInstance().deleteSystemMetadata(((SystemMetadata)event.getValue()).getIdentifier().getValue());
        if (this.identifiers.contains(event.getKey())) {
            this.identifiers.remove(event.getKey());
        }
    }

    public void entryUpdated(EntryEvent<Identifier, SystemMetadata> event) {
        logMetacat.debug((Object)("Entry added/updated to System Metadata map: " + ((Identifier)event.getKey()).getValue()));
        PartitionService partitionService = this.hzInstance.getPartitionService();
        Partition partition = partitionService.getPartition(event.getKey());
        Member ownerMember = partition.getOwner();
        SystemMetadata sysmeta = (SystemMetadata)event.getValue();
        if (!ownerMember.localMember()) {
            if (sysmeta == null) {
                logMetacat.warn((Object)("No SystemMetadata provided in the event, getting from shared map: " + ((Identifier)event.getKey()).getValue()));
                sysmeta = (SystemMetadata)this.getSystemMetadataMap().get(event.getKey());
                if (sysmeta == null) {
                    logMetacat.error((Object)("Could not find SystemMetadata in shared map for: " + ((Identifier)event.getKey()).getValue()));
                }
            }
            this.saveLocally((SystemMetadata)event.getValue());
        }
        if (!this.identifiers.contains(event.getKey())) {
            this.identifiers.add(event.getKey());
        }
    }

    private void saveLocally(SystemMetadata sm) {
        logMetacat.debug((Object)("Saving entry locally: " + sm.getIdentifier().getValue()));
        try {
            IdentifierManager.getInstance().insertOrUpdateSystemMetadata(sm);
        }
        catch (McdbDocNotFoundException e) {
            logMetacat.error((Object)"Could not save System Metadata to local store.", (Throwable)e);
        }
        catch (SQLException e) {
            logMetacat.error((Object)"Could not save System Metadata to local store.", (Throwable)e);
        }
        catch (InvalidSystemMetadata e) {
            logMetacat.error((Object)"Could not save System Metadata to local store.", (Throwable)e);
        }
    }

    private void synchronizeLocalStore() {
        List<String> localIds = IdentifierManager.getInstance().getLocalIdsWithNoSystemMetadata(true, -1);
        if (localIds != null) {
            logMetacat.debug((Object)("Member missing SystemMetadata entries, count = " + localIds.size()));
            for (String localId : localIds) {
                logMetacat.debug((Object)("Processing system metadata for localId: " + localId));
                try {
                    String docid = DocumentUtil.getSmartDocId(localId);
                    int rev = DocumentUtil.getRevisionFromAccessionNumber(localId);
                    String guid = IdentifierManager.getInstance().getGUID(docid, rev);
                    logMetacat.debug((Object)("Found mapped guid: " + guid));
                    Identifier pid = new Identifier();
                    pid.setValue(guid);
                    SystemMetadata sm = (SystemMetadata)this.systemMetadata.get((Object)pid);
                    logMetacat.debug((Object)("Found shared system metadata for guid: " + guid));
                    this.saveLocally(sm);
                    logMetacat.debug((Object)("Saved shared system metadata locally for guid: " + guid));
                }
                catch (Exception e) {
                    logMetacat.error((Object)("Could not save shared SystemMetadata entry locally, localId: " + localId), (Throwable)e);
                }
            }
        }
    }

    private void resynchToRemote() {
        Set<Identifier> localIdKeys = this.loadAllKeys();
        HashSet<Identifier> missingIdKeys = new HashSet<Identifier>();
        Iterator idIter = this.identifiers.iterator();
        int processedCount = 0;
        while (idIter.hasNext()) {
            Identifier pid = (Identifier)idIter.next();
            if (localIdKeys.contains(pid)) {
                logMetacat.debug((Object)("Shared pid is already in local identifier set: " + pid.getValue()));
                localIdKeys.remove(pid);
            } else {
                missingIdKeys.add(pid);
            }
            ++processedCount;
        }
        logMetacat.warn((Object)("processedCount (identifiers from iterator): " + processedCount));
        logMetacat.warn((Object)("local pid count not yet shared: " + localIdKeys.size() + ", shared pid count: " + this.identifiers.size()));
        logMetacat.warn((Object)"Loading missing local keys into hzIdentifiers");
        for (Identifier key : localIdKeys) {
            if (this.identifiers.contains((Object)key)) continue;
            logMetacat.debug((Object)("Adding missing hzIdentifiers key: " + key.getValue()));
            this.identifiers.add((Object)key);
        }
        logMetacat.warn((Object)"Initialized identifiers with missing local keys");
        logMetacat.warn((Object)("Processing missing SystemMetadata for missing pid count: " + missingIdKeys.size()));
        for (Identifier pid : missingIdKeys) {
            logMetacat.debug((Object)("Publishing missing pid to wanted list: " + pid.getValue()));
            this.missingIdentifiers.add((Object)pid);
        }
    }

    public void resynchInThread() {
        logMetacat.debug((Object)"launching system metadata resynch in a thread");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss aaa");
                    System.out.println(dateFormat.format(Calendar.getInstance().getTime()) + " Start the hazelcast synchronization");
                    logMetacat.warn((Object)"Start the hazelcast synchronization");
                    HazelcastService.this.resynchToRemote();
                    System.out.println(dateFormat.format(Calendar.getInstance().getTime()) + " End the hazelcast synchronization");
                    logMetacat.warn((Object)"End the hazelcast synchronization");
                }
                catch (Exception e) {
                    logMetacat.error((Object)("Error in resynchInThread: " + e.getMessage()), (Throwable)e);
                }
            }
        });
        executor.shutdown();
    }

    public void memberAdded(MembershipEvent event) {
        Member member = event.getMember();
        logMetacat.debug((Object)("Member added to cluster: " + member.getInetSocketAddress()));
        boolean isLocal = member.localMember();
        if (isLocal) {
            logMetacat.debug((Object)("Member islocal: " + member.getInetSocketAddress()));
            this.synchronizeLocalStore();
        }
    }

    public void memberRemoved(MembershipEvent event) {
    }

    public void stateChanged(LifecycleEvent event) {
        logMetacat.debug((Object)("HZ LifecycleEvent.state: " + event.getState()));
        if (event.getState().equals((Object)LifecycleEvent.LifecycleState.RESUMED)) {
            logMetacat.debug((Object)"HZ LifecycleEvent.state is RESUMED, calling synchronizeLocalStore()");
            this.synchronizeLocalStore();
        }
    }

    private Set<Identifier> loadAllKeys() {
        HashSet<Identifier> pids = new HashSet<Identifier>();
        try {
            List<String> guids = IdentifierManager.getInstance().getAllSystemMetadataGUIDs();
            logMetacat.warn((Object)("Local SystemMetadata pid count: " + guids.size()));
            for (String guid : guids) {
                Identifier pid = new Identifier();
                pid.setValue(guid);
                pids.add(pid);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return pids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemAdded(ItemEvent<Identifier> event) {
        Identifier pid = (Identifier)event.getItem();
        logMetacat.debug((Object)("Responding to itemAdded for pid: " + pid.getValue()));
        ILock lock = null;
        try {
            SystemMetadata sm = IdentifierManager.getInstance().getSystemMetadata(pid.getValue());
            if (sm != null) {
                lock = this.hzInstance.getLock((Object)(MISSING_PID_PREFIX + pid.getValue()));
                if (lock.tryLock()) {
                    logMetacat.debug((Object)("Adding SystemMetadata to shared map for pid: " + pid.getValue()));
                    this.systemMetadata.put((Object)pid, (Object)sm);
                    this.missingIdentifiers.remove((Object)pid);
                } else {
                    logMetacat.debug((Object)(MISSING_PID_PREFIX + pid.getValue() + " was already locked. Skipping."));
                }
            } else {
                logMetacat.warn((Object)("Local system metadata not found for pid: " + pid.getValue()));
            }
        }
        catch (Exception e) {
            logMetacat.error((Object)("Error looking up missing system metadata for pid: " + pid.getValue()));
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public void itemRemoved(ItemEvent<Identifier> event) {
    }
}

