/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.v1;

import edu.ucsb.nceas.metacat.dataone.D1NodeVersionChecker;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.service.cn.v1.CNAuthorization;
import org.dataone.service.cn.v1.CNCore;
import org.dataone.service.cn.v1.CNRead;
import org.dataone.service.cn.v1.CNReplication;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.ChecksumAlgorithmList;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormat;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectFormatList;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.ObjectLocationList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.types.v2.Log;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.types.v2.TypeFactory;

public class CNodeService
implements CNAuthorization,
CNCore,
CNRead,
CNReplication {
    private edu.ucsb.nceas.metacat.dataone.CNodeService impl = null;
    private Logger logMetacat = Logger.getLogger(CNodeService.class);

    public static CNodeService getInstance(HttpServletRequest request) {
        return new CNodeService(request);
    }

    private CNodeService(HttpServletRequest request) {
        this.impl = edu.ucsb.nceas.metacat.dataone.CNodeService.getInstance(request);
    }

    public boolean deleteReplicationMetadata(Identifier pid, NodeReference nodeId, long serialVersion) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotFound, NotImplemented, VersionMismatch {
        return this.impl.deleteReplicationMetadata(null, pid, nodeId, serialVersion);
    }

    @Deprecated
    public boolean deleteReplicationMetadata(Session session, Identifier pid, NodeReference nodeId, long serialVersion) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotFound, NotImplemented, VersionMismatch {
        return this.impl.deleteReplicationMetadata(session, pid, nodeId, serialVersion);
    }

    public boolean isNodeAuthorized(Subject targetNodeSubject, Identifier pid) throws NotImplemented, NotAuthorized, InvalidToken, ServiceFailure, NotFound, InvalidRequest {
        return this.impl.isNodeAuthorized(null, targetNodeSubject, pid);
    }

    @Deprecated
    public boolean isNodeAuthorized(Session originatingNodeSession, Subject targetNodeSubject, Identifier pid) throws NotImplemented, NotAuthorized, InvalidToken, ServiceFailure, NotFound, InvalidRequest {
        return this.impl.isNodeAuthorized(originatingNodeSession, targetNodeSubject, pid);
    }

    public boolean setReplicationPolicy(Identifier pid, ReplicationPolicy policy, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        String serviceFailure = "4882";
        String notFound = "4884";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No object could be found for given PID: " + pid.getValue());
        return this.impl.setReplicationPolicy(null, pid, policy, serialVersion);
    }

    @Deprecated
    public boolean setReplicationPolicy(Session session, Identifier pid, ReplicationPolicy policy, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        return this.impl.setReplicationPolicy(session, pid, policy, serialVersion);
    }

    public boolean setReplicationStatus(Identifier pid, NodeReference targetNode, ReplicationStatus status, BaseException failure) throws ServiceFailure, NotImplemented, InvalidToken, NotAuthorized, InvalidRequest, NotFound {
        return this.impl.setReplicationStatus(null, pid, targetNode, status, failure);
    }

    @Deprecated
    public boolean setReplicationStatus(Session session, Identifier pid, NodeReference targetNode, ReplicationStatus status, BaseException failure) throws ServiceFailure, NotImplemented, InvalidToken, NotAuthorized, InvalidRequest, NotFound {
        String serviceFailure = "4700";
        String notFound = "4740";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No object could be found for given PID: " + pid.getValue());
        return this.impl.setReplicationStatus(session, pid, targetNode, status, failure);
    }

    public boolean updateReplicationMetadata(Identifier pid, Replica replica, long serialVersion) throws NotImplemented, NotAuthorized, ServiceFailure, NotFound, InvalidRequest, InvalidToken, VersionMismatch {
        return this.impl.updateReplicationMetadata(null, pid, replica, serialVersion);
    }

    @Deprecated
    public boolean updateReplicationMetadata(Session session, Identifier pid, Replica replica, long serialVersion) throws NotImplemented, NotAuthorized, ServiceFailure, NotFound, InvalidRequest, InvalidToken, VersionMismatch {
        return this.impl.updateReplicationMetadata(session, pid, replica, serialVersion);
    }

    public DescribeResponse describe(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        String serviceFailure = "4931";
        String notFound = "4933";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No system metadata could be found for given PID: " + pid.getValue());
        return this.impl.describe(null, pid);
    }

    @Deprecated
    public DescribeResponse describe(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        String serviceFailure = "4931";
        String notFound = "4933";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No system metadata could be found for given PID: " + pid.getValue());
        return this.impl.describe(session, pid);
    }

    public InputStream get(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "1030";
        String notFound = "1020";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node");
        return this.impl.get(null, pid);
    }

    @Deprecated
    public InputStream get(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "1030";
        String notFound = "1020";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node");
        return this.impl.get(session, pid);
    }

    public Checksum getChecksum(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.impl.getChecksum(null, pid);
    }

    @Deprecated
    public Checksum getChecksum(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.impl.getChecksum(session, pid);
    }

    public QueryEngineDescription getQueryEngineDescription(String queryEngine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        return this.impl.getQueryEngineDescription(null, queryEngine);
    }

    public org.dataone.service.types.v1.SystemMetadata getSystemMetadata(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "1090";
        String notFound = "1060";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No system metadata could be found for given PID: " + pid.getValue());
        SystemMetadata sysMeta = this.impl.getSystemMetadata(null, pid);
        org.dataone.service.types.v1.SystemMetadata retSysMeta = null;
        try {
            retSysMeta = (org.dataone.service.types.v1.SystemMetadata)TypeFactory.convertTypeFromType((Object)sysMeta, org.dataone.service.types.v1.SystemMetadata.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("1090", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return retSysMeta;
    }

    @Deprecated
    public org.dataone.service.types.v1.SystemMetadata getSystemMetadata(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "1090";
        String notFound = "1060";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No system metadata could be found for given PID: " + pid.getValue());
        SystemMetadata sysMeta = this.impl.getSystemMetadata(session, pid);
        org.dataone.service.types.v1.SystemMetadata retSysMeta = null;
        try {
            retSysMeta = (org.dataone.service.types.v1.SystemMetadata)TypeFactory.convertTypeFromType((Object)sysMeta, org.dataone.service.types.v1.SystemMetadata.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("1090", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return retSysMeta;
    }

    public ObjectList listObjects(Date startTime, Date endTime, ObjectFormatIdentifier formatid, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        NodeReference nodeId = null;
        if (!replicaStatus.booleanValue()) {
            nodeId = new NodeReference();
            try {
                PropertyService.getInstance();
                String currentNodeId = PropertyService.getProperty("dataone.nodeId");
                nodeId.setValue(currentNodeId);
            }
            catch (Exception e) {
                throw new ServiceFailure("1580", e.getMessage());
            }
        }
        return this.impl.listObjects(null, startTime, endTime, formatid, null, nodeId, start, count);
    }

    @Deprecated
    public ObjectList listObjects(Session session, Date startTime, Date endTime, ObjectFormatIdentifier formatid, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        NodeReference nodeId = null;
        if (!replicaStatus.booleanValue()) {
            nodeId = new NodeReference();
            try {
                PropertyService.getInstance();
                String currentNodeId = PropertyService.getProperty("dataone.nodeId");
                nodeId.setValue(currentNodeId);
            }
            catch (Exception e) {
                throw new ServiceFailure("1580", e.getMessage());
            }
        }
        return this.impl.listObjects(session, startTime, endTime, formatid, null, nodeId, start, count);
    }

    public QueryEngineList listQueryEngines() throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        return this.impl.listQueryEngines(null);
    }

    public InputStream query(String queryEngine, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        return this.impl.query(null, queryEngine, query);
    }

    public ObjectLocationList resolve(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.impl.resolve(null, pid);
    }

    @Deprecated
    public ObjectLocationList resolve(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.impl.resolve(session, pid);
    }

    public ObjectList search(String queryType, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return this.impl.search(null, queryType, query);
    }

    @Deprecated
    public ObjectList search(Session session, String queryType, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return this.impl.search(session, queryType, query);
    }

    public Identifier archive(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "4972";
        String notFound = "4971";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.archive(null, pid);
    }

    @Deprecated
    public Identifier archive(Session session, Identifier pid) throws InvalidToken, ServiceFailure, InvalidRequest, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "4972";
        String notFound = "4971";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.archive(session, pid);
    }

    public Identifier create(Identifier pid, InputStream object, org.dataone.service.types.v1.SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        return this.create(null, pid, object, sysmeta);
    }

    @Deprecated
    public Identifier create(Session session, Identifier pid, InputStream object, org.dataone.service.types.v1.SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        SystemMetadata v2Sysmeta = null;
        try {
            v2Sysmeta = (SystemMetadata)TypeFactory.convertTypeFromType((Object)sysmeta, SystemMetadata.class);
        }
        catch (Exception e) {
            IOUtils.closeQuietly((InputStream)object);
            ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return this.impl.create(session, pid, object, v2Sysmeta);
    }

    public Identifier delete(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "4962";
        String notFound = "4961";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.delete(null, pid);
    }

    @Deprecated
    public Identifier delete(Session session, Identifier pid) throws InvalidToken, ServiceFailure, InvalidRequest, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "4962";
        String notFound = "4961";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.delete(session, pid);
    }

    public Identifier generateIdentifier(String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return this.impl.generateIdentifier(null, scheme, fragment);
    }

    @Deprecated
    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return this.impl.generateIdentifier(session, scheme, fragment);
    }

    public ObjectFormat getFormat(ObjectFormatIdentifier fmtid) throws ServiceFailure, NotFound, NotImplemented, InvalidRequest {
        org.dataone.service.types.v2.ObjectFormat format = this.impl.getFormat(fmtid);
        ObjectFormat v1Format = null;
        try {
            v1Format = (ObjectFormat)TypeFactory.convertTypeFromType((Object)format, ObjectFormat.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("4846", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return v1Format;
    }

    public org.dataone.service.types.v1.Log getLogRecords(Date fromDate, Date toDate, Event event, String pidFilter, Integer start, Integer count) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        return this.getLogRecords(null, fromDate, toDate, event, pidFilter, start, count);
    }

    @Deprecated
    public org.dataone.service.types.v1.Log getLogRecords(Session session, Date fromDate, Date toDate, Event event, String pidFilter, Integer start, Integer count) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        org.dataone.service.types.v1.Log retLog = new org.dataone.service.types.v1.Log();
        if (pidFilter != null && !pidFilter.trim().equals("")) {
            String serviceFailure = "1490";
            String notFound = "1020";
            Identifier pid = new Identifier();
            pid.setValue(pidFilter);
            try {
                this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "The given PID: " + pid.getValue() + " doesn't exist in this node");
            }
            catch (NotFound e) {
                this.logMetacat.info((Object)e.getMessage());
                return retLog;
            }
        }
        String eventValue = null;
        if (event != null) {
            eventValue = event.xmlValue();
        }
        Log log = this.impl.getLogRecords(session, fromDate, toDate, eventValue, pidFilter, start, count);
        try {
            retLog = (org.dataone.service.types.v1.Log)TypeFactory.convertTypeFromType((Object)log, org.dataone.service.types.v1.Log.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("1490", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return retLog;
    }

    public boolean hasReservation(Subject subject, Identifier pid) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        return this.impl.hasReservation(null, subject, pid);
    }

    @Deprecated
    public boolean hasReservation(Session session, Subject subject, Identifier pid) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        return this.impl.hasReservation(session, subject, pid);
    }

    public ChecksumAlgorithmList listChecksumAlgorithms() throws ServiceFailure, NotImplemented {
        return this.impl.listChecksumAlgorithms();
    }

    public ObjectFormatList listFormats() throws ServiceFailure, NotImplemented {
        org.dataone.service.types.v2.ObjectFormatList formats = this.impl.listFormats();
        ObjectFormatList retFormats = new ObjectFormatList();
        try {
            retFormats = (ObjectFormatList)TypeFactory.convertTypeFromType((Object)formats, ObjectFormatList.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("4841", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return retFormats;
    }

    public org.dataone.service.types.v1.NodeList listNodes() throws NotImplemented, ServiceFailure {
        NodeList nodes = this.impl.listNodes();
        org.dataone.service.types.v1.NodeList retNodes = null;
        try {
            retNodes = (org.dataone.service.types.v1.NodeList)TypeFactory.convertTypeFromType((Object)nodes, org.dataone.service.types.v1.NodeList.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("4801", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return retNodes;
    }

    public Date ping() throws NotImplemented, ServiceFailure, InsufficientResources {
        return this.impl.ping();
    }

    public Identifier registerSystemMetadata(Identifier pid, org.dataone.service.types.v1.SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        return this.registerSystemMetadata(null, pid, sysmeta);
    }

    @Deprecated
    public Identifier registerSystemMetadata(Session session, Identifier pid, org.dataone.service.types.v1.SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new InvalidRequest("4863", "The pid should not be null in the register system metadata request");
        }
        if (sysmeta == null) {
            throw new InvalidRequest("4863", "The system metadata object should not be null in the register system metadata request for the pid" + pid.getValue());
        }
        SystemMetadata v2Sysmeta = null;
        try {
            v2Sysmeta = (SystemMetadata)TypeFactory.convertTypeFromType((Object)sysmeta, SystemMetadata.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        D1NodeVersionChecker checker = new D1NodeVersionChecker(v2Sysmeta.getAuthoritativeMemberNode());
        String version = checker.getVersion("MNStorage");
        if (version == null) {
            throw new ServiceFailure("4862", "Couldn't determine the authoritative member node storage version for the pid " + pid.getValue());
        }
        if (version.equalsIgnoreCase("v2")) {
            throw new NotAuthorized("4861", "The Coordinating Node is not authorized to make systemMetadata changes on this object. Please make changes directly on the authoritative Member Node.");
        }
        if (!version.equalsIgnoreCase("v1")) {
            throw new InvalidRequest("4863", "The version of the MNStorage is " + version + " for the authoritative member node of the object " + pid.getValue() + ". We don't support it.");
        }
        v2Sysmeta.setSerialVersion(BigInteger.ONE);
        return this.impl.registerSystemMetadata(session, pid, v2Sysmeta);
    }

    public Identifier reserveIdentifier(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, NotImplemented, InvalidRequest {
        return this.impl.reserveIdentifier(null, pid);
    }

    @Deprecated
    public Identifier reserveIdentifier(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, NotImplemented, InvalidRequest {
        return this.impl.reserveIdentifier(session, pid);
    }

    public boolean setObsoletedBy(Identifier pid, Identifier obsoletedByPid, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        return this.impl.setObsoletedBy(null, pid, obsoletedByPid, serialVersion);
    }

    @Deprecated
    public boolean setObsoletedBy(Session session, Identifier pid, Identifier obsoletedByPid, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        return this.impl.setObsoletedBy(session, pid, obsoletedByPid, serialVersion);
    }

    public boolean isAuthorized(Identifier pid, Permission permission) throws ServiceFailure, InvalidToken, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        String serviceFailure = "1760";
        String notFound = "1800";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.isAuthorized(null, pid, permission);
    }

    @Deprecated
    public boolean isAuthorized(Session session, Identifier pid, Permission permission) throws ServiceFailure, InvalidToken, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        String serviceFailure = "1760";
        String notFound = "1800";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.isAuthorized(session, pid, permission);
    }

    public boolean setAccessPolicy(Identifier pid, AccessPolicy accessPolicy, long serialVersion) throws InvalidToken, NotFound, NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, VersionMismatch {
        String serviceFailure = "4430";
        String notFound = "4400";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No object could be found for given PID: " + pid.getValue());
        return this.impl.setAccessPolicy(null, pid, accessPolicy, serialVersion);
    }

    @Deprecated
    public boolean setAccessPolicy(Session session, Identifier pid, AccessPolicy accessPolicy, long serialVersion) throws InvalidToken, NotFound, NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, VersionMismatch {
        String serviceFailure = "4430";
        String notFound = "4400";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No object could be found for given PID: " + pid.getValue());
        return this.impl.setAccessPolicy(session, pid, accessPolicy, serialVersion);
    }

    public Identifier setRightsHolder(Identifier pid, Subject userId, long serialVersion) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, VersionMismatch {
        String serviceFailure = "4490";
        String notFound = "4460";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No object could be found for given PID: " + pid.getValue());
        return this.impl.setRightsHolder(null, pid, userId, serialVersion);
    }

    @Deprecated
    public Identifier setRightsHolder(Session session, Identifier pid, Subject userId, long serialVersion) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, VersionMismatch {
        return this.impl.setRightsHolder(session, pid, userId, serialVersion);
    }
}

