/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.service;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.SessionData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SessionService
extends BaseService {
    private static SessionService sessionService = null;
    private static int sessionTimeoutMinutes;
    private static Logger logMetacat;
    private static Hashtable<String, SessionData> sessionHash;
    private static final String PUBLIC_SESSION_ID = "0";
    private static Object lockObj;

    private SessionService() throws ServiceException {
        this._serviceName = "SessionService";
        String sessionTimeoutStr = null;
        try {
            sessionHash = new Hashtable();
            sessionTimeoutStr = PropertyService.getProperty("session.timeoutMinutes");
            sessionTimeoutMinutes = Integer.parseInt(sessionTimeoutStr);
            logMetacat.debug((Object)"SessionService() - Registering public session id: 0");
            this.registerSession(PUBLIC_SESSION_ID, "public", null, null, "Public User");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ServiceException("SessionService() - Error getting property: " + pnfe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new ServiceException("SessionService() - Error parsing session timeout minutes: " + sessionTimeoutStr);
        }
    }

    public static SessionService getInstance() {
        try {
            if (sessionService == null) {
                sessionService = new SessionService();
            }
            return sessionService;
        }
        catch (ServiceException se) {
            logMetacat.error((Object)("SessionService.getInstance - could not get an instance of SessionService: " + se.getMessage()));
            return null;
        }
    }

    @Override
    public boolean refreshable() {
        return false;
    }

    @Override
    public void doRefresh() throws ServiceException {
    }

    @Override
    public void stop() throws ServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSession(String sessionId, String userName, String[] groupNames, String password, String name) throws ServiceException {
        Object object = lockObj;
        synchronized (object) {
            if (sessionId == null) {
                throw new ServiceException("SessionService.registerSession - Cannot register a null session id");
            }
            logMetacat.debug((Object)("SessionService.registerSession - Registering session id: " + sessionId));
            SessionData sessionData = new SessionData(sessionId, userName, groupNames, password, name);
            sessionHash.put(sessionId, sessionData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSession(SessionData sessionData) throws ServiceException {
        Object object = lockObj;
        synchronized (object) {
            if (sessionData == null) {
                throw new ServiceException("SessionService.registerSession - Cannot register null session data");
            }
            logMetacat.debug((Object)("SessionService.registerSession - Registering session data with id: " + sessionData.getId()));
            sessionHash.put(sessionData.getId(), sessionData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterSession(String sessionId) {
        Object object = lockObj;
        synchronized (object) {
            if (sessionId == null) {
                logMetacat.error((Object)"SessionService.unRegisterSession - trying to unregister a session with null id");
                return;
            }
            if (sessionId.equals(PUBLIC_SESSION_ID)) {
                logMetacat.error((Object)("SessionService.unRegisterSession - cannot unregister public session, sessionId=" + sessionId));
                return;
            }
            logMetacat.info((Object)("SessionService.unRegisterSession - unRegistering session: " + sessionId));
            sessionHash.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterAllSessions() {
        Object object = lockObj;
        synchronized (object) {
            Enumeration<String> keyEnum = sessionHash.keys();
            while (keyEnum.hasMoreElements()) {
                String sessionId = keyEnum.nextElement();
                if (sessionId.equals(PUBLIC_SESSION_ID)) continue;
                logMetacat.info((Object)("SessionService.unRegisterAllSessions - unRegistering session: " + sessionId));
                sessionHash.remove(sessionId);
            }
        }
    }

    public boolean isSessionRegistered(String sessionId) {
        if (sessionId == null) {
            logMetacat.error((Object)"SessionService.isSessionRegistered - trying to check if a session with null id is registered");
            return false;
        }
        this.checkTimeout(sessionId);
        return sessionHash.containsKey(sessionId);
    }

    public void validateSession(Writer out, HttpServletResponse response, String sessionId) throws IOException {
        SessionData sessionData;
        boolean needSessionInfo = false;
        response.setContentType("text/xml");
        out.write("<?xml version=\"1.0\"?>");
        out.write("<validateSession><status>");
        if (this.validateSession(sessionId)) {
            out.write("valid");
            needSessionInfo = true;
        } else {
            out.write("invalid");
        }
        out.write("</status>");
        if (needSessionInfo && (sessionData = this.getRegisteredSession(sessionId)) != null) {
            out.write("<userInformation>");
            out.write("<name>");
            out.write(sessionData.getUserName());
            out.write("</name>");
            out.write("<fullName>");
            out.write(sessionData.getName());
            out.write("</fullName>");
            this.appendGroupsInformation(sessionData, out);
            out.write("</userInformation>");
        }
        out.write("<sessionId>" + sessionId + "</sessionId></validateSession>");
    }

    public boolean validateSession(String sessionId) {
        return sessionId != null && !sessionId.equals(PUBLIC_SESSION_ID) && this.isSessionRegistered(sessionId);
    }

    public SessionData getRegisteredSession(String sessionId) {
        if (sessionId == null) {
            logMetacat.error((Object)"SessionService.getRegisteredSession - trying to get a session with null id");
            return null;
        }
        this.checkTimeout(sessionId);
        return sessionHash.get(sessionId);
    }

    public SessionData getPublicSession() {
        return sessionHash.get(PUBLIC_SESSION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void touchSession(String sessionId) {
        if (sessionId == null) {
            logMetacat.error((Object)"SessionService.touchSession - trying to touch a session with null id");
        } else if (this.isSessionRegistered(sessionId)) {
            Object object = lockObj;
            synchronized (object) {
                SessionData sessionData = this.getRegisteredSession(sessionId);
                sessionData.setLastAccessedTime();
            }
        }
    }

    private void checkTimeout(String sessionId) {
        SessionData sessionData = null;
        sessionData = sessionHash.get(sessionId);
        if (sessionData != null) {
            Calendar expireTime = Calendar.getInstance();
            Calendar lastAccessedTime = sessionData.getLastAccessedTime();
            expireTime.add(12, 0 - sessionTimeoutMinutes);
            if (lastAccessedTime.compareTo(expireTime) < 0) {
                this.unRegisterSession(sessionId);
            }
        }
    }

    private void appendGroupsInformation(SessionData sessionData, Writer out) throws IOException {
        String[] groups;
        if (sessionData != null && out != null && (groups = sessionData.getGroupNames()) != null) {
            for (String groupName : groups) {
                out.write("<group>");
                out.write(groupName);
                out.write("</group>");
            }
        }
    }

    static {
        logMetacat = Logger.getLogger(SessionService.class);
        sessionHash = null;
        lockObj = new Object();
    }
}

