/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.cucadiagram.CrossingType;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.graphic.HtmlColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    private final Map<String, IEntity> entities = new LinkedHashMap<String, IEntity>();
    private final String code;
    private final String display;
    private final String namespace;
    private HtmlColor backColor;
    private final Group parent;
    private final Collection<Group> children = new ArrayList<Group>();
    private boolean dashed;
    private boolean rounded;
    private boolean bold;
    private final GroupType type;
    private IEntity entityCluster;
    private boolean autonom = true;
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private final int cpt = UniqueSequence.getValue();
    private String stereotype;

    public Group(String string, String string2, String string3, GroupType groupType, Group group) {
        if (groupType == null) {
            throw new IllegalArgumentException();
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (group != null) {
            if (group.children.contains(this)) {
                throw new IllegalArgumentException();
            }
            group.children.add(this);
        }
        this.namespace = string3;
        this.type = groupType;
        this.parent = group;
        this.code = string;
        this.display = string2;
    }

    public String toString() {
        return "G[code=" + this.code + "]" + this.entities + " autonom=" + this.isAutonom();
    }

    public void addEntity(Entity entity) {
        if (this.entities.containsValue(entity)) {
            throw new IllegalArgumentException();
        }
        if (this.entities.containsKey(entity.getCode())) {
            throw new IllegalArgumentException(entity.getCode());
        }
        if (entity.getType() == EntityType.GROUP) {
            throw new IllegalArgumentException();
        }
        this.entities.put(entity.getCode(), entity);
    }

    public boolean contains(IEntity iEntity) {
        if (iEntity == null) {
            throw new IllegalArgumentException();
        }
        if (iEntity.equals(this.entityCluster)) {
            throw new IllegalArgumentException();
        }
        if (this.entities.containsValue(iEntity)) {
            return true;
        }
        for (Group group : this.getChildren()) {
            if (!group.contains(iEntity)) continue;
            return true;
        }
        return false;
    }

    public CrossingType getCrossingType(Link link) {
        if (link.getEntity1().equals(this.entityCluster) && link.getEntity2().equals(this.entityCluster)) {
            return CrossingType.SELF;
        }
        if (link.getEntity1().equals(this.entityCluster)) {
            if (this.contains(link.getEntity2())) {
                return CrossingType.TOUCH_INSIDE;
            }
            return CrossingType.TOUCH_OUTSIDE;
        }
        if (link.getEntity2().equals(this.entityCluster)) {
            if (this.contains(link.getEntity1())) {
                return CrossingType.TOUCH_INSIDE;
            }
            return CrossingType.TOUCH_OUTSIDE;
        }
        boolean bl = this.contains(link.getEntity1());
        boolean bl2 = this.contains(link.getEntity2());
        if (bl && bl2) {
            return CrossingType.INSIDE;
        }
        if (!bl && !bl2) {
            return CrossingType.OUTSIDE;
        }
        return CrossingType.CUT;
    }

    public Map<String, IEntity> entities() {
        return Collections.unmodifiableMap(this.entities);
    }

    public String getCode() {
        return this.code;
    }

    public String getUid() {
        return "cluster" + this.cpt;
    }

    public final HtmlColor getBackColor() {
        return this.backColor;
    }

    public final void setBackColor(HtmlColor htmlColor) {
        this.backColor = htmlColor;
    }

    public final Group getParent() {
        return this.parent;
    }

    public final boolean isDashed() {
        return this.dashed;
    }

    public final void setDashed(boolean bl) {
        this.dashed = bl;
    }

    public final boolean isRounded() {
        return this.rounded;
    }

    public final void setRounded(boolean bl) {
        this.rounded = bl;
    }

    public GroupType getType() {
        return this.type;
    }

    public final IEntity getEntityCluster() {
        if (this.entityCluster == null) {
            throw new IllegalStateException();
        }
        return this.entityCluster;
    }

    public final void setEntityCluster(IEntity iEntity) {
        if (iEntity == null) {
            throw new IllegalArgumentException();
        }
        this.entityCluster = iEntity;
    }

    public String getDisplay() {
        return this.display;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bl) {
        this.bold = bl;
    }

    public void moveEntitiesTo(Group group) {
        for (IEntity iEntity : this.entities.values()) {
            ((Entity)iEntity).moveTo(group);
        }
        this.entities.clear();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public final Collection<Group> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public final boolean isAutonom() {
        return this.autonom;
    }

    public final void setAutonom(boolean bl) {
        this.autonom = bl;
    }

    public final Rankdir getRankdir() {
        return this.rankdir;
    }

    public final void setRankdir(Rankdir rankdir) {
        this.rankdir = rankdir;
    }

    public final void setStereotype(String string) {
        this.stereotype = string;
    }

    public final String getStereotype() {
        return this.stereotype;
    }
}

