/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.usecasediagram.command;

import java.util.Map;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.usecasediagram.UsecaseDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkUsecase2
extends SingleLineCommand2<UsecaseDiagram> {
    public CommandLinkUsecase2(UsecaseDiagram usecaseDiagram) {
        super(usecaseDiagram, CommandLinkUsecase2.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), CommandLinkUsecase2.getGroup("ENT1"), new RegexLeaf("\\s*"), new RegexOr(new RegexLeaf("LEFT_TO_RIGHT", "(([-=.]+)(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.]))?([-=.]*)([\\]>]|\\|[>\\]])?)"), new RegexLeaf("RIGHT_TO_LEFT", "(([\\[<]|[<\\[]\\|)?([-=.]*)(left|right|up|down|le?|ri?|up?|do?)?([-=.]+))")), new RegexLeaf("\\s*"), CommandLinkUsecase2.getGroup("ENT2"), new RegexLeaf("\\s*"), new RegexLeaf("LABEL_LINK", "(?::\\s*([^\"]+))?$"));
    }

    private static RegexLeaf getGroup(String string) {
        return new RegexLeaf(string, "([\\p{L}0-9_.]+|:[^:]+:|\\((?!\\*\\))[^)]+\\))(?:\\s*(\\<\\<.*\\>\\>))?");
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        String string = map.get("ENT1").get(0);
        String string2 = map.get("ENT2").get(0);
        if (((UsecaseDiagram)this.getSystem()).isGroup(string) && ((UsecaseDiagram)this.getSystem()).isGroup(string2)) {
            return this.executePackageLink(map);
        }
        if (((UsecaseDiagram)this.getSystem()).isGroup(string) || ((UsecaseDiagram)this.getSystem()).isGroup(string2)) {
            return CommandExecutionResult.error("Package can be only linked to other package");
        }
        IEntity iEntity = ((UsecaseDiagram)this.getSystem()).getOrCreateClass(string);
        IEntity iEntity2 = ((UsecaseDiagram)this.getSystem()).getOrCreateClass(string2);
        if (map.get("ENT1").get(1) != null) {
            iEntity.setStereotype(new Stereotype(map.get("ENT1").get(1)));
        }
        if (map.get("ENT2").get(1) != null) {
            iEntity2.setStereotype(new Stereotype(map.get("ENT2").get(1)));
        }
        LinkType linkType = this.getLinkType(map);
        Direction direction = this.getDirection(map);
        String string3 = direction == Direction.LEFT || direction == Direction.RIGHT ? "-" : this.getQueue(map);
        if (direction != null && linkType.isExtendsOrAgregationOrCompositionOrPlus()) {
            direction = direction.getInv();
        }
        Link link = new Link(iEntity, iEntity2, linkType, map.get("LABEL_LINK").get(0), string3.length());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        ((UsecaseDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executePackageLink(Map<String, RegexPartialMatch> map) {
        String string = map.get("ENT1").get(0);
        String string2 = map.get("ENT2").get(0);
        Group group = ((UsecaseDiagram)this.getSystem()).getGroup(string);
        Group group2 = ((UsecaseDiagram)this.getSystem()).getGroup(string2);
        LinkType linkType = this.getLinkType(map);
        Direction direction = this.getDirection(map);
        String string3 = direction == Direction.LEFT || direction == Direction.RIGHT ? "-" : this.getQueue(map);
        if (direction != null && linkType.isExtendsOrAgregationOrCompositionOrPlus()) {
            direction = direction.getInv();
        }
        Link link = new Link(group.getEntityCluster(), group2.getEntityCluster(), linkType, map.get("LABEL_LINK").get(0), string3.length());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        ((UsecaseDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }

    private String getQueue(Map<String, RegexPartialMatch> map) {
        if (map.get("LEFT_TO_RIGHT").get(1) != null) {
            return map.get("LEFT_TO_RIGHT").get(1).trim() + map.get("LEFT_TO_RIGHT").get(3).trim();
        }
        if (map.get("RIGHT_TO_LEFT").get(2) != null) {
            return map.get("RIGHT_TO_LEFT").get(2).trim() + map.get("RIGHT_TO_LEFT").get(4).trim();
        }
        throw new IllegalArgumentException();
    }

    private Direction getDirection(Map<String, RegexPartialMatch> map) {
        if (map.get("LEFT_TO_RIGHT").get(2) != null) {
            return StringUtils.getQueueDirection(map.get("LEFT_TO_RIGHT").get(2));
        }
        if (map.get("RIGHT_TO_LEFT").get(3) != null) {
            return StringUtils.getQueueDirection(map.get("RIGHT_TO_LEFT").get(3)).getInv();
        }
        return null;
    }

    private LinkType getLinkType(Map<String, RegexPartialMatch> map) {
        if (map.get("LEFT_TO_RIGHT").get(0) != null) {
            return this.getLinkTypeNormal(map.get("LEFT_TO_RIGHT"));
        }
        if (map.get("RIGHT_TO_LEFT").get(0) != null) {
            return this.getLinkTypeInv(map.get("RIGHT_TO_LEFT"));
        }
        throw new IllegalArgumentException();
    }

    private LinkType getLinkTypeNormal(RegexPartialMatch regexPartialMatch) {
        String string = regexPartialMatch.get(1).trim() + regexPartialMatch.get(3).trim();
        String string2 = regexPartialMatch.get(4);
        return this.getLinkType(string, string2);
    }

    private LinkType getLinkTypeInv(RegexPartialMatch regexPartialMatch) {
        String string = regexPartialMatch.get(2).trim() + regexPartialMatch.get(4).trim();
        String string2 = regexPartialMatch.get(1);
        return this.getLinkType(string, string2).getInv();
    }

    private LinkType getLinkType(String string, String string2) {
        if (string2 != null) {
            string2 = string2.trim();
        }
        LinkType linkType = this.getLinkTypeFromKey(string2);
        if (string.startsWith(".")) {
            linkType = linkType.getDashed();
        }
        return linkType;
    }

    private LinkType getLinkTypeFromKey(String string) {
        if (string == null) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        if (string.equals("<") || string.equals(">")) {
            return new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
        }
        if (string.equals("<|") || string.equals("|>")) {
            return new LinkType(LinkDecor.EXTENDS, LinkDecor.NONE);
        }
        return null;
    }
}

