/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.PSystemBasicFactory;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.PSystemFactory;
import net.sourceforge.plantuml.StartUtils;
import net.sourceforge.plantuml.UmlSource;
import net.sourceforge.plantuml.command.AbstractUmlSystemCommandFactory;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.PSystemCommandFactory;
import net.sourceforge.plantuml.command.ProtectedCommand;
import net.sourceforge.plantuml.suggest.SuggestEngine;
import net.sourceforge.plantuml.suggest.SuggestEngineResult;
import net.sourceforge.plantuml.suggest.SuggestEngineStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PSystemSingleBuilder {
    private final Iterator<String> it;
    private final UmlSource source;
    private int nb = 0;
    private AbstractPSystem sys;

    private boolean hasNext() {
        return this.it.hasNext();
    }

    private String next() {
        ++this.nb;
        return this.it.next();
    }

    public PSystem getPSystem() {
        return this.sys;
    }

    public PSystemSingleBuilder(UmlSource umlSource, PSystemFactory pSystemFactory) throws IOException {
        this.source = umlSource;
        this.it = umlSource.iterator();
        if (!StartUtils.isArobaseStartDiagram(this.next())) {
            throw new UnsupportedOperationException();
        }
        if (umlSource.isEmpty()) {
            this.sys = this.buildEmptyError();
        } else if (pSystemFactory instanceof PSystemCommandFactory) {
            this.executeUmlCommand((PSystemCommandFactory)pSystemFactory);
        } else if (pSystemFactory instanceof PSystemBasicFactory) {
            this.executeUmlBasic((PSystemBasicFactory)pSystemFactory);
        }
    }

    private void executeUmlBasic(PSystemBasicFactory pSystemBasicFactory) throws IOException {
        pSystemBasicFactory.init();
        while (this.hasNext()) {
            String string = this.next();
            if (StartUtils.isArobaseEndDiagram(string)) {
                if (this.source.getSize() == 2) {
                    assert (false);
                    this.sys = this.buildEmptyError();
                } else {
                    this.sys = (AbstractPSystem)pSystemBasicFactory.getSystem();
                }
                if (this.sys == null) {
                    return;
                }
                this.sys.setSource(this.source);
                return;
            }
            boolean bl = pSystemBasicFactory.executeLine(string);
            if (bl) continue;
            this.sys = new PSystemError(this.source, new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", this.nb - 1));
            return;
        }
        this.sys = (AbstractPSystem)pSystemBasicFactory.getSystem();
        this.sys.setSource(this.source);
    }

    private PSystemError buildEmptyError() {
        PSystemError pSystemError = new PSystemError(this.source, new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Empty description", 1));
        pSystemError.setSource(this.source);
        return pSystemError;
    }

    private PSystemError buildEmptyError(String string) {
        PSystemError pSystemError = new PSystemError(this.source, new ErrorUml(ErrorUmlType.EXECUTION_ERROR, string, 1));
        pSystemError.setSource(this.source);
        return pSystemError;
    }

    private void executeUmlCommand(PSystemCommandFactory pSystemCommandFactory) throws IOException {
        pSystemCommandFactory.init();
        while (this.hasNext()) {
            Object object;
            Object object2;
            String string = this.next();
            if (StartUtils.isArobaseEndDiagram(string)) {
                object2 = ((AbstractUmlSystemCommandFactory)pSystemCommandFactory).checkFinalError();
                if (object2 != null) {
                    this.sys = this.buildEmptyError((String)object2);
                }
                if (this.source.getSize() == 2) {
                    assert (false);
                    this.sys = this.buildEmptyError();
                } else {
                    this.sys = (AbstractPSystem)pSystemCommandFactory.getSystem();
                }
                if (this.sys == null) {
                    return;
                }
                this.sys.setSource(this.source);
                return;
            }
            object2 = pSystemCommandFactory.isValid(Arrays.asList(string));
            if (object2 == CommandControl.NOT_OK) {
                SuggestEngineResult suggestEngineResult;
                ErrorUml errorUml = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", this.nb - 1);
                if (OptionFlags.getInstance().isUseSuggestEngine() && (suggestEngineResult = ((SuggestEngine)(object = new SuggestEngine(this.source, pSystemCommandFactory))).tryToSuggest()).getStatus() == SuggestEngineStatus.ONE_SUGGESTION) {
                    errorUml.setSuggest(suggestEngineResult);
                }
                this.sys = new PSystemError(this.source, errorUml);
                return;
            }
            if (object2 == CommandControl.OK_PARTIAL) {
                boolean bl = this.manageMultiline(pSystemCommandFactory, string);
                if (bl) continue;
                this.sys = new PSystemError(this.source, new ErrorUml(ErrorUmlType.EXECUTION_ERROR, "Syntax Error?", this.nb - 1));
                return;
            }
            if (object2 == CommandControl.OK) {
                ProtectedCommand protectedCommand = new ProtectedCommand(pSystemCommandFactory.createCommand(Arrays.asList(string)));
                object = protectedCommand.execute(Arrays.asList(string));
                if (!((CommandExecutionResult)object).isOk()) {
                    this.sys = new PSystemError(this.source, new ErrorUml(ErrorUmlType.EXECUTION_ERROR, ((CommandExecutionResult)object).getError(), this.nb - 1));
                    return;
                }
                this.testDeprecated(Arrays.asList(string), protectedCommand);
                continue;
            }
            assert (false);
        }
        this.sys = (AbstractPSystem)pSystemCommandFactory.getSystem();
        this.sys.setSource(this.source);
    }

    private void testDeprecated(List<String> list, Command command) {
        if (command.isDeprecated(list)) {
            Log.error("The following syntax is deprecated :");
            for (String string : list) {
                Log.error(string);
            }
            String string = command.getHelpMessageForDeprecated(list);
            if (string != null) {
                Log.error("Use instead :");
                Log.error(string);
            }
        }
    }

    private boolean manageMultiline(PSystemCommandFactory pSystemCommandFactory, String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        while (this.hasNext()) {
            String string2 = this.next();
            if (StartUtils.isArobaseEndDiagram(string2)) {
                return false;
            }
            arrayList.add(string2);
            CommandControl commandControl = pSystemCommandFactory.isValid(arrayList);
            if (commandControl == CommandControl.NOT_OK) {
                return false;
            }
            if (commandControl != CommandControl.OK) continue;
            Command command = pSystemCommandFactory.createCommand(arrayList);
            this.testDeprecated(arrayList, command);
            return command.execute(arrayList).isOk();
        }
        return false;
    }
}

