/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.StickMan;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageActor
extends AbstractEntityImage {
    private final TextBlock name;
    private final StickMan stickman;

    public EntityImageActor(Entity entity) {
        super(entity);
        this.name = TextBlockUtils.create(StringUtils.getWithNewlines(entity.getDisplay()), new FontConfiguration(this.getFont14(), HtmlColor.BLACK), HorizontalAlignement.CENTER);
        this.stickman = new StickMan(this.getYellow(), this.getRed());
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        double d = this.stickman.getPreferredWidth(stringBounder);
        double d2 = this.stickman.getPreferredHeight(stringBounder);
        return new Dimension2DDouble(Math.max(d, dimension2D.getWidth()), d2 + dimension2D.getHeight());
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D) {
        Dimension2D dimension2D = this.getDimension(StringBounderUtils.asStringBounder(graphics2D));
        Dimension2D dimension2D2 = this.name.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
        double d = this.stickman.getPreferredWidth(StringBounderUtils.asStringBounder(graphics2D));
        double d2 = this.stickman.getPreferredHeight(StringBounderUtils.asStringBounder(graphics2D));
        double d3 = (dimension2D.getWidth() - d) / 2.0;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight()));
        graphics2D.translate(d3, 0.0);
        graphics2D.translate(-d3, 0.0);
        graphics2D.setColor(Color.BLACK);
        this.name.drawTOBEREMOVED(colorMapper, graphics2D, (dimension2D.getWidth() - dimension2D2.getWidth()) / 2.0, d2);
    }
}

