/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;

class ColorChange
implements FontChange {
    private static final Pattern colorPattern = Pattern.compile("(?i)\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)\\s*\\>");
    private final HtmlColor color;

    ColorChange(String string) {
        Matcher matcher = colorPattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalArgumentException();
        }
        this.color = HtmlColor.getColorIfValid(matcher.group(1));
    }

    HtmlColor getColor() {
        return this.color;
    }

    public FontConfiguration apply(FontConfiguration fontConfiguration) {
        return fontConfiguration.changeColor(this.color);
    }
}

