/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.MapItem;
import org.exolab.castor.mapping.loader.CollectionHandlers;

public final class J1CollectionHandlers {
    private static CollectionHandlers.Info[] _colHandlers = new CollectionHandlers.Info[]{new CollectionHandlers.Info("array", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = J1CollectionHandlers.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, true, new CollectionHandler(){

        public Object add(Object collection, Object object) {
            if (collection == null) {
                Object newArray = Array.newInstance(object.getClass(), 1);
                Array.set(newArray, 0, object);
                return newArray;
            }
            Class<?> type = collection.getClass();
            if (!type.isArray()) {
                String err = "J1CollectionHandlers.array#add: type mismatch, expecting an array, instead received: ";
                err = err + type.getName();
                throw new IllegalArgumentException(err);
            }
            type = type.getComponentType();
            Object newArray = Array.newInstance(type, Array.getLength(collection) + 1);
            int i = 0;
            while (i < Array.getLength(collection)) {
                Array.set(newArray, i, Array.get(collection, i));
                ++i;
            }
            Array.set(newArray, Array.getLength(collection), object);
            return newArray;
        }

        public Enumeration elements(Object collection) {
            if (collection == null) {
                return new CollectionHandlers.EmptyEnumerator();
            }
            return new ArrayEnumerator(collection);
        }

        public int size(Object collection) {
            if (collection == null) {
                return 0;
            }
            return Array.getLength(collection);
        }

        public Object clear(Object collection) {
            if (collection == null) {
                return null;
            }
            Class<?> type = collection.getClass();
            if (!type.isArray()) {
                String err = "J1CollectionHandlers.array#add: type mismatch, expecting an array, instead received: ";
                err = err + type.getName();
                throw new IllegalArgumentException(err);
            }
            type = type.getComponentType();
            return Array.newInstance(type, 0);
        }

        public String toString() {
            return "Object[]";
        }
    }), new CollectionHandlers.Info("vector", class$java$util$Vector == null ? (class$java$util$Vector = J1CollectionHandlers.class$("java.util.Vector")) : class$java$util$Vector, false, new CollectionHandler(){

        public Object add(Object collection, Object object) {
            if (collection == null) {
                collection = new Vector<Object>();
                collection.addElement(object);
                return collection;
            }
            ((Vector)collection).addElement(object);
            return null;
        }

        public Enumeration elements(Object collection) {
            if (collection == null) {
                return new CollectionHandlers.EmptyEnumerator();
            }
            return ((Vector)collection).elements();
        }

        public int size(Object collection) {
            if (collection == null) {
                return 0;
            }
            return ((Vector)collection).size();
        }

        public Object clear(Object collection) {
            if (collection != null) {
                ((Vector)collection).removeAllElements();
            }
            return null;
        }

        public String toString() {
            return "Vector";
        }
    }), new CollectionHandlers.Info("hashtable", class$java$util$Hashtable == null ? (class$java$util$Hashtable = J1CollectionHandlers.class$("java.util.Hashtable")) : class$java$util$Hashtable, false, new CollectionHandler(){

        public Object add(Object collection, Object object) {
            Object key = object;
            Object value = object;
            if (object instanceof MapItem) {
                MapItem mapItem = (MapItem)object;
                key = mapItem.getKey();
                value = mapItem.getValue();
                if (value == null) {
                    value = object;
                }
                if (key == null) {
                    key = value;
                }
            }
            if (collection == null) {
                collection = new Hashtable<Object, Object>();
                collection.put(key, value);
                return collection;
            }
            ((Hashtable)collection).put(key, value);
            return null;
        }

        public Enumeration elements(Object collection) {
            if (collection == null) {
                return new CollectionHandlers.EmptyEnumerator();
            }
            return ((Hashtable)collection).elements();
        }

        public int size(Object collection) {
            if (collection == null) {
                return 0;
            }
            return ((Hashtable)collection).size();
        }

        public Object clear(Object collection) {
            if (collection != null) {
                ((Hashtable)collection).clear();
            }
            return null;
        }

        public String toString() {
            return "Hashtable";
        }
    }), new CollectionHandlers.Info("enumerate", class$java$util$Enumeration == null ? (class$java$util$Enumeration = J1CollectionHandlers.class$("java.util.Enumeration")) : class$java$util$Enumeration, false, new CollectionHandler(){

        public Object add(Object collection, Object object) {
            return null;
        }

        public Enumeration elements(Object collection) {
            if (collection == null) {
                return new CollectionHandlers.EmptyEnumerator();
            }
            return (Enumeration)collection;
        }

        public int size(Object collection) {
            return 0;
        }

        public Object clear(Object collection) {
            return null;
        }

        public String toString() {
            return "Enumeration";
        }
    })};
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$Enumeration;

    public static CollectionHandlers.Info[] getCollectionHandlersInfo() {
        return _colHandlers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class ArrayEnumerator
    implements Enumeration {
        private final Object _array;
        private int _index;

        ArrayEnumerator(Object array) {
            this._array = array;
        }

        public boolean hasMoreElements() {
            return this._index < Array.getLength(this._array);
        }

        public Object nextElement() {
            if (this._index >= Array.getLength(this._array)) {
                throw new NoSuchElementException();
            }
            return Array.get(this._array, this._index++);
        }
    }
}

