/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.types.DateTimeBase;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;

public class DateTimeValidator
implements TypeValidator {
    private DateTimeBase _maxInclusive;
    private DateTimeBase _maxExclusive;
    private DateTimeBase _minInclusive;
    private DateTimeBase _minExclusive;

    public void setMaxExclusive(DateTimeBase max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(DateTimeBase max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(DateTimeBase min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(DateTimeBase min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public void validate(DateTimeBase dateTime) throws ValidationException {
        boolean isThereMaxExclusive;
        boolean isThereMinInclusive = this._minInclusive != null;
        boolean isThereMinExclusive = this._minExclusive != null;
        boolean isThereMaxInclusive = this._maxInclusive != null;
        boolean bl = isThereMaxExclusive = this._maxExclusive != null;
        if (isThereMinExclusive && isThereMinInclusive) {
            throw new ValidationException("both minInclusive and minExclusiveare set up");
        }
        if (isThereMaxExclusive && isThereMaxInclusive) {
            throw new ValidationException("both maxInclusive and maxExclusiveare set up");
        }
        if (isThereMinInclusive && dateTime.compareTo(this._minInclusive) != 2 && !dateTime.equals(this._minInclusive)) {
            String err = dateTime + " must be greater than (or equal to) the minimum allowable ";
            err = err + "value of " + this._minInclusive;
            throw new ValidationException(err);
        }
        if (isThereMinExclusive && dateTime.compareTo(this._minExclusive) != 2) {
            String err = dateTime + " must be greater than the minimum allowable ";
            err = err + "value of " + this._minExclusive;
            throw new ValidationException(err);
        }
        if (isThereMaxInclusive && dateTime.compareTo(this._maxInclusive) != 0 && !dateTime.equals(this._maxInclusive)) {
            String err = dateTime + " must be less than (or equal to) the maximum allowable ";
            err = err + "value of " + this._maxInclusive;
            throw new ValidationException(err);
        }
        if (isThereMaxExclusive && dateTime.compareTo(this._maxExclusive) != 0) {
            String err = dateTime + " must be less than the maximum allowable ";
            err = err + "value of " + this._maxExclusive;
            throw new ValidationException(err);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "DateTimeValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        DateTimeBase value = null;
        try {
            value = (DateTimeBase)object;
        }
        catch (Exception ex) {
            String err = ex.toString() + "\nExpecting a RecurringDuration, received instead: ";
            err = err + object.getClass().getName();
            throw new ValidationException(err);
        }
        this.validate(value);
    }
}

